/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class ResultSetMinCutsSort
extends ResultSetAbstract {
    int _maxAddArray;
    Comparator _comparator = null;
    ArrayList<CutsOrder> _setArray = new ArrayList(6);
    boolean _bSetIsTrue = false;
    ArrayList<TreeSet<ModelTrans[]>> _addArray = new ArrayList(6);
    int _sizeAddArray = 0;

    public ResultSetMinCutsSort() {
        this(true, -1);
    }

    public ResultSetMinCutsSort(boolean idxEvt, int max) {
        MsgStepUser.LOG.finest(ResultSetMinCutsSort.class.getSimpleName() + "::creator()");
        this.createComparator();
        this._getIdxEvt = idxEvt;
        if (max == -1) {
            max = 10000;
        }
        this._maxAddArray = max;
    }

    protected void createComparator() {
        this._comparator = new Comparator(){

            public int compare(Object O1, Object O2) {
                ModelTrans[] o1 = (ModelTrans[])O1;
                ModelTrans[] o2 = (ModelTrans[])O2;
                int res = o1.length - o2.length;
                if (res != 0) {
                    return res;
                }
                for (int i = 0; i < o1.length; ++i) {
                    res = ResultSetMinCutsSort.this._getIdxEvt ? o1[i].getIdxEvt() - o2[i].getIdxEvt() : o1[i].getIdx() - o2[i].getIdx();
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        };
    }

    private void setSetAsTrue() {
        this.clearAddArray();
        CutsOrder set = new CutsOrder(0);
        set.add(new ModelTrans[0]);
        this._setArray = new ArrayList(1);
        this._setArray.add(set);
        this._bSetIsTrue = true;
    }

    private void clearAddArray() {
        for (int i = 0; i < this._addArray.size(); ++i) {
            TreeSet<ModelTrans[]> set = this._addArray.get(i);
            if (set == null) continue;
            set.clear();
        }
        this._addArray.clear();
        this._sizeAddArray = 0;
    }

    protected void mergeResult() {
        int addSize;
        int refSize = this._setArray.size();
        if (refSize < (addSize = this._addArray.size())) {
            this._setArray.ensureCapacity(addSize + 1);
            while (this._setArray.size() <= addSize) {
                this._setArray.add(null);
            }
        }
        for (int addIdx = 0; addIdx < addSize; ++addIdx) {
            TreeSet<ModelTrans[]> addSet = this._addArray.get(addIdx);
            if (addSet == null || addSet.size() == 0) continue;
            for (int refIdx = addIdx + 1; refIdx < refSize; ++refIdx) {
                CutsOrder refSet = this._setArray.get(refIdx);
                if (refSet == null || refSet.size() == 0) continue;
                refSet.suppressResult(addSet);
            }
            CutsOrder refCutsOrder = this._setArray.get(addIdx);
            if (refCutsOrder == null) {
                refCutsOrder = new CutsOrder(addIdx);
                this._setArray.set(addIdx, refCutsOrder);
            }
            ArrayList<CutsOrder> refSets = new ArrayList<CutsOrder>(addIdx);
            for (int refIdx = 1; refIdx < addIdx; ++refIdx) {
                CutsOrder refSet = this._setArray.get(refIdx);
                if (refSet == null || refSet.size() == 0) continue;
                refSets.add(refSet);
                refSet.resetPlay();
            }
            int refSetsSize = refSets.size();
            Iterator<ModelTrans[]> iter = addSet.iterator();
            while (iter.hasNext()) {
                boolean included = false;
                ModelTrans[] cut = iter.next();
                for (int idx = 0; !included && idx < refSetsSize; ++idx) {
                    included = ((CutsOrder)refSets.get(idx)).play(cut);
                }
                if (included) continue;
                refCutsOrder.add(cut);
            }
            refCutsOrder.sort();
        }
        this.clearAddArray();
    }

    private void addRealSeq(ModelTrans[] add) {
        TreeSet<Object> set;
        if (this._bSetIsTrue) {
            return;
        }
        int order = add.length;
        if (order == 0) {
            this.setSetAsTrue();
            return;
        }
        if (this._addArray.size() <= order) {
            this._addArray.ensureCapacity(order + 1);
            while (this._addArray.size() <= order) {
                this._addArray.add(null);
            }
        }
        if ((set = this._addArray.get(order)) == null) {
            set = new TreeSet(this._comparator);
            this._addArray.set(order, set);
        }
        set.add(add);
        ++this._sizeAddArray;
        if (this._sizeAddArray >= this._maxAddArray) {
            this.mergeResult();
        }
    }

    @Override
    protected ModelTrans[] clone(ModelTrans[] trs, int order) {
        ModelTrans[] add = new ModelTrans[order];
        int size = order;
        int idx = 0;
        for (int i = 0; i < order; ++i) {
            boolean insert = false;
            for (int j = 0; !insert && j < idx; ++j) {
                int k;
                if (this._getIdxEvt) {
                    if (trs[i].getIdxEvt() == add[j].getIdxEvt()) {
                        --size;
                        insert = true;
                        continue;
                    }
                    if (trs[i].getIdxEvt() >= add[j].getIdxEvt()) continue;
                    for (k = i - 1; k >= j; --k) {
                        add[k + 1] = add[k];
                    }
                    add[j] = trs[i];
                    ++idx;
                    insert = true;
                    continue;
                }
                if (trs[i].getIdx() == add[j].getIdx()) {
                    --size;
                    insert = true;
                    continue;
                }
                if (trs[i].getIdx() >= add[j].getIdx()) continue;
                for (k = i - 1; k >= j; --k) {
                    add[k + 1] = add[k];
                }
                add[j] = trs[i];
                ++idx;
                insert = true;
            }
            if (insert) continue;
            add[idx++] = trs[i];
        }
        if (size < order) {
            return super.clone(add, size);
        }
        return add;
    }

    @Override
    protected ModelTrans[] convert(List<ModelTrans> trs) {
        int order = trs.size();
        ModelTrans[] add = new ModelTrans[order];
        for (int i = 0; i < order; ++i) {
            add[i] = trs.get(i);
        }
        return this.clone(add, order);
    }

    @Override
    public void addSeq(ModelTrans[] trs) {
        this.addRealSeq(this.clone(trs, trs.length));
    }

    @Override
    public void addSeq(ModelTrans[] trs, int order) {
        ModelTrans[] add = this.clone(trs, order);
        this.addRealSeq(add);
    }

    @Override
    public void addSeq(List<ModelTrans> trs, boolean error) {
        ModelTrans[] add = this.convert(trs);
        this.addRealSeq(add);
    }

    @Override
    public void flush() {
        if (this._sizeAddArray > 0) {
            this.mergeResult();
        }
    }

    @Override
    public Iterator getSeqIterator() {
        class SeqIterator
        implements Iterator {
            Iterator<CutsOrder> iSet;
            Iterator iObj;

            SeqIterator() {
                this.iSet = ResultSetMinCutsSort.this._setArray.iterator();
                this.findNext();
            }

            void findNext() {
                this.iObj = null;
                while (this.iSet.hasNext()) {
                    CutsOrder cSet = this.iSet.next();
                    if (cSet == null) continue;
                    this.iObj = cSet.iterator();
                    if (!this.iObj.hasNext()) continue;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.iObj == null) {
                    return false;
                }
                if (this.iObj.hasNext()) {
                    return true;
                }
                this.findNext();
                if (this.iObj == null) {
                    return false;
                }
                return this.iObj.hasNext();
            }

            public Object next() {
                if (this.iObj == null || !this.iObj.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.iObj.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new SeqIterator();
    }

    @Override
    public String getSeqAbstract() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("/* Order of products :\n");
        for (int i = 0; i < this._setArray.size(); ++i) {
            CutsOrder set = this._setArray.get(i);
            if (set == null || set.size() == 0) continue;
            sb.append("\t");
            sb.append(Integer.toString(i));
            sb.append("\t");
            sb.append(Integer.toString(set.size()));
            sb.append("\n");
        }
        sb.append(" */\n");
        return sb.toString();
    }

    @Override
    public Map<Integer, Integer> getOrders() {
        LinkedHashMap<Integer, Integer> orders = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < this._setArray.size(); ++i) {
            CutsOrder set = this._setArray.get(i);
            if (set == null || set.size() == 0) continue;
            orders.put(i, set.size());
        }
        return orders;
    }

    @Override
    public String getShortName() {
        return "MCS";
    }

    class CutsOrder {
        List<ModelTrans[]> _cuts;
        int _order;
        int _playIndex;

        CutsOrder(int order) {
            this._order = order;
            this._cuts = new ArrayList<ModelTrans[]>(128);
        }

        public int size() {
            return this._cuts.size();
        }

        void add(ModelTrans[] cut) {
            this._cuts.add(cut);
        }

        public Iterator<ModelTrans[]> iterator() {
            return this._cuts.iterator();
        }

        public void sort() {
            Collections.sort(this._cuts, ResultSetMinCutsSort.this._comparator);
        }

        public void suppressResult(TreeSet<ModelTrans[]> cuts) {
            throw new UnsupportedOperationException();
        }

        void resetPlay() {
            this._playIndex = 0;
        }

        boolean play(ModelTrans[] testSeq) {
            for (int idx = this._playIndex; idx < this._cuts.size(); ++idx) {
                ModelTrans[] refSeq = this._cuts.get(idx);
                boolean included = true;
                int j = 0;
                int i = 0;
                while (included && i < refSeq.length) {
                    boolean find = false;
                    boolean stop = false;
                    while (!find && !stop && j < testSeq.length) {
                        if (ResultSetMinCutsSort.this._getIdxEvt) {
                            if (refSeq[i].getIdxEvt() <= testSeq[j].getIdxEvt()) {
                                if (refSeq[i].getIdxEvt() == testSeq[j].getIdxEvt()) {
                                    find = true;
                                } else {
                                    stop = true;
                                }
                            }
                        } else if (refSeq[i].getIdx() <= testSeq[j].getIdx()) {
                            if (refSeq[i].getIdx() == testSeq[j].getIdx()) {
                                find = true;
                            } else {
                                stop = true;
                            }
                        }
                        ++j;
                    }
                    if (!find) {
                        included = false;
                        if (idx != this._playIndex || !(ResultSetMinCutsSort.this._getIdxEvt ? refSeq[i].getIdxEvt() < testSeq[i].getIdxEvt() : refSeq[i].getIdx() < testSeq[i].getIdx())) continue;
                        while (++idx < this._cuts.size()) {
                            refSeq = this._cuts.get(idx);
                            boolean nextGreater = false;
                            for (j = 0; !nextGreater && j < i; ++j) {
                                if (!(ResultSetMinCutsSort.this._getIdxEvt ? refSeq[j].getIdxEvt() > testSeq[j].getIdxEvt() : refSeq[j].getIdx() > testSeq[j].getIdx())) continue;
                                nextGreater = true;
                            }
                            if (!nextGreater && i == j && (ResultSetMinCutsSort.this._getIdxEvt ? refSeq[j].getIdxEvt() >= testSeq[j].getIdxEvt() : refSeq[j].getIdx() >= testSeq[j].getIdx())) {
                                nextGreater = true;
                            }
                            if (!nextGreater) continue;
                            break;
                        }
                        this._playIndex = idx--;
                        continue;
                    }
                    ++i;
                }
                if (!included) continue;
                return true;
            }
            return false;
        }
    }
}

