/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ResultSetSync
implements ResultSet {
    ResultSet _delegate;
    protected Lock _lockAddSeq = new ReentrantLock();

    public ResultSetSync(ResultSet delegate) {
        this._delegate = delegate;
    }

    @Override
    public Lock getLockAvailable() {
        return this._lockAddSeq;
    }

    @Override
    public void addSeq(List<ModelTrans> trs, boolean error) {
        this._delegate.addSeq(trs, error);
    }

    @Override
    public void addSeq(ModelTrans[] trs, int order) {
        this._lockAddSeq.lock();
        try {
            this._delegate.addSeq(trs, order);
        }
        finally {
            this._lockAddSeq.unlock();
        }
    }

    @Override
    public void addSeq(ModelTrans[] trs) {
        this._delegate.addSeq(trs);
    }

    @Override
    public void flush() {
        this._lockAddSeq.lock();
        try {
            this._delegate.flush();
        }
        finally {
            this._lockAddSeq.unlock();
        }
    }

    @Override
    public Map<Integer, Integer> getOrders() {
        this._lockAddSeq.lock();
        try {
            Map<Integer, Integer> map = this._delegate.getOrders();
            return map;
        }
        finally {
            this._lockAddSeq.unlock();
        }
    }

    @Override
    public String getSeqAbstract() {
        this._lockAddSeq.lock();
        try {
            String string = this._delegate.getSeqAbstract();
            return string;
        }
        finally {
            this._lockAddSeq.unlock();
        }
    }

    @Override
    public Iterator getSeqIterator() {
        this._lockAddSeq.lock();
        try {
            Iterator iterator = this._delegate.getSeqIterator();
            return iterator;
        }
        finally {
            this._lockAddSeq.unlock();
        }
    }

    @Override
    public String getShortName() {
        return this._delegate.getShortName();
    }
}

