/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderStd;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGameCombIterator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StatUtil;
import java.util.Iterator;
import java.util.List;

public class SeqFinderComb
extends SeqFinderStd {
    public SeqFinderComb(int order) {
        super(order);
    }

    @Override
    public double init(SeqGenerator simul) {
        super.init(simul);
        this._dspMaxTest = StatUtil.Combinaison(this._order, this._trList.size());
        return this._dspMaxTest;
    }

    private void findCombinaison(int boucle, int index, boolean next, List<ModelTrans> begin) throws StepperException {
        if (boucle == this._order) {
            if (this._tgt.addSequence(this._simul, this._cut, boucle)) {
                ++this._addCut;
            }
            this._simul.changeProgress(this._dspNbrTest += 1.0, this._dspMaxTest);
        } else {
            if (this._tgt.addSequence(this._simul, this._cut, boucle)) {
                ++this._addCut;
                if (this._looker) {
                    ++this._stopMinCut;
                    this._dspMaxTest -= StatUtil.Combinaison(this._order - boucle, this._trList.size() - index);
                    return;
                }
            }
            boolean playNext = next;
            for (int i = index; i < this._trList.size(); ++i) {
                boolean valid;
                this._cut[boucle] = (ModelTrans)this._trList.get(i);
                if (next) {
                    if (this._cut[boucle] != begin.get(boucle)) continue;
                    next = false;
                    if (boucle == begin.size() - 1) {
                        playNext = false;
                        this._cut[boucle] = null;
                        continue;
                    }
                }
                if (!(valid = this._simul.isValidTransition(this._cut[boucle]))) {
                    ++this._stopNaNCut;
                    this._dspMaxTest -= StatUtil.Combinaison(this._order - (boucle + 1), this._trList.size() - (i + 1));
                    continue;
                }
                if (valid) {
                    this._simul.goForward(this._cut[boucle]);
                }
                ++this._stepNbr;
                this.findCombinaison(boucle + 1, i + 1, playNext, begin);
                if (valid) {
                    this._simul.goBackward(1);
                }
                playNext = false;
                this._cut[boucle] = null;
            }
        }
    }

    @Override
    protected void playSimul(List<ModelTrans> currentSeq) throws StepperException {
        this.findCombinaison(0, 0, currentSeq != null, currentSeq);
    }

    @Override
    protected String getKeyHeader() {
        return "MSG_CMD_SEQ_FINDER_COMBIN_TITLE";
    }

    @Override
    public Iterator<SeqGame> getGames(int initSize) {
        return new SeqGameCombIterator(this._simul.getTransIndexes(), initSize);
    }

    @Override
    public int getNbGame(int size) {
        int nbTrans = this._simul.getTransIndexes().size();
        int factNsurFactNmoinsSize = 1;
        for (int i = 0; i < size; ++i) {
            factNsurFactNmoinsSize *= nbTrans - i;
        }
        return factNsurFactNmoinsSize;
    }
}

