/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepper.BanStepper;
import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.SeqManager;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFilter;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenAbstract;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGeneratorThreaded;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqParameters;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.util.DefaultControllableProcess;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.DestinationProxy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SeqGenManager
extends SeqManager {
    protected int _changeCheck;
    protected int _errorCheck;
    protected BanStepper _stepper;
    protected Model _fmodel;
    protected Object _lockerCurrent = new Object();
    protected SeqGenAbstract _current;
    List<SeqGenTarget> _targets = new ArrayList<SeqGenTarget>();
    SeqParameters _params = null;
    SeqFilter<Event> _eventFilter = null;
    SeqFilter<Event> _eventInvisible = null;

    public SeqGenManager(BanStepper stepper, Model model) {
        this._stepper = stepper;
        this._fmodel = model;
        this._changeCheck = 1000;
        this._errorCheck = 10;
    }

    public void addGenTarget(String name, String value, File resultFile, Map<String, String> params) {
        SeqGenTarget tgt = new SeqGenTarget(name, value, resultFile, params);
        this._targets.add(tgt);
    }

    public void setParams(Map<String, String> params) {
        this._params = new SeqParameters(params);
    }

    public void setEventFilter(SeqFilter<Event> seqFilter) {
        this._eventFilter = seqFilter;
    }

    public void setEventInvisible(SeqFilter<Event> seqFilter) {
        this._eventInvisible = seqFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws StepperException, IOException, Exception {
        int result;
        block30: {
            result = 0;
            this._state = DefaultControllableProcess.CtrlState.INIT;
            if (this._fmodel.getNodeCount() != 1) {
                throw new StepperException("Model no flatness");
            }
            Node node = this._fmodel.getNode(0);
            boolean bThreaded = false;
            String strBool = this._params.getParam("threaded");
            if (strBool != null && strBool.equals("true")) {
                bThreaded = true;
            }
            boolean bSequential = false;
            String strBool2 = this._params.getParam("sequential");
            if (strBool2 != null && strBool2.equals("true")) {
                bSequential = true;
            }
            try {
                this._state = DefaultControllableProcess.CtrlState.WORK;
                if (bSequential) {
                    for (SeqGenTarget tgt : this._targets) {
                        if (this._eventFilter != null) {
                            this._eventFilter.prepare(node, Arrays.asList(tgt));
                        }
                        if (this._eventInvisible != null) {
                            this._eventInvisible.prepare(node, Arrays.asList(tgt));
                        }
                        SeqGenerator gen = new SeqGenerator(this._stepper);
                        for (Destination dest : this._destinations) {
                            gen.addDestination(new DestinationProxy(dest, false));
                        }
                        gen.setParams(this._params);
                        gen.addTarget(tgt.getName(), tgt.getValue(), tgt.getResultFile(), tgt.getParams());
                        gen.setPlayTrans(this.createTransList(this._stepper, node));
                        gen.InitFinder();
                        SeqGenAbstract realGen = null;
                        realGen = bThreaded && this._params.getOrder() > 1 ? new SeqGeneratorThreaded(gen, this._stepper) : gen;
                        Object object = this._lockerCurrent;
                        synchronized (object) {
                            this._current = realGen;
                            this._current.setControllableProcess(this);
                        }
                        result += realGen.execute();
                        gen.printResultSet(node);
                        if (this._eventFilter != null) {
                            this._eventFilter.clean();
                        }
                        if (this._eventInvisible == null) continue;
                        this._eventInvisible.clean();
                    }
                    break block30;
                }
                if (this._eventFilter != null) {
                    this._eventFilter.prepare(node, this._targets);
                }
                if (this._eventInvisible != null) {
                    this._eventInvisible.prepare(node, this._targets);
                }
                SeqGenerator gen = new SeqGenerator(this._stepper);
                for (Destination dest : this._destinations) {
                    gen.addDestination(new DestinationProxy(dest, false));
                }
                gen.setParams(this._params);
                for (SeqGenTarget tgt : this._targets) {
                    gen.addTarget(tgt.getName(), tgt.getValue(), tgt.getResultFile(), tgt.getParams());
                }
                gen.setPlayTrans(this.createTransList(this._stepper, node));
                gen.InitFinder();
                SeqGenAbstract realGen = null;
                realGen = bThreaded && this._params.getOrder() > 1 ? new SeqGeneratorThreaded(gen, this._stepper) : gen;
                Object object = this._lockerCurrent;
                synchronized (object) {
                    this._current = realGen;
                    this._current.setControllableProcess(this);
                }
                result += realGen.execute();
                gen.printResultSet(node);
            }
            finally {
                if (this._eventFilter != null) {
                    this._eventFilter.clean();
                }
                if (this._eventInvisible != null) {
                    this._eventInvisible.clean();
                }
                Object object = this._lockerCurrent;
                synchronized (object) {
                    this._current = null;
                }
                this.close();
                this._state = DefaultControllableProcess.CtrlState.FINISH;
            }
        }
        return result;
    }

    List<Integer> createTransList(Stepper stepper, Node node) throws StepperException {
        int nbrTrans = stepper.getNbrTransition();
        ArrayList<Integer> result = new ArrayList<Integer>(nbrTrans);
        for (int i = 1; i <= nbrTrans; ++i) {
            String name = stepper.getNameOfTransition(i);
            Event evt = node.getEvent(name);
            if (evt == null) {
                throw new StepperException(MsgStepUser.msgFormat("ERR_NO_EVT_FIND", name));
            }
            if (this._eventFilter != null && !this._eventFilter.accept(evt)) continue;
            result.add(i);
        }
        MsgStepUser.LOG.fine("NbrTrans = " + nbrTrans);
        MsgStepUser.LOG.fine("FixTrans = " + result.size());
        MsgStepUser.LOG.finer("IdxTranss= " + ((Object)result).toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo(String key) {
        if (key.equals("process.p1000")) {
            Object object = this._lockerCurrent;
            synchronized (object) {
                if (this._current != null) {
                    return this._current.getInfo(key);
                }
            }
        }
        return super.getInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSuspend() {
        Object object = this._lockerCurrent;
        synchronized (object) {
            if (this._current != null) {
                this._current.callbackRequestSuspend();
            }
        }
        super.requestSuspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestResume() {
        super.requestResume();
        Object object = this._lockerCurrent;
        synchronized (object) {
            if (this._current != null) {
                this._current.callbackRequestResume();
            }
        }
    }
}

