/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqs;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqsAralia;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqsDebug;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqsMCS;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqsXML;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSet;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetBasic;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinCuts;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinCutsHashNoSort;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinCutsHashSort;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinCutsPrimeNoSort;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinCutsPrimeSort;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinCutsSort;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinSeqs;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinSeqsPrimeNoSort;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetMinSeqsPrimeSort;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetNone;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetSync;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinder;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderBasic;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderComb;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderPerm;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderPermLarge2;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderRepeat;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderStd;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SeqParameters {
    Map<String, String> _params;

    public SeqParameters(Map<String, String> params) {
        this._params = new HashMap<String, String>(params);
    }

    public String getParam(String key) {
        String result = this._params.get(key);
        if (result == null) {
            return "";
        }
        return result;
    }

    public void setParam(String key, String value) {
        this._params.put(key, value);
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this._params);
    }

    SeqFinder createFinder() {
        String locker;
        SeqFinderStd result = new SeqFinderPerm(3);
        String finder = this._params.get("finder");
        if (finder != null) {
            if (finder.equals("combinaison")) {
                result = new SeqFinderComb(this.getFinderOrder(finder));
            }
            if (finder.equals("permutation")) {
                result = new SeqFinderPerm(this.getFinderOrder(finder));
            }
            if (finder.equals("permutation.large")) {
                result = new SeqFinderPermLarge2(this.getFinderOrder(finder));
            }
            if (finder.equals("repetition")) {
                result = new SeqFinderRepeat(this.getFinderOrder(finder));
            }
            if (finder.equals("basic")) {
                result = new SeqFinderBasic(this.getFinderOrder(finder));
            }
        }
        if ((locker = this._params.get("locker")) != null) {
            result.setLocker(Boolean.parseBoolean(locker));
        }
        return result;
    }

    private int getFinderOrder(String key) {
        String strOrder = this._params.get(key + ".order");
        if (strOrder == null) {
            return 3;
        }
        try {
            int iOrder = Integer.parseInt(strOrder);
            if (iOrder <= 0) {
                iOrder = 3;
            }
            return iOrder;
        }
        catch (NumberFormatException e) {
            return 3;
        }
    }

    int getOrder() {
        String finder = this._params.get("finder");
        if (finder != null) {
            if (finder.equals("combinaison")) {
                return this.getFinderOrder(finder);
            }
            if (finder.equals("permutation")) {
                return this.getFinderOrder(finder);
            }
            if (finder.equals("repetition")) {
                return this.getFinderOrder(finder);
            }
            if (finder.equals("basic")) {
                return this.getFinderOrder(finder);
            }
        }
        return -1;
    }

    private int getResultSetStackSize() {
        int stack = -1;
        String strStack = this._params.get("resultset.stacksize");
        if (strStack != null) {
            try {
                stack = Integer.parseInt(strStack);
                if (stack <= 100) {
                    stack = 100;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return stack;
    }

    private boolean getResultSetMinIdxTrans() {
        boolean result = false;
        String buffer = this._params.get("resultset.minidxtrans");
        if (buffer != null) {
            result = Boolean.parseBoolean(buffer);
        }
        return result;
    }

    private ResultSet createBasicResultSet() {
        String result = this._params.get("resultset");
        if (result != null) {
            if (result.equals("mincuts.hash.sort")) {
                return new ResultSetMinCutsHashSort(!this.getResultSetMinIdxTrans());
            }
            if (result.equals("mincuts.hash.nosort")) {
                return new ResultSetMinCutsHashNoSort(!this.getResultSetMinIdxTrans());
            }
            if (result.equals("mincuts.prime.sort")) {
                return new ResultSetMinCutsPrimeSort(!this.getResultSetMinIdxTrans());
            }
            if (result.equals("mincuts.prime.nosort")) {
                return new ResultSetMinCutsPrimeNoSort(!this.getResultSetMinIdxTrans());
            }
            if (result.equals("mincuts.sort")) {
                return new ResultSetMinCutsSort(!this.getResultSetMinIdxTrans(), this.getResultSetStackSize());
            }
            if (result.equals("mincuts")) {
                return new ResultSetMinCuts(!this.getResultSetMinIdxTrans(), this.getResultSetStackSize());
            }
            if (result.equals("minseqs.prime.nosort")) {
                return new ResultSetMinSeqsPrimeNoSort(!this.getResultSetMinIdxTrans());
            }
            if (result.equals("minseqs.prime.sort")) {
                return new ResultSetMinSeqsPrimeSort(!this.getResultSetMinIdxTrans());
            }
            if (result.equals("minseqs")) {
                return new ResultSetMinSeqs(!this.getResultSetMinIdxTrans(), this.getResultSetStackSize());
            }
            if (result.equals("none")) {
                return new ResultSetNone();
            }
            if (result.equals("basic")) {
                String strSort = this._params.get("resultset.sort");
                if (strSort == null || !strSort.equalsIgnoreCase("true")) {
                    return new ResultSetBasic();
                }
                return new ResultSetBasic(true);
            }
        }
        return null;
    }

    private ResultSet createSyncResultSet(ResultSet rset) {
        String result = this._params.get("threaded");
        if (result != null && result.equalsIgnoreCase("true")) {
            return new ResultSetSync(rset);
        }
        return rset;
    }

    ResultSet defaultResultSet() {
        return this.createSyncResultSet(new ResultSetMinSeqs());
    }

    ResultSet createResultSet() {
        ResultSet result = this.createBasicResultSet();
        if (result != null) {
            return this.createSyncResultSet(result);
        }
        return result;
    }

    FormatSeqs createFormat(Node node) {
        String format = this._params.get("format");
        if (format != null) {
            if (format.equals("aralia")) {
                return new FormatSeqsAralia(node);
            }
            if (format.equals("MCS")) {
                return new FormatSeqsMCS();
            }
            if (format.equals("debug")) {
                return new FormatSeqsDebug();
            }
            if (format.equals("XML")) {
                return new FormatSeqsXML(node);
            }
        }
        return new FormatSeqsMCS();
    }
}

