/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqverif;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepper.HelperStepper;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetVar;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqSetPlayer;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqVerifManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SeqSetDefine
implements SeqSetPlayer {
    SeqVerifManager _owner;
    List<ModelTargetVar> _targets = new ArrayList<ModelTargetVar>();
    List<ModelTargetVar> _lockerTargets = new ArrayList<ModelTargetVar>();
    List<List<HelperStepper.Event>> _sequences = new ArrayList<List<HelperStepper.Event>>(10);

    public SeqSetDefine(SeqVerifManager owner) {
        this._owner = owner;
    }

    public void addTarget(ModelTargetVar tgt) {
        this._targets.add(tgt);
    }

    public void addLockerTarget(ModelTargetVar tgt) {
        this._lockerTargets.add(tgt);
    }

    public boolean addSequence(List<String> evts, HelperStepper stepper) {
        ArrayList<HelperStepper.Event> sequence = new ArrayList<HelperStepper.Event>(evts.size());
        for (String evt : evts) {
            HelperStepper.Event stp = stepper.getEvent(evt);
            if (stp != null) {
                sequence.add(stp);
                continue;
            }
            this._owner.addRecord(new LogGenRecord(true, "ERR_NO_EVT_FIND", evt));
        }
        this._sequences.add(sequence);
        return sequence.size() == evts.size();
    }

    @Override
    public Map<String, String> getInitState() {
        return null;
    }

    @Override
    public boolean playSequences() throws StepperException {
        this._owner.goInitialState(this);
        for (List<HelperStepper.Event> sequence : this._sequences) {
            boolean playseq = true;
            for (HelperStepper.Event event : sequence) {
                if (this._owner.goForward(event)) continue;
                playseq = false;
                break;
            }
            if (playseq) {
                for (ModelTargetVar tgt : this._targets) {
                    this._owner.verifyTarget(tgt, false);
                }
                for (ModelTargetVar tgt : this._lockerTargets) {
                    this._owner.verifyTarget(tgt, true);
                }
            }
            this._owner.goBeginState();
        }
        return true;
    }
}

