/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.mbsa.translator.ban.AlTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.ErrorManager;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.parser.OcasParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class AlTransRead
extends AlTrans {
    UtilFileSrc _src = new UtilFileSrc();
    String _node = "main";
    private String _id;
    private String _uid;

    public void setSrcfile(String value) {
        this._src.setFile("srcfile", value);
    }

    public void setSrcref(String value) {
        this._src.setRef("srcref", value);
    }

    public void setText(String text) {
        this._src.setText(text);
    }

    public void setNode(String value) {
        this._node = value;
    }

    public void setId(String value) {
        if (this._id != null) {
            this.log("Model 'id' already define : " + this._id + " => " + value, 1);
        }
        this._id = value;
    }

    public void setUid(String value) {
        if (this._uid != null) {
            this.log("Model 'uid' already define : " + this._uid + " => " + value, 1);
        }
        this._uid = value;
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src.setProcess(process);
    }

    public void endValid() {
        this._src.endValid();
        if (this._id == null) {
            throw new BanProcessException("No attribut 'id' define");
        }
    }

    @Override
    public void execute() {
        this.setResult(false);
        this.verifyFailOnError();
        String id = this.expanse(this._id);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("id", id, this._id);
        }
        long uid = -1L;
        String expandUID = this.expanse(this._uid);
        try {
            uid = Long.parseLong(expandUID);
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer(64);
            sb.append("Attribute 'uid' expanse in long value");
            sb.append(" : ").append(expandUID).append(" <= ").append(this._uid);
            throw new BanProcessException(sb.toString());
        }
        try {
            ErrorManager errorMng = new ErrorManager();
            File srcFile = this._src.getSrcFile();
            FileReader reader = new FileReader(srcFile);
            OcasParser parser = new OcasParser(reader, errorMng);
            parser.run();
            if (errorMng.withError()) {
                this.log(errorMng);
            } else {
                String node;
                Model toModel = parser.getModel();
                if (uid != -1L) {
                    toModel.setUID(uid);
                }
                if (toModel.getNode(node = this.expanse(this._node)) == null) {
                    this.log(new TranslateException("EXC_NODE_UNKNOW", this._node));
                } else {
                    toModel.setDefaultNode(node);
                    this.getProcess().setIdObject(id, toModel, 2);
                    this.setResult(true);
                }
            }
        }
        catch (IOException e) {
            throw new BanProcessException(this.getName() + " - IOexception", e);
        }
    }
}

