/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import com.dassault.cecilia.lib.mbsa.translator.ban.AlTrans;
import com.dassault.cecilia.lib.mbsa.translator.simul.Analyser;
import java.io.File;
import java.io.IOException;

public class AlTransSaveStepper
extends AlTrans {
    UtilFileDst _dst = new UtilFileDst();
    private String _refId;

    public void setSrcfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setSrcref(String value) {
        this._dst.setRef("destref", value);
    }

    public void setRef(String value) {
        if (this._refId != null) {
            this.log("Attribute 'ref' already define : " + this._refId + " => " + value, 1);
        }
        this._refId = value;
    }

    protected String getRef() {
        String refId = this.expanse(this._refId);
        if (!this.isSimpleID(refId)) {
            throw this.errorComplexId("ref", refId, this._refId);
        }
        return refId;
    }

    protected Analyser getRefStepper() {
        String refId = this.getRef();
        Object obj = this.getProcess().getIdObject(refId);
        if (obj == null) {
            throw new BanProcessException("Stepper '" + refId + "' unknow");
        }
        if (!(obj instanceof Analyser)) {
            throw new BanProcessException("Object with id '" + refId + "' is not 'Simulator'");
        }
        return (Analyser)obj;
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._dst.setProcess(process);
    }

    public void endValid() {
        this._dst.endValid();
        if (this._refId == null) {
            throw new BanProcessException("No attribut 'ref' define");
        }
    }

    @Override
    public void execute() {
        this.setResult(false);
        this.verifyFailOnError();
        try {
            File destFile = this._dst.getDstFile();
            Analyser simul = this.getRefStepper();
            simul.save(destFile);
            this.setResult(true);
        }
        catch (IOException e) {
            throw new BanProcessException(this.getName() + " - IOexception", e);
        }
    }
}

