/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.ban;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.mbsa.translator.ban.AlTransModel;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyOptionsAccessor;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class AlTransVerify
extends AlTransModel {
    List<Param> _params = new ArrayList<Param>();
    String _filter = "0";
    String _default;
    String _options;

    public Param createOption() {
        return this.createParam();
    }

    public Param createParam() {
        Param msg = new Param();
        this._params.add(msg);
        return msg;
    }

    public void setFilter(String value) {
        this._filter = value;
    }

    int castFilter(String value) {
        int result = this.castInt(value, "filter");
        if (result < 0 || result > 2) {
            throw new BanProcessException("Attribute 'filter' must be an integer including [0, 2]");
        }
        return result;
    }

    public void setDefault(String value) {
        this._default = value;
    }

    int getDefault() {
        if (this._default == null) {
            return 2;
        }
        return this.getLevelOption("default", this.expanse(this._default));
    }

    public void setOptions(String value) {
        this._options = value;
    }

    @Override
    public void execute() {
        this.setResult(false);
        this.verifyFailOnError();
        int filter = this.castFilter(this.expanse(this._filter));
        Model fromModel = this.getRefModel();
        int defValue = this.getDefault();
        DefineOptions defOpt = new DefineOptions(defValue);
        if (this._options != null) {
            StringTokenizer st = new StringTokenizer(this.expanse(this._options), ",; \t\n\r");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                defOpt.addOption(tok, Integer.toString(Math.abs(defValue - 2)));
            }
        }
        defOpt.addOptions(this._params);
        boolean playVerify = defOpt.withVerify();
        if (playVerify) {
            VerifyManager mng = new VerifyManager(defOpt);
            fromModel.verifyWarning(mng, filter);
            if (mng.getMsgCount() > 0) {
                this.log(mng);
            }
            this.setResult(!mng.withError());
        } else {
            this.setResult(true);
        }
    }

    protected int getLevelOption(String key, String value) {
        int level = 1;
        if (value.equalsIgnoreCase("false")) {
            level = 0;
        } else if (value.equalsIgnoreCase("decline")) {
            level = 0;
        } else if (value.equalsIgnoreCase("no")) {
            level = 0;
        } else if (value.equalsIgnoreCase("off")) {
            level = 0;
        } else if (value.equalsIgnoreCase("true")) {
            level = 2;
        } else if (value.equalsIgnoreCase("accept")) {
            level = 2;
        } else if (value.equalsIgnoreCase("yes")) {
            level = 2;
        } else if (value.equalsIgnoreCase("on")) {
            level = 2;
        } else if (value.equalsIgnoreCase("ignore")) {
            level = 0;
        } else if (value.equalsIgnoreCase("warning")) {
            level = 1;
        } else if (value.equalsIgnoreCase("error")) {
            level = 2;
        } else {
            try {
                level = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.log("Value [" + value + "] of param [" + key + "] not undestand", 1);
            }
        }
        return level;
    }

    class DefineOptions
    implements VerifyOptionsAccessor {
        Map<String, Integer> _opts = new HashMap<String, Integer>();
        int _defValue;

        public DefineOptions(int defValue) {
            this._defValue = defValue;
        }

        protected boolean withVerify() {
            if (this._defValue > 0) {
                return true;
            }
            for (Map.Entry<String, Integer> opt : this._opts.entrySet()) {
                if (opt.getValue() <= 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean withWarning(String key) {
            Integer lvl = this._opts.get(key);
            if (lvl == null) {
                return this._defValue > 0;
            }
            return lvl > 0;
        }

        @Override
        public boolean withError(String key) {
            if (key == null) {
                return false;
            }
            Integer lvl = this._opts.get(key);
            if (lvl == null) {
                return this._defValue >= 2;
            }
            return lvl >= 2;
        }

        @Override
        public void setOption(String key, int level) {
            this._opts.put(key, level);
        }

        protected void addOption(String key, String value) {
            int level = AlTransVerify.this.getLevelOption(key, value);
            this._opts.put(key, level);
        }

        protected void addOptions(List<Param> opts) {
            for (Param option : opts) {
                this.addOption(option.getName(), option.getValue());
            }
        }
    }
}

