/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.translator.ban.AlTransModel;
import com.dassault.cecilia.lib.mbsa.translator.ban.AltaProcessException;
import com.dassault.cecilia.lib.mbsa.translator.error.GenerateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.CompilatorAbstract;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.CompilatorV1;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.CompilatorV3;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.CompilatorV4;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.CompilatorV5;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;

public class AlTransWrite
extends AlTransModel {
    UtilFileDst _dst = new UtilFileDst();
    String _format = "OTools";
    static final boolean _JAR_JAVA2 = true;

    public void setDestfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setDestref(String value) {
        this._dst.setRef("destref", value);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._dst.setProcess(process);
    }

    @Override
    public void endValid() {
        this._dst.endValid();
        super.endValid();
    }

    public void setFormat(String value) {
        this._format = value;
    }

    String castFormat(String value) {
        if (value.equalsIgnoreCase("Extended")) {
            return "Extended";
        }
        if (value.equalsIgnoreCase("OTools")) {
            return "OTools";
        }
        if (value.equalsIgnoreCase("OToolsFlatness")) {
            return "OToolsFlatness";
        }
        if (value.equalsIgnoreCase("DataFlow")) {
            return "DataFlow";
        }
        if (value.equalsIgnoreCase("Mec5")) {
            return "Mec5";
        }
        if (value.equalsIgnoreCase("MocaRP")) {
            return "MocaRP";
        }
        if (value.equalsIgnoreCase("Java1")) {
            return "Java1";
        }
        if (value.equalsIgnoreCase("Java2")) {
            return "Java2";
        }
        throw new BanProcessException("Format '" + value + "' unknow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        block31: {
            this.setResult(false);
            this.verifyFailOnError();
            String format = this.castFormat(this.expanse(this._format));
            Model fromModel = this.getRefModel();
            if (format.equals("Java2")) {
                File outFile = this._dst.getDstFile();
                if (fromModel.getNodeCount() != 1) {
                    throw new BanProcessException("Model '" + this.getRef() + "' is not flatness model.");
                }
                CompilatorAbstract simul = switch (Integer.getInteger("cecilia.mbsa.stepper.javaf.version", 4)) {
                    case 3 -> new CompilatorV3(fromModel.getNode(0), fromModel);
                    case 5 -> new CompilatorV5(fromModel.getNode(0), fromModel);
                    default -> new CompilatorV4(fromModel.getNode(0), fromModel);
                };
                try {
                    simul.setSimulOptions(Arrays.asList("instantaneous.auto=\"false\""));
                    simul.goInitialState();
                }
                catch (StepperException e) {
                    throw new BanProcessException(e);
                }
                String name = outFile.getName();
                if (name.lastIndexOf(46) > 0) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                try {
                    simul.printJar(outFile, name);
                }
                catch (IOException e) {
                    throw new AltaProcessException(e);
                }
            }
            Writer writer = null;
            try {
                File outFile = this._dst.getDstFile();
                writer = new BufferedWriter(new FileWriter(outFile));
                if (format.equals("Java1")) {
                    String name = outFile.getName();
                    name = name.substring(0, name.length() - 5);
                    fromModel.printJava(writer, name);
                    break block31;
                }
                if (format.equals("Java2")) {
                    if (fromModel.getNodeCount() != 1) {
                        throw new BanProcessException("Model '" + this.getRef() + "' is not flatness model.");
                    }
                    CompilatorV1 simul = new CompilatorV1(fromModel.getNode(0), fromModel);
                    try {
                        simul.goInitialState();
                    }
                    catch (StepperException e) {
                        throw new BanProcessException(e);
                    }
                    String name = outFile.getName();
                    name = name.substring(0, name.length() - 5);
                    simul.printJavaCode(writer, name);
                    try (OutputStream dataStream = null;){
                        File dataFile = new File(outFile.getParentFile(), name + ".data");
                        dataStream = new BufferedOutputStream(new FileOutputStream(dataFile));
                        simul.printBinaryInformations(dataStream);
                        break block31;
                    }
                }
                fromModel.printOTools(writer, format);
            }
            catch (GenerateException e) {
                throw new AltaProcessException(e);
            }
            catch (IOException e) {
                throw new AltaProcessException(e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.setResult(true);
    }
}

