/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.error;

import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class LoopManager {
    List<List<Var>> _loops = new ArrayList<List<Var>>();

    public static List<Var> realLoop(LinkedList<Var> cur) {
        if (cur.size() < 2) {
            return cur;
        }
        if (cur.getFirst() == cur.getLast()) {
            return cur;
        }
        LinkedList<Var> result = new LinkedList<Var>();
        ListIterator<Var> i = cur.listIterator(cur.size());
        Var last = cur.getLast();
        result.addFirst(i.previous());
        while (i.hasPrevious()) {
            Var var = i.previous();
            result.addFirst(var);
            if (var != last) continue;
            return result;
        }
        return cur;
    }

    public void addLoop(List<Var> loop) {
        if (loop.size() < 2) {
            return;
        }
        ArrayList<Var> realLoop = new ArrayList<Var>(loop.size() / 4 + 3);
        Var last = loop.get(loop.size() - 1);
        for (Var cur : loop) {
            if (last != null && last == cur) {
                last = null;
            }
            if (last != null) continue;
            realLoop.add(cur);
        }
        this._loops.add(realLoop);
    }

    public int getNbrLoop() {
        return this._loops.size();
    }

    public List<Var> getLoop(int i) {
        return this._loops.get(i);
    }

    public int getMsgCount() {
        return this._loops.size();
    }

    public String getMsg(int idx) {
        StringBuffer sb = new StringBuffer((this._loops.size() + 1) * 20);
        List<Var> loop = this.getLoop(idx);
        int size = loop.size();
        for (int i = 0; i < size; ++i) {
            Var cur = loop.get(i);
            if (i > 0) {
                sb.append("\n\t<= ");
            }
            sb.append(cur.getName());
            Simular sim = cur.getSimular();
            Collection<Var> alias = sim.getListAlias();
            if (alias.size() <= 0) continue;
            sb.append(" [ ");
            for (Var var : alias) {
                sb.append(var.getName()).append(" ");
            }
            sb.append("] ");
        }
        sb.append("\n");
        return sb.toString();
    }
}

