/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.error;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.util.destination.Record;
import java.text.MessageFormat;
import java.util.logging.Level;

public class TranslateException
extends Exception
implements Record {
    String _keyFormat;
    Object[] _arguments;
    TranslateException _parent;
    Data _cause;
    int _line = -1;

    public TranslateException(String keyFormat, Object ... arguments) {
        this._keyFormat = keyFormat;
        this._arguments = arguments;
    }

    public TranslateException(Data cause, String keyFormat, Object ... arguments) {
        this._cause = cause;
        this._keyFormat = keyFormat;
        this._arguments = arguments;
    }

    public TranslateException(TranslateException parent, String keyFormat, Object ... arguments) {
        this._parent = parent;
        this._keyFormat = keyFormat;
        this._arguments = arguments;
    }

    public void setLine(int line) {
        this._line = line;
    }

    @Override
    public String getMessage() {
        try {
            return MessageFormat.format(MsgTrans.getString(this._keyFormat), this._arguments);
        }
        catch (IllegalArgumentException e) {
            MsgTrans.LOG.log(Level.SEVERE, "IllegalArgumentException from MessageFormat\nCode : " + this._keyFormat + "\nMsg : " + MsgTrans.getString(this._keyFormat), e);
            return MsgTrans.getString(this._keyFormat);
        }
    }

    protected static void printData(StringBuffer out, Data cause, String msg) {
        if (cause != null) {
            String name = cause.getClass().getSimpleName();
            if (name.startsWith("Expr")) {
                name = "Expr";
            }
            out.append(name);
            out.append(" : ");
            out.append(cause.getStart());
            out.append(" : ");
            if (msg != null) {
                out.append(msg);
            } else {
                String info = cause.getInfo();
                if (info == null || info.length() == 0) {
                    out.append(MsgTrans.getString("EXC_ATTACH_DATA"));
                } else {
                    out.append(MsgTrans.getString(info));
                }
            }
            out.append("\n");
            TranslateException.printData(out, cause.getBrother(), null);
        }
    }

    public void print(StringBuffer out) {
        if (this._parent != null) {
            this._parent.print(out);
        }
        if (this._cause != null) {
            TranslateException.printData(out, this._cause, this.getMessage());
        } else {
            out.append("AltaRica : ");
            out.append(this._line);
            out.append(" : ");
            out.append(this.getMessage());
            out.append("\n");
        }
    }

    public TranslateException getParent() {
        return this._parent;
    }

    public String getBaseName() {
        if (this._cause != null) {
            String name = this._cause.getClass().getSimpleName();
            if (name.startsWith("Expr")) {
                name = "Expr";
            }
            return name;
        }
        return "AltaRica";
    }

    public int getLine() {
        if (this._cause != null) {
            return this._cause.getStart();
        }
        return this._line;
    }

    public String getCodeMsg() {
        return this._keyFormat;
    }

    public Object[] getArgsMsg() {
        return this._arguments;
    }
}

