/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.error;

import com.dassault.cecilia.lib.mbsa.translator.error.MessageManager;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyItem;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyOptionsAccessor;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.util.destination.Record;
import java.util.ArrayList;
import java.util.List;

public class VerifyManager
implements MessageManager {
    VerifyOptionsAccessor _optsAccessor;
    List<VerifyItem> _errors;

    public VerifyManager(VerifyOptionsAccessor optsAccessor) {
        this._optsAccessor = optsAccessor;
        this._errors = new ArrayList<VerifyItem>();
    }

    public boolean withWarning(String key) {
        return this._optsAccessor.withWarning(key);
    }

    public void setOption(String key, int level) {
        this._optsAccessor.setOption(key, level);
    }

    public void addError(String key, Data src, String keyMsg, Object ... arguments) {
        if (!this.withWarning(key)) {
            return;
        }
        this._errors.add(new VerifyItem(key, src, keyMsg, arguments));
    }

    public void addWarning(Data src, String keyMsg, Object ... arguments) {
        this._errors.add(new VerifyItem(null, src, keyMsg, arguments));
    }

    @Override
    public int getMsgCount() {
        return this._errors.size();
    }

    @Override
    public String getMsg(int i) {
        StringBuffer sb = new StringBuffer(256);
        this._errors.get(i).print(sb);
        return sb.toString();
    }

    @Override
    public boolean withError() {
        for (VerifyItem item : this._errors) {
            if (item._key == null || !this._optsAccessor.withError(item._key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Record getRecord(int i) {
        return this._errors.get(i);
    }
}

