/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Sub;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class DataFlow {
    Node _node;
    LinkedList<Expr> _asserts;
    LinkedHashSet<String> _flows;
    LinkedList<Flow> _localsNodef;
    private static final int PROP_DEF_MAX_FLOW = 15000;
    private static final String PROP_MAX_FLOW = "cecilia.mbsa.translator.dataflow.MaxFlow";
    protected static final int MAX_FLOW = Integer.getInteger("cecilia.mbsa.translator.dataflow.MaxFlow", 15000);
    private static final int PROP_DEF_ALTALIB_DATAFLOW_LIMIT = 500000;
    private static final String PROP_ALTALIB_DATAFLOW_LIMIT = "cecilia.mbsa.translator.dataflow.SimulLimit";
    private static final String PROP_DATAFLOW_NOSORT = "cecilia.mbsa.translator.dataflow.NoSort";

    public DataFlow(Node node, List<Expr> asserts) {
        this._node = node;
        this._asserts = new LinkedList<Expr>(asserts);
        this._flows = new LinkedHashSet();
        this._localsNodef = new LinkedList();
        this.sortFlows();
    }

    private void sortFlows() {
        Flow flow;
        int i;
        for (i = 0; i < this._node.getFlowCount(); ++i) {
            flow = this._node.getFlow(i);
            if (flow.getOrientation() != '\u0003') continue;
            this._flows.add(flow.getName());
        }
        for (i = 0; i < this._node.getFlowCount(); ++i) {
            flow = this._node.getFlow(i);
            if (flow.getOrientation() != '\u0002') continue;
            this._flows.add(flow.getName());
        }
        for (i = 0; i < this._node.getSubCount(); ++i) {
            Sub sub = this._node.getSub(i);
            for (int j = 0; j < sub.getType().getFlowCount(); ++j) {
                Flow flow2 = sub.getType().getFlow(j);
                if (flow2.getOrientation() != '\u0001') continue;
                this._flows.add(sub.getName() + "." + flow2.getName());
            }
        }
    }

    private String messag(String flow) {
        return "DataFlow(" + this._node.getName() + ", " + flow + ")";
    }

    private Expr createExprFromFlow(String name) {
        Object context = "";
        Node node = this._node;
        String flowName = name;
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            context = name.substring(0, pos);
            node = ((Sub)this._node.findData(4, this._node, (String)context)).getType();
            flowName = name.substring(pos + 1);
            context = (String)context + ".";
        }
        Flow flow = node.getFlow(flowName);
        assert (flow != null);
        return new ExprVar(flow, (String)context);
    }

    public List<Expr> getAssert() {
        return this._asserts;
    }

    public List<Flow> getLocalNodef() {
        return this._localsNodef;
    }

    public void action(boolean simul) throws TranslateException {
        LinkedList<Expr> dfAsserts = new LinkedList<Expr>();
        ArrayList<DataFromFlow> dffs = new ArrayList<DataFromFlow>();
        boolean hideDataFlow = true;
        LinkedHashMap<String, Expr> realDataFlows = new LinkedHashMap<String, Expr>();
        Iterator i = this._asserts.iterator();
        while (i.hasNext()) {
            String flow;
            Expr previousExpr;
            Expr left;
            Expr expr = (Expr)i.next();
            if (!ExprOp.isType(expr, ExprOp.Type.EQ) || !((left = expr.getArg(0)) instanceof ExprVar) || (previousExpr = (Expr)realDataFlows.get(flow = left.toString())) != null) continue;
            realDataFlows.put(flow, expr);
            i.remove();
        }
        if (this._flows.size() - realDataFlows.size() > MAX_FLOW) {
            throw this.CreateException("EXC_DFW_MAX_FLOW", "???", this._flows.size(), MAX_FLOW);
        }
        for (String curFlow : this._flows) {
            Object dfExpr = (Expr)realDataFlows.remove(curFlow);
            if (dfExpr == null) {
                dfExpr = this.findRealDataFlowExpr(curFlow);
            }
            if (dfExpr == null) {
                dfExpr = this.findHideDataFlowExpr(curFlow);
            }
            if (dfExpr == null) {
                hideDataFlow = false;
                DataFromFlow dff = this.createDataFromFlow(curFlow);
                if (dff._affectations.size() == 0) {
                    Flow flow = this._node.getFlow(curFlow);
                    if (flow != null && flow.getOrientation() == '\u0003') {
                        this._localsNodef.addLast(flow);
                        continue;
                    }
                    throw this.CreateException("EXC_DFW_NOCONNECT", curFlow, new Object[0]);
                }
                dffs.add(dff);
                dfExpr = dff.toExpr(this._node);
            }
            if (dfExpr == null) {
                throw this.CreateException("EXC_DFW_INTERNAL", curFlow, new Object[0]);
            }
            dfAsserts.addLast((Expr)dfExpr);
        }
        if (this._asserts.size() > 0 || realDataFlows.size() > 0) {
            StringBuffer sb = new StringBuffer(40 * (this._asserts.size() + realDataFlows.size()));
            for (Expr expr : this._asserts) {
                sb.append("\t");
                sb.append(expr);
                sb.append("\n");
            }
            for (Expr expr : realDataFlows.values()) {
                sb.append("\t");
                sb.append(expr);
                sb.append("\n");
            }
            throw this.CreateException("EXC_DFW_ASSERT_EXIST", "???", sb.toString());
        }
        this._asserts = dfAsserts;
        if (!hideDataFlow && simul) {
            for (DataFromFlow dff : dffs) {
                dff.simul(dfAsserts);
            }
        }
        this.verifyAffect(hideDataFlow);
        this.ReorderAssert();
    }

    protected TranslateException CreateException(String key, String flow, Object ... params) {
        Object[] args = new Object[params.length + 2];
        args[0] = this._node.getName();
        args[1] = flow;
        for (int i = 0; i < params.length; ++i) {
            args[i + 2] = params[i];
        }
        return new TranslateException(this._node, key, args);
    }

    private DataFromFlow createDataFromFlow(String flow) throws TranslateException {
        DataFromFlow dff = new DataFromFlow();
        dff._flow = flow;
        ListIterator<Expr> i = this._asserts.listIterator();
        while (i.hasNext()) {
            LinkedList<Expr> conditions;
            Expr expr = (Expr)i.next();
            if (!dff.recupFromExpr(expr, conditions = new LinkedList<Expr>())) continue;
            Expr spExpr = dff.simplifyToExpr(expr);
            if (spExpr == null) {
                i.remove();
                continue;
            }
            if (spExpr == expr) continue;
            i.set(spExpr);
        }
        return dff;
    }

    private Expr findRealDataFlowExpr(String flow) {
        Iterator i = this._asserts.iterator();
        while (i.hasNext()) {
            Expr expr = (Expr)i.next();
            if (!this.isRealDFExpr(expr, flow)) continue;
            i.remove();
            return expr;
        }
        return null;
    }

    private boolean isRealDFExpr(Expr expr, String flow) {
        if (!ExprOp.isType(expr, ExprOp.Type.EQ)) {
            return false;
        }
        Expr left = expr.getArg(0);
        if (!(left instanceof ExprVar)) {
            return false;
        }
        return left.toString().equals(flow);
    }

    private boolean isRealDFVar(Expr left, String flow) {
        if (!(left instanceof ExprVar)) {
            return false;
        }
        return left.toString().equals(flow);
    }

    private Expr findHideDataFlowExpr(String flow) throws TranslateException {
        ListIterator<Expr> i = this._asserts.listIterator();
        while (i.hasNext()) {
            Expr expr = (Expr)i.next();
            if (!this.isHideDFExpr(expr, flow)) continue;
            Expr dfExpr = this.createHideDFExpr(expr, flow);
            assert (dfExpr != null) : "Error - createHideDFExpr(" + expr + ", " + flow + ")\n";
            Expr spExpr = this.simplifyHideDFExpr(expr, flow);
            if (spExpr == null) {
                i.remove();
            } else if (spExpr != expr) {
                i.set(spExpr);
            }
            Expr var = this.createExprFromFlow(flow);
            var.setPosition(this.messag(flow) + " rewrite");
            ExprOp result = new ExprOp(ExprOp.Type.EQ, var, dfExpr);
            result.setPosition(this.messag(flow) + " rewrite");
            return result;
        }
        return null;
    }

    private boolean isHideDFExpr(Expr expr, String flow) {
        if (expr instanceof ExprOp) {
            switch (((ExprOp)expr).getType()) {
                case ITE: {
                    if (!this.isHideDFExpr(expr.getArg(1), flow)) {
                        return false;
                    }
                    return this.isHideDFExpr(expr.getArg(2), flow);
                }
                case AND: {
                    int cpt = 0;
                    for (int i = 0; i < expr.getArgCount(); ++i) {
                        if (!this.isHideDFExpr(expr.getArg(i), flow)) continue;
                        ++cpt;
                    }
                    return cpt == 1;
                }
                case EQ: {
                    return this.isRealDFVar(expr.getArg(0), flow);
                }
            }
        }
        return false;
    }

    private Expr createHideDFExpr(Expr expr, String flow) throws TranslateException {
        if (expr instanceof ExprOp) {
            switch (((ExprOp)expr).getType()) {
                case ITE: {
                    Expr Then = this.createHideDFExpr(expr.getArg(1), flow);
                    assert (Then != null) : this.messag(flow) + " - createHideDFExpr(" + expr + ")\n";
                    Expr Else = this.createHideDFExpr(expr.getArg(2), flow);
                    assert (Else != null) : this.messag(flow) + " - createHideDFExpr(" + expr + ")\n";
                    ExprOp result = new ExprOp(ExprOp.Type.ITE, expr.getArg(0), Then, Else);
                    result.setPosition(this.messag(flow) + " rewrite");
                    return ((Expr)result).simplify(this._node, true);
                }
                case AND: {
                    Expr create = null;
                    for (int i = 0; create == null && i < expr.getArgCount(); ++i) {
                        if (!this.isHideDFExpr(expr.getArg(i), flow)) continue;
                        create = this.createHideDFExpr(expr.getArg(i), flow);
                    }
                    return create;
                }
                case EQ: {
                    if (!this.isRealDFVar(expr.getArg(0), flow)) break;
                    return expr.getArg(1);
                }
            }
        }
        return null;
    }

    private Expr simplifyHideDFExpr(Expr expr, String flow) {
        if (expr instanceof ExprOp) {
            switch (((ExprOp)expr).getType()) {
                case ITE: {
                    Expr Then = this.simplifyHideDFExpr(expr.getArg(1), flow);
                    Expr Else = this.simplifyHideDFExpr(expr.getArg(2), flow);
                    if (Then == null && Else == null) {
                        return null;
                    }
                    if (Else == null) {
                        ExprOp result = new ExprOp(ExprOp.Type.IMPLY, expr.getArg(0), Then);
                        result.setPosition(this.messag(flow) + " rewrite (simplify HideDF)");
                        return result;
                    }
                    if (Then == null) {
                        ExprOp neg = new ExprOp(ExprOp.Type.NOT, expr.getArg(0));
                        neg.setPosition(this.messag(flow) + " rewrite (simplify HideDF)");
                        ExprOp result = new ExprOp(ExprOp.Type.IMPLY, neg, Else);
                        result.setPosition(this.messag(flow) + " rewrite (simplify HideDF)");
                        return result;
                    }
                    if (Then != expr.getArg(1)) {
                        expr.setArg(1, Then);
                    }
                    if (Else != expr.getArg(2)) {
                        expr.setArg(2, Else);
                    }
                    return expr;
                }
                case AND: {
                    ArrayList<Expr> args = new ArrayList<Expr>();
                    for (int i = 0; i < expr.getArgCount(); ++i) {
                        Expr simple = this.simplifyHideDFExpr(expr.getArg(i), flow);
                        if (simple == null) continue;
                        args.add(simple);
                    }
                    if (args.size() == 0) {
                        return null;
                    }
                    if (args.size() == 1) {
                        return (Expr)args.get(0);
                    }
                    ExprOp result = new ExprOp(ExprOp.Type.AND, args);
                    result.setPosition(this.messag(flow) + " rewrite (simplify HideDF)");
                    return result;
                }
                case EQ: {
                    if (!this.isRealDFVar(expr.getArg(0), flow)) break;
                    return null;
                }
            }
        }
        return expr;
    }

    private void verifyAffect(boolean hideDataFlow) throws TranslateException {
        for (Expr expr : this._asserts) {
            Expr badAffect;
            assert (ExprOp.isType(expr, ExprOp.Type.EQ));
            assert (expr.getArg(0) instanceof ExprVar);
            if (!hideDataFlow && DataFlow.findVarOutFlow(expr.getArg(1))) {
                throw this.CreateException("EXC_DFW_AFFECT_OUT", expr.getArg(0).toString(), new Object[0]);
            }
            if (!expr.getArg(0).getDomain().isSymbolic() || (badAffect = expr.getArg(1).verifySymbolic(((ExprVar)expr.getArg(0)).getVar())) == null) continue;
            throw this.CreateException("EXC_DFW_AFFECT_OUTOFRANGE", expr.getArg(0).toString(), expr.getArg(0).getDomain().toString(), badAffect.toString());
        }
    }

    private static boolean findVarOutFlow(Expr expr) {
        if (expr instanceof ExprVar) {
            Var var = ((ExprVar)expr).getVar();
            if (var instanceof Flow) {
                Flow flow = (Flow)var;
                switch (flow.getOrientation()) {
                    case '\u0001': {
                        return ((ExprVar)expr).getContext().length() > 0;
                    }
                    case '\u0002': {
                        return ((ExprVar)expr).getContext().length() == 0;
                    }
                }
            }
        } else {
            for (int i = 0; i < expr.getArgCount(); ++i) {
                if (!DataFlow.findVarOutFlow(expr.getArg(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void ReorderAssert() throws TranslateException {
        DAG dag = new DAG();
        for (Expr expr : this._asserts) {
            dag.play(expr);
        }
        dag.verify();
        if (Boolean.getBoolean(PROP_DATAFLOW_NOSORT)) {
            return;
        }
        this._asserts = dag.sort();
    }

    class DataFromFlow {
        String _flow;
        List<Expr> _conditions = new ArrayList<Expr>();
        List<Expr> _affectations = new ArrayList<Expr>();

        DataFromFlow() {
        }

        public boolean recupFromExpr(Expr expr, LinkedList<Expr> conditions) throws TranslateException {
            boolean result;
            block14: {
                block13: {
                    result = false;
                    if (!(expr instanceof ExprOp)) break block13;
                    switch (((ExprOp)expr).getType()) {
                        case ITE: {
                            conditions.addLast(expr.getArg(0));
                            result |= this.recupFromExpr(expr.getArg(1), conditions);
                            conditions.removeLast();
                            ExprOp negation = new ExprOp(ExprOp.Type.NOT, expr.getArg(0));
                            negation.setPosition(DataFlow.this.messag(this._flow) + " rewrite (DFF)");
                            conditions.addLast(negation);
                            result |= this.recupFromExpr(expr.getArg(2), conditions);
                            conditions.removeLast();
                            break block14;
                        }
                        case IMPLY: {
                            conditions.addLast(expr.getArg(0));
                            result |= this.recupFromExpr(expr.getArg(1), conditions);
                            conditions.removeLast();
                            break block14;
                        }
                        case AND: {
                            for (int i = 0; i < expr.getArgCount(); ++i) {
                                result |= this.recupFromExpr(expr.getArg(i), conditions);
                            }
                            break block14;
                        }
                        case EQ: {
                            if (DataFlow.this.isRealDFVar(expr.getArg(0), this._flow)) {
                                Expr condition;
                                switch (conditions.size()) {
                                    case 0: {
                                        condition = DataFlow.this._node.getModel().getBooleanExpr(true);
                                        break;
                                    }
                                    case 1: {
                                        condition = conditions.getFirst();
                                        break;
                                    }
                                    default: {
                                        condition = new ExprOp(ExprOp.Type.AND, conditions);
                                        condition.setPosition(DataFlow.this.messag(this._flow) + " rewrite (DFF)");
                                    }
                                }
                                this._conditions.add(condition);
                                this._affectations.add(expr.getArg(1));
                                result = true;
                            }
                            break block14;
                        }
                        default: {
                            throw DataFlow.this.CreateException("EXC_DFW_EXPR_NO_DFW", this._flow, expr);
                        }
                    }
                }
                if (expr instanceof ExprVar) {
                    throw DataFlow.this.CreateException("EXC_DFW_EXPR_VAR", this._flow, expr);
                }
                throw DataFlow.this.CreateException("EXC_DFW_EXPR_NO_DFW", this._flow, expr);
            }
            return result;
        }

        public Expr simplifyToExpr(Expr expr) {
            if (expr instanceof ExprOp) {
                switch (((ExprOp)expr).getType()) {
                    case ITE: {
                        Expr Then = this.simplifyToExpr(expr.getArg(1));
                        Expr Else = this.simplifyToExpr(expr.getArg(2));
                        if (Then == null && Else == null) {
                            return null;
                        }
                        if (Else == null) {
                            ExprOp result = new ExprOp(ExprOp.Type.IMPLY, expr.getArg(0), Then);
                            result.setPosition(DataFlow.this.messag(this._flow) + " rewrite (simplify DFF)");
                            return result;
                        }
                        if (Then == null) {
                            ExprOp neg = new ExprOp(ExprOp.Type.NOT, expr.getArg(0));
                            neg.setPosition(DataFlow.this.messag(this._flow) + " rewrite (simplify DFF)");
                            ExprOp result = new ExprOp(ExprOp.Type.IMPLY, neg, Else);
                            result.setPosition(DataFlow.this.messag(this._flow) + " rewrite (simplify DFF)");
                            return result;
                        }
                        if (Then != expr.getArg(1)) {
                            expr.setArg(1, Then);
                        }
                        if (Else != expr.getArg(2)) {
                            expr.setArg(2, Else);
                        }
                        return expr;
                    }
                    case IMPLY: {
                        Expr Then = this.simplifyToExpr(expr.getArg(1));
                        if (Then == null) {
                            return null;
                        }
                        if (Then != expr.getArg(1)) {
                            expr.setArg(1, Then);
                        }
                        return expr;
                    }
                    case AND: {
                        ArrayList<Expr> args = new ArrayList<Expr>();
                        for (int i = 0; i < expr.getArgCount(); ++i) {
                            Expr simple = this.simplifyToExpr(expr.getArg(i));
                            if (simple == null) continue;
                            args.add(simple);
                        }
                        if (args.size() == 0) {
                            return null;
                        }
                        if (args.size() == 1) {
                            return (Expr)args.get(0);
                        }
                        ExprOp result = new ExprOp(ExprOp.Type.AND, args);
                        result.setPosition(DataFlow.this.messag(this._flow) + " rewrite (simplify DFF)");
                        return result;
                    }
                    case EQ: {
                        if (!DataFlow.this.isRealDFVar(expr.getArg(0), this._flow)) break;
                        return null;
                    }
                }
            }
            return expr;
        }

        public Expr toExpr(Node node) throws TranslateException {
            Expr affect = null;
            if (this._conditions.size() <= 0) {
                throw DataFlow.this.CreateException("EXC_DFW_INTERNAL", this._flow, new Object[0]);
            }
            if (this._conditions.size() == 1) {
                affect = this._affectations.get(0);
            } else if (this._conditions.size() == 2) {
                affect = new ExprOp(ExprOp.Type.ITE, this._conditions.get(0), this._affectations.get(0), this._affectations.get(1));
                affect.setPosition(DataFlow.this.messag(this._flow) + " rewrite (DFF)");
                affect = affect.verify(node, false);
            } else {
                ArrayList<Expr> args = new ArrayList<Expr>(this._conditions.size() * 2);
                for (int i = 0; i < this._conditions.size() - 1; ++i) {
                    args.add(this._conditions.get(i));
                    args.add(this._affectations.get(i));
                }
                args.add(this._affectations.get(this._affectations.size() - 1));
                affect = new ExprOp(ExprOp.Type.CASE, args);
                affect.setPosition(DataFlow.this.messag(this._flow) + " rewrite (DFF)");
                affect = affect.verify(node, false);
            }
            Expr var = DataFlow.this.createExprFromFlow(this._flow);
            var.setPosition(DataFlow.this.messag(this._flow) + " rewrite (DFF)");
            ExprOp res = new ExprOp(ExprOp.Type.EQ, var, affect);
            res.setPosition(DataFlow.this.messag(this._flow) + " rewrite (DFF)");
            return res;
        }

        private void recupDataFromVar(Expr expr, List<DataFromVar> inputs, List<DataFromVar> locals, List<Expr> dfAsserts) throws TranslateException {
            if (expr instanceof ExprVar) {
                Var var = ((ExprVar)expr).getVar();
                if (var instanceof Flow && ((Flow)var).getOrientation() == '\u0003') {
                    for (DataFromVar dfv : locals) {
                        if (!dfv.equivalent((ExprVar)expr)) continue;
                        if (dfv._define == null) {
                            throw DataFlow.this.CreateException("EXC_DFW_SIMUL_LOOP", dfv._exprs.get(0).toString(), new Object[0]);
                        }
                        return;
                    }
                    for (Expr eAssert : DataFlow.this._asserts) {
                        Expr left;
                        if (!ExprOp.isType(eAssert, ExprOp.Type.EQ) || !((left = eAssert.getArg(0)) instanceof ExprVar) || ((ExprVar)left).getVar() != var) continue;
                        DataFromVar dfv = new DataFromVar((ExprVar)expr);
                        locals.add(dfv);
                        this.recupDataFromVar(eAssert.getArg(1), inputs, locals, dfAsserts);
                        locals.remove(dfv);
                        dfv._define = eAssert.getArg(1);
                        locals.add(dfv);
                        return;
                    }
                    throw DataFlow.this.CreateException("EXC_DFW_INTERNAL", this._flow, new Object[0]);
                }
                for (DataFromVar dfv : inputs) {
                    if (!dfv.equivalent((ExprVar)expr)) continue;
                    return;
                }
                inputs.add(new DataFromVar((ExprVar)expr));
            } else {
                for (int i = 0; i < expr.getArgCount(); ++i) {
                    this.recupDataFromVar(expr.getArg(i), inputs, locals, dfAsserts);
                }
            }
        }

        private void printDebug(LinkedList<DataFromVar> vars) {
            System.out.println("-------------------------------------------");
            Iterator i = vars.iterator();
            while (i.hasNext()) {
                System.out.println(((DataFromVar)i.next()).toString());
            }
            System.out.println("-------------------------------------------");
        }

        public void simul(List<Expr> dfAsserts) throws TranslateException {
            LinkedList<DataFromVar> inputs = new LinkedList<DataFromVar>();
            LinkedList<DataFromVar> locals = new LinkedList<DataFromVar>();
            for (int idx = 0; idx < this._conditions.size(); ++idx) {
                this.recupDataFromVar(this._conditions.get(idx), inputs, locals, dfAsserts);
                this.recupDataFromVar(this._affectations.get(idx), inputs, locals, dfAsserts);
            }
            ListIterator i = inputs.listIterator();
            while (i.hasNext()) {
                DataFromVar dfv = (DataFromVar)i.next();
                if (!this._flow.equals(dfv._context + dfv._var.getName())) continue;
                throw DataFlow.this.CreateException("EXC_DFW_SIMUL_LOOP", this._flow, new Object[0]);
            }
            long nbrState = 1L;
            long maxState = Integer.getInteger(DataFlow.PROP_ALTALIB_DATAFLOW_LIMIT, 500000).longValue();
            i = inputs.listIterator();
            while (i.hasNext()) {
                DataFromVar dfv = (DataFromVar)i.next();
                Domain dom = dfv._var.getDomain();
                int nbrVal = dom.getNbrValue();
                if (nbrVal < 0) {
                    throw DataFlow.this.CreateException("EXC_DFW_SIMUL_INF", this._flow, dfv._context + dfv._var.getName());
                }
                if ((nbrState *= (long)nbrVal) <= maxState) continue;
                throw DataFlow.this.CreateException("EXC_DFW_SIMUL_MAX", this._flow, new Object[0]);
            }
            this.simulValues(inputs.listIterator(), new LinkedList<Double>(), inputs, locals);
        }

        private void simulValues(ListIterator<DataFromVar> iVars, LinkedList<Double> values, List<DataFromVar> inputs, List<DataFromVar> locals) throws TranslateException {
            if (iVars.hasNext()) {
                DataFromVar dfv = iVars.next();
                Domain dom = dfv._var.getDomain();
                for (int i = 0; i < dom.getNbrValue(); ++i) {
                    double val = dom.getDouble(i);
                    for (int j = 0; j < dfv._exprs.size(); ++j) {
                        dfv._exprs.get(j).setDouble(val);
                    }
                    values.addLast(val);
                    this.simulValues(iVars, values, inputs, locals);
                    values.removeLast();
                }
                iVars.previous();
            } else {
                String sResult = null;
                for (DataFromVar dfv : locals) {
                    dfv._define.evaluate();
                    double val = dfv._define.getDouble();
                    for (int j = 0; j < dfv._exprs.size(); ++j) {
                        dfv._exprs.get(j).setDouble(val);
                    }
                }
                for (int idx = 0; idx < this._conditions.size(); ++idx) {
                    Expr expr = this._conditions.get(idx);
                    expr.evaluate();
                    if (!expr.getBool()) continue;
                    expr = this._affectations.get(idx);
                    expr.evaluate();
                    if (sResult == null) {
                        sResult = DataFlow.this._node.valueToString(expr);
                        Flow flow = DataFlow.this._node.getFlow(this._flow);
                        if (flow.getDomain().verifyValueOf(expr)) continue;
                        StringBuffer sb = new StringBuffer(inputs.size() * 20);
                        this.printValuation(inputs, values, sb);
                        throw DataFlow.this.CreateException("EXC_DFW_SIMUL_AFFECT", this._flow, sResult, flow.getDomain(), sb.toString());
                    }
                    String nResult = DataFlow.this._node.valueToString(expr);
                    if (sResult.equals(nResult)) continue;
                    StringBuffer sb = new StringBuffer(inputs.size() * 20);
                    this.printValuation(inputs, values, sb);
                    throw DataFlow.this.CreateException("EXC_DFW_SIMUL_INCOHERENCE", this._flow, sResult, nResult, sb.toString());
                }
                if (sResult == null) {
                    StringBuffer sb = new StringBuffer(inputs.size() * 20);
                    this.printValuation(inputs, values, sb);
                    throw DataFlow.this.CreateException("EXC_DFW_SIMUL_INCOMPLETUDE", this._flow, sb.toString());
                }
            }
        }

        private void printValuation(List<DataFromVar> vars, List<Double> values, StringBuffer sb) {
            assert (vars.size() == values.size());
            Iterator<DataFromVar> iVar = vars.iterator();
            Iterator<Double> iVal = values.iterator();
            while (iVar.hasNext()) {
                DataFromVar dfv = iVar.next();
                sb.append("\t\t");
                sb.append(dfv._context);
                sb.append(dfv._var.getName());
                sb.append(" = ");
                sb.append(dfv._var.getDomain().toString(iVal.next()));
                sb.append("\n");
            }
        }
    }

    class DAG {
        List<myVar> _lVars = new ArrayList<myVar>();
        Map<String, myVar> _mVars = new HashMap<String, myVar>();

        DAG() {
        }

        myVar get(Expr var, boolean add) {
            assert (var instanceof ExprVar);
            myVar result = this._mVars.get(var.toString());
            if (result == null && add) {
                result = new myVar();
                result._name = var.toString();
                this._lVars.add(result);
                this._mVars.put(result._name, result);
            }
            return result;
        }

        void play(Expr root) {
            assert (ExprOp.isType(root, ExprOp.Type.EQ));
            assert (root.getArg(0) instanceof ExprVar);
            myVar var = this.get(root.getArg(0), true);
            var._assert = root;
            this.playSon(var, root.getArg(1));
        }

        void playSon(myVar var, Expr expr) {
            block8: {
                block7: {
                    if (!(expr instanceof ExprVar)) break block7;
                    Var evar = ((ExprVar)expr).getVar();
                    if (!(evar instanceof Flow)) break block8;
                    boolean find = false;
                    Flow flow = (Flow)evar;
                    switch (flow.getOrientation()) {
                        case '\u0001': {
                            find = ((ExprVar)expr).getContext().length() > 0;
                        }
                        case '\u0002': {
                            find = ((ExprVar)expr).getContext().length() == 0;
                        }
                        case '\u0003': {
                            find = true;
                        }
                    }
                    if (!find) break block8;
                    myVar son = this.get(expr, true);
                    if (!son._parents.contains(var)) {
                        son._parents.add(var);
                    }
                    if (var._sons.contains(son)) break block8;
                    var._sons.add(son);
                    break block8;
                }
                for (int i = 0; i < expr.getArgCount(); ++i) {
                    this.playSon(var, expr.getArg(i));
                }
            }
        }

        void verify() throws TranslateException {
            Iterator<myVar> i = this._lVars.iterator();
            while (i.hasNext()) {
                i.next()._flag = 0;
            }
            LinkedList<myVar> path = new LinkedList<myVar>();
            for (myVar var : this._lVars) {
                if (var._flag != 0) continue;
                this.verifySon(var, path);
            }
        }

        void verifySon(myVar var, LinkedList<myVar> path) throws TranslateException {
            switch (var._flag) {
                case 0: {
                    var._flag = 1;
                    path.addLast(var);
                    Iterator<myVar> i = var._sons.iterator();
                    while (i.hasNext()) {
                        this.verifySon(i.next(), path);
                    }
                    path.removeLast();
                    var._flag = (short)2;
                    break;
                }
                case 2: {
                    return;
                }
                default: {
                    path.addLast(var);
                    StringBuffer sb = new StringBuffer(path.size() * 40);
                    Iterator i = path.iterator();
                    while (i.hasNext()) {
                        sb.append("\t");
                        sb.append(((myVar)i.next())._name);
                        sb.append("\n");
                    }
                    throw DataFlow.this.CreateException("EXC_DFW_NO_DAG", "???", sb.toString());
                }
            }
        }

        LinkedList<Expr> sort() {
            Iterator<myVar> i = this._lVars.iterator();
            while (i.hasNext()) {
                i.next()._flag = 0;
            }
            LinkedList<myVar> vars = new LinkedList<myVar>();
            for (myVar var : this._lVars) {
                this.sortSon(var, vars);
            }
            LinkedList<Expr> result = new LinkedList<Expr>();
            for (myVar var : vars) {
                if (var._assert == null) continue;
                result.addLast(var._assert);
            }
            return result;
        }

        void sortSon(myVar var, LinkedList<myVar> vars) {
            if (var._flag == 0) {
                var._flag = 1;
                Iterator<myVar> i = var._sons.iterator();
                while (i.hasNext()) {
                    this.sortSon(i.next(), vars);
                }
                vars.addLast(var);
            }
        }

        class myVar {
            String _name = "";
            Expr _assert = null;
            short _flag = 0;
            List<myVar> _sons = new ArrayList<myVar>();
            List<myVar> _parents = new ArrayList<myVar>();

            myVar() {
            }
        }
    }

    class DataFromVar {
        Var _var;
        String _context;
        List<Expr> _exprs;
        Expr _define;

        DataFromVar(ExprVar first) {
            this._var = first.getVar();
            this._context = first.getContext();
            this._exprs = new ArrayList<Expr>();
            this._exprs.add(first);
        }

        boolean equivalent(ExprVar other) {
            if (this._var != other.getVar()) {
                return false;
            }
            if (!this._context.equals(other.getContext())) {
                return false;
            }
            this._exprs.add(other);
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(128);
            sb.append(this._context).append(this._var.getName()).append("\n");
            for (Expr expr : this._exprs) {
                sb.append("\t").append(expr.toLL());
                sb.append(" (").append(expr).append(")");
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

