/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.LoopManager;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.BoolDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCst;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCstEnum;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprParent;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.UndefDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import com.dassault.cecilia.lib.util.collection.IdentityHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public abstract class Expr
extends ExprParent
implements Externalizable {
    private static final String PROP_EXPR_SETFORPARENT = "cecilia.mbsa.translator.expr.ParentsWithSet";
    double _double;
    Collection<ExprParent> _parents = null;
    Scale _scale = Scale.Undef;
    private static boolean __parentsWithSet = Boolean.getBoolean("cecilia.mbsa.translator.expr.ParentsWithSet");
    protected static final HashSet<String> _javaKeys = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));

    public final Scale getScale() {
        return this._scale == Scale.Undef ? this.defineScale() : this._scale;
    }

    abstract Scale defineScale();

    public final boolean getBool() {
        if (this.getScale() == Scale.Boolean) {
            return this._double != 0.0;
        }
        throw new UnsupportedOperationException();
    }

    public final double getFloat() {
        if (this.getScale() == Scale.Float || this.getScale() == Scale.Integer) {
            return this._double;
        }
        throw new UnsupportedOperationException();
    }

    public final long getInt() {
        if (this.getScale() == Scale.Integer) {
            return (long)this._double;
        }
        throw new UnsupportedOperationException();
    }

    public final int getSymbol() {
        if (this.getScale() == Scale.Symbolic) {
            return (int)this._double;
        }
        throw new UnsupportedOperationException();
    }

    public String getString() {
        throw new UnsupportedOperationException();
    }

    public final boolean isBoolean() {
        return this.getScale() == Scale.Boolean;
    }

    public final boolean isNumeric() {
        Scale scale = this.getScale();
        return scale == Scale.Integer || scale == Scale.Float;
    }

    public final boolean isSymbolic() {
        return this.getScale() == Scale.Symbolic;
    }

    public boolean isStructured() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public Domain getDomain() {
        if (this.isBoolean()) {
            return BoolDomain.getInstance();
        }
        return UndefDomain.getInstance();
    }

    public final double getDouble() {
        return this._double;
    }

    public final void setDouble(double value) {
        this._double = value;
    }

    public final void setBool(boolean value) {
        this._double = value ? 1.0 : 0.0;
    }

    @Override
    protected void copy(Data src) {
        super.copy(src);
        assert (src instanceof Expr);
        Expr Src = (Expr)src;
        Src._double = this._double;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }

    public int hashCode() {
        switch (this.getScale()) {
            case Boolean: {
                return this._double == 0.0 ? 2 : 3;
            }
            case Symbolic: 
            case Integer: {
                return (int)this._double + 5;
            }
            case Float: {
                return (int)Double.doubleToLongBits(this._double) + 7;
            }
        }
        return 0;
    }

    @Override
    public Iterator<ExprParent> getParents() {
        if (this._parents != null) {
            return this._parents.iterator();
        }
        return super.getParents();
    }

    public boolean addParent(ExprParent parent) {
        if (__parentsWithSet) {
            if (this._parents == null) {
                this._parents = new IdentityHashSet<ExprParent>();
            }
            this._parents.add(parent);
        } else {
            if (this._parents == null) {
                this._parents = new ArrayList<ExprParent>(3);
            }
            for (int i = ((ArrayList)this._parents).size() - 1; i >= 0; --i) {
                if (((ArrayList)this._parents).get(i) == parent) {
                    return false;
                }
                assert (!((ArrayList)this._parents).get(i).equals(parent));
            }
            this._parents.add(parent);
        }
        return true;
    }

    public void removeParent(ExprParent parent) {
        if (__parentsWithSet) {
            this._parents.remove(parent);
        } else {
            for (int i = ((ArrayList)this._parents).size() - 1; i >= 0; --i) {
                if (((ArrayList)this._parents).get(i) == parent) {
                    ((ArrayList)this._parents).remove(i);
                    continue;
                }
                if (((ArrayList)this._parents).get(i).equals(parent)) assert (false);
            }
        }
    }

    @Override
    protected boolean exchangeChild(Expr oldChild, Expr newChild) {
        throw new UnsupportedOperationException("Error Expr::exchangeChild(" + oldChild.toString() + ", " + newChild.toString() + ") [" + this.toString() + "]");
    }

    public abstract int getArgCount();

    public abstract Expr getArg(int var1);

    public abstract void setArg(int var1, Expr var2);

    @Override
    protected void instance(Data src) {
        super.instance(src);
        this._double = ((Expr)src)._double;
    }

    protected abstract Expr instance(Node var1, String var2);

    public final Data instance(Node owner, String inst, ExprParent parent) {
        Expr res = this.instance(owner, inst);
        res.fixParent(parent);
        return res;
    }

    void fixParent(ExprParent parent) {
        if (parent != null && !this.addParent(parent)) {
            return;
        }
        for (int i = this.getArgCount() - 1; i >= 0; --i) {
            this.getArg(i).fixParent(this);
        }
    }

    public Expr moveTo(Node node, ExprParent parent) {
        for (int i = this.getArgCount() - 1; i >= 0; --i) {
            this.setArg(i, this.getArg(i).moveTo(node, this));
        }
        Expr curr = node.addUniqueExpr(this);
        if (curr != this) {
            if (parent != null) {
                this.removeParent(parent);
                curr.addParent(parent);
            }
            return curr;
        }
        return this;
    }

    public Expr convertVar(Node node) throws TranslateException {
        int nbrArg = this.getArgCount();
        for (int i = 0; i < nbrArg; ++i) {
            this.setArg(i, this.getArg(i).convertVar(node));
        }
        return node.addUniqueExpr(this);
    }

    public Expr verify(Node node, boolean affect) throws TranslateException {
        return this;
    }

    Expr simplify(Node node, boolean affect) throws TranslateException {
        return this;
    }

    public String toLL() {
        StringWriter sw = new StringWriter();
        IndentWriter out = new IndentWriter(sw);
        try {
            this.printOTools(out, 0);
            out.close(true);
        }
        catch (IOException e) {
            MsgTrans.LOG.log(Level.SEVERE, "IOException during transform to LL", e);
        }
        return sw.toString();
    }

    public void printOToolsArgs(IndentWriter out, String sep, int frm) throws IOException {
        out.write("(");
        for (int i = 0; i < this.getArgCount(); ++i) {
            if (i > 0) {
                out.write(sep);
            }
            this.getArg(i).printOTools(out, frm);
        }
        out.write(")");
    }

    public void printAssertLL(IndentWriter out, int frm) throws IOException {
        this.printOTools(out, frm);
    }

    @Override
    public abstract void printOTools(IndentWriter var1, int var2) throws IOException;

    public String toString() {
        StringWriter write = new StringWriter(128);
        IndentWriter out = new IndentWriter(write);
        try {
            this.printOTools(out, 0);
            out.close(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return write.toString();
    }

    public void printMocaArgs(IndentWriter out, String sep) throws IOException {
        out.write("(");
        for (int i = 0; i < this.getArgCount(); ++i) {
            if (i > 0) {
                out.write(sep);
            }
            this.getArg(i).printMoca(out);
        }
        out.write(")");
    }

    public abstract void printMoca(IndentWriter var1) throws IOException;

    public static String toIDJava(String var) {
        if (_javaKeys.contains(var)) {
            return var + "$$$java";
        }
        StringBuffer sb = new StringBuffer(var.length() * 125 / 100);
        for (int i = 0; i < var.length(); ++i) {
            char car = var.charAt(i);
            if (Character.isLetter(car)) {
                sb.append(car);
                continue;
            }
            if (Character.isDigit(car)) {
                sb.append(car);
                continue;
            }
            if (car == '_') {
                sb.append(car);
                continue;
            }
            if (car == '.') {
                sb.append('$');
                continue;
            }
            if (car == '^') {
                sb.append("$$");
                continue;
            }
            sb.append("_$$_");
        }
        return sb.toString();
    }

    public void printJavaArgs(IndentWriter out, String sep, Set<String> outs, Map<String, Expr> csts) throws IOException {
        out.write("(");
        for (int i = 0; i < this.getArgCount(); ++i) {
            if (i > 0) {
                out.write(sep);
            }
            this.getArg(i).printJava(out, outs, csts);
        }
        out.write(")");
    }

    public abstract void printJava(IndentWriter var1, Set<String> var2, Map<String, Expr> var3) throws IOException;

    public void printNaNJavaArgs(IndentWriter out, Set<String> outs, String op, Map<String, Expr> csts) throws IOException {
        int i = 0;
        while (i < this.getArgCount() - 1) {
            out.write(op);
            out.write("(");
            this.getArg(i++).printNaNJava(out, outs, csts);
            out.write(",");
        }
        this.getArg(i).printNaNJava(out, outs, csts);
        while (i-- > 0) {
            out.write(")");
        }
    }

    public abstract void printNaNJava(IndentWriter var1, Set<String> var2, Map<String, Expr> var3) throws IOException;

    public boolean printAssertJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        return false;
    }

    protected void printVarDeclarationJava(IndentWriter out, Set<String> vars, Set<String> outs, Map<String, Expr> csts, Map<String, Expr> links) throws IOException {
        for (int i = 0; i < this.getArgCount(); ++i) {
            this.getArg(i).printVarDeclarationJava(out, vars, outs, csts, links);
        }
    }

    public boolean printDeclarationJava(IndentWriter out, Set<String> vars, Set<String> outs, Map<String, Expr> csts, Map<String, Expr> links) throws IOException {
        out.addData(this);
        throw new IOException("No Dataflow assertion");
    }

    public boolean isLink() {
        return false;
    }

    public void printLinkJava(IndentWriter out) throws IOException {
        assert (this.isLink());
    }

    public boolean withType(Class<? extends Expr> type) {
        if (type == this.getClass()) {
            return true;
        }
        for (int i = 0; i < this.getArgCount(); ++i) {
            if (!this.getArg(i).withType(type)) continue;
            return true;
        }
        return false;
    }

    public Expr translateFct(Node node) {
        for (int i = 0; i < this.getArgCount(); ++i) {
            Expr expr = this.getArg(i).translateFct(node);
            if (expr == null) continue;
            this.setArg(i, expr);
        }
        return null;
    }

    public Expr translateLink(Node node) {
        for (int i = 0; i < this.getArgCount(); ++i) {
            Expr expr = this.getArg(i).translateLink(node);
            if (expr == null) continue;
            this.setArg(i, expr);
        }
        return null;
    }

    public void rename(Model.RenameHelper helper, Node node) {
        for (int i = 0; i < this.getArgCount(); ++i) {
            this.getArg(i).rename(helper, node);
        }
    }

    public boolean isAliasAssert() {
        return false;
    }

    public boolean useVar(Var var) {
        for (int i = 0; i < this.getArgCount(); ++i) {
            if (!this.getArg(i).useVar(var)) continue;
            return true;
        }
        return false;
    }

    protected Flow getFirstFlow() {
        for (int i = 0; i < this.getArgCount(); ++i) {
            Flow res = this.getArg(i).getFirstFlow();
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void verifyGuard(VerifyManager mng, Data src) {
        Flow flow;
        if (mng.withWarning("GuardWithFlow") && (flow = this.getFirstFlow()) != null) {
            mng.addError("GuardWithFlow", src, "WRN_GUARD_WITHFLOW", flow.getName());
        }
    }

    @Override
    public void setFlagPropage(char value) {
        if (this._flag == value) {
            return;
        }
        this._flag = value;
        for (int i = 0; i < this.getArgCount(); ++i) {
            this.getArg(i).setFlagPropage(value);
        }
    }

    protected void verifyLoop(LoopManager mng, LinkedList<Var> lst, Map<Var, Expr> affects) {
        if (this._flag == 'I') {
            this._flag = (char)87;
            for (int i = 0; i < this.getArgCount(); ++i) {
                this.getArg(i).verifyLoop(mng, lst, affects);
            }
            this._flag = (char)84;
        } else if (this._flag == 'W') {
            for (int i = 0; i < this.getArgCount(); ++i) {
                this.getArg(i).verifyLoop(mng, lst, affects);
            }
            this._flag = (char)84;
        }
    }

    public void verifyExpr(VerifyManager mng) {
        for (int i = 0; i < this.getArgCount(); ++i) {
            this.getArg(i).verifyExpr(mng);
        }
    }

    public final double getEvaluateDouble() throws StepperException {
        if (this._flag != '\u0000') {
            this.evaluateIfNecessary();
        }
        return this._double;
    }

    protected Expr simplifyConstant(Node node) throws TranslateException {
        boolean cst = this.getArgCount() > 0;
        for (int i = 0; i < this.getArgCount() && cst; ++i) {
            if (this.getArg(i).isConstant()) continue;
            cst = false;
        }
        if (cst) {
            this.evaluate();
            Expr result = null;
            switch (this.getScale()) {
                case Boolean: {
                    return node.getModel().getBooleanExpr(this.getBool());
                }
                case Integer: {
                    result = new ExprCst(this.getInt());
                    break;
                }
                case Float: {
                    result = new ExprCst(this.getFloat());
                    break;
                }
                case Symbolic: {
                    result = new ExprCstEnum(this.getSymbol(), node.getModel().getDomainDefine().getEnumStr(this.getSymbol()));
                }
            }
            if (result != null) {
                result.copy(this);
                return node.addUniqueExpr(result);
            }
        }
        return this;
    }

    public void evaluate() throws TranslateException {
    }

    public void evaluateIfNecessary() throws StepperException {
    }

    public boolean evaluateWithNaN() throws StepperException {
        return true;
    }

    public Expr verifySymbolic(Var var) {
        return null;
    }

    public static enum Scale {
        Undef(0),
        Boolean(1),
        Integer(2),
        Float(3),
        Symbolic(4);

        short _index;

        public short getIndex() {
            return this._index;
        }

        private Scale(int idx) {
            this._index = (short)idx;
        }

        public static Scale valueOf(short idx) {
            Scale[] values = Scale.values();
            for (int i = values.length - 1; i >= 0; --i) {
                if (values[i].getIndex() != idx) continue;
                return values[i];
            }
            return Undef;
        }
    }
}

