/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.GenerateException;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprFct;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprParent;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprUndef;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Sub;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Extern
extends ExprParent {
    private static final String PROP_ALTALIB_DATAFLOW_INVERSE = "cecilia.mbsa.translator.exterm.InverseLocal";
    public static final String OBSERVER = "observer";
    public static final String PROPERTY = "property";
    public static final String PREDICATE = "predicate";
    public static final String LAW = "law";
    public static final String PARAMETER = "parameter";
    public static final String ATTRIBUTE = "attribute";
    public static final String NODEPROPERTY = "nodeproperty";
    public static final String PRIORITY = "priority";
    public static final String BUCKET = "bucket";
    public static final String PREEMPTIBLE = "preemptible";
    public static final String REMARK = "remark";
    public static final String SIMUL_DELAY = "simul-delay";
    private Tree _data;
    protected static final int XTERM_LAW_ALTAX = 1;
    protected static final int XTERM_LAW_MOCA12 = 16;
    protected static final int XTERM_LAW_ALL = -1;

    protected Extern(String name, Tree var, Tree val) {
        this._data = new Tree(273, var, val);
        this._data._sval = name;
    }

    protected Extern(Tree data) {
        this._data = data;
        this.setPosition(data.getStart());
    }

    public Tree getTree() {
        return this._data;
    }

    private static boolean containsInSet(Tree current, Tree value) {
        if (current._type == value._type) {
            return Extern.toString(current).equals(Extern.toString(value));
        }
        if (current._type == 40 && current._sval.length() == 0) {
            Tree son = (Tree)current._son;
            while (son != null) {
                if (Extern.containsInSet(son, value)) {
                    return true;
                }
                son = son._next;
            }
        }
        return false;
    }

    public boolean contains(String id, Tree tree) {
        assert (this._data._type == 273);
        if (!id.equals(this._data._sval)) {
            return false;
        }
        return Extern.containsInSet(this.getVar(), tree);
    }

    public String getName() {
        assert (this._data._type == 273);
        return this._data._sval;
    }

    public Tree getVar() {
        assert (this._data._type == 273);
        return (Tree)this._data._son;
    }

    public Tree getVal() {
        assert (this._data._type == 273);
        return this._data._next;
    }

    private void setFlag(Tree tree, char value) {
        tree._flag = value;
        switch (tree._type) {
            case 258: 
            case 304: {
                Expr expr = (Expr)tree._son;
                expr.setFlagPropage(value);
                break;
            }
            case 40: {
                Tree cur = (Tree)tree._son;
                while (cur != null) {
                    this.setFlag(cur, value);
                    cur = cur._next;
                }
                break;
            }
        }
    }

    @Override
    public void setFlagPropage(char value) {
        this._flag = value;
        this.setFlag(this.getVar(), value);
        if (this._data._next != null) {
            this.setFlag(this._data._next, value);
        }
    }

    public void verify(Node node) throws TranslateException {
        assert (this._data._type == 273);
        this.verifyTerm((Tree)this._data._son, node);
        if (this._data._next != null) {
            this.verifyTerm(this._data._next, node);
        }
    }

    private void verifyTerm(Tree tree, Node node) throws TranslateException {
        switch (tree._type) {
            case 258: {
                Expr expr = (Expr)tree._son;
                if (expr.withType(ExprUndef.class)) {
                    throw new TranslateException(expr, "EXC_EXPR_UNDEF", new Object[0]);
                }
                if (expr.isConstant()) break;
                throw new TranslateException(this, "EXC_EXPR_NOCST", new Object[0]);
            }
            case 303: {
                break;
            }
            case 40: {
                tree = (Tree)tree._son;
                while (tree != null) {
                    this.verifyTerm(tree, node);
                    tree = tree._next;
                }
                break;
            }
            case 266: {
                tree._son = node.findData(2, node, tree._sval);
                if (tree._son == null) {
                    throw new TranslateException(tree, "EXC_STATE_UNKNOW", tree._sval);
                }
                tree._sval = node.findContext(2, node, tree._sval);
                break;
            }
            case 265: {
                tree._son = node.findData(1, node, tree._sval);
                if (tree._son == null) {
                    throw new TranslateException(tree, "EXC_FLOW_UNKNOW", tree._sval);
                }
                tree._sval = node.findContext(1, node, tree._sval);
                break;
            }
            case 268: {
                tree._son = node.findData(3, node, tree._sval);
                if (tree._son == null) {
                    throw new TranslateException(tree, "EXC_EVENT_UNKNOW", tree._sval);
                }
                tree._sval = node.findContext(3, node, tree._sval);
                break;
            }
            case 269: {
                tree._son = node.findData(4, node, tree._sval);
                if (tree._son == null) {
                    throw new TranslateException(tree, "EXC_SUB_UNKNOW", tree._sval);
                }
                tree._sval = node.findContext(4, node, tree._sval);
                break;
            }
            case 304: {
                Expr expr = (Expr)tree._son;
                if (expr.withType(ExprUndef.class)) {
                    throw new TranslateException(expr, "EXC_EXPR_UNDEF", new Object[0]);
                }
                if (expr.withType(ExprFct.class)) {
                    throw new TranslateException(expr, "EXC_EXPR_FUNC", new Object[0]);
                }
                expr = expr.convertVar(node);
                tree._son = expr.verify(node, false);
            }
        }
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        assert (this._data._type == 273);
        out.addData(this);
        out.write(this._data._sval);
        out.write(" ");
        this.printOToolsTerm((Tree)this._data._son, out, frm);
        if (this._data._next != null) {
            out.write(" = ");
            this.printOToolsTerm(this._data._next, out, frm);
        } else {
            out.write(" = true");
        }
    }

    private boolean isDataFlowWithInverseLocal() {
        String value = System.getProperty(PROP_ALTALIB_DATAFLOW_INVERSE);
        if (value == null) {
            return true;
        }
        return !value.equalsIgnoreCase("false");
    }

    private void printOToolsTerm(Tree tree, IndentWriter out, int frm) throws IOException {
        switch (tree._type) {
            case 258: {
                Expr expr = (Expr)tree._son;
                if (frm == 2 && expr.isConstant() && expr.getScale() == Expr.Scale.Symbolic && this.isDataFlowWithInverseLocal()) {
                    out.write("<global ");
                    expr.printOTools(out, frm);
                    out.write(">");
                    break;
                }
                expr.printOTools(out, frm);
                break;
            }
            case 303: {
                out.write(tree._sval);
                break;
            }
            case 40: {
                if (tree._sval.length() > 0) {
                    out.write(tree._sval);
                    out.write("(");
                } else {
                    out.write("{");
                }
                Tree cur = (Tree)tree._son;
                while (cur != null) {
                    this.printOToolsTerm(cur, out, frm);
                    cur = cur._next;
                    if (cur == null) continue;
                    out.write(", ");
                }
                out.write(tree._sval.length() > 0 ? ")" : "}");
                break;
            }
            case 266: {
                out.write("<state ");
                out.write(tree._sval);
                out.write(((Var)tree._son).getName());
                out.write(">");
                break;
            }
            case 265: {
                out.write("<flow ");
                out.write(tree._sval);
                out.write(((Var)tree._son).getName());
                out.write(">");
                break;
            }
            case 268: {
                out.write("<event ");
                out.write(tree._sval);
                out.write(tree._son == null ? "<null>" : ((Event)tree._son).getName());
                out.write(">");
                break;
            }
            case 269: {
                out.write("<sub ");
                out.write(tree._sval);
                out.write(((Sub)tree._son).getName());
                out.write(">");
                break;
            }
            case 267: {
                if (frm == 2 && this.isDataFlowWithInverseLocal()) {
                    out.write(tree._sval);
                    break;
                }
                out.write("<local ");
                out.write(tree._sval);
                out.write(">");
                break;
            }
            case 304: {
                out.write("<term (");
                Expr expr = (Expr)tree._son;
                expr.printOTools(out, frm);
                out.write(")>");
            }
        }
    }

    private static void toString(Tree tree, StringBuffer out) {
        switch (tree._type) {
            case 258: {
                Expr expr = (Expr)tree._son;
                out.append(expr.toString());
                break;
            }
            case 303: {
                out.append(tree._sval);
                break;
            }
            case 40: {
                if (tree._sval.length() > 0) {
                    out.append(tree._sval);
                    out.append("(");
                } else {
                    out.append("{");
                }
                Tree cur = (Tree)tree._son;
                while (cur != null) {
                    Extern.toString(cur, out);
                    cur = cur._next;
                    if (cur == null) continue;
                    out.append(", ");
                }
                out.append(tree._sval.length() > 0 ? ")" : "}");
                break;
            }
            case 266: {
                out.append("<state ");
                out.append(tree._sval);
                out.append(((Var)tree._son).getName());
                out.append(">");
                break;
            }
            case 265: {
                out.append("<flow ");
                out.append(tree._sval);
                out.append(((Var)tree._son).getName());
                out.append(">");
                break;
            }
            case 268: {
                out.append("<event ");
                out.append(tree._sval);
                out.append(((Event)tree._son).getName());
                out.append(">");
                break;
            }
            case 269: {
                out.append("<sub ");
                out.append(tree._sval);
                out.append(((Sub)tree._son).getName());
                out.append(">");
                break;
            }
            case 267: {
                out.append("<local ");
                out.append(tree._sval);
                out.append(">");
                break;
            }
            case 304: {
                out.append("<term (");
                Expr expr = (Expr)tree._son;
                out.append(expr.toString());
                out.append(")>");
            }
        }
    }

    public static String toString(Tree tree) {
        StringBuffer sb = new StringBuffer(128);
        Extern.toString(tree, sb);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(this._data._sval);
        sb.append(" ");
        Extern.toString((Tree)this._data._son, sb);
        if (this._data._next != null) {
            sb.append(" ");
            Extern.toString(this._data._next, sb);
        }
        return sb.toString();
    }

    public void rename(Model.RenameHelper helper, Node node) {
        this.renameTerm((Tree)this._data._son, helper, node);
        if (this._data._next != null) {
            this.renameTerm(this._data._next, helper, node);
        }
    }

    private void renameTerm(Tree tree, Model.RenameHelper helper, Node node) {
        switch (tree._type) {
            case 40: {
                tree = (Tree)tree._son;
                while (tree != null) {
                    this.renameTerm(tree, helper, node);
                    tree = tree._next;
                }
                break;
            }
            case 265: 
            case 266: 
            case 268: 
            case 269: {
                tree._sval = helper.convertPath(tree._sval, node);
                break;
            }
            case 267: {
                break;
            }
            case 304: {
                Expr expr = (Expr)tree._son;
                expr.rename(helper, node);
            }
        }
    }

    public void translateLink(Node node) {
        this.translateLinkTerm((Tree)this._data._son, node);
        if (this._data._next != null) {
            this.translateLinkTerm(this._data._next, node);
        }
    }

    private void translateLinkTerm(Tree tree, Node node) {
        switch (tree._type) {
            case 40: {
                tree = (Tree)tree._son;
                while (tree != null) {
                    this.translateLinkTerm(tree, node);
                    tree = tree._next;
                }
                break;
            }
            case 304: {
                Expr expr = (Expr)tree._son;
                Expr translate = expr.translateLink(node);
                if (translate == null) break;
                tree._son = translate;
            }
        }
    }

    public void instanceLocal(Node node, String inst) {
        this.instanceLocalTerm(node, (Tree)this._data._son, inst);
        if (this._data._next != null) {
            this.instanceLocalTerm(node, this._data._next, inst);
        }
    }

    private void instanceLocalTerm(Node node, Tree tree, String inst) {
        switch (tree._type) {
            case 40: {
                Tree arg = (Tree)tree._son;
                while (arg != null) {
                    this.instanceLocalTerm(node, arg, (String)inst);
                    arg = arg._next;
                }
                break;
            }
            case 267: {
                if (((String)inst).length() > 0) {
                    inst = (String)inst + ".";
                }
                tree._sval = (String)inst + tree._sval;
                break;
            }
            case 258: 
            case 304: {
                tree._son = ((Expr)tree._son).moveTo(node, this);
            }
        }
    }

    public Data instance(Node parent, String inst) throws TranslateException {
        Tree next = null;
        Tree son = this.instanceTerm((Tree)this._data._son, parent, inst);
        if (this._data._next != null) {
            next = this.instanceTerm(this._data._next, parent, inst);
        }
        Tree data = new Tree(this._data._type, son, next);
        data._sval = this._data._sval;
        data.instance(this._data);
        Extern res = new Extern(data);
        res.instance(this);
        return res;
    }

    private Tree instanceTerm(Tree tree, Node parent, String inst) throws TranslateException {
        Data res = null;
        switch (tree._type) {
            case 258: {
                res = new Tree(tree._type, ((Expr)tree._son).instance(parent, (String)inst, this));
                break;
            }
            case 303: {
                res = new Tree(tree._type, tree._sval);
                break;
            }
            case 40: {
                res = new Tree(tree._type, tree._sval);
                Tree arg = (Tree)tree._son;
                Data iarg = res;
                while (arg != null) {
                    ((Tree)iarg)._next = this.instanceTerm(arg, parent, (String)inst);
                    iarg = ((Tree)iarg)._next;
                    arg = arg._next;
                }
                ((Tree)res)._son = ((Tree)res)._next;
                ((Tree)res)._next = null;
                break;
            }
            case 266: {
                if (((String)inst).length() > 0) {
                    inst = (String)inst + ".";
                }
                String name = (String)inst + ((Var)tree._son).getName();
                if (tree._sval.length() > 0) {
                    name = tree._sval + ((Var)tree._son).getName();
                }
                res = new Tree(tree._type, parent.getState(name));
                assert (((Tree)res)._son != null);
                break;
            }
            case 265: {
                if (((String)inst).length() > 0) {
                    inst = (String)inst + ".";
                }
                String name = (String)inst + ((Var)tree._son).getName();
                if (tree._sval.length() > 0) {
                    name = tree._sval + ((Var)tree._son).getName();
                }
                res = new Tree(tree._type, parent.getFlow(name));
                assert (((Tree)res)._son != null);
                break;
            }
            case 268: {
                if (((String)inst).length() > 0) {
                    inst = (String)inst + ".";
                }
                String name = (String)inst + ((Event)tree._son).getName();
                if (tree._sval.length() > 0) {
                    name = tree._sval + ((Event)tree._son).getName();
                }
                res = new Tree(tree._type, parent.getEvent(name));
                if (((Tree)res)._son != null) break;
                throw new TranslateException(parent, "EXC_FLATNESS_EVENT", (String)inst + name, parent.getName());
            }
            case 269: {
                StringBuffer sb = new StringBuffer(128);
                Extern.toString(tree, sb);
                res = new Tree(303, sb.toString());
                break;
            }
            case 267: {
                if (((String)inst).length() > 0) {
                    inst = (String)inst + ".";
                }
                res = new Tree(tree._type, (String)inst + tree._sval);
                break;
            }
            case 304: {
                res = new Tree(tree._type, ((Expr)tree._son).instance(parent, (String)inst, this));
            }
        }
        if (res != null) {
            res.instance(tree);
        }
        return res;
    }

    @Override
    protected boolean exchangeChild(Expr oldChild, Expr newChild) {
        boolean result = false;
        result |= this.exchangeChildTerm((Tree)this._data._son, oldChild, newChild);
        if (this._data._next != null) {
            result |= this.exchangeChildTerm(this._data._next, oldChild, newChild);
        }
        return result;
    }

    private boolean exchangeChildTerm(Tree tree, Expr oldChild, Expr newChild) {
        boolean result = false;
        switch (tree._type) {
            case 258: {
                if (tree._son != oldChild) break;
                tree._son = newChild;
                result = true;
                break;
            }
            case 40: {
                Tree arg = (Tree)tree._son;
                while (arg != null) {
                    result |= this.exchangeChildTerm(arg, oldChild, newChild);
                    arg = arg._next;
                }
                break;
            }
            case 304: {
                if (tree._son != oldChild) break;
                tree._son = newChild;
                result = true;
            }
        }
        return result;
    }

    private boolean termIsData(Tree term, int type, Data data) {
        if (term._type != type) {
            return false;
        }
        return term._son == data;
    }

    private Tree purgeDataInSet(Tree term, int type, Data data) {
        if (term._type != 40) {
            return term;
        }
        Tree res = new Tree(40, term._sval);
        res.setPosition(term, "PurgeData");
        Tree cur = (Tree)term._son;
        Tree rcur = res;
        boolean chg = false;
        while (cur != null) {
            if (this.termIsData(cur, type, data)) {
                chg = true;
            } else {
                Tree ncur = this.purgeDataInSet(cur, type, data);
                if (ncur == null) {
                    chg = true;
                } else {
                    if (rcur == res) {
                        rcur._son = ncur;
                    } else {
                        rcur._next = ncur;
                    }
                    rcur = ncur;
                    if (ncur != cur) {
                        chg = true;
                    }
                }
            }
            cur = cur._next;
        }
        if (chg) {
            if (rcur == res) {
                return null;
            }
            rcur._next = null;
            return res;
        }
        return term;
    }

    public boolean purge(int type, Data data) {
        switch (type) {
            case 3: {
                type = 268;
                break;
            }
            case 1: {
                type = 265;
                break;
            }
            case 2: {
                type = 266;
                break;
            }
            case 4: {
                type = 269;
                break;
            }
            default: {
                return false;
            }
        }
        if (this.termIsData((Tree)this._data._son, type, data)) {
            return true;
        }
        Tree res = this.purgeDataInSet((Tree)this._data._son, type, data);
        if (res == null) {
            return true;
        }
        this._data._son = res;
        if (this._data._next == null) {
            return false;
        }
        this._data._next = this.termIsData(this._data._next, type, data) ? new Tree(40, (Data)null) : ((res = this.purgeDataInSet(this._data._next, type, data)) == null ? new Tree(40, (Data)null) : res);
        return false;
    }

    public static int verifyOnlyEvent(Tree set, List<Event> evts, boolean onlySet) {
        if (set._type == 40) {
            if (onlySet && set._sval.length() != 0) {
                return Integer.MIN_VALUE;
            }
            Tree tset = (Tree)set._son;
            int cpt = 0;
            while (tset != null) {
                int add = Extern.verifyOnlyEvent(tset, evts, true);
                if (add == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                cpt += add;
                tset = tset._next;
            }
            return cpt;
        }
        if (set._type == 268) {
            if (!evts.contains(set._son)) {
                evts.add((Event)set._son);
            }
            return 1;
        }
        return Integer.MIN_VALUE;
    }

    public void printMocaObserver(IndentWriter out, Node node, Set<String> defSet) throws IOException {
        if (!this.getName().equals(OBSERVER)) {
            return;
        }
        Tree var = this.getVar();
        if (var._type != 258) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XOBSERVER"));
        }
        Expr evar = (Expr)var._son;
        if (!evar.isConstant() || !evar.isSymbolic()) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XOBSERVER"));
        }
        Tree val = this.getVal();
        if (val == null || val._type != 40 || val._sval.length() == 0) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XOBSERVER"));
        }
        if (!(val._sval.equals("count") || val._sval.equals("date") || val._sval.equals("end_value") || val._sval.equals("weighted_value"))) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XOBSERVER"));
        }
        Tree tval = (Tree)val._son;
        if (tval._type != 304) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XOBSERVER"));
        }
        Expr eval = (Expr)tval._son;
        if (defSet.contains(evar.toString())) {
            return;
        }
        out.write("ES: ");
        out.write(evar.toString());
        out.write(" = ");
        eval.printMoca(out);
        out.write(" TS: ");
        if (val._sval.equals("count")) {
            out.write("4 ;\n");
        } else if (val._sval.equals("date")) {
            out.write("6 ;\n");
        } else if (val._sval.equals("end_value")) {
            out.write("3 ;\n");
        } else if (val._sval.equals("weighted_value")) {
            out.write("5 ;\n");
        }
    }

    private boolean verifyObserver(VerifyManager mng, Node node) {
        if (!mng.withWarning("ExternObserver")) {
            return true;
        }
        mng.addError("ExternObserver", this, "WRN_XOBSERVER_DEPRECATED", new Object[0]);
        return false;
    }

    private boolean verifyPropercate(VerifyManager mng, Node node, boolean predicate) {
        Expr evar;
        Tree var = this.getVar();
        if (var._type == 258 ? !(evar = (Expr)var._son).isConstant() || !evar.isSymbolic() : var._type != 267) {
            return false;
        }
        Tree val = this.getVal();
        if (val._type != 304) {
            return false;
        }
        Expr expr = (Expr)val._son;
        return !(predicate ? !expr.isBoolean() : !expr.isNumeric());
    }

    private boolean verifyPredicate(VerifyManager mng, Node node) {
        if (!mng.withWarning("ExternPredicate")) {
            return true;
        }
        boolean result = this.verifyPropercate(mng, node, true);
        if (!result) {
            mng.addError("ExternPredicate", this, "WRN_XPREDICATE_SYNTAX", new Object[0]);
        }
        return result;
    }

    private boolean verifyProperty(VerifyManager mng, Node node) {
        if (!mng.withWarning("ExternProperty")) {
            return true;
        }
        boolean result = this.verifyPropercate(mng, node, false);
        if (!result) {
            mng.addError("ExternProperty", this, "WRN_XPROPERTY_SYNTAX", new Object[0]);
        }
        return result;
    }

    public void printMocaParameter(IndentWriter out, Node node, Set<String> defSet) throws IOException {
        if (!this.getName().equals(PARAMETER)) {
            return;
        }
        Tree var = this.getVar();
        String name = null;
        if (var._type == 258) {
            Expr evar = (Expr)var._son;
            if (evar.isConstant() && evar.isSymbolic()) {
                name = "g.." + evar.toString();
            }
        } else if (var._type == 267) {
            name = "l.." + var._sval;
        }
        if (name == null) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
        }
        if (defSet.contains(name)) {
            return;
        }
        defSet.add(name);
        out.write("const float ");
        out.write(name);
        out.write(" = ");
        Extern.printMocaParam(out, node, this.getVal());
        out.write(" ;\n");
    }

    public static void printMocaParam(IndentWriter out, Node node, Tree tset) throws IOException {
        if (tset == null) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
        }
        switch (tset._type) {
            case 258: {
                Expr evar = (Expr)tset._son;
                if (evar.isConstant() && evar.isSymbolic()) {
                    out.write("g..");
                    out.write(evar.toString());
                    break;
                }
            }
            case 304: {
                ((Expr)tset._son).printMoca(out);
                break;
            }
            case 267: {
                out.write("l..");
                out.write(tset._sval);
                break;
            }
            case 40: {
                if (tset._sval.length() > 0) {
                    if (tset._sval.equals("lognormal")) {
                        out.write("nlog(");
                    } else if (tset._sval.equals("uniform")) {
                        out.write("unif(");
                    } else if (tset._sval.equals("normal")) {
                        out.write("norm(");
                    } else {
                        throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
                    }
                    Tree param = (Tree)tset._son;
                    while (param != null) {
                        Extern.printMocaParam(out, node, param);
                        param = param._next;
                        if (param == null) continue;
                        out.write(",");
                    }
                    out.write(")");
                    break;
                }
            }
            default: {
                throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
            }
        }
    }

    public void printMocaLaw(IndentWriter out, Node node) throws IOException {
        out.addData(this);
        Tree val = this.getVal();
        if (val == null || val._type != 40 || val._sval.length() == 0) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
        }
        String law = val._sval;
        if (law.equals("exponential") || law.equals("exp")) {
            out.write("exp ");
        } else if (law.equals("Dirac") || law.equals("drc")) {
            out.write("drc ");
        } else if (law.equals("Weibull") || law.equals("web")) {
            out.write("web ");
        } else if (law.equals("ifa") || law.equals("periodic")) {
            out.write("ifa ");
        } else if (law.equals("nlog")) {
            out.write("nlog ");
        } else if (law.equals("unif")) {
            out.write("unif ");
        } else {
            if (law.equals("constant") || law.equals("cst")) {
                out.write("drc 0");
                return;
            }
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW_MOCA"));
        }
        Tree param = (Tree)val._son;
        while (param != null) {
            Extern.printMocaParam(out, node, param);
            param = param._next;
            if (param == null) continue;
            out.write(", ");
        }
    }

    public static void printAraliaParam(Writer out, Node node, Tree tset, Set<String> namedParams) throws IOException {
        if (tset == null) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
        }
        switch (tset._type) {
            case 258: {
                Expr evar = (Expr)tset._son;
                if (evar.isConstant() && evar.isSymbolic()) {
                    String name = evar.toString();
                    namedParams.add(name);
                    out.write(name);
                    out.write(" ");
                    break;
                }
            }
            case 304: {
                out.write(tset._son.toString());
                break;
            }
            case 267: {
                namedParams.add(tset._sval);
                out.write("'");
                out.write(tset._sval);
                out.write("' ");
                break;
            }
            case 40: {
                if (tset._sval.length() > 0) {
                    if (tset._sval.equals("lognormal")) {
                        out.write("lognormal ");
                    } else if (tset._sval.equals("uniform")) {
                        out.write("uniform ");
                    } else if (tset._sval.equals("normal")) {
                        out.write("normal ");
                    } else {
                        throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
                    }
                    Tree param = (Tree)tset._son;
                    while (param != null) {
                        Extern.printAraliaParam(out, node, param, namedParams);
                        param = param._next;
                        out.write(" ");
                    }
                    break;
                }
            }
            default: {
                throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
            }
        }
    }

    public void printAraliaLaw(Writer out, Node node, Set<String> namedParams) throws IOException {
        Tree val = this.getVal();
        if (val == null || val._type != 40 || val._sval.length() == 0) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
        }
        String law = val._sval;
        if (law.equals("exponential") || law.equals("exp")) {
            out.write("exponential ");
        } else if (law.equals("Dirac") || law.equals("drc")) {
            out.write("Dirac ");
        } else if (law.equals("Weibull") || law.equals("web")) {
            out.write("Weibull ");
        } else if (law.equals("constant") || law.equals("cst")) {
            out.write("constant ");
        } else if (law.equals("GLM")) {
            out.write("GLM ");
        } else if (law.equals("CMT")) {
            out.write("CMT ");
        } else if (law.equals("asymptotic_exponential")) {
            out.write("asymptotic-exponential ");
        } else if (law.equals("periodic_test")) {
            out.write("periodic-test ");
        } else {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW_ALTAX"));
        }
        Tree param = (Tree)val._son;
        while (param != null) {
            Extern.printAraliaParam(out, node, param, namedParams);
            param = param._next;
            if (param == null) continue;
            out.write(" ");
        }
        if (law.equals("Weibull") || law.equals("web")) {
            out.write(" 0");
        }
    }

    private static double getParamValue(Tree param, Node node) {
        if (param == null) {
            return Double.NaN;
        }
        switch (param._type) {
            case 258: {
                Expr expr = (Expr)param._son;
                if (expr.isConstant()) {
                    switch (expr.getScale()) {
                        case Float: {
                            return expr.getFloat();
                        }
                        case Integer: {
                            return expr.getInt();
                        }
                        case Symbolic: {
                            Tree tFind = new Tree(param._type, 0L, 0.0, "", expr, null);
                            Extern xParam = node.findExtern(PARAMETER, tFind);
                            if (xParam == null) {
                                return Double.NaN;
                            }
                            return Extern.getParamValue(xParam.getVal(), node);
                        }
                    }
                    return Double.NaN;
                }
            }
            case 267: {
                Tree tFind = new Tree(param._type, 0L, 0.0, param._sval, null, null);
                Extern xParam = node.findExtern(PARAMETER, tFind);
                if (xParam == null) {
                    return Double.NaN;
                }
                return Extern.getParamValue(xParam.getVal(), node);
            }
            case 40: {
                if (param._sval.length() <= 0) break;
                if (param._sval.equals("lognormal")) {
                    Tree arg = (Tree)param._son;
                    if (arg == null) {
                        return Double.NaN;
                    }
                    return Extern.getParamValue(arg, node);
                }
                if (param._sval.equals("uniform")) {
                    Tree arg = (Tree)param._son;
                    if (arg == null) {
                        return Double.NaN;
                    }
                    if (arg._next == null) {
                        return Double.NaN;
                    }
                    double min = Extern.getParamValue(arg, node);
                    if (Double.isNaN(min)) {
                        return Double.NaN;
                    }
                    double max = Extern.getParamValue(arg._next, node);
                    if (Double.isNaN(max)) {
                        return Double.NaN;
                    }
                    return (min + max) / 2.0;
                }
                if (param._sval.equals("normal")) {
                    Tree arg = (Tree)param._son;
                    if (arg == null) {
                        return Double.NaN;
                    }
                    return Extern.getParamValue(arg, node);
                }
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    public double delayOfLaw(Node node) {
        Tree val = this.getVal();
        if (val == null || val._type != 40 || val._sval.length() == 0) {
            return Double.NaN;
        }
        String law = val._sval;
        if (!law.equals("Dirac") && !law.equals("drc")) {
            return Double.NaN;
        }
        Tree param = (Tree)val._son;
        if (param == null || param._next != null) {
            return Double.NaN;
        }
        return Extern.getParamValue(param, node);
    }

    private boolean verifyParameter(VerifyManager mng, Node node) {
        if (!mng.withWarning("ExternParameter")) {
            return true;
        }
        Tree var = this.getVar();
        if (var._type == 258) {
            Expr evar = (Expr)var._son;
            if (!evar.isConstant() || !evar.isSymbolic()) {
                mng.addError("ExternParameter", this, "WRN_XPARAMETER_SYNTAX", new Object[0]);
                return false;
            }
        } else if (var._type != 267) {
            mng.addError("ExternParameter", this, "WRN_XPARAMETER_SYNTAX", new Object[0]);
            return false;
        }
        return this.verifyParam(mng, node, this.getVal(), true);
    }

    private boolean verifyParam(VerifyManager mng, Node node, Tree val, boolean incertitude) {
        if (val == null) {
            mng.addError("ExternParameter", this, "WRN_XPARAM_SYNTAX", new Object[0]);
        }
        if (val._type == 258) {
            Expr eval = (Expr)val._son;
            if (!eval.isConstant() || eval.getScale() != Expr.Scale.Float && eval.getScale() != Expr.Scale.Integer && eval.getScale() != Expr.Scale.Symbolic) {
                mng.addError("ExternParameter", this, "WRN_XPARAM_SYNTAX", new Object[0]);
                return false;
            }
        } else {
            if (val._type == 40 && val._sval.length() > 0) {
                if (!(val._sval.equals("uniform") || val._sval.equals("normal") || val._sval.equals("lognormal"))) {
                    mng.addError("ExternParameter", this, "WRN_XPARAM_FCT", new Object[0]);
                    return false;
                }
                if (!incertitude) {
                    mng.addError("ExternParameter", this, "WRN_XPARAM_ERROR_INCERTITUDE", new Object[0]);
                    return false;
                }
                return this.verifyLawParams(mng, node, val, false, 2);
            }
            if (val._type != 267) {
                mng.addError("ExternParameter", this, "WRN_XPARAM_SYNTAX", new Object[0]);
                return false;
            }
        }
        return true;
    }

    private boolean verifyLawParams(VerifyManager mng, Node node, Tree law, boolean incertitude, int ... nbrParams) {
        int cpt = 0;
        Tree param = (Tree)law._son;
        while (param != null) {
            this.verifyParam(mng, node, param, incertitude);
            param = param._next;
            ++cpt;
        }
        boolean find = false;
        for (int i = 0; i < nbrParams.length && !find; ++i) {
            if (cpt != nbrParams[i]) continue;
            find = true;
        }
        if (!find) {
            mng.addError("ExternParameter", this, "WRN_XLAW_NBR_PARAM", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean verifyClassLaw(VerifyManager mng, Node node, Tree law, boolean aralia, boolean moca, int ... nbrParams) {
        if (!aralia) {
            mng.addError("ExternLawAralia", this, "WRN_XLAW_ARALIA", new Object[0]);
        }
        if (!moca) {
            mng.addError("ExternLawMoca", this, "WRN_XLAW_MOCA", new Object[0]);
        }
        return this.verifyLawParams(mng, node, law, true, nbrParams);
    }

    private boolean verifyLaw(VerifyManager mng, Node node) {
        Tree val;
        if (!mng.withWarning("ExternLaw")) {
            return true;
        }
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(this.getVar(), evts, true);
        if (nbrEvt <= 0) {
            mng.addError("ExternLaw", this, "WRN_XEVENTS_NOTHINK", new Object[0]);
            return false;
        }
        if (nbrEvt != evts.size()) {
            mng.addWarning(this, "WRN_XEVENTS_DEFINE", new Object[0]);
        }
        if ((val = this.getVal()) == null || val._type != 40 || val._sval.length() == 0) {
            mng.addError("ExternLaw", this, "WRN_XLAW_SYNTAX", new Object[0]);
            return false;
        }
        String law = val._sval;
        if (law.equals("exponential")) {
            return this.verifyClassLaw(mng, node, val, true, true, 1);
        }
        if (law.equals("exp")) {
            return this.verifyClassLaw(mng, node, val, false, true, 1);
        }
        if (law.equals("Dirac")) {
            return this.verifyClassLaw(mng, node, val, true, true, 1);
        }
        if (law.equals("drc")) {
            return this.verifyClassLaw(mng, node, val, false, true, 1);
        }
        if (law.equals("constant")) {
            return this.verifyClassLaw(mng, node, val, true, true, 1);
        }
        if (law.equals("cst")) {
            return this.verifyClassLaw(mng, node, val, false, true, 1);
        }
        if (law.equals("Weibull")) {
            return this.verifyClassLaw(mng, node, val, true, true, 2);
        }
        if (law.equals("web")) {
            return this.verifyClassLaw(mng, node, val, false, true, 3);
        }
        if (law.equals("GLM")) {
            return this.verifyClassLaw(mng, node, val, true, false, 3);
        }
        if (law.equals("CMT")) {
            return this.verifyClassLaw(mng, node, val, true, false, 3);
        }
        if (law.equals("asymptotic_exponential")) {
            return this.verifyClassLaw(mng, node, val, true, false, 2);
        }
        if (law.equals("periodic_test")) {
            return this.verifyClassLaw(mng, node, val, true, false, 3, 4, 10);
        }
        if (law.equals("ifa") || law.equals("periodic")) {
            return this.verifyClassLaw(mng, node, val, false, true, 2);
        }
        if (law.equals("nlog")) {
            return this.verifyClassLaw(mng, node, val, false, true, 2);
        }
        if (law.equals("unif")) {
            return this.verifyClassLaw(mng, node, val, false, true, 2);
        }
        mng.addError("ExternLaw", this, "WRN_XLAW_FCT", new Object[0]);
        return false;
    }

    private boolean verifyAttributeValue(VerifyManager mng, Node node) {
        Expr eval;
        Tree val = this.getVal();
        return val == null || !(val._type == 258 ? !(eval = (Expr)val._son).isConstant() : val._type != 303);
    }

    private boolean verifyAttribute(VerifyManager mng, Node node) {
        if (!mng.withWarning("ExternAttribute")) {
            return true;
        }
        Tree var = this.getVar();
        if (var == null || var._type != 40 || var._sval.length() == 0) {
            mng.addError("ExternAttribute", this, "WRN_XATTRIB_SYNTAX", "name");
            return false;
        }
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(this.getVar(), evts, false);
        if (nbrEvt <= 0) {
            mng.addError("ExternAttribute", this, "WRN_XEVENTS_NOTHINK", new Object[0]);
            return false;
        }
        if (nbrEvt != evts.size()) {
            mng.addWarning(this, "WRN_XEVENTS_DEFINE", new Object[0]);
        }
        if (!this.verifyAttributeValue(mng, node)) {
            mng.addError("ExternAttribute", this, "WRN_XATTRIB_SYNTAX", "value");
            return false;
        }
        return true;
    }

    private boolean verifyNodeProperty(VerifyManager mng, Node node) {
        if (!mng.withWarning("ExternNodeProperty")) {
            return true;
        }
        Tree var = this.getVar();
        if (var._type == 258) {
            Expr evar = (Expr)var._son;
            if (!evar.isConstant() || !evar.isSymbolic()) {
                mng.addError("ExternNodeProperty", this, "WRN_XNODEPROPERTY_SYNTAX", new Object[0]);
                return false;
            }
        } else if (var._type != 267) {
            mng.addError("ExternNodeProperty", this, "WRN_XNODEPROPERTY_SYNTAX", new Object[0]);
            return false;
        }
        if (!this.verifyAttributeValue(mng, node)) {
            mng.addError("ExternNodeProperty", this, "WRN_XNODEPROPERTY_SYNTAX", new Object[0]);
            return false;
        }
        return true;
    }

    public int valueOfPriority() {
        Tree val = this.getVal();
        if (val == null || val._type != 258) {
            return -1;
        }
        Expr eval = (Expr)val._son;
        if (!eval.isConstant() || eval.getScale() != Expr.Scale.Integer) {
            return -1;
        }
        long result = eval.getInt();
        return result > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)result;
    }

    private boolean verifyPriority(VerifyManager mng, Node node) {
        Tree val;
        if (!mng.withWarning("ExternPriority")) {
            return true;
        }
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(this.getVar(), evts, true);
        if (nbrEvt <= 0) {
            mng.addError("ExternPriority", this, "WRN_XEVENTS_NOTHINK", new Object[0]);
            return false;
        }
        if (nbrEvt != evts.size()) {
            mng.addWarning(this, "WRN_XEVENTS_DEFINE", new Object[0]);
        }
        if ((val = this.getVal()) == null || val._type != 258) {
            mng.addError("ExternPriority", this, "WRN_XPRIO_SYNTAX", new Object[0]);
            return false;
        }
        Expr eval = (Expr)val._son;
        if (!eval.isConstant() || eval.getScale() != Expr.Scale.Integer) {
            mng.addError("ExternPriority", this, "WRN_XPRIO_SYNTAX", new Object[0]);
            return false;
        }
        if (eval.getInt() < 0L) {
            mng.addError("ExternPriority", this, "WRN_XPRIO_SYNTAX", new Object[0]);
            return false;
        }
        if (mng.withWarning("ExternPriorityDirac")) {
            for (int i = 0; i < evts.size(); ++i) {
                Tree tEvt = new Tree(268, 0L, 0.0, "", (Data)evts.get(i), null);
                Extern xLaw = node.findExtern(LAW, tEvt);
                double delay = xLaw.delayOfLaw(node);
                if (!Double.isNaN(delay)) continue;
                mng.addError("ExternPriorityDirac", xLaw, "WRN_XPRIO_NO_DIRAC", ((Event)evts.get(i)).getName());
            }
        }
        return true;
    }

    public static int verifyOnlyRemarkObject(Tree var, List<Data> datum) {
        switch (var._type) {
            case 40: {
                if (var._sval.length() != 0) break;
                Tree tset = (Tree)var._son;
                int cpt = 0;
                while (tset != null) {
                    int add = Extern.verifyOnlyRemarkObject(tset, datum);
                    if (add == Integer.MIN_VALUE) {
                        return Integer.MIN_VALUE;
                    }
                    cpt += add;
                    tset = tset._next;
                }
                return cpt;
            }
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: {
                if (!datum.contains(var._son)) {
                    datum.add(var._son);
                }
                return 1;
            }
        }
        return Integer.MIN_VALUE;
    }

    private boolean verifyRemark(VerifyManager mng, Node node) {
        if (!mng.withWarning("ExternRemark")) {
            return true;
        }
        ArrayList<Data> datum = new ArrayList<Data>();
        int nbrObj = Extern.verifyOnlyRemarkObject(this.getVar(), datum);
        if (nbrObj <= 0) {
            mng.addError("ExternRemark", this, "WRN_XREMARK_NO_OBJ", new Object[0]);
            return false;
        }
        Tree val = this.getVal();
        if (val == null || val._type != 303) {
            mng.addError("ExternRemark", this, "WRN_XREMARK_SYNTAX", new Object[0]);
            return false;
        }
        return true;
    }

    public static void printGammaOfTransBucket(IndentWriter out, Trans tr, Node node) throws IOException {
        Tree tEvt = new Tree(268, 0L, 0.0, "", tr.getEvent(), null);
        Extern xLaw = node.findExtern(LAW, tEvt);
        if (xLaw == null) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XBUCKET"));
        }
        Tree val = xLaw.getVal();
        if (val == null || val._type != 40 || val._sval.length() == 0) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XBUCKET"));
        }
        String law = val._sval;
        if (!law.equals("constant") && !law.equals("cst")) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XBUCKET"));
        }
        Tree param = (Tree)val._son;
        if (param == null || param._next != null) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_XBUCKET"));
        }
        Extern.printMocaParam(out, node, param);
    }

    private boolean transOfBucket(Node node, VerifyManager mng, List<Trans> result) {
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(this.getVar(), evts, true);
        if (nbrEvt <= 0) {
            if (mng != null) {
                mng.addError("ExternBucket", this, "WRN_XEVENTS_NOTHINK", new Object[0]);
            }
            return false;
        }
        if (nbrEvt != evts.size() && mng != null) {
            mng.addWarning(this, "WRN_XEVENTS_DEFINE", new Object[0]);
        }
        for (int i = 0; i < evts.size(); ++i) {
            Event evt = (Event)evts.get(i);
            int cpt = 0;
            for (int j = 0; j < node.getTransCount(); ++j) {
                Trans tr = node.getTrans(j);
                if (tr.getEvent() != evt || ++cpt > 1 && mng == null) continue;
                result.add(tr);
            }
            if (cpt == true || mng == null) continue;
            mng.addError("ExternBucket", this, "WRN_XBUCKET_NBR_TRANS", evt.getName());
            return false;
        }
        if (evts.size() != result.size()) {
            mng.addError("ExternBucket", this, "WRN_XBUCKET_NBR_TRANS", "<undef>");
            return false;
        }
        return true;
    }

    public List<Trans> transOfBucket(Node node) {
        ArrayList<Trans> result = new ArrayList<Trans>();
        if (!this.transOfBucket(node, null, result)) {
            return null;
        }
        return result;
    }

    public static double gammaOfTransBucket(Trans tr, Node node) {
        Tree tEvt = new Tree(268, 0L, 0.0, "", tr.getEvent(), null);
        Extern xLaw = node.findExtern(LAW, tEvt);
        if (xLaw == null) {
            return Double.NaN;
        }
        Tree val = xLaw.getVal();
        if (val == null || val._type != 40 || val._sval.length() == 0) {
            return Double.NaN;
        }
        String law = val._sval;
        if (!law.equals("constant") && !law.equals("cst")) {
            return Double.NaN;
        }
        Tree param = (Tree)val._son;
        if (param == null || param._next != null) {
            return Double.NaN;
        }
        return Extern.getParamValue(param, node);
    }

    private boolean verifyBucket(VerifyManager mng, Node node) {
        if (!mng.withWarning("ExternBucket")) {
            return true;
        }
        ArrayList<Trans> trs = new ArrayList<Trans>();
        if (!this.transOfBucket(node, mng, trs)) {
            return false;
        }
        Tree val = this.getVal();
        if (val != null) {
            Expr eval;
            boolean warning = true;
            if (val._type == 258 && (eval = (Expr)val._son).isConstant() && eval.isBoolean()) {
                boolean bl = warning = !eval.getBool();
            }
            if (warning) {
                mng.addError("ExternBucket", this, "WRN_XBUCKET_SYNTAX", new Object[0]);
            }
        }
        double sum = 0.0;
        Trans first = null;
        for (int i = 0; i < trs.size(); ++i) {
            double gamma = Extern.gammaOfTransBucket((Trans)trs.get(i), node);
            if (Double.isNaN(gamma)) {
                mng.addError("ExternBucket", (Data)trs.get(i), "WRN_XBUCKET_GAMMA", ((Trans)trs.get(i)).getEvent().getName());
                return false;
            }
            if (gamma < 0.0 || gamma > 1.0) {
                mng.addError("ExternBucket", (Data)trs.get(i), "WRN_XBUCKET_GAMMA", ((Trans)trs.get(i)).getEvent().getName());
                return false;
            }
            if (first == null) {
                first = (Trans)trs.get(i);
            } else if (!first.getGuard().equals(((Trans)trs.get(i)).getGuard())) {
                mng.addWarning((Data)trs.get(i), "WRN_XBUCKET_GUARDS", first.getEvent().getName(), ((Trans)trs.get(i)).getEvent().getName());
            }
            sum += gamma;
        }
        if (sum != 1.0) {
            mng.addError("ExternBucket", this, "WRN_XBUCKET_GAMMA_SUM", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean verifyPreemptible(VerifyManager mng, Node node) {
        Tree val;
        if (!mng.withWarning("ExternPreemptible")) {
            return true;
        }
        ArrayList<Event> evts = new ArrayList<Event>();
        int nbrEvt = Extern.verifyOnlyEvent(this.getVar(), evts, true);
        if (nbrEvt <= 0) {
            if (mng != null) {
                mng.addError("ExternPreemptible", this, "WRN_XEVENTS_NOTHINK", new Object[0]);
            }
            return false;
        }
        if (nbrEvt != evts.size() && mng != null) {
            mng.addWarning(this, "WRN_XEVENTS_DEFINE", new Object[0]);
        }
        if ((val = this.getVal()) != null) {
            Expr eval;
            boolean warning = true;
            if (val._type == 258 && (eval = (Expr)val._son).isConstant() && eval.isBoolean()) {
                boolean bl = warning = !eval.getBool();
            }
            if (warning) {
                mng.addError("ExternPreemptible", this, "WRN_XPREEMPTIBLE_SYNTAX", new Object[0]);
            }
        }
        return true;
    }

    public boolean verifyWarning(VerifyManager mng, Node node) {
        if (this.getName().equals(OBSERVER)) {
            return this.verifyObserver(mng, node);
        }
        if (this.getName().equals(PROPERTY)) {
            return this.verifyProperty(mng, node);
        }
        if (this.getName().equals(PREDICATE)) {
            return this.verifyPredicate(mng, node);
        }
        if (this.getName().equals(LAW)) {
            return this.verifyLaw(mng, node);
        }
        if (this.getName().equals(PARAMETER)) {
            return this.verifyParameter(mng, node);
        }
        if (this.getName().equals(ATTRIBUTE)) {
            return this.verifyAttribute(mng, node);
        }
        if (this.getName().equals(NODEPROPERTY)) {
            return this.verifyNodeProperty(mng, node);
        }
        if (this.getName().equals(PRIORITY)) {
            return this.verifyPriority(mng, node);
        }
        if (this.getName().equals(BUCKET)) {
            return this.verifyBucket(mng, node);
        }
        if (this.getName().equals(PREEMPTIBLE)) {
            return this.verifyPreemptible(mng, node);
        }
        if (this.getName().equals(REMARK)) {
            return this.verifyRemark(mng, node);
        }
        return true;
    }
}

