/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import java.io.IOException;

class FloatDomain
extends Domain {
    protected static final Domain _instance = new FloatDomain();

    private FloatDomain() {
        this.setName("float");
    }

    public static Domain getInstance() {
        return _instance;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean verifyValueOf(Expr expr) {
        return expr.getScale() == Expr.Scale.Float || expr.getScale() == Expr.Scale.Integer;
    }

    @Override
    public boolean verifyValueOf(double value) {
        return true;
    }

    @Override
    public void printDefLL(IndentWriter out, int frm) throws IOException {
        assert (false);
    }

    public String toString() {
        return "float";
    }

    @Override
    public void printDefJava(IndentWriter out) throws IOException {
        out.write("JDomain.JFloat()");
    }

    @Override
    public void printJava(IndentWriter out) throws IOException {
        out.write("JDomain.JFloat()");
    }

    @Override
    public void printDefaultValue(IndentWriter out) throws IOException {
        out.write("0.0");
    }

    @Override
    public int getNbrValue() {
        return -1;
    }

    @Override
    public double getDouble(int idx) {
        return Double.NaN;
    }

    @Override
    public String toString(double value) {
        return Double.toString(value);
    }

    @Override
    public double parse(String strValue) {
        try {
            return Double.parseDouble(strValue);
        }
        catch (NumberFormatException exc) {
            return Double.NaN;
        }
    }
}

