/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Flow
extends Var {
    private char _orientation;
    public static final char IN = '\u0001';
    public static final char OUT = '\u0002';
    public static final char LOCAL = '\u0003';

    public Flow(String name, Domain domain, char orientation) {
        super(name, domain);
        this._orientation = orientation;
    }

    public Flow(String name, Domain domain) {
        this(name, domain, '\u0001');
    }

    public Data instance(Node parent, String inst) {
        Flow res = new Flow((String)(inst.length() > 0 ? inst + "." + this.getName() : this.getName()), this.getDomain(), this._orientation);
        res.instance(this);
        if (this.isAlias()) {
            // empty if block
        }
        return res;
    }

    public char getOrientation() {
        return this._orientation;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.toString()).append(":");
        switch (this._orientation) {
            case '\u0001': {
                sb.append("in");
                break;
            }
            case '\u0002': {
                sb.append("out");
                break;
            }
            case '\u0003': {
                sb.append("private");
            }
        }
        return sb.toString();
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        super.printOTools(out, frm);
        out.write(":");
        switch (this._orientation) {
            case '\u0001': {
                out.write("in");
                if (frm != 4) break;
                out.write(",public");
                break;
            }
            case '\u0002': {
                out.write("out");
                if (frm != 4) break;
                out.write(",public");
                break;
            }
            case '\u0003': {
                out.write("private");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeChar(this._orientation);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._orientation = in.readChar();
    }
}

