/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class GroupDepend {
    Set<GroupDepend> _previous = new LinkedHashSet<GroupDepend>();
    Set<GroupDepend> _next = new LinkedHashSet<GroupDepend>();
    List<Trans> _transs = new ArrayList<Trans>();
    Set<Event> _events = new LinkedHashSet<Event>();
    Set<State> _states = new LinkedHashSet<State>();
    Set<Flow> _flows = new LinkedHashSet<Flow>();
    int _groupID = -1;
    int _flag = 0;

    public GroupDepend(int id) {
        this._groupID = id;
    }

    public int hashCode() {
        return this._groupID;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this._groupID == ((GroupDepend)obj)._groupID;
    }

    private void depend(GroupDepend previous) {
        if (this._previous.add(previous)) {
            previous._next.add(this);
        }
    }

    private void depend(int groupID, Map<Integer, GroupDepend> groups) {
        GroupDepend group = groups.get(groupID);
        if (group == null) assert (false);
        this.depend(group);
    }

    void addTrans(Trans data) {
        this._transs.add(data);
        data.setGroupID(this._groupID);
        this._events.add(data.getEvent());
    }

    private void merge(GroupDepend other) {
        for (Trans trans : other._transs) {
            this._transs.add(trans);
            trans.setGroupID(this._groupID);
        }
        for (Event event : other._events) {
            this._events.add(event);
        }
        for (State state : other._states) {
            this._states.add(state);
            state.setGroupID(this._groupID);
        }
        for (Flow flow : other._flows) {
            this._flows.add(flow);
            flow.setGroupID(this._groupID);
        }
        for (GroupDepend groupDepend : other._previous) {
            groupDepend._next.remove(other);
            if (!groupDepend._next.add(this)) continue;
            this._previous.add(groupDepend);
        }
        for (GroupDepend groupDepend : other._next) {
            groupDepend._previous.remove(other);
            if (!groupDepend._previous.add(this)) continue;
            this._next.add(groupDepend);
        }
    }

    private void merge(int groupID, Map<Integer, GroupDepend> groups) {
        GroupDepend group = groups.get(groupID);
        if (group == null) assert (false);
        this.merge(group);
        groups.remove(groupID);
    }

    public void recupFrom(Var var, Map<Integer, GroupDepend> groups) {
        Var refVar = var.getSimular().getVar();
        int id = refVar.getGroupID();
        if (id == this._groupID) {
            return;
        }
        if (id != -1) {
            if (var instanceof State) {
                this.merge(id, groups);
            } else {
                this.depend(id, groups);
            }
        } else if (var instanceof State) {
            this._states.add((State)var);
            var.setGroupID(this._groupID);
        } else {
            this._flows.add((Flow)var);
        }
    }

    public void recupFrom(Expr expr, Map<Integer, GroupDepend> groups) {
        if (expr instanceof ExprVar) {
            Var var = ((ExprVar)expr).getVar();
            this.recupFrom(var, groups);
        } else {
            int nbrArg = expr.getArgCount();
            for (int i = 0; i < nbrArg; ++i) {
                this.recupFrom(expr.getArg(i), groups);
            }
        }
    }

    public void recupFrom(Trans tr, Map<Integer, GroupDepend> groups) {
        int id = tr.getGroupID();
        if (id == this._groupID) {
            return;
        }
        if (id != -1) {
            this.merge(id, groups);
        } else {
            this.addTrans(tr);
            this.recupFrom(tr.getGuard(), groups);
            List<Data> affects = tr.getAffects();
            int nbrAffect = affects.size();
            for (int j = 0; j < nbrAffect; j += 2) {
                this.recupFrom((State)affects.get(j), groups);
                this.recupFrom((Expr)affects.get(j + 1), groups);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(this._groupID).append(" |- {");
        Iterator<Event> iEvt = this._events.iterator();
        while (iEvt.hasNext()) {
            sb.append(iEvt.next().getName());
            if (!iEvt.hasNext()) continue;
            sb.append(",");
        }
        sb.append("} -> [");
        Iterator<Var> iVar = this._states.iterator();
        while (iVar.hasNext()) {
            sb.append(((Var)iVar.next()).getName());
            if (!iVar.hasNext()) continue;
            sb.append(",");
        }
        sb.append("] := [");
        iVar = this._flows.iterator();
        while (iVar.hasNext()) {
            sb.append(iVar.next().getName());
            if (!iVar.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static Collection<Event> dependVariables(Node owner, Collection<Var> vars) {
        Map<Integer, GroupDepend> groups = owner.groupsDependGet();
        for (GroupDepend grp : groups.values()) {
            grp._flag = 0;
        }
        owner.setFlagPropage('\u0000');
        for (Var var : vars) {
            var = var.getSimular().getVar();
            if (MsgTrans.LOG.isLoggable(Level.FINE)) {
                MsgTrans.LOG.fine("GroupDepend: " + var.toString() + " : " + var.getGroupID());
            }
            GroupDepend.dependVariable(var.getGroupID(), groups);
            GroupDepend.dependVariable(var.getSimular().getDefine(), groups);
        }
        HashSet<Event> events = new HashSet<Event>();
        for (GroupDepend grp : groups.values()) {
            if (grp._flag <= 0) continue;
            events.addAll(grp._events);
        }
        return events;
    }

    private static void dependVariable(int idGroup, Map<Integer, GroupDepend> groups) {
        if (idGroup == -1) {
            return;
        }
        GroupDepend grp = groups.get(idGroup);
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("GroupDepend:" + grp.toString());
        }
        if (grp._flag > 0) {
            return;
        }
        grp._flag = 1;
        if (grp._states.size() == 0) {
            return;
        }
        for (Var var : grp._flows) {
            GroupDepend.dependVariable(var.getSimular().getDefine(), groups);
        }
        for (GroupDepend groupDepend : grp._previous) {
            GroupDepend.dependVariable(groupDepend._groupID, groups);
        }
    }

    private static void dependVariable(Expr define, Map<Integer, GroupDepend> groups) {
        if (define == null) {
            return;
        }
        if (define._flag > '\u0000') {
            return;
        }
        define._flag = (char)(define._flag + '\u0001');
        if (define instanceof ExprVar) {
            Var var = ((ExprVar)define).getVar();
            GroupDepend.dependVariable(var.getGroupID(), groups);
            GroupDepend.dependVariable(var.getSimular().getDefine(), groups);
        } else {
            int nbrArgs = define.getArgCount();
            for (int i = 0; i < nbrArgs; ++i) {
                GroupDepend.dependVariable(define.getArg(i), groups);
            }
        }
    }
}

