/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprParent;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprUndef;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.IOException;

public class Init
extends ExprParent {
    private Expr _state;
    private Expr _value;

    public Init(Expr state, Expr value) {
        this._state = state;
        this._value = value;
    }

    @Override
    protected boolean exchangeChild(Expr oldChild, Expr newChild) {
        boolean result = false;
        if (this._state == oldChild) {
            this._state = newChild;
            result = true;
        }
        if (this._value == oldChild) {
            this._value = newChild;
            result = true;
        }
        return result;
    }

    public Init instance(Node parent, String inst) {
        if (inst == null) {
            this._value = this._value.moveTo(parent, this);
            return this;
        }
        Init res = new Init((Expr)this._state.instance(parent, inst, this), (Expr)this._value.instance(parent, inst, this));
        res.instance(this);
        return res;
    }

    public void defineInitValue(Node parent, String inst) throws TranslateException {
        Var var = ((ExprVar)this._state).getInstanceVar(parent, inst);
        Simular simVar = var.getSimular();
        if (simVar == null) {
            simVar = new Simular(parent, var);
            var.setSimular(simVar);
        }
        this._value.evaluate();
        simVar.setInitValue(this._value.getDouble());
    }

    public void verify(Node node) throws TranslateException {
        String name = this._state.toString();
        this._state = this._state.convertVar(node);
        if (!(this._state instanceof ExprVar)) {
            throw new TranslateException(this, "EXC_VAR_UNKNOW", name);
        }
        Var var = ((ExprVar)this._state).getVar();
        this._value = this._value.convertVar(node);
        if (this._value.withType(ExprUndef.class)) {
            throw new TranslateException(this._value, "EXC_EXPR_UNDEF", new Object[0]);
        }
        if (!this._value.isConstant()) {
            throw new TranslateException(this, "EXC_EXPR_NOCST", new Object[0]);
        }
        if (!var.getDomain().verifyValueOf(this._value)) {
            throw new TranslateException(this._value, "EXC_INIT_NOEQUAL", this._state, this._value.toLL());
        }
    }

    public Var getVar() {
        return ((ExprVar)this._state).getVar();
    }

    public String getValue() {
        return this._value.toString();
    }

    public Expr getExprValue() {
        return this._value;
    }

    public String getPathVar() {
        return this._state.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this._state).append(" := ").append(this._value);
        return sb.toString();
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        this._state.printOTools(out, frm);
        out.write(" := ");
        this._value.printOTools(out, frm);
    }

    @Deprecated
    public void printMoca(IndentWriter out, Node node) throws IOException {
        out.addData(this);
        out.write("AI: ");
        this._state.printMoca(out);
        out.write(" = ");
        this._value.printMoca(out);
        out.write(";\n");
    }

    public void printJava(IndentWriter out, Node node) throws IOException {
        out.addData(this);
        out.write("getState(\"");
        out.write(this._state.toString());
        out.write("\").setInit(");
        this._value.printJava(out, null, null);
        out.write(");\n");
    }

    public void rename(Model.RenameHelper helper, Node node) {
        this._state.rename(helper, node);
        this._value.rename(helper, node);
    }

    @Override
    public void setFlagPropage(char value) {
        this._state.setFlagPropage(value);
        this._value.setFlagPropage(value);
    }
}

