/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainRange;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.SimulVar;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class LocalSimul {
    private static final int PROP_DEF_ALTALIB_LOCALSIMUL_LIMIT = 100000;
    private static final String PROP_ALTALIB_LOCALSIMUL_LIMIT = "cecilia.mbsa.translator.localsimul.SimulLimit";
    Node _node;
    LinkedList<Trans> _transs;
    Map<Var, SimulVar> _simulVars;
    boolean _detectStatic = true;
    VerifyManager _manager = null;

    protected void CreateException(String key, SimulVar var, Object ... params) throws TranslateException {
        Object[] args = new Object[params.length + 1];
        args[0] = this._node.getName();
        for (int i = 0; i < params.length; ++i) {
            args[i + 1] = params[i];
        }
        if (this._manager != null) {
            this._manager.addError("LocalSimul", var._var, key, args);
        }
        throw new TranslateException(this._node, key, args);
    }

    public void verifyWarning(VerifyManager mng) {
        if (!mng.withWarning("LocalSimul")) {
            return;
        }
        this._detectStatic = mng.withWarning("LocalSimulStatic");
        this._manager = mng;
        try {
            this.action();
        }
        catch (TranslateException e) {
            MsgTrans.LOG.info("Internal error : not TranslateException possible");
        }
    }

    public SimulVar getOrCreateSimulVar(Var var) {
        SimulVar cur = this._simulVars.get(var);
        if (cur == null) {
            cur = new SimulVar(this._node, var);
            this._simulVars.put(var, cur);
        }
        return cur;
    }

    public LocalSimul(Node node, List<Trans> transs) {
        this._node = node;
        this._transs = new LinkedList<Trans>(transs);
        this._simulVars = new IdentityHashMap<Var, SimulVar>();
    }

    public void action() throws TranslateException {
        this._node.setFlagPropage('I');
        LinkedList<CaseSimulOutput> simulCase = new LinkedList<CaseSimulOutput>();
        for (int i = 0; i < this._node.getStateCount(); ++i) {
            State var = this._node.getState(i);
            SimulVar simVar = this.getOrCreateSimulVar(var);
            simulCase.add(new CaseSimulState(simVar));
        }
        ListIterator iCase = simulCase.listIterator();
        while (iCase.hasNext()) {
            ((CaseSimulOutput)iCase.next()).recupDepends();
        }
        iCase = simulCase.listIterator();
        int cpt = 0;
        while (iCase.hasNext()) {
            CaseSimulOutput first = (CaseSimulOutput)iCase.next();
            while (iCase.hasNext()) {
                CaseSimulOutput next = (CaseSimulOutput)iCase.next();
                if (first.include(next)) {
                    iCase.remove();
                    continue;
                }
                ++cpt;
            }
            while (cpt > 0) {
                iCase.previous();
                --cpt;
            }
            first.sortOutputs();
            cpt = 0;
        }
        for (int i = this._node.getAssertCount() - 1; i >= 0; --i) {
            Expr evar;
            Expr expr = this._node.getAssert(i);
            if (!ExprOp.isType(expr, ExprOp.Type.EQ) || !((evar = expr.getArg(0)) instanceof ExprVar)) continue;
            Var var = ((ExprVar)evar).getVar();
            if (var._flag != 'I') continue;
            SimulVar simVar = this.getOrCreateSimulVar(var);
            CaseSimulOutput sCase = new CaseSimulOutput(simVar);
            simulCase.add(sCase);
            sCase.recupDepends();
            sCase.sortOutputs();
        }
        iCase = simulCase.listIterator();
        if (this._manager == null) {
            while (iCase.hasNext()) {
                ((CaseSimulOutput)iCase.next()).action();
            }
        } else {
            while (iCase.hasNext()) {
                try {
                    ((CaseSimulOutput)iCase.next()).action();
                }
                catch (TranslateException translateException) {}
            }
        }
    }

    class CaseSimulState
    extends CaseSimulOutput {
        List<Event> _eventSimul;
        Set<SimulVar> _stateSimul;
        Event[] _cutSimul;
        int[] _cutSimulIdx;

        public CaseSimulState(SimulVar state) {
            super(state);
            this._eventSimul = new ArrayList<Event>();
            this._stateSimul = new LinkedHashSet<SimulVar>();
            this._stateSimul.add(state);
            this._inputSimul.add(state);
        }

        @Override
        protected boolean stopAction() {
            return false;
        }

        @Override
        protected void recupDepends() {
            Iterator iTr = LocalSimul.this._transs.iterator();
            boolean find = false;
            while (iTr.hasNext()) {
                Trans tr = (Trans)iTr.next();
                Iterator<Data> iAff = tr.getAffects().iterator();
                while (iAff.hasNext()) {
                    State state = (State)iAff.next();
                    Expr value = (Expr)iAff.next();
                    SimulVar simVar = LocalSimul.this.getOrCreateSimulVar(state);
                    if (simVar != this._var) continue;
                    if (!find) {
                        find = true;
                        this.recupVars(tr.getGuard());
                        if (!this._eventSimul.contains(tr.getEvent())) {
                            this._eventSimul.add(tr.getEvent());
                        }
                    }
                    this.recupVars(value);
                }
                find = false;
            }
        }

        protected void union(CaseSimulState other) {
            this._stateSimul.addAll(other._stateSimul);
            this._inputSimul.addAll(other._inputSimul);
            this._outputSimul.addAll(other._outputSimul);
            for (int i = 0; i < other._eventSimul.size(); ++i) {
                Event evt = other._eventSimul.get(i);
                if (this._eventSimul.contains(evt)) continue;
                this._eventSimul.add(evt);
            }
        }

        @Override
        protected boolean include(CaseSimulOutput other) {
            CaseSimulState Other = (CaseSimulState)other;
            boolean disjoint = true;
            disjoint = disjoint && Collections.disjoint(this._eventSimul, Other._eventSimul);
            disjoint = disjoint && Collections.disjoint(this._inputSimul, Other._stateSimul);
            boolean bl = disjoint = disjoint && Collections.disjoint(this._stateSimul, Other._inputSimul);
            if (!disjoint) {
                this.union(Other);
            }
            return !disjoint;
        }

        @Override
        protected SimulVar getCurrentState(Var var) {
            if (this._var.getVar() == var) {
                return this._var;
            }
            return null;
        }

        @Override
        protected long verifyComplexity() throws TranslateException {
            double doubleNbrMax;
            long nbrMax;
            long nbrState = super.verifyComplexity();
            long maxState = Integer.getInteger(LocalSimul.PROP_ALTALIB_LOCALSIMUL_LIMIT, 100000).longValue();
            long nbrPermut = 1L;
            for (long i = (long)this._eventSimul.size(); i > 0L; --i) {
                if ((nbrPermut *= i) <= maxState * 10L) continue;
                LocalSimul.this.CreateException("EXC_STN_SIMUL_MAX2", this._var, nbrPermut, maxState);
            }
            if (nbrPermut > maxState) {
                LocalSimul.this.CreateException("EXC_STN_SIMUL_MAX", this._var, nbrPermut, maxState);
            }
            long l = nbrMax = (doubleNbrMax = (double)nbrPermut * (double)nbrState) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)doubleNbrMax;
            if (nbrMax > maxState) {
                LocalSimul.this.CreateException("EXC_STN_SIMUL_MAX", this._var, nbrMax, maxState);
            }
            this._cutSimul = new Event[this._eventSimul.size()];
            this._cutSimulIdx = new int[this._eventSimul.size()];
            for (int i = this._eventSimul.size() - 1; i >= 0; --i) {
                this._cutSimulIdx[i] = -1;
            }
            return nbrMax;
        }

        @Override
        protected void simulInitValues(ListIterator<SimulVar> iVars, LinkedList<Double> values, ArrayList<Object> stack) throws TranslateException {
            block5: {
                super.simulInitValues(iVars, values, stack);
                try {
                    BitSet evtSet = new BitSet(this._eventSimul.size());
                    BitSet fixSet = new BitSet(this._eventSimul.size());
                    HashMap<BitSet, SimulResult> results = new HashMap<BitSet, SimulResult>();
                    this.simulPermutation(0, evtSet, fixSet, results, stack);
                }
                catch (SimulException e) {
                    StringBuffer sb = new StringBuffer(this._inputSimul.size() * 20);
                    this.printInitCondition(sb, this._inputSimul, values);
                    if (e._type == 1) {
                        LocalSimul.this.CreateException("EXC_STN_NO_STATIC", this._var, e.getMessage(), sb.toString());
                    }
                    if (e._type == 2) {
                        LocalSimul.this.CreateException("EXC_STN_UNCHECK_TRANS", this._var, e.getMessage(), sb.toString());
                    }
                    if (e._type == 3) {
                        LocalSimul.this.CreateException("EXC_STN_AFFECT_ERROR", this._var, e.getMessage(), e._otherMsg, sb.toString());
                    }
                    if (e._type != 4) break block5;
                    LocalSimul.this.CreateException("EXC_STN_EVALUATE_ERROR", this._var, e.getMessage(), e._otherMsg, sb.toString());
                }
            }
        }

        private void simulPermutation(int boucle, BitSet evtSet, BitSet fixSet, Map<BitSet, SimulResult> results, List<Object> stack) throws SimulException {
            if (boucle >= this._eventSimul.size()) {
                return;
            }
            for (int i = 0; i < this._eventSimul.size(); ++i) {
                if (evtSet.get(i)) continue;
                this._cutSimul[boucle] = this._eventSimul.get(i);
                this._cutSimulIdx[boucle] = i;
                evtSet.set(i);
                Trans trValid = null;
                try {
                    for (Trans tr : LocalSimul.this._transs) {
                        if (tr.getEvent() != this._cutSimul[boucle]) continue;
                        tr.getGuard().evaluate();
                        if (!tr.getGuard().getBool()) continue;
                        if (trValid != null) {
                            StringBuffer sb = new StringBuffer(boucle * 20);
                            this.printCurrentSeq(sb, boucle + 1);
                            throw new SimulException(2, sb.toString());
                        }
                        trValid = tr;
                    }
                    if (trValid != null) {
                        int oldSize = stack.size();
                        Iterator<Data> iAff = trValid.getAffects().iterator();
                        while (iAff.hasNext()) {
                            State st = (State)iAff.next();
                            Expr val = (Expr)iAff.next();
                            SimulVar simVar = LocalSimul.this._simulVars.get(st);
                            if (simVar.affect(val, stack)) continue;
                            StringBuffer sb = new StringBuffer(boucle * 20);
                            this.printCurrentSeq(sb, boucle + 1);
                            throw new SimulException(3, simVar.getMsgAffect(val, LocalSimul.this._node), sb.toString());
                        }
                        for (SimulVar outVar : this._outputSimul) {
                            if (outVar.evaluate(stack)) continue;
                            StringBuffer sb = new StringBuffer(boucle * 20);
                            this.printCurrentSeq(sb, boucle + 1);
                            throw new SimulException(3, outVar.getMsgAffect(null, LocalSimul.this._node), sb.toString());
                        }
                        stack.add((stack.size() - oldSize) / 2);
                        fixSet.set(i);
                    }
                }
                catch (TranslateException exc) {
                    StringBuffer sb = new StringBuffer(boucle * 20);
                    this.printCurrentSeq(sb, boucle + 1);
                    throw new SimulException(4, exc.getMessage(), sb.toString());
                }
                if (LocalSimul.this._detectStatic) {
                    SimulResult res = results.get(evtSet);
                    if (res == null) {
                        res = new SimulResult(boucle + 1, fixSet, this._stateSimul);
                        results.put((BitSet)evtSet.clone(), res);
                    } else {
                        res.addSequence(evtSet, fixSet, this._stateSimul);
                    }
                }
                this.simulPermutation(boucle + 1, evtSet, fixSet, results, stack);
                if (trValid != null) {
                    int size = stack.size() - 1;
                    for (int nbrModif = ((Integer)stack.remove(size--)).intValue(); nbrModif > 0; --nbrModif) {
                        Double value = (Double)stack.remove(size--);
                        SimulVar simVar = (SimulVar)stack.remove(size--);
                        simVar.setDouble(value);
                    }
                    fixSet.clear(i);
                }
                evtSet.clear(i);
                this._cutSimul[boucle] = null;
                this._cutSimulIdx[boucle] = -1;
            }
        }

        private void printCurrentSeq(StringBuffer sb, int size) {
            sb.append("Seq(");
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this._cutSimul[i].getName());
            }
            sb.append(")");
        }

        class SimulResult {
            Map<BitSet, double[]> _results = new HashMap<BitSet, double[]>();
            BitSet _tmpSet;
            LinkedList<BitSet> _tmpDel;

            SimulResult(int size, BitSet fixSet, Collection<SimulVar> states) {
                this._tmpSet = new BitSet(size);
                this._tmpDel = new LinkedList();
                this.addResult(fixSet, states);
            }

            public void addSequence(BitSet evtSet, BitSet fixSet, Collection<SimulVar> states) throws SimulException {
                double[] res = this._results.get(fixSet);
                if (res != null) {
                    if (!this.equalsResult(res, states)) {
                        throw new SimulException(1, this.displayConflict(evtSet, fixSet, res, fixSet, states));
                    }
                    return;
                }
                this._tmpDel.clear();
                for (Map.Entry<BitSet, double[]> map : this._results.entrySet()) {
                    if (!map.getKey().intersects(fixSet)) continue;
                    this._tmpSet.clear();
                    this._tmpSet.or(map.getKey());
                    this._tmpSet.and(fixSet);
                    if (this._tmpSet.equals(fixSet)) {
                        if (!this.equalsResult(map.getValue(), states)) {
                            throw new SimulException(1, this.displayConflict(evtSet, map.getKey(), map.getValue(), fixSet, states));
                        }
                        this._tmpDel.addLast(map.getKey());
                        continue;
                    }
                    if (!this._tmpSet.equals(map.getKey())) continue;
                    if (!this.equalsResult(map.getValue(), states)) {
                        throw new SimulException(1, this.displayConflict(evtSet, map.getKey(), map.getValue(), fixSet, states));
                    }
                    return;
                }
                while (!this._tmpDel.isEmpty()) {
                    this._results.remove(this._tmpDel.removeFirst());
                }
                this.addResult(fixSet, states);
            }

            private void addResult(BitSet fixSet, Collection<SimulVar> states) {
                double[] res = new double[CaseSimulState.this._stateSimul.size()];
                Iterator<SimulVar> iVar = states.iterator();
                int j = 0;
                while (iVar.hasNext()) {
                    res[j] = iVar.next().getValue();
                    ++j;
                }
                this._results.put((BitSet)fixSet.clone(), res);
            }

            private boolean equalsResult(double[] res, Collection<SimulVar> states) {
                Iterator<SimulVar> iVar = states.iterator();
                int j = 0;
                while (iVar.hasNext()) {
                    if (res[j] != iVar.next().getValue()) {
                        return false;
                    }
                    ++j;
                }
                return true;
            }

            private String displayConflict(BitSet seq, BitSet oldOpts, double[] oldRes, BitSet newOpts, Collection<SimulVar> states) {
                StringBuffer sb = new StringBuffer(512);
                sb.append("\t\tMemComb(");
                int cpt = 0;
                int i = seq.nextSetBit(0);
                while (i >= 0) {
                    if (cpt > 0) {
                        sb.append(", ");
                    }
                    sb.append(CaseSimulState.this._eventSimul.get(i).getName());
                    if (!oldOpts.get(i)) {
                        sb.append("?");
                    }
                    i = seq.nextSetBit(i + 1);
                    ++cpt;
                }
                sb.append(") => {");
                Iterator<SimulVar> iVar = states.iterator();
                int j = 0;
                while (iVar.hasNext()) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    SimulVar var = iVar.next();
                    sb.append(var.getName());
                    sb.append("=").append(var.getVar().getDomain().toString(oldRes[j]));
                    ++j;
                }
                sb.append("}\n");
                sb.append("\t\tCurPerm(");
                int cpt2 = 0;
                int i2 = seq.nextSetBit(0);
                while (i2 >= 0) {
                    if (cpt2 > 0) {
                        sb.append(", ");
                    }
                    sb.append(CaseSimulState.this._cutSimul[cpt2].getName());
                    if (!newOpts.get(CaseSimulState.this._cutSimulIdx[cpt2])) {
                        sb.append("?");
                    }
                    i2 = seq.nextSetBit(i2 + 1);
                    ++cpt2;
                }
                sb.append(") => {");
                iVar = states.iterator();
                j = 0;
                while (iVar.hasNext()) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    SimulVar var = iVar.next();
                    sb.append(var.getName());
                    sb.append("=").append(var.getVar().getDomain().toString(var.getValue()));
                    ++j;
                }
                sb.append("}\n");
                return sb.toString();
            }
        }
    }

    class CaseSimulOutput {
        Set<SimulVar> _inputSimul = new LinkedHashSet<SimulVar>();
        Set<SimulVar> _outputSimul = new LinkedHashSet<SimulVar>();
        SimulVar _var;

        public CaseSimulOutput(SimulVar var) {
            this._var = var;
            if (var != null) {
                this._outputSimul.add(var);
            }
        }

        protected void recupDepends() {
            assert (this._var != null);
            this.recupVars(this._var.searchDefine());
        }

        protected void recupVars(Expr current) {
            block6: {
                block3: {
                    SimulVar simVar;
                    Var var;
                    block7: {
                        block4: {
                            block5: {
                                if (!(current instanceof ExprVar)) break block3;
                                var = ((ExprVar)current).getVar();
                                if (!(var instanceof Flow)) break block4;
                                if (((Flow)var).getOrientation() != '\u0001') break block5;
                                SimulVar simVar2 = LocalSimul.this.getOrCreateSimulVar(var);
                                if (this._inputSimul.contains(simVar2)) {
                                    simVar2.addExpr(current);
                                } else {
                                    this._inputSimul.add(simVar2.addExpr(current));
                                }
                                break block6;
                            }
                            SimulVar simVar3 = LocalSimul.this.getOrCreateSimulVar(var);
                            if (this._outputSimul.contains(simVar3)) break block6;
                            this._outputSimul.add(simVar3.addExpr(current));
                            this.recupVars(simVar3.searchDefine());
                            break block6;
                        }
                        simVar = this.getCurrentState(var);
                        if (simVar == null) break block7;
                        simVar.addExpr(current);
                        break block6;
                    }
                    simVar = LocalSimul.this.getOrCreateSimulVar(var);
                    simVar.addExpr(current);
                    if (this._inputSimul.contains(simVar)) break block6;
                    this._inputSimul.add(simVar.addExpr(current));
                    break block6;
                }
                int size = current.getArgCount();
                for (int i = 0; i < size; ++i) {
                    this.recupVars(current.getArg(i));
                }
            }
            current.setFlagPropage('P');
        }

        protected boolean include(CaseSimulOutput other) {
            return false;
        }

        protected SimulVar getCurrentState(Var var) {
            return null;
        }

        protected void sortOutputs() {
            LinkedHashSet<SimulVar> outputs = new LinkedHashSet<SimulVar>();
            for (int i = 0; i < LocalSimul.this._node.getAssertCount(); ++i) {
                Var var;
                SimulVar simVar;
                Expr evar;
                Expr expr = LocalSimul.this._node.getAssert(i);
                if (!ExprOp.isType(expr, ExprOp.Type.EQ) || !((evar = expr.getArg(0)) instanceof ExprVar) || !this._outputSimul.contains(simVar = LocalSimul.this.getOrCreateSimulVar(var = ((ExprVar)evar).getVar()))) continue;
                outputs.add(simVar);
                var.setFlagPropage('P');
            }
            this._outputSimul = outputs;
        }

        protected boolean stopAction() {
            boolean interval = false;
            for (SimulVar outVar : this._outputSimul) {
                if (!(outVar.getDomain() instanceof DomainRange)) continue;
                interval = true;
                break;
            }
            return !interval;
        }

        public void action() throws TranslateException {
            if (this.stopAction()) {
                return;
            }
            this.verifyComplexity();
            LinkedList<SimulVar> inputs = new LinkedList<SimulVar>(this._inputSimul);
            LinkedList<Double> values = new LinkedList<Double>();
            this.simulInitValues(inputs.listIterator(), values);
        }

        protected long verifyComplexity() throws TranslateException {
            long nbrState = 1L;
            long maxState = Integer.getInteger(LocalSimul.PROP_ALTALIB_LOCALSIMUL_LIMIT, 100000).longValue();
            for (SimulVar simVar : this._inputSimul) {
                Domain dom = simVar.getDomain();
                int nbrVal = dom.getNbrValue();
                if (nbrVal < 0) {
                    LocalSimul.this.CreateException("EXC_STN_SIMUL_INF", simVar, simVar.getName());
                }
                if ((nbrState *= (long)nbrVal) <= maxState * 10L) continue;
                LocalSimul.this.CreateException("EXC_STN_SIMUL_MAX2", this._var, nbrState, maxState);
            }
            if (nbrState > maxState) {
                LocalSimul.this.CreateException("EXC_STN_SIMUL_MAX", this._var, nbrState, maxState);
            }
            return nbrState;
        }

        protected void simulInitValues(ListIterator<SimulVar> iVars, LinkedList<Double> values) throws TranslateException {
            if (iVars.hasNext()) {
                SimulVar simVar = iVars.next();
                Domain dom = simVar.getDomain();
                for (int i = 0; i < dom.getNbrValue(); ++i) {
                    double val = dom.getDouble(i);
                    simVar.setDouble(val);
                    values.addLast(val);
                    this.simulInitValues(iVars, values);
                    values.removeLast();
                }
                iVars.previous();
            } else {
                ArrayList<Object> stack = new ArrayList<Object>(100);
                this.simulInitValues(iVars, values, stack);
            }
        }

        protected void simulInitValues(ListIterator<SimulVar> vars, LinkedList<Double> values, ArrayList<Object> stack) throws TranslateException {
            for (SimulVar outVar : this._outputSimul) {
                if (outVar.evaluate(stack)) continue;
                StringBuffer sb = new StringBuffer(this._inputSimul.size() * 20);
                this.printInitCondition(sb, this._inputSimul, values);
                LocalSimul.this.CreateException("EXC_STN_PROPAGATE_ERROR", outVar, outVar.getMsgAffect(null, LocalSimul.this._node), sb.toString());
            }
            stack.add(stack.size() / 2);
        }

        protected void printInitCondition(StringBuffer sb, Collection<SimulVar> vars, List<Double> values) {
            assert (vars.size() == values.size());
            Iterator<SimulVar> iVar = vars.iterator();
            Iterator<Double> iVal = values.iterator();
            while (iVar.hasNext()) {
                SimulVar simVar = iVar.next();
                sb.append("\t\t");
                sb.append(simVar.getName());
                sb.append(" = ");
                sb.append(simVar.getDomain().toString(iVal.next()));
                sb.append("\n");
            }
        }
    }

    class SimulException
    extends Exception {
        int _type;
        String _otherMsg;

        SimulException(int type, String messag) {
            super(messag);
            this._type = type;
        }

        SimulException(int type, String messag, String otherMsg) {
            super(messag);
            this._type = type;
            this._otherMsg = otherMsg;
        }
    }
}

