/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SimulVar {
    Node _owner;
    Var _var;
    List<Expr> _exprs;
    double _value;
    Expr _define;

    SimulVar(Node owner, Var var) {
        this._owner = owner;
        this._var = var;
        this._value = Double.NaN;
        this._define = null;
        this._exprs = new ArrayList<Expr>(5);
    }

    boolean containExact(List<Expr> lst, Expr search) {
        Iterator<Expr> iExpr = lst.iterator();
        while (iExpr.hasNext()) {
            if (search != iExpr.next()) continue;
            return true;
        }
        return false;
    }

    public SimulVar addExpr(Expr expr) {
        if (expr._flag == 'I') {
            assert (!this.containExact(this._exprs, expr)) : "LocalSimul[" + this._owner + "].SimulVar[" + this._var.toString() + "].addExpr(" + expr.toString() + ")";
            this._exprs.add(expr);
            expr.setFlag('P');
        }
        return this;
    }

    public Expr searchDefine() {
        if (this._define == null) {
            for (int i = 0; i < this._owner.getAssertCount(); ++i) {
                Expr var;
                Expr expr = this._owner.getAssert(i);
                if (!ExprOp.isType(expr, ExprOp.Type.EQ) || !((var = expr.getArg(0)) instanceof ExprVar) || ((ExprVar)var).getVar() != this._var) continue;
                this._define = expr.getArg(1);
                break;
            }
        }
        assert (this._define != null);
        return this._define;
    }

    public boolean evaluate(List<Object> stack) throws TranslateException {
        assert (this._define != null);
        if (Double.isNaN(this._value)) {
            this._value = this._define.getDouble();
            stack.add(this);
            stack.add(this._value);
            this.setDouble(this._value);
        }
        this._define.evaluate();
        double newValue = this._define.getDouble();
        if (!this.getDomain().verifyValueOf(this._define)) {
            return false;
        }
        if (this._value != newValue) {
            stack.add(this);
            stack.add(this._value);
            this.setDouble(newValue);
        }
        return true;
    }

    public boolean affect(Expr expr, List<Object> stack) throws TranslateException {
        assert (this._define == null);
        expr.evaluate();
        double newValue = expr.getDouble();
        if (!this.getDomain().verifyValueOf(expr)) {
            return false;
        }
        if (newValue != this._value) {
            stack.add(this);
            stack.add(this._value);
            this.setDouble(newValue);
        }
        return true;
    }

    public String getMsgAffect(Expr expr, Node node) {
        if (expr == null) {
            expr = this._define;
        }
        String newValue = node.valueToString(expr);
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getName());
        sb.append(" : value=").append(newValue);
        sb.append(", domain=").append(this.getDomain());
        return sb.toString();
    }

    public void setDouble(double value) {
        this._value = value;
        for (int i = this._exprs.size() - 1; i >= 0; --i) {
            this._exprs.get(i).setDouble(value);
        }
    }

    public Var getVar() {
        return this._var;
    }

    public double getValue() {
        return this._value;
    }

    public Domain getDomain() {
        return this._var.getDomain();
    }

    public String getName() {
        return this._var.getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

