/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Extern;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Sub;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Sync
extends Data {
    public static final char SYNC = '\u0002';
    public static final char DIFF = '\u0004';
    public static final char CCF = '\u0006';
    private char _type;
    private List _evts;
    protected static final long LIMIT_NBR_TRANS_FLATNESS = 8192L;

    public Sync(char type, List<String> events) {
        assert (type >= '\u0002' & type <= '\u0006');
        this._type = type;
        this._evts = new ArrayList<String>(events);
    }

    public char getType() {
        return (char)(this._type / 2 * 2);
    }

    public char getRealType() {
        return this._type;
    }

    public int getSize() {
        return this._evts.size();
    }

    public Event getEventAt(int idx) {
        return ((IEvent)this._evts.get((int)idx))._evt;
    }

    public Event getSync() {
        IEvent ievt = (IEvent)this._evts.get(0);
        return ievt._evt;
    }

    public void verify(Node node) throws TranslateException {
        ArrayList namEvts = new ArrayList(this._evts);
        this._evts = new ArrayList(namEvts.size() + 1);
        for (int i = 0; i < namEvts.size(); ++i) {
            String path = (String)namEvts.get(i);
            IEvent evt = new IEvent(path, node, this);
            if (i == 0) {
                if (evt._context.length() != 0) {
                    throw new TranslateException(this, "EXC_SYNC_FIRST", new Object[0]);
                }
                if (this.getType() == '\u0006') {
                    evt._evt.noBasic();
                }
            } else if (evt._context.length() == 0) {
                throw new TranslateException(this, "EXC_SYNC_OTHER", new Object[0]);
            }
            this._evts.add(evt);
        }
    }

    public void verifyWarning(VerifyManager mng) {
        if (!mng.withWarning("SyncSomeSub")) {
            return;
        }
        for (int i = 0; i < this._evts.size(); ++i) {
            IEvent evt = (IEvent)this._evts.get(i);
            for (int j = i - 1; j > 0; --j) {
                IEvent oEvt = (IEvent)this._evts.get(j);
                if (!oEvt._context.equals(evt._context)) continue;
                mng.addError("SyncSomeSub", this, "WRN_SYNC_SOME_SUB", this.getSync().getName(), oEvt.toString(), evt.toString());
                return;
            }
        }
    }

    public void translateCCF(Node node) {
        assert (this._type == '\u0006');
        this._type = (char)5;
        node.addTranslateSync(this);
        Tree tSync = new Tree(268, 0L, 0.0, "", this.getSync(), null);
        Tree ccf = new Tree(273, 0L, 0.0, "ccf", (Tree)tSync.clone(), null);
        node.addTranslateExtern(ccf);
        for (int i = 1; i < this._evts.size(); ++i) {
            IEvent ievt = (IEvent)this._evts.get(i);
            if (ievt._evt.isBasic()) {
                Sync sync = new Sync('\u0002', new ArrayList<String>());
                sync._evts.add(ievt);
                sync.setPosition(this, "Translate CCF");
                node.addTranslateSync(sync);
                this.translateCCFCreateExtern(node, ievt._context, ievt._evt, tSync);
                continue;
            }
            this.translateCCFCreateExternR(node, ievt._context, ievt, tSync);
        }
    }

    private void translateCCFCreateExternR(Node node, String context, IEvent ievt, Tree tSync) {
        int j;
        Sync sync = null;
        Node nodeEvt = ievt._sub.getType();
        for (j = 0; sync == null && j < nodeEvt.getSyncCount(); ++j) {
            if (nodeEvt.getSync(j).getSync() != ievt._evt) continue;
            sync = nodeEvt.getSync(j);
        }
        assert (sync != null);
        for (j = 1; j < sync._evts.size(); ++j) {
            IEvent eevt = (IEvent)sync._evts.get(j);
            if (eevt._evt.isBasic()) {
                this.translateCCFCreateExtern(node, context + eevt._context, eevt._evt, tSync);
                continue;
            }
            this.translateCCFCreateExternR(node, context + eevt._context, eevt, tSync);
        }
    }

    private void translateCCFCreateExtern(Node node, String context, Event evt, Tree tSync) {
        Tree tSet;
        Tree tEvt = new Tree(268, 0L, 0.0, context, evt, null);
        Extern xSet = node.findExtern("withCCF", tEvt);
        Tree tree = tSet = xSet == null ? null : xSet.getVal();
        if (tSet == null) {
            tSet = new Tree(40, 0L, 0.0, "", (Tree)tSync.clone(), null);
            Tree xTern = new Tree(273, 0L, 0.0, "withCCF", tEvt, tSet);
            node.addTranslateExtern(xTern);
        } else {
            Tree tFirst = (Tree)tSync.clone();
            tFirst._next = (Tree)tSet._son;
            tSet._son = tFirst;
        }
    }

    public Data instance(Node parent, String inst) throws TranslateException {
        Sync res = new Sync(this._type, this._evts);
        res.instance(this);
        for (int i = 0; i < this._evts.size(); ++i) {
            IEvent evt = (IEvent)this._evts.get(i);
            res._evts.set(i, evt.instance(parent, inst));
        }
        return res;
    }

    public boolean hasEvent(Event evt) {
        for (int i = 1; i < this._evts.size(); ++i) {
            IEvent ievt = (IEvent)this._evts.get(i);
            if (ievt._evt != evt) continue;
            return true;
        }
        return false;
    }

    public boolean addTrans(Trans tr) {
        for (int i = 0; i < this._evts.size(); ++i) {
            IEvent ievt = (IEvent)this._evts.get(i);
            if (ievt._evt != tr.getEvent()) continue;
            ievt._trs.add(0, tr);
            return true;
        }
        return false;
    }

    public void flatness(Node node) throws TranslateException {
        ArrayList<Trans> cur = new ArrayList<Trans>();
        long nbrTrans = this.nbrTransFlatness();
        if (nbrTrans > 8192L) {
            throw new TranslateException(this, "EXC_FLATNESS_SYNC", this.getSync().getName(), node.getName(), nbrTrans);
        }
        this.flatnessR(node, cur, 0);
    }

    private long nbrTransFlatness() {
        long result = 1L;
        for (int idx = 0; idx < this._evts.size(); ++idx) {
            IEvent ievt = (IEvent)this._evts.get(idx);
            int size = ievt._trs.size();
            if (size == 0) continue;
            if (Long.MAX_VALUE / (long)size < result) {
                return Long.MAX_VALUE;
            }
            result *= (long)size;
        }
        return result;
    }

    private void flatnessR(Node node, List<Trans> lst, int idx) throws TranslateException {
        if (idx == this._evts.size()) {
            Trans tr = new Trans(lst, this.getSync(), this.getType() == '\u0004', node);
            if (tr.getGuard() != null) {
                node.addPrivateTrans(tr);
            }
        } else {
            IEvent ievt = (IEvent)this._evts.get(idx);
            if (ievt._trs.size() > 0) {
                for (int i = 0; i < ievt._trs.size(); ++i) {
                    lst.add(ievt._trs.get(i));
                    this.flatnessR(node, lst, idx + 1);
                    lst.remove(lst.size() - 1);
                }
            } else {
                this.flatnessR(node, lst, idx + 1);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        for (int i = 0; i < this._evts.size(); ++i) {
            if (i > 0) {
                switch (this.getType()) {
                    case '\u0002': {
                        sb.append(", ");
                        break;
                    }
                    case '\u0004': {
                        sb.append(" or ");
                        break;
                    }
                    case '\u0006': {
                        sb.append(" ? ");
                    }
                }
            }
            IEvent ievt = (IEvent)this._evts.get(i);
            sb.append(ievt._context);
            sb.append(ievt._evt.getName());
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        out.write("<");
        for (int i = 0; i < this._evts.size(); ++i) {
            if (i > 0) {
                block0 : switch (this.getType()) {
                    case '\u0002': {
                        out.write(" , ");
                        break;
                    }
                    case '\u0004': {
                        if (i == 1) {
                            switch (frm) {
                                case 1: {
                                    out.write(" or ");
                                    break block0;
                                }
                                case 4: {
                                    out.write(", ");
                                    break block0;
                                }
                            }
                            out.write(" : ");
                            break;
                        }
                        if (frm == 4) {
                            out.write("?, ");
                            break;
                        }
                        out.write(" or ");
                        break;
                    }
                    case '\u0006': {
                        out.write(" ? ");
                    }
                }
            }
            IEvent ievt = (IEvent)this._evts.get(i);
            out.write(ievt._context);
            out.write(ievt._evt.getName());
        }
        if (this.getType() == '\u0004' && frm == 4) {
            out.write("? > >= 1");
        } else {
            out.write(">");
        }
    }

    public void printJava(IndentWriter out) throws IOException {
        out.addData(this);
        switch (this.getType()) {
            case '\u0002': {
                out.write("&");
                break;
            }
            case '\u0004': {
                out.write("|");
                break;
            }
            case '\u0006': {
                out.write("?");
            }
        }
        for (int i = 0; i < this._evts.size(); ++i) {
            if (i > 0) {
                out.write(",");
            }
            IEvent ievt = (IEvent)this._evts.get(i);
            out.write(ievt._context);
            out.write(ievt._evt.getName());
        }
    }

    public void rename(Model.RenameHelper helper, Node node) {
        for (int i = 0; i < this._evts.size(); ++i) {
            IEvent ievt = (IEvent)this._evts.get(i);
            ievt._context = helper.convertPath(ievt._context, node);
        }
    }

    class IEvent {
        Event _evt;
        String _context;
        Sub _sub = null;
        ArrayList<Trans> _trs = null;

        public IEvent(String path, Node node, Data src) throws TranslateException {
            this._evt = (Event)node.findData(3, node, path);
            if (this._evt == null) {
                throw new TranslateException(src, "EXC_EVENT_UNKNOW", path);
            }
            this._context = node.findContext(3, node, path);
            if (this._context.length() > 0) {
                this._sub = (Sub)node.findData(4, node, this._context.substring(0, this._context.length() - 1));
            }
        }

        protected IEvent(Event evt) {
            this._evt = evt;
            this._trs = new ArrayList();
        }

        public IEvent instance(Node parent, String inst) throws TranslateException {
            String name;
            Event evt;
            if (inst.length() > 0) {
                inst = ".";
            }
            if ((evt = parent.getEvent(name = inst + this._context + this._evt.getName())) == null) {
                throw new TranslateException(parent, "EXC_FLATNESS_EVENT", name, parent.getName());
            }
            return new IEvent(evt);
        }

        public String toString() {
            if (this._context.length() > 0) {
                return this._context + this._evt.getName();
            }
            return this._evt.getName();
        }
    }
}

