/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.GenerateException;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprParent;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Extern;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class Trans
extends ExprParent
implements Externalizable {
    private Expr _guard = null;
    private Event _event = null;
    private ArrayList<Data> _affects = new ArrayList();
    private int _groupID = -1;

    public Trans() {
    }

    private static boolean containInOrExpr(Expr or, Expr search) {
        if (!ExprOp.isType(or, ExprOp.Type.OR)) {
            return or.equals(search);
        }
        for (int k = 0; k < or.getArgCount(); ++k) {
            if (!Trans.containInOrExpr(or.getArg(k), search)) continue;
            return true;
        }
        return false;
    }

    Trans(List<Trans> lst, Event evt, boolean diff, Node node) throws TranslateException {
        this();
        this._event = evt;
        for (int i = 0; i < lst.size(); ++i) {
            Trans tr = lst.get(i);
            int j = 0;
            while (j < tr._affects.size()) {
                State var = (State)tr._affects.get(j++);
                Expr val = (Expr)tr._affects.get(j++);
                int idx = this._affects.indexOf(var);
                if (idx < 0) {
                    if (diff) {
                        Expr arg;
                        boolean create = false;
                        if (ExprOp.isType(val, ExprOp.Type.ITE) && (arg = val.getArg(2)) instanceof ExprVar && ((ExprVar)arg).getVar() == var) {
                            create = Trans.containInOrExpr(tr.getGuard(), val.getArg(0));
                        }
                        if (!create) {
                            val = node.addUniqueExpr(new ExprOp(ExprOp.Type.ITE, tr.getGuard(), val, node.addUniqueExpr(new ExprVar(var))));
                        }
                    }
                    this._affects.add(var);
                    this._affects.add(val);
                    continue;
                }
                Expr previousVal = (Expr)this._affects.get(idx + 1);
                if (diff) {
                    ArrayList<Expr> args = new ArrayList<Expr>();
                    if (ExprOp.isType(previousVal, ExprOp.Type.ITE)) {
                        args.add(previousVal.getArg(0));
                        args.add(previousVal.getArg(1));
                    } else if (ExprOp.isType(previousVal, ExprOp.Type.XCASE)) {
                        for (int y = 0; y < previousVal.getArgCount() - 1; ++y) {
                            args.add(previousVal.getArg(y));
                        }
                    } else {
                        throw new TranslateException(evt, "EXC_TRANS_AFFECT_EXIST", var);
                    }
                    args.add(tr.getGuard());
                    args.add(val);
                    args.add(node.addUniqueExpr(new ExprVar(var)));
                    val = node.addUniqueExpr(new ExprOp(ExprOp.Type.XCASE, args));
                    this._affects.set(idx + 1, val);
                    continue;
                }
                if (previousVal.equals(val)) continue;
                throw new TranslateException(evt, "EXC_TRANS_AFFECT_EXIST", var);
            }
            this._guard = this._guard == null ? tr.getGuard() : node.addUniqueExpr(new ExprOp(diff ? ExprOp.Type.OR : ExprOp.Type.AND, this._guard, tr.getGuard()));
        }
        if (this._guard != null) {
            this._guard.fixParent(this);
        }
        for (int j = 0; j < this._affects.size(); ++j) {
            int n = ++j;
            Expr val = (Expr)this._affects.get(n);
            val.fixParent(this);
        }
    }

    public Trans instance(Node parent, String inst) throws TranslateException {
        if (inst == null) {
            this._guard = this._guard.moveTo(parent, this);
            for (int i = 1; i < this._affects.size(); i += 2) {
                Expr val = (Expr)this._affects.get(i);
                this._affects.set(i, val.moveTo(parent, this));
            }
            return this;
        }
        Trans res = new Trans();
        res.instance(this);
        res._guard = (Expr)this._guard.instance(parent, inst, res);
        res._event = parent.getEvent(inst + "." + this._event.getName());
        if (res._event == null) {
            throw new TranslateException(parent, "EXC_FLATNESS_EVENT", inst + "." + this._event.getName(), parent.getName());
        }
        int i = 0;
        while (i < this._affects.size()) {
            State var = (State)this._affects.get(i++);
            Expr val = (Expr)this._affects.get(i++);
            res._affects.add(parent.getState(inst + "." + var.getName()));
            res._affects.add(val.instance(parent, inst, res));
        }
        return res;
    }

    @Override
    protected boolean exchangeChild(Expr oldChild, Expr newChild) {
        boolean result = false;
        if (this._guard == oldChild) {
            this._guard = newChild;
            result = true;
        }
        for (int i = 1; i < this._affects.size(); i += 2) {
            Expr val = (Expr)this._affects.get(i);
            if (val != oldChild) continue;
            this._affects.set(i, newChild);
            result = true;
        }
        return result;
    }

    public void setGuard(Expr guard) throws TranslateException {
        assert (this._guard == null);
        if (!guard.isBoolean()) {
            throw new TranslateException(guard, "EXC_TRANS_GUARD_NOBOOL", new Object[0]);
        }
        this._guard = guard;
    }

    public final Expr getGuard() {
        return this._guard;
    }

    public void setEvent(Event evt) {
        assert (this._event == null);
        this._event = evt;
    }

    public final Event getEvent() {
        return this._event;
    }

    public void setGroupID(int value) {
        this._groupID = value;
    }

    public int getGroupID() {
        return this._groupID;
    }

    void addPrivateAffect(State var, Expr expr) throws TranslateException {
        if (var.getDomain().isBoolean() ? !expr.isBoolean() : (var.getDomain().isNumeric() ? !expr.isNumeric() : var.getDomain().isSymbolic() && !expr.isSymbolic())) {
            throw new TranslateException(expr, "EXC_TRANS_AFFECT_DOMAIN", var.getName());
        }
        this._affects.add(var);
        this._affects.add(expr);
    }

    public void addAffect(State var, Expr expr) throws TranslateException {
        if (this._affects.contains(var)) {
            throw new TranslateException(this, "EXC_TRANS_AFFECT_EXIST", var.getName());
        }
        this.addPrivateAffect(var, expr);
    }

    public final List<Data> getAffects() {
        return this._affects;
    }

    public String toString() {
        StringWriter write = new StringWriter(128);
        IndentWriter out = new IndentWriter(write);
        try {
            this.printOTools(out, 0);
            out.close(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return write.toString();
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        if (this._guard != null) {
            this._guard.printOTools(out, frm);
        } else {
            out.write("<null>");
        }
        out.write(" |- ");
        if (this._event == null) {
            out.write("<null>");
        } else {
            this._event.printOTools(out, frm);
        }
        out.write(" -> ");
        int i = 0;
        while (i < this._affects.size()) {
            if (i > 0) {
                out.write(", ");
            }
            State var = (State)this._affects.get(i++);
            Expr val = (Expr)this._affects.get(i++);
            out.addData(var);
            String name = var.getName();
            if (frm == 4 && name.indexOf(46) != -1) {
                out.write(name.replaceAll("\\.", "^^"));
            } else {
                out.write(name);
            }
            out.write(" := ");
            val.printOTools(out, frm);
        }
    }

    private void printAffectMoca(IndentWriter out, Node node) throws IOException {
        if (this._affects.size() == 0) {
            return;
        }
        out.write("!! ");
        int i = 0;
        while (i < this._affects.size()) {
            if (i > 0) {
                out.write(", ");
            }
            State var = (State)this._affects.get(i++);
            Expr val = (Expr)this._affects.get(i++);
            out.addData(var);
            out.write("'");
            out.write(var.getName());
            out.write("' =");
            val.printMoca(out);
        }
        out.write("\n");
    }

    public void printMocaBucket(IndentWriter out, Node node, Extern xBucket) throws IOException {
        Trans tr;
        int i;
        List<Trans> trs = xBucket.transOfBucket(node);
        int size = trs.size();
        if (size < 2) {
            throw new IOException(MsgTrans.getString("EXC_GEN_XBUCKET"));
        }
        int place = node.getCpt();
        out.addData(xBucket);
        out.write("TR: 'sol");
        for (i = 0; i < size; ++i) {
            tr = trs.get(i);
            out.write("..");
            out.write(tr.getEvent().getName());
        }
        out.write("'\n");
        out.addIndent(1);
        out.write("AM ");
        out.write(Integer.toString(place));
        out.write(" -1");
        for (i = 1; i < size; ++i) {
            out.write(", ");
            out.write(Integer.toString(node.getCpt()));
            out.write(" -1");
        }
        out.write("\n");
        out.write("AV ");
        for (i = 0; i < size; ++i) {
            if (i > 0) {
                out.write(", ");
            }
            out.write(Integer.toString(place + i));
            out.write(" 1");
        }
        out.write("\n");
        if (this._guard != null) {
            out.write("?? ");
            this._guard.printMoca(out);
            out.write("\n");
        }
        out.write("LOI drc 0\n");
        out.write("TIR sol");
        for (i = 0; i < size - 1; ++i) {
            tr = trs.get(i);
            out.write(" ");
            Extern.printGammaOfTransBucket(out, tr, node);
        }
        out.write("\n;\n");
        out.addIndent(-1);
        for (i = 0; i < size; ++i) {
            tr = trs.get(i);
            tr._flag = '\u0001';
            out.write("TR: '");
            out.write(tr.getEvent().getName());
            out.write("'\n");
            out.addIndent(1);
            out.write("AM ");
            out.write(Integer.toString(place + i));
            out.write(" 1\n");
            tr.printAffectMoca(out, node);
            out.write("LOI drc 0\n");
            out.write(";\n");
            out.addIndent(-1);
        }
    }

    public void printMoca(IndentWriter out, Node node) throws IOException {
        Extern xPrio;
        Extern xMem;
        if (this._flag != '\u0000') {
            return;
        }
        this._flag = '\u0001';
        Tree tEvt = new Tree(268, 0L, 0.0, "", this._event, null);
        Extern xBucket = node.findExtern("bucket", tEvt);
        if (xBucket != null) {
            this.printMocaBucket(out, node, xBucket);
            return;
        }
        out.addData(this);
        out.write("TR: '");
        out.write(this._event.getName());
        out.write("'\n");
        out.addIndent(1);
        if (this._guard != null) {
            out.write("?? ");
            this._guard.printMoca(out);
            out.write("\n");
        }
        this.printAffectMoca(out, node);
        Extern xLaw = node.findExtern("law", tEvt);
        if (xLaw != null) {
            out.write("LOI ");
            xLaw.printMocaLaw(out, node);
            out.write("\n");
        }
        if ((xMem = node.findExtern("preemptible", tEvt)) != null) {
            out.write("MEM ");
        }
        if ((xPrio = node.findExtern("priority", tEvt)) != null) {
            int priority = xPrio.valueOfPriority();
            if (priority < 0) {
                throw new GenerateException(MsgTrans.getString("EXC_GEN_XPRIORITY"));
            }
            out.write("PRIO ");
            out.write(Long.toString(priority));
            out.write("\n");
        }
        out.write(";\n");
        out.addIndent(-1);
    }

    public void printJava(IndentWriter out, Node node) throws IOException {
        out.addData(this);
        out.write("{\n");
        out.addIndent(1);
        out.write("JTrans tr = new JTrans(getEvent(\"");
        out.write(this._event.getName());
        out.write("\"), this) {\n");
        out.addIndent(1);
        out.write("protected boolean testValid() throws StepperViolatedAssertionException {\n");
        out.addIndent(1);
        out.write("return (");
        this._guard.printJava(out, null, null);
        out.write(") > 0 ? true : false;\n");
        out.addIndent(-1);
        out.write("}\n");
        out.write("public void affect() throws StepperViolatedAssertionException {\n");
        out.addIndent(1);
        int i = 0;
        while (i < this._affects.size()) {
            State var = (State)this._affects.get(i++);
            Expr val = (Expr)this._affects.get(i++);
            out.addData(var);
            out.write("getState(\"");
            out.write(var.getName());
            out.write("\").setValue(");
            val.printJava(out, null, null);
            out.write(");\n");
        }
        out.addIndent(-1);
        out.write("}\n");
        out.addIndent(-1);
        out.write("};\n");
        out.write("addTrans(tr);\n");
        out.write("tr.setDescription(\n");
        out.addIndent(1);
        out.write("\"");
        out.exportString(true);
        this.printOTools(out, 0);
        out.exportString(false);
        out.write("\");\n");
        out.addIndent(-1);
        out.addIndent(-1);
        out.write("}\n");
    }

    public void rename(Model.RenameHelper helper, Node node) {
        this._guard.rename(helper, node);
        for (int i = 1; i < this._affects.size(); ++i) {
            Expr val = (Expr)this._affects.get(i++);
            val.rename(helper, node);
        }
    }

    public void translateLink(Node node) {
        Expr guard = this._guard.translateLink(node);
        if (guard != null) {
            this._guard = guard;
        }
        for (int i = 1; i < this._affects.size(); i += 2) {
            Expr val = (Expr)this._affects.get(i);
            Expr expr = val.translateLink(node);
            if (expr == null) continue;
            this._affects.set(i, expr);
        }
    }

    public void verifyExpr(VerifyManager mng) {
        this._guard.verifyExpr(mng);
        for (int i = 1; i < this._affects.size(); i += 2) {
            Expr val = (Expr)this._affects.get(i);
            val.verifyExpr(mng);
        }
    }

    @Override
    public void setFlagPropage(char value) {
        this._flag = value;
        if (this._guard != null) {
            this._guard.setFlagPropage(value);
        }
        if (this._event != null) {
            this._event.setFlagPropage(value);
        }
        int i = 0;
        while (i < this._affects.size()) {
            State var = (State)this._affects.get(i++);
            Expr val = (Expr)this._affects.get(i++);
            var.setFlagPropage(value);
            val.setFlagPropage(value);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._guard);
        out.writeObject(this._event);
        int size = this._affects.size();
        out.writeInt(size);
        int i = 0;
        while (i < this._affects.size()) {
            out.writeObject(this._affects.get(i++));
            out.writeObject(this._affects.get(i++));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._guard = (Expr)in.readObject();
        this._event = (Event)in.readObject();
        int size = in.readInt();
        this._affects.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            this._affects.add((Data)in.readObject());
        }
    }
}

