/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.BoolDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainDefine;
import com.dassault.cecilia.lib.mbsa.translator.model.FloatDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.IntDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;

public class Var
extends Data
implements Externalizable {
    private String _name;
    private Domain _domain;
    private int _groupID = -1;
    private Simular _simular = null;

    protected Var() {
    }

    protected Var(String name, Domain domain) {
        this();
        this._name = name;
        this._domain = domain;
    }

    public String getName() {
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public Domain getDomain() {
        return this._domain;
    }

    public void setGroupID(int value) {
        this._groupID = value;
    }

    public int getGroupID() {
        return this._groupID;
    }

    public void setSimular(Simular simVar) {
        this._simular = simVar;
    }

    public Simular getSimular() {
        return this._simular;
    }

    public boolean isAlias() {
        if (this._simular == null) {
            return false;
        }
        return this._simular.getVar() != this;
    }

    @Override
    public String getNamedType() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.getNamedType());
        sb.append("(");
        sb.append(this._name);
        sb.append(")");
        return sb.toString();
    }

    public final int hashCode() {
        return this._name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Var)) {
            return false;
        }
        return this._name.equals(((Var)obj)._name);
    }

    @Override
    public void setFlagPropage(char value) {
        super.setFlagPropage(value);
        if (this._simular != null) {
            this._simular.setFlag(value);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getName()).append(":").append(this.getDomain());
        return sb.toString();
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        String name = this.getName();
        if (frm == 4 && name.indexOf(46) != -1) {
            out.write(name.replaceAll("\\.", "^^"));
        } else {
            out.write(name);
        }
        out.write(":");
        this.getDomain().printOTools(out, frm);
    }

    public void printMoca(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        if (this._domain == BoolDomain.getInstance()) {
            out.write("bool ");
        } else if (this._domain == FloatDomain.getInstance()) {
            out.write("float ");
        } else {
            out.write("int ");
            if (this._domain.isSymbolic()) {
                out.write("{");
                Iterator<String> iter = this._domain.getSymbolic();
                int i = 0;
                while (iter.hasNext()) {
                    if (i > 0) {
                        out.write(", ");
                    }
                    out.write("'e..");
                    out.write(iter.next());
                    out.write("'");
                    ++i;
                }
                out.write("} ");
            } else if (this._domain != IntDomain.getInstance()) {
                out.write(this._domain.toString());
                out.write(" ");
            }
        }
        out.write("'");
        out.write(this.getName());
        out.write("' ;\n");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._name);
        DomainDefine.writeExternalDomain(this._domain, out);
        if (this._simular != null) {
            out.writeBoolean(true);
            out.writeObject(this._simular);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._name = (String)in.readObject();
        this._domain = DomainDefine.readExternalDomain(in);
        if (in.readBoolean()) {
            this._simular = (Simular)in.readObject();
        }
    }
}

