/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul;

import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.Recorder;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.simul.Analyser;
import com.dassault.cecilia.lib.mbsa.translator.simul.SimTrans;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class SimRecorder
extends Recorder {
    private Map<Simular, Integer> _Sim2ID;
    private List<Simular> _ID2Sim;

    SimRecorder() {
    }

    protected void writeSimulator(DataOutput out, Analyser simul) throws IOException {
        this.writeVersion(out);
        out.writeBoolean(simul._loopModel);
        out.writeLong(simul._uid);
        this.writeDomainDefine(out, simul._domains);
        this.writeNode(out, simul._main);
        this.writeSimulars(out, simul);
        this.writeSimularsConnect(out, simul);
        this.writeTransitions(out, simul);
    }

    protected void readSimulator(DataInput in, Analyser simul) throws IOException {
        int firstInt = this.readVersion(in);
        if (firstInt < 0) {
            assert (this._version > 0);
            simul._loopModel = in.readBoolean();
            if (this._version >= 2) {
                simul._uid = in.readLong();
            }
        } else {
            assert (this._version == 0);
            simul._loopModel = true;
        }
        this.readDomainDefine(in, simul._domains, firstInt);
        this.readNode(in, simul._main);
        this.readSimulars(in, simul);
        this.readSimularsConnect(in, simul);
        this.readTransitions(in, simul);
    }

    protected final int writeIDSimular(DataOutput out, Simular sim) throws IOException {
        Integer ID = this._Sim2ID.get(sim);
        if (ID == null) {
            throw new IOException("ID null for simular " + sim.toString());
        }
        out.writeInt(ID);
        return ID;
    }

    private void writeSimulars(DataOutput out, Analyser simul) throws IOException {
        Simular sim;
        int i;
        int ID = 0;
        this._Sim2ID = new IdentityHashMap<Simular, Integer>();
        int nbrState = simul._states.size();
        out.writeInt(nbrState);
        int nbrVars = simul._vars.size();
        out.writeInt(nbrVars);
        for (i = 0; i < nbrState; ++i) {
            sim = simul._states.get(i);
            this._Sim2ID.put(sim, ID++);
            this.writeSimular(out, sim);
        }
        for (i = 0; i < nbrVars; ++i) {
            sim = simul._vars.get(i);
            this._Sim2ID.put(sim, ID++);
            this.writeSimular(out, sim);
        }
    }

    protected final Simular getSimularFromID(int ID) throws IOException {
        if (ID < 0 || ID >= this._ID2Sim.size()) {
            throw new IOException("ID simular exception : " + ID);
        }
        return this._ID2Sim.get(ID);
    }

    private void readSimulars(DataInput in, Analyser simul) throws IOException {
        Simular sim;
        int i;
        int nbrState = in.readInt();
        int nbrVars = in.readInt();
        this._ID2Sim = new ArrayList<Simular>(nbrState + nbrVars);
        for (i = 0; i < nbrState; ++i) {
            sim = this.readSimular(in, simul._main);
            simul._states.add(sim);
            this._ID2Sim.add(sim);
        }
        for (i = 0; i < nbrVars; ++i) {
            sim = this.readSimular(in, simul._main);
            simul._vars.add(sim);
            this._ID2Sim.add(sim);
        }
    }

    private void writeSimularsConnect(DataOutput out, Analyser simul) throws IOException {
        int i;
        int size = simul._states.size();
        for (i = 0; i < size; ++i) {
            this.writeSimularConnect(out, simul._states.get(i));
        }
        size = simul._vars.size();
        for (i = 0; i < size; ++i) {
            this.writeSimularConnect(out, simul._vars.get(i));
        }
    }

    private void writeSimularConnect(DataOutput out, Simular simular) throws IOException {
        Expr[] parentsExpr = simular.getParentsExpr();
        if (parentsExpr != null) {
            int size = parentsExpr.length;
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                int idExpr = this.getIDExpr(parentsExpr[i]);
                out.writeInt(idExpr);
            }
        } else {
            out.writeInt(-1);
        }
        List<Simular> parentsVar = simular.getOrderedParents();
        if (parentsVar != null) {
            out.writeInt(parentsVar.size());
            for (Simular simVar : parentsVar) {
                int n = this.writeIDSimular(out, simVar);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readSimularsConnect(DataInput in, Analyser simul) throws IOException {
        int i;
        int size = simul._states.size();
        for (i = 0; i < size; ++i) {
            this.readSimularConnect(in, simul._states.get(i));
        }
        size = simul._vars.size();
        for (i = 0; i < size; ++i) {
            this.readSimularConnect(in, simul._vars.get(i));
        }
    }

    private void readSimularConnect(DataInput in, Simular simular) throws IOException {
        int nbrVars;
        int nbrParents = in.readInt();
        if (nbrParents >= 0) {
            Expr[] parentsExpr = new Expr[nbrParents];
            for (int i = 0; i < nbrParents; ++i) {
                int idExpr = in.readInt();
                parentsExpr[i] = this.getExprFromID(idExpr);
            }
            simular.setParentsExpr(parentsExpr);
        }
        if ((nbrVars = in.readInt()) >= 0) {
            ArrayList<Simular> vars = new ArrayList<Simular>(nbrVars);
            for (int i = 0; i < nbrVars; ++i) {
                int idVar = in.readInt();
                vars.add(this.getSimularFromID(idVar));
            }
            simular.setOrderedParents(vars);
        }
    }

    private void writeTransitions(DataOutput out, Analyser simul) throws IOException {
        int sizeTranss = simul._transs.size();
        out.writeInt(sizeTranss);
        for (int idx = 0; idx < sizeTranss; ++idx) {
            SimTrans tr = simul._transs.get(idx);
            this.writeTransition(out, tr._tr);
            if (tr._parentsExpr != null) {
                int size = tr._parentsExpr.length;
                out.writeInt(size);
                for (int i = 0; i < size; ++i) {
                    out.writeInt(this.getIDExpr(tr._parentsExpr[i]));
                }
            } else {
                out.writeInt(-1);
            }
            if (tr._parentsVar != null) {
                out.writeInt(tr._parentsVar.size());
                for (Simular simVar : tr._parentsVar) {
                    this.writeIDSimular(out, simVar);
                }
                continue;
            }
            out.writeInt(-1);
        }
    }

    private void readTransitions(DataInput in, Analyser simul) throws IOException {
        int nbrTrans = in.readInt();
        for (int idx = 0; idx < nbrTrans; ++idx) {
            int nbrVars;
            Trans tr = this.readTransition(in);
            SimTrans simTr = new SimTrans(tr);
            simTr.setIdx(idx);
            simul._transs.add(simTr);
            int nbrParents = in.readInt();
            if (nbrParents >= 0) {
                Expr[] parentsExpr = new Expr[nbrParents];
                for (int i = 0; i < nbrParents; ++i) {
                    parentsExpr[i] = this.getExprFromID(in.readInt());
                }
                simTr.setParentsExpr(parentsExpr);
            }
            if ((nbrVars = in.readInt()) < 0) continue;
            ArrayList<Simular> vars = new ArrayList<Simular>(nbrVars);
            for (int i = 0; i < nbrVars; ++i) {
                vars.add(this.getSimularFromID(in.readInt()));
            }
            simTr.setOrderedParents(vars);
        }
    }
}

