/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul.jf;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainRange;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCst;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCstEnum;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import com.dassault.cecilia.lib.mbsa.translator.simul.SimTrans;
import com.dassault.cecilia.lib.mbsa.translator.simul.Simulator;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFFlow;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFSim;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFState;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFTrans;
import com.dassault.cecilia.lib.util.io.LimitedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompilatorV1
extends Simulator {
    int _cptValueByte = 0;
    int _cptValueInt = 0;
    int _cptValueFloat = 0;
    private static final String NameJFSim = JFSim.class.getSimpleName();
    private static final String NameJFState = JFState.class.getSimpleName();
    private static final String NameJFFlow = JFFlow.class.getSimpleName();
    protected Map<Simular, String> _codes = new HashMap<Simular, String>();
    private static final int POS_CODE = "_vF[".indexOf(70);
    private static final int POS_VALUE = "_vF[".indexOf(91);

    public CompilatorV1() {
    }

    public CompilatorV1(Node main, Model architect) {
        super(main, architect);
    }

    private void printHeader(Writer output, String name) throws IOException {
        output.append("import ").append(IOException.class.getName()).append(";\n");
        output.append("import ").append(StepperException.class.getName()).append(";\n");
        output.append("import ").append(JFFlow.class.getName()).append(";\n");
        output.append("import ").append(JFSim.class.getName()).append(";\n");
        output.append("import ").append(JFState.class.getName()).append(";\n");
        output.append("import ").append(JFTrans.class.getName()).append(";\n");
        output.append("\n");
        output.append("public class ").append(name).append(" extends " + NameJFSim + " {\n");
    }

    private void printEnums(Writer output) throws IOException {
        output.append("\nprotected void defineEnums() {\n");
        int nbrEnums = this._domains.getEnumSize();
        for (int i = 0; i < nbrEnums; ++i) {
            output.append("  addEnumStr(\"").append(this._domains.getEnumStr(i)).append("\");\n");
        }
        output.append("}\n");
    }

    private void printDomains(Writer output) throws IOException {
        output.append("\nprotected void defineDomains() {\n");
        int nbrDomains = this._domains.getDomainSize();
        for (int i = 0; i < nbrDomains; ++i) {
            output.append("  addDomain( ");
            Domain dom = this._domains.getDomainFromIndex(i);
            if (dom instanceof DomainRange) {
                output.append("new " + NameJFSim + ".DomainRange(");
                output.append(Integer.toString((int)dom.getDouble(0)));
                output.append(", ");
                output.append(Integer.toString((int)dom.getDouble(dom.getNbrValue() - 1)));
                output.append(")");
            } else {
                output.append("new " + NameJFSim + ".DomainEnum( new int[] {");
                int nbrValues = dom.getNbrValue();
                for (int j = 0; j < nbrValues; ++j) {
                    if (j > 0) {
                        output.append(",");
                    }
                    output.append(Integer.toString((int)dom.getDouble(j)));
                }
                output.append("} )");
            }
            output.append(" );\n");
        }
        output.append("}\n");
    }

    private int getIndexOfDomain(Domain dom) {
        int idx = dom.getIdx();
        if (idx >= 0) {
            return 10 + idx;
        }
        if (dom.equals(this._domains.getBool())) {
            return 0;
        }
        if (dom.equals(this._domains.getInt())) {
            return 1;
        }
        if (dom.equals(this._domains.getFloat())) {
            return 2;
        }
        return -1;
    }

    private JFState.Range getRangeOfDomain(Domain dom) {
        int idx = dom.getIdx();
        if (idx >= 0) {
            int maxValue = -1;
            if (dom instanceof DomainRange) {
                maxValue = (int)dom.getDouble(dom.getNbrValue() - 1);
            } else {
                int nbrValues = dom.getNbrValue();
                for (int j = 0; j < nbrValues; ++j) {
                    int value = (int)dom.getDouble(j);
                    if (maxValue >= value) continue;
                    maxValue = value;
                }
            }
            if (maxValue <= 127) {
                return JFState.Range.BYTE;
            }
            return JFState.Range.INT;
        }
        if (dom.equals(this._domains.getBool())) {
            return JFState.Range.BYTE;
        }
        if (dom.equals(this._domains.getInt())) {
            return JFState.Range.INT;
        }
        return JFState.Range.FLOAT;
    }

    private final JFState.Range getRangeOfCode(String code) {
        switch (code.charAt(POS_CODE)) {
            case 'B': {
                return JFState.Range.BYTE;
            }
            case 'I': {
                return JFState.Range.INT;
            }
        }
        return JFState.Range.FLOAT;
    }

    private final int getIndexValueOfCode(String code) {
        int end = code.indexOf(93);
        return Integer.parseInt(code.substring(POS_VALUE + 1, end));
    }

    private static boolean isBooleanScale(Expr ... args) {
        for (Expr expr : args) {
            if (expr.getScale() == Expr.Scale.Boolean) continue;
            return false;
        }
        return true;
    }

    private static boolean isBooleanMasked(Expr ... args) {
        for (Expr expr : args) {
            if (expr instanceof ExprCst || expr instanceof ExprVar) continue;
            if (expr instanceof ExprOp) {
                ExprOp exprOp = (ExprOp)expr;
                if (exprOp.getType() == ExprOp.Type.ITE && CompilatorV1.isBooleanScale(exprOp.getArg(1), exprOp.getArg(2)) && CompilatorV1.isBooleanMasked(exprOp.getArg(1), exprOp.getArg(2))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void printExprBool(Expr expr, Writer output, boolean ctrl) throws IOException {
        if (expr instanceof ExprCst && expr.getScale() == Expr.Scale.Boolean) {
            output.append(expr.getBool() ? "true" : "false");
            return;
        }
        if (expr instanceof ExprOp) {
            ExprOp exprOp = (ExprOp)expr;
            switch (exprOp.getType()) {
                case EQ: {
                    output.append("(");
                    if (CompilatorV1.isBooleanScale(expr.getArg(0), expr.getArg(1)) && !CompilatorV1.isBooleanMasked(expr.getArg(0), expr.getArg(1))) {
                        this.printExprBool(expr.getArg(0), output, false);
                        output.append("==");
                        this.printExprBool(expr.getArg(1), output, false);
                    } else {
                        this.printExprNum(expr.getArg(0), output, false);
                        output.append("==");
                        this.printExprNum(expr.getArg(1), output, false);
                    }
                    output.append(")");
                    return;
                }
                case NEQ: {
                    output.append("(");
                    if (CompilatorV1.isBooleanScale(expr.getArg(0), expr.getArg(1)) && !CompilatorV1.isBooleanMasked(expr.getArg(0), expr.getArg(1))) {
                        this.printExprBool(expr.getArg(0), output, false);
                        output.append("!=");
                        this.printExprBool(expr.getArg(1), output, false);
                    } else {
                        this.printExprNum(expr.getArg(0), output, false);
                        output.append("!=");
                        this.printExprNum(expr.getArg(1), output, false);
                    }
                    output.append(")");
                    return;
                }
                case LEQ: {
                    output.append("(");
                    this.printExprNum(expr.getArg(0), output, false);
                    output.append("<=");
                    this.printExprNum(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case GEQ: {
                    output.append("(");
                    this.printExprNum(expr.getArg(0), output, false);
                    output.append(">=");
                    this.printExprNum(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case LT: {
                    output.append("(");
                    this.printExprNum(expr.getArg(0), output, false);
                    output.append("<");
                    this.printExprNum(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case GT: {
                    output.append("(");
                    this.printExprNum(expr.getArg(0), output, false);
                    output.append(">");
                    this.printExprNum(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case NOT: {
                    output.append("(!");
                    this.printExprBool(expr.getArg(0), output, false);
                    output.append(")");
                    return;
                }
                case IMPLY: {
                    output.append("(!");
                    this.printExprBool(expr.getArg(0), output, false);
                    output.append("||");
                    this.printExprBool(expr.getArg(1), output, false);
                    output.append(")");
                    return;
                }
                case OR: 
                case AND: {
                    output.append("(");
                    for (int i = 0; i < expr.getArgCount(); ++i) {
                        if (i > 0) {
                            switch (((ExprOp)expr).getType()) {
                                case OR: {
                                    output.append("||");
                                    break;
                                }
                                case AND: {
                                    output.append("&&");
                                }
                            }
                        }
                        this.printExprBool(expr.getArg(i), output, false);
                    }
                    output.append(")");
                    return;
                }
                case ITE: {
                    if (!CompilatorV1.isBooleanScale(exprOp.getArg(1), exprOp.getArg(2))) break;
                    output.append("(");
                    this.printExprBool(exprOp.getArg(0), output, false);
                    output.append("?");
                    this.printExprBool(exprOp.getArg(1), output, false);
                    output.append(":");
                    this.printExprBool(exprOp.getArg(2), output, false);
                    output.append(")");
                    return;
                }
                case CASE: {
                    int i;
                    boolean isBool = true;
                    for (int i2 = 1; i2 < exprOp.getArgCount() - 1; i2 += 2) {
                        if (exprOp.getScale() == Expr.Scale.Boolean) continue;
                        isBool = false;
                        break;
                    }
                    if (!isBool) break;
                    int nbrArg = exprOp.getArgCount();
                    for (i = 0; i < nbrArg - 1; ++i) {
                        output.append("(");
                        this.printExprBool(exprOp.getArg(i++), output, false);
                        output.append("?");
                        this.printExprBool(exprOp.getArg(i), output, false);
                        output.append(":");
                    }
                    this.printExprBool(exprOp.getArg(nbrArg - 1), output, false);
                    for (i = nbrArg / 2; i > 0; --i) {
                        output.append(")");
                    }
                    return;
                }
            }
        }
        if (ctrl) {
            throw new IOException("Expression error (not compilable in java code)");
        }
        output.append("(");
        this.printExprNum(expr, output, true);
        output.append(" != 0)");
    }

    private void printExprNum(Expr expr, Writer output, boolean ctrl) throws IOException {
        if (expr instanceof ExprCstEnum) {
            output.append(Integer.toString(((ExprCstEnum)expr).getSymbol()));
            return;
        }
        if (expr instanceof ExprCst) {
            switch (expr.getScale()) {
                case Boolean: {
                    output.append(expr.getBool() ? "1" : "0");
                    break;
                }
                case Integer: {
                    output.append(Long.toString(expr.getInt()));
                    break;
                }
                case Float: {
                    output.append(Double.toString(expr.getFloat()));
                    break;
                }
                case Symbolic: {
                    output.append(Integer.toString(expr.getSymbol()));
                }
            }
            return;
        }
        if (expr instanceof ExprVar) {
            Simular var = ((ExprVar)expr).getVar().getSimular();
            output.append(this._codes.get(var));
            return;
        }
        if (expr instanceof ExprOp) {
            ExprOp exprOp = (ExprOp)expr;
            switch (exprOp.getType()) {
                case CASE: {
                    int i;
                    boolean isBool = true;
                    for (int i2 = 1; i2 < exprOp.getArgCount() - 1; i2 += 2) {
                        if (exprOp.getScale() == Expr.Scale.Boolean) continue;
                        isBool = false;
                        break;
                    }
                    if (isBool) break;
                    int nbrArg = exprOp.getArgCount();
                    for (i = 0; i < nbrArg - 1; ++i) {
                        output.append("(");
                        this.printExprBool(exprOp.getArg(i++), output, false);
                        output.append("?");
                        this.printExprNum(exprOp.getArg(i), output, false);
                        output.append(":");
                    }
                    this.printExprNum(exprOp.getArg(nbrArg - 1), output, false);
                    for (i = nbrArg / 2; i > 0; --i) {
                        output.append(")");
                    }
                    return;
                }
                case ITE: {
                    if (CompilatorV1.isBooleanScale(exprOp.getArg(1), exprOp.getArg(2))) break;
                    output.append("(");
                    this.printExprBool(exprOp.getArg(0), output, false);
                    output.append("?");
                    this.printExprNum(exprOp.getArg(1), output, false);
                    output.append(":");
                    this.printExprNum(exprOp.getArg(2), output, false);
                    output.append(")");
                    return;
                }
                case CRD: {
                    output.append("(");
                    for (int i = 0; i < exprOp.getArgCount(); ++i) {
                        if (i > 0) {
                            output.append("+");
                        }
                        output.append("(");
                        this.printExprBool(exprOp.getArg(i), output, false);
                        output.append(" ? 1 : 0)");
                    }
                    output.append(")");
                    return;
                }
                case NEG: {
                    output.append("(-1*");
                    this.printExprNum(exprOp.getArg(0), output, false);
                    output.append(")");
                    return;
                }
                case MIN: 
                case MAX: 
                case DIV: {
                    int i;
                    block29: for (i = 1; i <= exprOp.getArgCount(); ++i) {
                        switch (exprOp.getType()) {
                            case MIN: {
                                output.append("Min(");
                                continue block29;
                            }
                            case MAX: {
                                output.append("Max(");
                                continue block29;
                            }
                            case DIV: {
                                output.append("Div(");
                            }
                        }
                    }
                    for (i = 0; i < exprOp.getArgCount(); ++i) {
                        if (i > 1) {
                            output.append(")");
                        }
                        if (i > 0) {
                            output.append(",");
                        }
                        this.printExprNum(exprOp.getArg(i), output, false);
                    }
                    output.append(")");
                    return;
                }
                case MOD: {
                    int i;
                    for (i = 1; i <= exprOp.getArgCount(); ++i) {
                        output.append("Mod(");
                    }
                    for (i = 0; i < exprOp.getArgCount(); ++i) {
                        if (i > 1) {
                            output.append(")");
                        }
                        if (i > 0) {
                            output.append(",");
                        }
                        if (exprOp.getScale() == Expr.Scale.Float) {
                            output.append("(int)");
                        }
                        this.printExprNum(exprOp.getArg(i), output, false);
                    }
                    output.append(")");
                    return;
                }
                case ADD: 
                case SUB: 
                case MUL: {
                    output.append("(");
                    for (int i = 0; i < exprOp.getArgCount(); ++i) {
                        if (i > 0) {
                            switch (exprOp.getType()) {
                                case ADD: {
                                    output.append("+");
                                    break;
                                }
                                case SUB: {
                                    output.append("-");
                                    break;
                                }
                                case MUL: {
                                    output.append("*");
                                }
                            }
                        }
                        this.printExprNum(exprOp.getArg(i), output, false);
                    }
                    output.append(")");
                    return;
                }
            }
        }
        if (ctrl) {
            throw new IOException("Expression error (not compilable in java code)");
        }
        output.append("((");
        this.printExprBool(expr, output, true);
        output.append(") ? 1 : 0)");
    }

    private void printStates(Writer output) throws IOException {
        int i;
        int SPLIT_NBR = 1000;
        int nbrStates = this._states.size();
        int idx = 1;
        for (i = 0; i < nbrStates; ++i) {
            if (i % 1000 == 0) {
                output.append("private void defineStates_");
                output.append(Integer.toString(idx++));
                output.append("() {\n");
            }
            Simular var = (Simular)this._states.get(i);
            var.setIndex(i);
            Domain dom = var.getDomain();
            int idxValue = 0;
            StringBuffer code = new StringBuffer(128);
            switch (this.getRangeOfDomain(dom)) {
                case BYTE: {
                    idxValue = this._cptValueByte++;
                    output.append("  addState(new " + NameJFState + ".Byte(");
                    code.append("_vB[").append(idxValue).append("]");
                    break;
                }
                case INT: {
                    idxValue = this._cptValueInt++;
                    output.append("  addState(new " + NameJFState + ".Int(");
                    code.append("_vI[").append(idxValue).append("]");
                    break;
                }
                case FLOAT: {
                    idxValue = this._cptValueFloat++;
                    output.append("  addState(new " + NameJFState + ".Float(");
                    code.append("_vF[").append(idxValue).append("]");
                }
            }
            output.append(")");
            output.append(");\n");
            this._codes.put(var, code.toString());
            if ((i + 1) % 1000 != 0) continue;
            output.append("}\n");
        }
        if (nbrStates % 1000 != 0) {
            output.append("}\n");
        }
        output.append("\nprotected void defineStates() {\n");
        for (i = 1; i < idx; ++i) {
            output.append("  defineStates_");
            output.append(Integer.toString(i));
            output.append("();\n");
        }
        output.append("}\n");
    }

    private void printFlows(Writer output) throws IOException {
        int i;
        int nbrVars = this._vars.size();
        for (int i2 = 0; i2 < nbrVars; ++i2) {
            Simular var = (Simular)this._vars.get(i2);
            StringBuffer code = new StringBuffer(128);
            switch (this.getRangeOfDomain(var.getDomain())) {
                case BYTE: {
                    code.append("_vB[").append(this._cptValueByte++).append("]");
                    break;
                }
                case INT: {
                    code.append("_vI[").append(this._cptValueInt++).append("]");
                    break;
                }
                case FLOAT: {
                    code.append("_vF[").append(this._cptValueFloat++).append("]");
                }
            }
            this._codes.put(var, code.toString());
        }
        output.append("\n");
        int SPLIT_NBR = 100;
        int idx = 1;
        for (i = 0; i < nbrVars; ++i) {
            if (i % 100 == 0) {
                output.append("private void defineFlows_");
                output.append(Integer.toString(idx++));
                output.append("() {\n");
            }
            Simular var = (Simular)this._vars.get(i);
            output.append("  addFlow(");
            this.printConstructorFlow(var, output);
            output.append(");\n");
            if ((i + 1) % 100 != 0) continue;
            output.append("}\n");
        }
        if (nbrVars % 100 != 0) {
            output.append("}\n");
        }
        output.append("protected void defineFlows() {\n");
        for (i = 1; i < idx; ++i) {
            output.append("  defineFlows_");
            output.append(Integer.toString(i));
            output.append("();\n");
        }
        output.append("}\n");
    }

    private void printConstructorFlow(Simular var, Writer output) throws IOException {
        String code = this._codes.get(var);
        JFState.Range range = this.getRangeOfCode(code);
        output.append("new " + NameJFFlow + ".");
        switch (range) {
            case BYTE: {
                output.append("Byte");
                break;
            }
            case INT: {
                output.append("Int");
                break;
            }
            case FLOAT: {
                output.append("Float");
            }
        }
        output.append("(");
        output.append(") {\n");
        output.append("      public final boolean evaluate() throws StepperException {\n");
        output.append("        ");
        switch (range) {
            case BYTE: {
                output.append("byte value = (byte)(");
                break;
            }
            case INT: {
                output.append("int value = (int)(");
                break;
            }
            case FLOAT: {
                output.append("double value = ");
            }
        }
        this.printExprNum(var.getDefine(), output, false);
        if (range != JFState.Range.FLOAT) {
            output.append(")");
        }
        output.append(";\n");
        output.append("        boolean res = (").append(code).append(" != value);\n");
        output.append("        if (res) ").append(code);
        if (var.getDomain() instanceof DomainRange) {
            output.append(" = VerifyDomain(_fls[");
            output.append(Integer.toString(var.getIndex()));
            output.append("], value);\n");
        } else {
            output.append(" = value;\n");
        }
        output.append("        return res;\n");
        output.append("      }\n");
        output.append("    }");
    }

    private String getTransDescription(Trans tr) {
        LimitedWriter realWrite;
        StringWriter write;
        block3: {
            write = new StringWriter(128);
            realWrite = new LimitedWriter(write, 256, true);
            IndentWriter out = new IndentWriter(realWrite);
            try {
                tr.printOTools(out, 0);
                out.close(true);
            }
            catch (IOException e) {
                if (realWrite.isFull()) break block3;
                e.printStackTrace();
            }
        }
        if (realWrite.isFull()) {
            write.append("  ...");
        }
        return write.toString();
    }

    private void printCreateTransitionAffect(SimTrans simTr, Writer output) throws IOException {
        Trans tr = simTr.getTrans();
        LinkedHashMap<String, Integer> code2ID = new LinkedHashMap<String, Integer>();
        int nbrVar = tr.getAffects().size() / 2;
        for (int i = 0; i < nbrVar; ++i) {
            Simular var = ((Var)tr.getAffects().get(i * 2)).getSimular();
            String code = this._codes.get(var);
            JFState.Range range = this.getRangeOfCode(code);
            output.append("      ");
            switch (range) {
                case BYTE: {
                    output.append("byte");
                    break;
                }
                case INT: {
                    output.append("int");
                    break;
                }
                case FLOAT: {
                    output.append("double");
                }
            }
            output.append(" value_");
            output.append(Integer.toString(i));
            output.append(" = ");
            switch (range) {
                case BYTE: {
                    output.append("(byte)(");
                    break;
                }
                case INT: {
                    output.append("(int)(");
                }
            }
            this.printExprNum((Expr)tr.getAffects().get(i * 2 + 1), output, false);
            if (range != JFState.Range.FLOAT) {
                output.append(")");
            }
            output.append(";\n");
            if (code2ID.get(code) != null) {
                int oldIdx = (Integer)code2ID.get(code);
                output.append("      if (");
                output.append("value_");
                output.append(Integer.toString(oldIdx));
                output.append(" != value_");
                output.append(Integer.toString(i));
                output.append(") ThrowTransAffectException(this, _sts[");
                output.append(Integer.toString(var.getIndex()));
                output.append("], value_");
                output.append(Integer.toString(oldIdx));
                output.append(", value_");
                output.append(Integer.toString(i));
                output.append(");\n");
                continue;
            }
            code2ID.put(code, i);
        }
        for (Map.Entry entry : code2ID.entrySet()) {
            output.append("      ");
            output.append((CharSequence)entry.getKey());
            output.append("=");
            Simular var = ((Var)tr.getAffects().get((Integer)entry.getValue() * 2)).getSimular();
            if (var.getDomain() instanceof DomainRange) {
                output.append("VerifyDomain(_sts[");
                output.append(Integer.toString(var.getIndex()));
                output.append("], value_");
                output.append(Integer.toString((Integer)entry.getValue()));
                output.append(");\n");
                continue;
            }
            output.append("value_");
            output.append(Integer.toString((Integer)entry.getValue()));
            output.append(";\n");
        }
    }

    private void printConstructorTransition(SimTrans tr, Writer output) throws IOException {
        output.append("new JFTrans(");
        output.append(") {\n");
        output.append("    public final boolean isValid() throws StepperException {\n");
        output.append("      return ");
        this.printExprBool(tr.getTrans().getGuard(), output, false);
        output.append(";\n");
        output.append("    }\n");
        output.append("    public final void affect() throws StepperException {\n");
        this.printCreateTransitionAffect(tr, output);
        output.append("    }\n");
        output.append("  }");
    }

    private void printTransitions(Writer output) throws IOException {
        int i;
        int SPLIT_NBR = 50;
        int nbrTrs = this._transs.size();
        int idx = 1;
        output.append("\n");
        for (i = 0; i < nbrTrs; ++i) {
            if (i % 50 == 0) {
                output.append("private void defineTrans_");
                output.append(Integer.toString(idx++));
                output.append("() {\n");
            }
            output.append("  addTransition(");
            this.printConstructorTransition((SimTrans)this._transs.get(i), output);
            output.append(");\n");
            if ((i + 1) % 50 != 0) continue;
            output.append("}\n");
        }
        if (nbrTrs % 50 != 0) {
            output.append("}\n");
        }
        output.append("protected void defineTransitions() {\n");
        for (i = 1; i < idx; ++i) {
            output.append("  defineTrans_");
            output.append(Integer.toString(i));
            output.append("();\n");
        }
        output.append("}\n");
    }

    private void printConstructor(Writer output, String name) throws IOException {
        output.append("\npublic ");
        output.append(name);
        output.append("() throws IOException {\n  super(");
        output.append(Integer.toString(this._states.size()));
        output.append(",");
        output.append(Integer.toString(this._vars.size()));
        output.append(",");
        output.append(Integer.toString(this._main.getFlowCount()));
        output.append(",");
        output.append(Integer.toString(this._transs.size()));
        output.append(",");
        output.append(Integer.toString(this._cptValueByte));
        output.append(",");
        output.append(Integer.toString(this._cptValueInt));
        output.append(",");
        output.append(Integer.toString(this._cptValueFloat));
        output.append(");\n}\n");
    }

    private void printFooter(Writer output) throws IOException {
        output.append("\n}\n");
    }

    public void printJavaCode(Writer output, String name) throws IOException {
        this.printHeader(output, name);
        this.printEnums(output);
        this.printDomains(output);
        this.printStates(output);
        this.printFlows(output);
        this.printTransitions(output);
        this.printConstructor(output, name);
        this.printFooter(output);
        output.flush();
        MsgTrans.LOG.fine("Finish generated");
    }

    public void printBinaryInformations(OutputStream stream) throws IOException {
        Simular var;
        int i;
        DataOutputStream output = new DataOutputStream(stream);
        output.writeInt(0);
        int nbr = this._vars.size();
        output.writeInt(nbr);
        for (i = 0; i < nbr; ++i) {
            var = (Simular)this._vars.get(i);
            output.writeUTF(var.getName());
            output.writeInt(this.getIndexOfDomain(var.getDomain()));
            output.writeInt(this.getIndexValueOfCode(this._codes.get(var)));
            output.writeDouble(var.getValue());
            output.writeDouble(Double.NaN);
            output.writeInt(var.getOrderedParents().size());
            for (Simular parent : var.getOrderedParents()) {
                output.writeInt(parent.getIndex());
            }
        }
        nbr = this._states.size();
        output.writeInt(nbr);
        for (i = 0; i < nbr; ++i) {
            var = (Simular)this._states.get(i);
            output.writeUTF(var.getName());
            output.writeInt(this.getIndexOfDomain(var.getDomain()));
            output.writeInt(this.getIndexValueOfCode(this._codes.get(var)));
            output.writeDouble(var.getValue());
            output.writeInt(var.getOrderedParents().size());
            for (Simular parent : var.getOrderedParents()) {
                output.writeInt(parent.getIndex());
            }
        }
        nbr = this._transs.size();
        output.writeInt(nbr);
        for (i = 0; i < nbr; ++i) {
            SimTrans tr = (SimTrans)this._transs.get(i);
            output.writeUTF(tr.getEvent().getName());
            output.writeUTF(this.getTransDescription(tr.getTrans()));
            boolean bStochastic = tr.getEvent().isStochastic();
            output.writeBoolean(bStochastic);
            if (!bStochastic) {
                output.writeDouble(tr.getEvent().computeDelay(0.0));
                output.writeInt(tr.getEvent().getPriority());
            }
            output.writeInt(tr.getOrderedParents().size());
            for (Simular parent : tr.getOrderedParents()) {
                output.writeInt(parent.getIndex());
            }
        }
        int nbrVars = this._main.getFlowCount();
        output.writeInt(nbrVars);
        for (i = 0; i < nbrVars; ++i) {
            String name = null;
            Var var2 = this._main.getFlow(i);
            if (var2.getSimular().getVar() != var2) {
                name = var2.getName();
            }
            var2 = var2.getSimular().getVar();
            if (name == null) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
                output.writeUTF(name);
            }
            if (var2 instanceof State) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
            }
            output.writeInt(var2.getSimular().getIndex());
        }
    }

    private void printStepperFlows(Writer output) throws IOException {
        int i;
        int SPLIT_NBR = 1000;
        int nbrVars = this._main.getFlowCount();
        int idx = 1;
        for (i = 0; i < nbrVars; ++i) {
            if (i % 1000 == 0) {
                output.append("private void defineStepperFlows_");
                output.append(Integer.toString(idx++));
                output.append("() {\n");
            }
            String name = null;
            Var var = this._main.getFlow(i);
            if (var.getSimular().getVar() != var) {
                name = var.getName();
            }
            var = var.getSimular().getVar();
            output.append("  addFlowStepper(");
            if (var instanceof State) {
                output.append("_sts[");
            } else {
                output.append("_fls[");
            }
            output.append(Integer.toString(var.getSimular().getIndex()));
            output.append("],");
            if (name == null) {
                output.append("null");
            } else {
                output.append("\"").append(name).append("\"");
            }
            output.append(");\n");
            if ((i + 1) % 1000 != 0) continue;
            output.append("}\n");
        }
        if (nbrVars % 1000 != 0) {
            output.append("}\n");
        }
        output.append("\nprotected void defineStepperFlows() {\n");
        for (i = 1; i < idx; ++i) {
            output.append("  defineStepperFlows_");
            output.append(Integer.toString(i));
            output.append("();\n");
        }
        output.append("}\n");
    }

    private void printCreateTransitions(Writer output) throws IOException {
        int nbrTrs = this._transs.size();
        for (int i = 0; i < nbrTrs; ++i) {
            output.append("\nprivate JFTrans createTr$");
            output.append(Integer.toString(i));
            output.append("() {\n");
            output.append("  return ");
            this.printConstructorTransition((SimTrans)this._transs.get(i), output);
            output.append(";\n");
            output.append("}\n");
        }
    }

    private void printParentsOfFlows(Writer output) throws IOException {
        int i;
        int SPLIT_NBR = 100;
        int nbrVars = this._vars.size();
        int idx = 1;
        int nbr = 0;
        output.append("\n");
        for (i = 0; i < nbrVars; ++i) {
            Simular var = (Simular)this._vars.get(i);
            if (var.getOrderedParents().size() <= 0) continue;
            if (nbr % 100 == 0) {
                output.append("private void defineParentsOfFlows_");
                output.append(Integer.toString(idx++));
                output.append("() {\n");
            }
            output.append("  _fls[");
            output.append(Integer.toString(var.getIndex()));
            output.append("].setParents(");
            Iterator<Simular> iParent = var.getOrderedParents().iterator();
            while (iParent.hasNext()) {
                Simular parent = iParent.next();
                output.append("_fls[");
                output.append(Integer.toString(parent.getIndex()));
                output.append("]");
                if (!iParent.hasNext()) continue;
                output.append(",");
            }
            output.append(");\n");
            if (++nbr % 100 != 0) continue;
            output.append("}\n");
        }
        if (nbr % 100 != 0) {
            output.append("}\n");
        }
        output.append("protected void defineParentsOfFlows() {\n");
        for (i = 1; i < idx; ++i) {
            output.append("  defineParentsOfFlows_");
            output.append(Integer.toString(i));
            output.append("();\n");
        }
        output.append("}\n");
    }

    private void printParentsOfStates(Writer output) throws IOException {
        int i;
        int SPLIT_NBR = 100;
        int nbrVars = this._states.size();
        int idx = 1;
        output.append("\n");
        for (i = 0; i < nbrVars; ++i) {
            if (i % 100 == 0) {
                output.append("private void defineParentsOfStates_");
                output.append(Integer.toString(idx++));
                output.append("() {\n");
            }
            Simular var = (Simular)this._states.get(i);
            output.append("  _sts[");
            output.append(Integer.toString(var.getIndex()));
            output.append("].setParents(");
            Iterator<Simular> iParent = var.getOrderedParents().iterator();
            while (iParent.hasNext()) {
                Simular parent = iParent.next();
                output.append("_fls[");
                output.append(Integer.toString(parent.getIndex()));
                output.append("]");
                if (!iParent.hasNext()) continue;
                output.append(",");
            }
            output.append(");\n");
            if ((i + 1) % 100 != 0) continue;
            output.append("}\n");
        }
        if (nbrVars % 100 != 0) {
            output.append("}\n");
        }
        output.append("protected void defineParentsOfStates() {\n");
        for (i = 1; i < idx; ++i) {
            output.append("  defineParentsOfStates_");
            output.append(Integer.toString(i));
            output.append("();\n");
        }
        output.append("}\n");
    }

    private void printParentsOfTransitions(Writer output) throws IOException {
        int i;
        int SPLIT_NBR = 100;
        int nbrTrs = this._transs.size();
        int idx = 1;
        output.append("\n");
        for (i = 0; i < nbrTrs; ++i) {
            if (i % 100 == 0) {
                output.append("private void defineParentsOfTransitions_");
                output.append(Integer.toString(idx++));
                output.append("() {\n");
            }
            SimTrans tr = (SimTrans)this._transs.get(i);
            output.append("  _trs[");
            output.append(Integer.toString(i));
            output.append("].setParents(");
            Iterator<Simular> iParent = tr.getOrderedParents().iterator();
            while (iParent.hasNext()) {
                Simular parent = iParent.next();
                output.append("_fls[");
                output.append(Integer.toString(parent.getIndex()));
                output.append("]");
                if (!iParent.hasNext()) continue;
                output.append(",");
            }
            output.append(");\n");
            if ((i + 1) % 100 != 0) continue;
            output.append("}\n");
        }
        if (nbrTrs % 100 != 0) {
            output.append("}\n");
        }
        output.append("protected void defineParentsOfTransitions() {\n");
        for (i = 1; i < idx; ++i) {
            output.append("  defineParentsOfTransitions_");
            output.append(Integer.toString(i));
            output.append("();\n");
        }
        output.append("}\n");
    }
}

