/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul.jf;

import com.dassault.cecilia.lib.mbsa.StepperConflictDeterministeException;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.StepperInstantaneousLoopException;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFSim;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFTrans;
import com.dassault.cecilia.lib.util.collection.LinkedStack;
import com.dassault.cecilia.lib.util.collection.Stack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class JFSheduler
implements Externalizable {
    private JFSim _simul;
    private ArrayList<JFTrans> _shTranss;
    private TreeSet<JFTrans> _shedulList = new TreeSet<JFTrans>(new Comparator<JFTrans>(){

        @Override
        public int compare(JFTrans tr1, JFTrans tr2) {
            if (tr1.getFiringTime() < tr2.getFiringTime()) {
                return -1;
            }
            if (tr1.getFiringTime() > tr2.getFiringTime()) {
                return 1;
            }
            int diff = tr1.getPriority() - tr2.getPriority();
            if (diff != 0) {
                return -diff;
            }
            diff = tr1.getIdx() - tr2.getIdx();
            return diff;
        }
    });
    private double _currentTime = 0.0;
    private int _currentLoop = 0;
    private int _loopInstantaneous = 1000;
    private boolean _autoInstantaneous = true;
    private boolean _throwConflictException = false;
    private Stack _stackStep = new LinkedStack();
    private int[] _shedulExtern;

    public JFSheduler() {
        this._shTranss = new ArrayList();
    }

    JFSheduler(JFSim simul) {
        this();
        this._simul = simul;
        int nbrTrans = this._simul.getNbrTransition();
        this._shTranss.ensureCapacity((nbrTrans + 20) / 10);
        for (int i = 0; i < nbrTrans; ++i) {
            JFTrans tr = this._simul.getTransition(i);
            if (tr.isStochastic()) continue;
            this._shTranss.add(tr);
        }
        this._shedulExtern = new int[this._shTranss.size() + 1];
    }

    double getCurrentTime() {
        return this._currentTime;
    }

    int getCurrentLoop() {
        return this._currentLoop;
    }

    int[] getSheduler() {
        int idx = 0;
        this._shedulExtern[idx++] = this._shedulList.size();
        for (JFTrans tr : this._shedulList) {
            this._shedulExtern[idx++] = tr.getIdx() + 1;
        }
        return this._shedulExtern;
    }

    boolean isInstantaneousFire() {
        return this._autoInstantaneous;
    }

    boolean setSimulOptions(List<String> args) {
        for (String option : args) {
            String key = JFSim.getKeyOfSimulOption(option);
            if (key.equals("instantaneous.auto")) {
                this._autoInstantaneous = JFSim.getValueOfSimulOption(option).equals("true");
                continue;
            }
            if (key.equals("instantaneous.loop")) {
                this._loopInstantaneous = Integer.parseInt(JFSim.getValueOfSimulOption(option));
                continue;
            }
            if (!key.equals("conflict.sheduler")) continue;
            this._throwConflictException = JFSim.getValueOfSimulOption(option).equals("true");
        }
        return true;
    }

    void init() {
        this._stackStep.clear();
        this._shedulList.clear();
        for (int i = 0; i < this._shTranss.size(); ++i) {
            JFTrans tr = this._shTranss.get(i);
            tr.setFiringTime(Double.POSITIVE_INFINITY);
        }
        this._currentTime = 0.0;
        this._currentLoop = 0;
    }

    boolean canFire(JFTrans tr) throws StepperException {
        Iterator<JFTrans> itr;
        if (tr.getFiringTime() == this._currentTime && this._currentLoop >= this._loopInstantaneous) {
            if (this._simul.withMonitoring(2)) {
                this._simul.monitor("Exception : Maximum Instantaneous Loop\n");
            }
            StringBuffer sb = new StringBuffer(this._loopInstantaneous * 30);
            sb.append(MessageFormat.format(MsgTrans.getString("EXC_INSTANTANEOUS_LOOP_MAX"), this._loopInstantaneous));
            sb.append("\n\n");
            sb.append("Num\tTr\tEvent\n");
            Iterator i = this._stackStep.iterator();
            while (i.hasNext()) {
                JShedulStep step = (JShedulStep)i.next();
                sb.append(step._loop);
                sb.append("\t");
                sb.append(step._trans.getIdx());
                sb.append("\t");
                sb.append(step._trans.getName());
                sb.append("\n");
                if (step._loop != 0) continue;
                break;
            }
            throw new StepperInstantaneousLoopException(sb.toString());
        }
        if (this._throwConflictException && !tr.isStochastic() && (itr = this._shedulList.iterator()).hasNext()) {
            JFTrans prev = itr.next();
            while (itr.hasNext()) {
                JFTrans next = itr.next();
                if (prev.getFiringTime() == next.getFiringTime() && prev.getPriority() == next.getPriority()) {
                    throw new StepperConflictDeterministeException(MsgTrans.msgFormat("EXC_DETERMINIST_CONFLICT", this.getCurrentTime(), this.getCurrentLoop(), prev.getName(), prev.getIdx(), next.getName(), next.getIdx()));
                }
                prev = next;
            }
        }
        return true;
    }

    JFTrans firing(JFSim sim, JFTrans tr, boolean fire) throws StepperException {
        JShedulStep step = new JShedulStep(this._currentTime, this._currentLoop, fire, tr);
        this._stackStep.push(step);
        if (tr != null) {
            this._currentLoop = tr.getFiringTime() == this._currentTime ? ++this._currentLoop : 0;
            if (!this._shedulList.isEmpty() && tr.getFiringTime() == this._shedulList.first().getFiringTime()) {
                this._currentTime = tr.getFiringTime();
            }
            if (tr.getFiringTime() < Double.POSITIVE_INFINITY) {
                this._shedulList.remove(tr);
                tr.setFiringTime(Double.POSITIVE_INFINITY);
            }
        }
        return this.update(sim);
    }

    boolean includeInFirst(JFTrans tr) {
        if (this._shedulList.isEmpty()) {
            return true;
        }
        JFTrans first = this._shedulList.first();
        if (tr.getFiringTime() > first.getFiringTime()) {
            return false;
        }
        return tr.getPriority() >= first.getPriority();
    }

    JFTrans update(JFSim sim) throws StepperException {
        JFTrans first;
        this.updateSheduler(sim);
        if (this._autoInstantaneous && !this._shedulList.isEmpty() && (first = this._shedulList.first()).getFiringTime() == this._currentTime) {
            if (this._simul.withMonitoring(6)) {
                this._simul.monitor("Instantaneous >> ");
            }
            return first;
        }
        return null;
    }

    private void updateSheduler(JFSim sim) throws StepperException {
        for (int i = 0; i < this._shTranss.size(); ++i) {
            JFTrans tr = this._shTranss.get(i);
            if (tr.getFiringTime() == Double.POSITIVE_INFINITY) {
                if (!tr.isValid()) continue;
                tr.setFiringTime(this._currentTime + tr.computeDelay(this._currentTime));
                this._shedulList.add(tr);
                continue;
            }
            if (tr.isValid()) continue;
            this._shedulList.remove(tr);
            tr.setFiringTime(Double.POSITIVE_INFINITY);
        }
    }

    boolean back(JFSim sim) throws StepperException {
        JShedulStep step = (JShedulStep)this._stackStep.pop();
        this._currentTime = step._time;
        this._currentLoop = step._loop;
        this.updateSheduler(sim);
        if (this._simul.withMonitoring(6)) {
            this._simul.monitor("goBackward(" + (step._trans != null ? step._trans.getName() : "<modif State>") + ")\n");
        }
        if (step._trans == null || step._trans.isStochastic()) {
            return false;
        }
        this._shedulList.remove(step._trans);
        step._trans.setFiringTime(step._firingTr);
        this._shedulList.add(step._trans);
        if (this._autoInstantaneous && !step._fire) {
            if (this._simul.withMonitoring(6)) {
                this._simul.monitor("Instantaneous >> ");
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._simul);
        int size = this._shTranss.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeObject(this._shTranss.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._simul = (JFSim)in.readObject();
        int size = in.readInt();
        this._shTranss.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            this._shTranss.add((JFTrans)in.readObject());
        }
    }

    public void dispose() {
        this._stackStep = null;
        this._simul = null;
        this._shTranss = null;
        this._shedulList = null;
    }

    class JShedulStep {
        double _time;
        int _loop;
        boolean _fire;
        JFTrans _trans;
        double _firingTr;

        JShedulStep(double time, int loop, boolean fire, JFTrans tr) {
            this._time = time;
            this._loop = loop;
            this._fire = fire;
            this._trans = tr;
            if (tr != null) {
                this._firingTr = tr.getFiringTime();
            }
        }
    }
}

