/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul.jf;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFFlow;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFSheduler;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFState;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFTrans;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JFSim
implements Stepper {
    Locale _language;
    ArrayList<String> _enumValToStr = new ArrayList();
    Map<String, Integer> _enumStrToVal = new TreeMap<String, Integer>();
    ArrayList<Domain> _domains = new ArrayList();
    int _nbrState;
    int _cptStates = 0;
    double[] _statesInit;
    public JFState[] _sts;
    int _nbrFlow;
    int _nbrFlowStepper;
    int _cptFlows = 0;
    int _cptFlowsStepper = 0;
    Flow[] _stepperFlows;
    Map<Integer, Double> _flowsInit;
    Map<Integer, Double> _flowsReset;
    public JFFlow[] _fls;
    int _nbrTransitions;
    int _cptTransitions = 0;
    protected JFTrans[] _trs;
    JFSheduler _sheduler;
    int _maxChange;
    PrintStream _monitoring;
    int _levelMonitor;
    boolean _autoDeterminist = false;
    boolean _loopModel = false;
    int _nbrValueB;
    int _nbrValueI;
    int _nbrValueF;
    public byte[] _vB;
    public int[] _vI;
    public double[] _vF;
    StepValues[] _valuesStack;
    int _valuesStackIdx = -1;
    private static int ADD_SIZE_STACK = 10;
    private static int INIT_SIZE_STACK = 10;

    protected Integer addEnumStr(String str) {
        Integer val = this._enumStrToVal.get(str);
        if (val == null) {
            val = this._enumValToStr.size();
            this._enumValToStr.add(str);
            this._enumStrToVal.put(str, val);
        }
        return val;
    }

    protected abstract void defineEnums();

    protected abstract void defineDomains();

    protected final void addDomain(Domain domain) {
        this._domains.add(domain);
    }

    protected Domain getDomain(int indexDomain) {
        switch (indexDomain) {
            case 0: {
                return Domain.Bool();
            }
            case 1: {
                return Domain.Int();
            }
            case 2: {
                return Domain.Float();
            }
        }
        assert (indexDomain >= 10);
        return this._domains.get(indexDomain - 10);
    }

    protected void addState(JFState state) {
        this._sts[this._cptStates++] = state;
    }

    protected abstract void defineStates();

    public void addFlow(JFFlow flow) {
        int idx = this._cptFlows++;
        this._fls[idx] = flow;
        flow._indexVar = idx;
    }

    protected abstract void defineFlows();

    private void addFlowStepper(JFState refFlow, String name) {
        this._stepperFlows[this._cptFlowsStepper++] = new Flow(refFlow, name);
    }

    public void addTransition(JFTrans tr) {
        this._trs[this._cptTransitions++] = tr;
    }

    protected abstract void defineTransitions();

    private void initValues() {
        if (this._valuesStack == null) {
            int size = INIT_SIZE_STACK;
            StepValues[] newStack = new StepValues[size];
            for (int idx = 0; idx < size; ++idx) {
                newStack[idx] = new StepValues();
            }
            this._valuesStack = newStack;
        }
        this._valuesStackIdx = 0;
        this._vB = this._valuesStack[0]._stpB;
        this._vI = this._valuesStack[0]._stpI;
        this._vF = this._valuesStack[0]._stpF;
    }

    private void pushValues() {
        if (this._valuesStackIdx + 1 >= this._valuesStack.length) {
            int idx;
            int size = this._valuesStack.length + ADD_SIZE_STACK;
            StepValues[] newStack = new StepValues[size];
            for (idx = 0; idx < this._valuesStack.length; ++idx) {
                newStack[idx] = this._valuesStack[idx];
            }
            while (idx < size) {
                newStack[idx] = new StepValues();
                ++idx;
            }
            this._valuesStack = newStack;
        }
        StepValues tmp = this._valuesStack[++this._valuesStackIdx];
        if (this._nbrValueB > 0) {
            System.arraycopy(this._vB, 0, tmp._stpB, 0, this._nbrValueB);
        }
        if (this._nbrValueI > 0) {
            System.arraycopy(this._vI, 0, tmp._stpI, 0, this._nbrValueI);
        }
        if (this._nbrValueF > 0) {
            System.arraycopy(this._vF, 0, tmp._stpF, 0, this._nbrValueF);
        }
    }

    private void popValues() {
        StepValues tmp = this._valuesStack[this._valuesStackIdx];
        this._valuesStack[this._valuesStackIdx] = this._valuesStack[0];
        this._valuesStack[0] = tmp;
        this._vB = tmp._stpB;
        this._vI = tmp._stpI;
        this._vF = tmp._stpF;
        --this._valuesStackIdx;
    }

    public JFSim(int nbrState, int nbrVarFlow, int nbrFlow, int nbrTrans, int nbrValueB, int nbrValueI, int nbrValueF) throws IOException {
        this._nbrState = nbrState;
        this._nbrFlow = nbrVarFlow;
        this._nbrFlowStepper = nbrFlow;
        this._nbrTransitions = nbrTrans;
        this._nbrValueB = nbrValueB;
        this._nbrValueI = nbrValueI;
        this._nbrValueF = nbrValueF;
        this.createBasicStructures();
        this.callDefineFunctions();
        this.readBinaryInformations();
        this._sheduler = new JFSheduler(this);
    }

    private void createBasicStructures() {
        this._monitoring = null;
        this._levelMonitor = 0;
        this._maxChange = Integer.getInteger("cecilia.mbsa.translator.simul.fixpoint.loop", 100);
        String defMonitor = System.getProperty("cecilia.mbsa.stepper.DefaultMonitoring");
        if (defMonitor == null || defMonitor.length() == 0) {
            defMonitor = "1 stderr";
        }
        this.defineMonitoring(defMonitor);
        this._cptStates = 0;
        this._sts = new JFState[this._nbrState];
        this._statesInit = new double[this._nbrState];
        this._cptFlows = 0;
        this._fls = new JFFlow[this._nbrFlow];
        this._flowsInit = new HashMap<Integer, Double>();
        this._flowsReset = new HashMap<Integer, Double>();
        this._cptFlowsStepper = 0;
        this._stepperFlows = new Flow[this._nbrFlowStepper];
        this._cptTransitions = 0;
        this._trs = new JFTrans[this._nbrTransitions];
        this.initValues();
    }

    private void callDefineFunctions() {
        this.defineEnums();
        this.defineDomains();
        this.defineStates();
        this.defineFlows();
        this.defineTransitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBinaryInformations() throws IOException {
        try (FilterInputStream input = null;){
            JFState var;
            int i;
            String streamName = this.getClass().getSimpleName() + ".data";
            InputStream stream = this.getClass().getResourceAsStream(streamName);
            input = new DataInputStream(stream);
            int version = ((DataInputStream)input).readInt();
            if (version != 0) {
                throw new IOException("Bad data version");
            }
            int nbr = ((DataInputStream)input).readInt();
            for (i = 0; i < nbr; ++i) {
                double reset;
                var = this._fls[i];
                var._indexVar = i;
                var._name = ((DataInputStream)input).readUTF();
                var._indexDomain = ((DataInputStream)input).readInt();
                var._indexValue = ((DataInputStream)input).readInt();
                double init = ((DataInputStream)input).readDouble();
                if (!Double.isNaN(init)) {
                    this._flowsInit.put(i, init);
                }
                if (!Double.isNaN(reset = ((DataInputStream)input).readDouble())) {
                    this._flowsReset.put(i, reset);
                }
                int nbrParents = ((DataInputStream)input).readInt();
                var._parentsVar = new JFFlow[nbrParents];
                for (int j = 0; j < nbrParents; ++j) {
                    var._parentsVar[j] = this._fls[((DataInputStream)input).readInt()];
                }
            }
            nbr = ((DataInputStream)input).readInt();
            for (i = 0; i < nbr; ++i) {
                var = this._sts[i];
                var._name = ((DataInputStream)input).readUTF();
                var._indexDomain = ((DataInputStream)input).readInt();
                var._indexValue = ((DataInputStream)input).readInt();
                this._statesInit[i] = ((DataInputStream)input).readDouble();
                int nbrParents = ((DataInputStream)input).readInt();
                var._parentsVar = new JFFlow[nbrParents];
                for (int j = 0; j < nbrParents; ++j) {
                    var._parentsVar[j] = this._fls[((DataInputStream)input).readInt()];
                }
            }
            nbr = ((DataInputStream)input).readInt();
            for (i = 0; i < nbr; ++i) {
                JFTrans tr = this._trs[i];
                tr._idx = i;
                tr._name = ((DataInputStream)input).readUTF();
                tr._description = ((DataInputStream)input).readUTF();
                boolean bStochastic = ((DataInputStream)input).readBoolean();
                if (!bStochastic) {
                    tr._delay = ((DataInputStream)input).readDouble();
                    tr._priority = ((DataInputStream)input).readInt();
                }
                int nbrParents = ((DataInputStream)input).readInt();
                tr._parentsVar = new JFFlow[nbrParents];
                for (int j = 0; j < nbrParents; ++j) {
                    tr._parentsVar[j] = this._fls[((DataInputStream)input).readInt()];
                }
            }
            nbr = ((DataInputStream)input).readInt();
            for (i = 0; i < nbr; ++i) {
                String name = null;
                JFState refFlow = null;
                if (!((DataInputStream)input).readBoolean()) {
                    name = ((DataInputStream)input).readUTF();
                }
                refFlow = ((DataInputStream)input).readBoolean() ? this._sts[((DataInputStream)input).readInt()] : this._fls[((DataInputStream)input).readInt()];
                this.addFlowStepper(refFlow, name);
            }
        }
    }

    @Override
    public boolean withSimul() {
        return true;
    }

    @Override
    public boolean withDomain() {
        return true;
    }

    void setMonitoring(PrintStream monitor, int level) {
        if (this._monitoring != null && this._monitoring != System.out && this._monitoring != System.err) {
            this._monitoring.close();
        }
        this._monitoring = monitor;
        this._levelMonitor = level;
    }

    boolean withMonitoring(int level) {
        return level <= this._levelMonitor && this._monitoring != null;
    }

    void monitor(String text) {
        if (this._monitoring != null) {
            this._monitoring.print(text);
        }
    }

    @Override
    public int getNbrTransition() {
        return this._trs.length;
    }

    final JFTrans getTransition(int i) {
        return this._trs[i];
    }

    @Override
    public String getNameOfTransition(int i) {
        return this.getTransition(i - 1).getName();
    }

    @Override
    public String getDescOfTransition(int i) {
        return this.getTransition(i - 1).getDescription();
    }

    @Override
    public int getNbrState() {
        return this._sts.length;
    }

    @Override
    public String getNameOfState(int i) {
        return this._sts[i - 1].getName();
    }

    @Override
    public double getValueOfState(int i) {
        return this._sts[i - 1].valueF(this);
    }

    @Override
    public String getValueStringOfState(int i) {
        Domain dom = this.getDomain(this._sts[i - 1].getIndexDomain());
        return dom.toString(this._sts[i - 1].valueF(this));
    }

    @Override
    public int getNbrFlow() {
        return this._stepperFlows.length;
    }

    @Override
    public String getNameOfFlow(int i) {
        return this._stepperFlows[i - 1].getName();
    }

    @Override
    public double getValueOfFlow(int i) {
        return this._stepperFlows[i - 1]._simular.valueF(this);
    }

    @Override
    public String getValueStringOfFlow(int i) {
        Domain dom = this.getDomain(this._stepperFlows[i - 1]._simular.getIndexDomain());
        return dom.toString(this._stepperFlows[i - 1]._simular.valueF(this));
    }

    @Override
    public int getDomainOfFlow(int i) {
        return this._stepperFlows[i - 1]._simular.getIndexDomain();
    }

    @Override
    public int getDomainOfState(int i) {
        return this._sts[i - 1].getIndexDomain();
    }

    @Override
    public List<String> getValuesOfDomain(int i) {
        return this.getDomain(i).getStringValues();
    }

    @Override
    public List<Double> getDoubleValuesOfDomain(int i) {
        return this.getDomain(i).getDoubleValues();
    }

    @Override
    public double getCurrentTime() {
        return this._sheduler.getCurrentTime();
    }

    @Override
    public int getCurrentCycle() {
        return this._sheduler.getCurrentLoop();
    }

    @Override
    public int[] getSheduler() {
        return this._sheduler.getSheduler();
    }

    static String getKeyOfSimulOption(String option) {
        int pos = option.indexOf("=");
        if (pos == -1) {
            return "";
        }
        return option.substring(0, pos);
    }

    static String getValueOfSimulOption(String option) {
        int pos = option.indexOf("=");
        if (pos == -1) {
            return "";
        }
        String value = option.substring(pos + 1);
        if (value.length() > 0 && value.charAt(0) == '\"' && (pos = value.lastIndexOf(34)) > 0) {
            return value.substring(1, pos);
        }
        return value;
    }

    @Override
    public boolean setSimulOptions(List<String> args) {
        if (!this._sheduler.setSimulOptions(args)) {
            return false;
        }
        for (String option : args) {
            String optVal;
            String key = JFSim.getKeyOfSimulOption(option);
            if (key.equals("monitoring")) {
                optVal = JFSim.getValueOfSimulOption(option);
                this.defineMonitoring(optVal);
                continue;
            }
            if (key.equals("fixpoint.loop")) {
                optVal = JFSim.getValueOfSimulOption(option);
                int maxChange = Integer.parseInt(optVal);
                if (maxChange < 0) continue;
                this._maxChange = maxChange;
                continue;
            }
            if (!key.equals("determinist.auto")) continue;
            this._autoDeterminist = JFSim.getValueOfSimulOption(option).equals("true");
        }
        return true;
    }

    void defineMonitoring(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        int level = 6;
        Pattern pattern = Pattern.compile("^([0-9]+)");
        Matcher match = pattern.matcher(value);
        if (match.find()) {
            level = Integer.parseInt(match.group(1));
            value = value.substring(match.end(1)).trim();
        }
        if (value.equals("stdout")) {
            this.setMonitoring(System.out, level);
        } else if (value.equals("stderr")) {
            this.setMonitoring(System.err, level);
        } else if (value.equals("null")) {
            this.setMonitoring(null, level);
        } else {
            try {
                FileOutputStream fout = new FileOutputStream(value);
                PrintStream pout = new PrintStream(fout, true);
                this.setMonitoring(pout, level);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void propageFixPointWithNaN() throws StepperException {
        for (int limit = 0; limit < this._maxChange; ++limit) {
            if (this.withMonitoring(10)) {
                this.monitor("  Propage values --- (step=" + limit + ")\n");
            }
            boolean change = false;
            int nbrNaN = 0;
            int indexMin = 0;
            int indexMax = this._fls.length - 1;
            block6: for (int index = indexMin; index <= indexMax; ++index) {
                JFFlow var = this._fls[index];
                JFFlow.NaNValue valueNaN = var.evaluateWithNaN();
                switch (valueNaN) {
                    case NaN: {
                        ++nbrNaN;
                        if (!this.withMonitoring(12)) continue block6;
                        this.monitor("      Stop NaN : " + var.getName() + "\n");
                        continue block6;
                    }
                    case NoChange: {
                        if (!this.withMonitoring(14)) continue block6;
                        this.monitor("      Don't change : " + var.getName() + " = " + var.printValue(this) + "\n");
                        continue block6;
                    }
                    case Change: {
                        change = true;
                        if (!this.withMonitoring(10)) continue block6;
                        this.monitor("    Change : " + var.getName() + " = " + var.printValue(this) + "\n");
                    }
                }
            }
            if (change) continue;
            if (nbrNaN > 0) {
                if (this.withMonitoring(1)) {
                    this.monitor("  Propage with NaN (nbr=" + nbrNaN + ")\n");
                }
                StringBuffer sb = new StringBuffer(512);
                sb.append("Unresolving loop because ").append(nbrNaN).append(" variables have no value :\n");
                int maxNaNVariables = Integer.getInteger("cecilia.mbsa.translator.simul.fixpoint.TraceNaNValues", 100);
                int cpt = 0;
                for (int index = indexMin; index <= indexMax && cpt < maxNaNVariables; ++index) {
                    JFFlow var = this._fls[index];
                    if (var.evaluateWithNaN() != JFFlow.NaNValue.NaN) continue;
                    sb.append("\t").append(var.getName()).append("\n");
                    ++cpt;
                }
                if (this.withMonitoring(10)) {
                    this.monitor(sb.toString());
                }
                throw new StepperException(sb.toString());
            }
            if (this.withMonitoring(4)) {
                if (limit > 1) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                } else if (this.withMonitoring(8) && !this.withMonitoring(10)) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                }
            }
            return;
        }
        throw new StepperException("Unresolving loop (number loop " + this._maxChange + ")");
    }

    private void propageFixPointWithoutList(int firstIndex, int lastIndex) throws StepperException {
        for (int limit = 0; limit < this._maxChange; ++limit) {
            int index = firstIndex;
            firstIndex = Integer.MAX_VALUE;
            if (this.withMonitoring(10)) {
                this.monitor("  Propage values --- (step=" + limit + ")\n");
            }
            while (index <= lastIndex) {
                JFFlow var = this._fls[index];
                if (var.getFlag() == 'C') {
                    var.setFlag('\u0000');
                    if (var.evaluate()) {
                        int i = var._parentsVar.length;
                        while (--i >= 0) {
                            int idxParent = var._parentsVar[i].getIndexVar();
                            if (idxParent > lastIndex) {
                                lastIndex = idxParent;
                            }
                            if (idxParent < var.getIndexVar() && idxParent < firstIndex) {
                                firstIndex = idxParent;
                            }
                            var._parentsVar[i].setFlag('C');
                        }
                        if (this.withMonitoring(10)) {
                            this.monitor("    Change : " + var.getName() + " = " + var.printValue(this) + "\n");
                        }
                    }
                }
                ++index;
            }
            if (firstIndex != Integer.MAX_VALUE) continue;
            if (this.withMonitoring(4)) {
                if (limit > 1) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                } else if (this.withMonitoring(8) && !this.withMonitoring(10)) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                }
            }
            return;
        }
        throw new StepperException("Unresolving loop (number loop " + this._maxChange + ")");
    }

    private final void setVariable_sValue(JFState var, double value) {
        switch (var.getRange()) {
            case BYTE: {
                this._vB[var.getIndexValue()] = (byte)value;
                break;
            }
            case INT: {
                this._vI[var.getIndexValue()] = (int)value;
                break;
            }
            case FLOAT: {
                this._vF[var.getIndexValue()] = value;
            }
        }
    }

    @Override
    public boolean goInitialState() throws StepperException {
        int i;
        MsgTrans.LOG.finer("[JFStepper.goInitialState] Start " + Integer.toHexString(super.hashCode()));
        if (this.withMonitoring(6)) {
            this.monitor("goInitialState()\n");
        }
        this.initValues();
        for (i = this._sts.length - 1; i >= 0; --i) {
            this.setVariable_sValue(this._sts[i], this._statesInit[i]);
            this._sts[i].setFlag('I');
        }
        for (i = this._fls.length - 1; i >= 0; --i) {
            Double initValue = this._flowsInit.get(i);
            if (initValue != null) {
                this.setVariable_sValue(this._fls[i], initValue);
            }
            this._fls[i].setFlag('C');
        }
        for (i = this._trs.length - 1; i >= 0; --i) {
            this._trs[i].setFiringTime(Double.POSITIVE_INFINITY);
        }
        this.propageFixPointWithoutList(0, this._nbrFlow - 1);
        this._sheduler.init();
        JFTrans tr = this._sheduler.update(this);
        boolean first = true;
        while (tr != null) {
            tr = this.goForward(tr, first);
            first = false;
        }
        if (this.withMonitoring(8)) {
            this.monitor(">> End initiale state\n");
        }
        MsgTrans.LOG.finer("[JFStepper.goInitialState] End " + Integer.toHexString(super.hashCode()));
        return true;
    }

    @Override
    public double isValidTransition(int i) throws StepperException {
        JFTrans tr = this.getTransition(i - 1);
        if (tr.isValid()) {
            if (this._autoDeterminist && !tr.isStochastic() && !this._sheduler.includeInFirst(tr)) {
                return -1.0;
            }
            return tr.getFiringTime();
        }
        return -1.0;
    }

    @Override
    public boolean setValueOfState(int i, String strValue) throws StepperException {
        JFState var = this._sts[i - 1];
        Domain dom = this.getDomain(var.getIndexDomain());
        double value = dom.parse(strValue);
        if (Double.isNaN(value)) {
            return false;
        }
        if (var.valueF(this) == value) {
            return true;
        }
        if (this.withMonitoring(6)) {
            this.monitor("setValueOfState(" + var.getName() + ", strValue [" + value + "])\n");
        }
        return this.setValueOfState(var, value);
    }

    @Override
    public boolean setValueOfState(int i, double value) throws StepperException {
        JFState var = this._sts[i - 1];
        Domain dom = this.getDomain(var.getIndexDomain());
        if (!dom.verifyValueOf(value)) {
            throw new StepperViolatedAssertionException(MsgTrans.msgFormat("EXC_STEP_VALUE_NO_CORRECT", var.getName(), value + "/[" + dom.toString(value) + "]", dom.toString()));
        }
        if (var.valueF(this) == value) {
            return true;
        }
        if (this.withMonitoring(6)) {
            this.monitor("setValueOfState(" + var.getName() + ", strValue [" + value + "])\n");
        }
        return this.setValueOfState(var, value);
    }

    private boolean setValueOfState(JFState simVar, double value) throws StepperException {
        this.pushValues();
        this.setVariable_sValue(simVar, value);
        int i = simVar._parentsVar.length;
        if (i > 0) {
            int firstIndex = simVar._parentsVar[0].getIndexVar();
            int lastIndex = simVar._parentsVar[i - 1].getIndexVar();
            while (i > 0) {
                simVar._parentsVar[--i].setFlag('C');
            }
            this.propageFixPointWithoutList(firstIndex, lastIndex);
        }
        JFTrans tr = this._sheduler.firing(this, null, true);
        boolean first = true;
        while (tr != null) {
            tr = this.goForward(tr, first);
            first = false;
        }
        return true;
    }

    @Override
    public boolean setInitOfState(int i, String strValue) {
        JFState var = this._sts[i - 1];
        Domain dom = this.getDomain(var.getIndexDomain());
        double value = dom.parse(strValue);
        if (Double.isNaN(value)) {
            return false;
        }
        this._statesInit[i - 1] = value;
        return true;
    }

    @Override
    public boolean setInitOfState(int i, double value) {
        JFState var = this._sts[i - 1];
        Domain dom = this.getDomain(var.getIndexDomain());
        if (!dom.verifyValueOf(value)) {
            return false;
        }
        this._statesInit[i - 1] = value;
        return true;
    }

    @Override
    public boolean goForward(int i) throws StepperException {
        JFTrans tr = this.getTransition(i - 1);
        if (!tr.isValid()) {
            if (this.withMonitoring(1)) {
                this.monitor("Exception : ");
                this.monitor(MsgTrans.msgFormat("EXC_STEP_TRANSITION_NOT_VALID", tr.getName()));
                this.monitor("\n");
            }
            throw new StepperViolatedAssertionException(MsgTrans.msgFormat("EXC_STEP_TRANSITION_NOT_VALID", tr.getName()));
        }
        boolean first = true;
        while (tr != null) {
            tr = this.goForward(tr, first);
            first = false;
        }
        return true;
    }

    JFTrans goForward(JFTrans tr, boolean fire) throws StepperException {
        this._sheduler.canFire(tr);
        if (this.withMonitoring(6)) {
            this.monitor("goForward(" + tr.getName() + ")\n");
        }
        this.pushValues();
        tr.affect();
        int i = tr._parentsVar.length;
        if (i > 0) {
            int firstIndex = tr._parentsVar[0].getIndexVar();
            int lastIndex = tr._parentsVar[i - 1].getIndexVar();
            while (i > 0) {
                tr._parentsVar[--i].setFlag('C');
            }
            this.propageFixPointWithoutList(firstIndex, lastIndex);
        }
        return this._sheduler.firing(this, tr, fire);
    }

    @Override
    public boolean goBackward(int nbrTrans) throws StepperException {
        try {
            while (nbrTrans-- > 0 && this._valuesStackIdx > 0) {
                boolean next = true;
                while (next && this._valuesStackIdx > 0) {
                    this.popValues();
                    next = this._sheduler.back(this);
                }
            }
            return this._valuesStackIdx > 0;
        }
        catch (StepperException exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static byte Div(byte a, byte b) throws StepperException {
        if (b == 0) {
            throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
        }
        return (byte)(a / b);
    }

    public static int Div(int a, int b) throws StepperException {
        if (b == 0) {
            throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
        }
        return a / b;
    }

    public static double Div(double a, double b) throws StepperException {
        if (b == 0.0) {
            throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
        }
        return a / b;
    }

    public static byte Mod(byte a, byte b) throws StepperException {
        if (b == 0) {
            throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
        }
        return (byte)(a % b);
    }

    public static int Mod(int a, int b) throws StepperException {
        if (b == 0) {
            throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
        }
        return a % b;
    }

    public static byte Min(byte a, byte b) {
        return a < b ? a : b;
    }

    public static int Min(int a, int b) {
        return a < b ? a : b;
    }

    public static double Min(double a, double b) {
        return a < b ? a : b;
    }

    public static byte Max(byte a, byte b) {
        return a > b ? a : b;
    }

    public static int Max(int a, int b) {
        return a > b ? a : b;
    }

    public static double Max(double a, double b) {
        return a > b ? a : b;
    }

    public static byte XCase(byte defaultValue, boolean[] conditions, double[] values, String exprCode) throws StepperException {
        byte currentValue = defaultValue;
        boolean bCurrentValue = false;
        for (int i = 0; i < conditions.length; ++i) {
            if (!conditions[i]) continue;
            if (bCurrentValue) {
                if ((double)currentValue == values[i]) continue;
                throw new StepperException(MsgTrans.msgFormat("EXC_EXPR_CASE_EXCLUSIF", exprCode));
            }
            currentValue = (byte)values[i];
            bCurrentValue = true;
        }
        return currentValue;
    }

    public static int XCase(int defaultValue, boolean[] conditions, double[] values, String exprCode) throws StepperException {
        int currentValue = defaultValue;
        boolean bCurrentValue = false;
        for (int i = 0; i < conditions.length; ++i) {
            if (!conditions[i]) continue;
            if (bCurrentValue) {
                if ((double)currentValue == values[i]) continue;
                throw new StepperException(MsgTrans.msgFormat("EXC_EXPR_CASE_EXCLUSIF", exprCode));
            }
            currentValue = (int)values[i];
            bCurrentValue = true;
        }
        return currentValue;
    }

    public static double XCase(double defaultValue, boolean[] conditions, double[] values, String exprCode) throws StepperException {
        double currentValue = defaultValue;
        boolean bCurrentValue = false;
        for (int i = 0; i < conditions.length; ++i) {
            if (!conditions[i]) continue;
            if (bCurrentValue) {
                if (currentValue == values[i]) continue;
                throw new StepperException(MsgTrans.msgFormat("EXC_EXPR_CASE_EXCLUSIF", exprCode));
            }
            currentValue = values[i];
            bCurrentValue = true;
        }
        return currentValue;
    }

    static void _VerifyDomain(JFState var, JFSim sim, double value) throws StepperException {
        Domain domain = sim.getDomain(var.getIndexDomain());
        if (!domain.verifyValueOf(value)) {
            throw new StepperViolatedAssertionException(MsgJStep.msgFormat("EXC_STEP_VALUE_NO_CORRECT", var.getName(), domain.toString(value), domain.toString()));
        }
    }

    public byte VerifyDomain(JFState var, byte value) throws StepperException {
        JFSim._VerifyDomain(var, this, value);
        return value;
    }

    public int VerifyDomain(JFState var, int value) throws StepperException {
        JFSim._VerifyDomain(var, this, value);
        return value;
    }

    public double VerifyDomain(JFState var, double value) throws StepperException {
        JFSim._VerifyDomain(var, this, value);
        return value;
    }

    public void ThrowTransAffectException(JFTrans tr, JFState var, double value_1, double value_2) throws StepperException {
        Domain domain = this.getDomain(var.getIndexDomain());
        throw new StepperException("Affect 2 differents values (" + domain.toString(value_1) + ", " + domain.toString(value_2) + ") for variable '" + var.getName() + "' during firing transition '" + tr.getName() + "'.");
    }

    protected void finalize() throws Throwable {
        if (this._fls != null) {
            this.dispose();
        }
        MsgTrans.LOG.finest("Finalize " + JFSim.class.getSimpleName() + " " + Integer.toHexString(super.hashCode()));
    }

    @Override
    public void dispose() {
        int i;
        MsgTrans.LOG.finest("Dispose " + JFSim.class.getSimpleName() + " " + Integer.toHexString(super.hashCode()));
        if (this._fls != null) {
            for (i = this._fls.length - 1; i >= 0; --i) {
                this._fls[i].dispose();
            }
            this._fls = null;
        }
        this._flowsInit.clear();
        this._flowsReset.clear();
        if (this._sts != null) {
            for (i = this._sts.length - 1; i >= 0; --i) {
                this._sts[i].dispose();
            }
            this._sts = null;
        }
        this._statesInit = null;
        if (this._stepperFlows != null) {
            for (i = this._stepperFlows.length - 1; i >= 0; --i) {
                this._stepperFlows[i].dispose();
            }
            this._stepperFlows = null;
        }
        if (this._trs != null) {
            for (i = this._trs.length - 1; i >= 0; --i) {
                this._trs[i].dispose();
            }
            this._trs = null;
        }
        if (this._sheduler != null) {
            this._sheduler.dispose();
            this._sheduler = null;
        }
        this._enumValToStr.clear();
        this._enumStrToVal.clear();
        this._domains.clear();
    }

    static abstract class Domain {
        static Domain _bool = new DomainBool();
        static Domain _int = new DomainInt();
        static Domain _float = new DomainFloat();

        Domain() {
        }

        public abstract String toString(double var1);

        public abstract List<Double> getDoubleValues();

        public abstract List<String> getStringValues();

        public abstract double parse(String var1);

        public abstract boolean verifyValueOf(double var1);

        static Domain Bool() {
            return _bool;
        }

        static Domain Int() {
            return _int;
        }

        static Domain Float() {
            return _float;
        }

        static class DomainBool
        extends Domain {
            List<Double> _doubleValues = new ArrayList<Double>(3);
            List<String> _stringValues = new ArrayList<String>(3);

            DomainBool() {
                this._doubleValues.add(0.0);
                this._doubleValues.add(1.0);
                this._stringValues.add("false");
                this._stringValues.add("true");
            }

            @Override
            public String toString(double value) {
                return value == 0.0 ? "false" : "true";
            }

            public String toString() {
                return "bool";
            }

            @Override
            public boolean verifyValueOf(double value) {
                return value == 0.0 || value == 1.0;
            }

            @Override
            public double parse(String strValue) {
                if (strValue.equals("false")) {
                    return 0.0;
                }
                if (strValue.equals("true")) {
                    return 1.0;
                }
                return Double.NaN;
            }

            @Override
            public List<Double> getDoubleValues() {
                return this._doubleValues;
            }

            @Override
            public List<String> getStringValues() {
                return this._stringValues;
            }
        }

        static class DomainInt
        extends Domain {
            DomainInt() {
            }

            @Override
            public String toString(double value) {
                return Long.toString((long)value);
            }

            public String toString() {
                return "int";
            }

            @Override
            public boolean verifyValueOf(double value) {
                return (double)((int)value) == value;
            }

            @Override
            public double parse(String strValue) {
                try {
                    return Long.parseLong(strValue);
                }
                catch (NumberFormatException exc) {
                    return Double.NaN;
                }
            }

            @Override
            public List<String> getStringValues() {
                return null;
            }

            @Override
            public List<Double> getDoubleValues() {
                return null;
            }
        }

        static class DomainFloat
        extends Domain {
            DomainFloat() {
            }

            @Override
            public String toString(double value) {
                return Double.toString(value);
            }

            public String toString() {
                return "float";
            }

            @Override
            public boolean verifyValueOf(double value) {
                return true;
            }

            @Override
            public double parse(String strValue) {
                try {
                    return Double.parseDouble(strValue);
                }
                catch (NumberFormatException exc) {
                    return Double.NaN;
                }
            }

            @Override
            public List<String> getStringValues() {
                return null;
            }

            @Override
            public List<Double> getDoubleValues() {
                return null;
            }
        }
    }

    protected static class Flow {
        String _name;
        JFState _simular;

        public Flow(JFState simular, String name) {
            this._name = name;
            this._simular = simular;
        }

        public Flow(JFFlow simular) {
            this._simular = simular;
            this._name = null;
        }

        String getName() {
            if (this._name == null) {
                return this._simular.getName();
            }
            return this._name;
        }

        public void dispose() {
            this._name = null;
            this._simular = null;
        }
    }

    class StepValues {
        byte[] _stpB;
        int[] _stpI;
        double[] _stpF;

        StepValues() {
            if (JFSim.this._nbrValueB > 0) {
                this._stpB = new byte[JFSim.this._nbrValueB];
            }
            if (JFSim.this._nbrValueI > 0) {
                this._stpI = new int[JFSim.this._nbrValueI];
            }
            if (JFSim.this._nbrValueF > 0) {
                this._stpF = new double[JFSim.this._nbrValueF];
            }
        }
    }

    public class DomainRange
    extends Domain {
        int _min;
        int _max;
        List<String> _stringValues = null;
        List<Double> _doubleValues = null;

        public DomainRange(int min, int max) {
            this._min = min;
            this._max = max;
        }

        @Override
        public String toString(double valueDouble) {
            if (Double.isNaN(valueDouble)) {
                return "NaN";
            }
            return Integer.toString((int)valueDouble);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(32);
            sb.append("[").append(this._min).append(",").append(this._max).append("]");
            return sb.toString();
        }

        @Override
        public List<String> getStringValues() {
            if (this._stringValues == null) {
                this._stringValues = new ArrayList<String>(this._max - this._min + 1);
                for (int i = this._min; i <= this._max; ++i) {
                    this._stringValues.add(Integer.toString(i));
                }
            }
            return this._stringValues;
        }

        @Override
        public List<Double> getDoubleValues() {
            if (this._doubleValues == null) {
                this._doubleValues = new ArrayList<Double>(this._max - this._min + 1);
                for (int i = this._min; i <= this._max; ++i) {
                    this._doubleValues.add(Double.valueOf(i));
                }
            }
            return this._doubleValues;
        }

        @Override
        public double parse(String strValue) {
            try {
                long res = Long.parseLong(strValue);
                if (res >= (long)this._min && res <= (long)this._max) {
                    return res;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Double.NaN;
        }

        @Override
        public boolean verifyValueOf(double value) {
            int ival = (int)value;
            return ival >= this._min && ival <= this._max;
        }
    }

    public class DomainEnum
    extends Domain {
        int[] _enums;
        List<String> _stringValues = null;
        List<Double> _doubleValues = null;

        public DomainEnum(int[] enums) {
            this._enums = enums;
        }

        @Override
        public String toString(double valueDouble) {
            if (Double.isNaN(valueDouble)) {
                return "NaN";
            }
            int i = (int)valueDouble;
            return JFSim.this._enumValToStr.get(i);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this._enums.length * 10);
            sb.append("{");
            Iterator<String> iter = this.getStringValues().iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public List<String> getStringValues() {
            if (this._stringValues == null) {
                this._stringValues = new ArrayList<String>(this._enums.length + 1);
                for (int i = 0; i < this._enums.length; ++i) {
                    this._stringValues.add(JFSim.this._enumValToStr.get(this._enums[i]));
                }
            }
            return this._stringValues;
        }

        @Override
        public List<Double> getDoubleValues() {
            if (this._doubleValues == null) {
                this._doubleValues = new ArrayList<Double>(this._enums.length + 1);
                for (int i = 0; i < this._enums.length; ++i) {
                    this._doubleValues.add(Double.valueOf(this._enums[i]));
                }
            }
            return this._doubleValues;
        }

        @Override
        public double parse(String strValue) {
            for (int i = 0; i < this._enums.length; ++i) {
                int val = this._enums[i];
                String str = JFSim.this._enumValToStr.get(val);
                if (!str.equals(strValue)) continue;
                return val;
            }
            return Double.NaN;
        }

        @Override
        public boolean verifyValueOf(double value) {
            int ival = (int)value;
            for (int i = 0; i < this._enums.length; ++i) {
                if (ival != this._enums[i]) continue;
                return true;
            }
            return false;
        }
    }
}

