/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul.jf;

import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFFlow;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFSim;

public abstract class JFState {
    int _indexValue = -1;
    int _indexDomain = -1;
    String _name;
    char _flag = '\u0000';
    JFFlow[] _parentsVar;

    protected abstract Range getRange();

    public abstract double valueF(JFSim var1);

    public final int getIndexValue() {
        return this._indexValue;
    }

    public final int getIndexDomain() {
        return this._indexDomain;
    }

    public final String getName() {
        return this._name;
    }

    public final void setFlag(char flag) {
        this._flag = flag;
    }

    public final char getFlag() {
        return this._flag;
    }

    public final void setParents(JFFlow ... flows) {
        this._parentsVar = flows;
    }

    final JFFlow[] getParents() {
        return this._parentsVar;
    }

    JFState() {
    }

    protected JFState(String name, int idxDomain) {
        this();
        this._name = name;
        this._indexDomain = idxDomain;
    }

    public void dispose() {
        this._parentsVar = null;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JFState)) {
            return false;
        }
        return this.getName().equals(((JFState)obj).getName());
    }

    public String toString() {
        return this.getName();
    }

    public String printValue(JFSim simulator) {
        JFSim.Domain dom = simulator.getDomain(this._indexDomain);
        return dom.toString(this.valueF(simulator));
    }

    public static class Float
    extends JFState {
        @Override
        protected Range getRange() {
            return Range.FLOAT;
        }

        @Override
        public double valueF(JFSim simul) {
            return simul._vF[this._indexValue];
        }
    }

    public static class Int
    extends JFState {
        @Override
        protected Range getRange() {
            return Range.INT;
        }

        @Override
        public double valueF(JFSim simul) {
            return simul._vI[this._indexValue];
        }
    }

    public static class Byte
    extends JFState {
        @Override
        protected Range getRange() {
            return Range.BYTE;
        }

        @Override
        public double valueF(JFSim simul) {
            return simul._vB[this._indexValue];
        }
    }

    public static enum Range {
        BYTE,
        INT,
        FLOAT;

    }
}

