/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia;

import com.dassault.cecilia.DocProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DocPropertyProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Filer filer = this.processingEnv.getFiler();
        Messager messager = this.processingEnv.getMessager();
        Elements elements = this.processingEnv.getElementUtils();
        int n = 0;
        if (!roundEnvironment.processingOver()) {
            TypeElement typeElement = elements.getTypeElement(DocProperty.class.getName());
            Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(typeElement);
            if (!set2.isEmpty()) {
                n = this.GenerateExcelFile(messager, filer, set2);
            } else {
                messager.printMessage(Diagnostic.Kind.NOTE, "DocProperty: Rien a faire");
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "DocProperty: Nombre d'annotation: " + n);
        return true;
    }

    static int GenerateTxtFile(Messager messager, Filer filer, Set<? extends Element> set) {
        int n = 0;
        try {
            messager.printMessage(Diagnostic.Kind.NOTE, "DocProperty: Generation du fichier 'Properties.txt'");
            PrintWriter printWriter = new PrintWriter(filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "Properties.txt", new Element[0]).openOutputStream());
            printWriter.println("Liste des proprietes\n");
            for (Element element : set) {
                Object object;
                printWriter.println("\nElement:" + element.getSimpleName());
                if (element instanceof VariableElement) {
                    object = ((VariableElement)element).getConstantValue();
                    printWriter.println("  Value= " + (object == null ? "<null>" : object.toString()));
                }
                object = element.getAnnotation(DocProperty.class);
                printWriter.println("  Default= " + object.def() + " Dyna=" + object.dynamic());
                printWriter.print("  Description : ");
                printWriter.println(object.comment());
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            messager.printMessage(Diagnostic.Kind.ERROR, iOException.getMessage());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int GenerateExcelFile(Messager messager, Filer filer, Set<? extends Element> set) {
        int n = 0;
        OutputStream outputStream = null;
        Writer writer = null;
        try {
            messager.printMessage(Diagnostic.Kind.NOTE, "DocProperty: Generation du fichier 'Properties.excel.xml'");
            outputStream = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "Properties.excel.xml", new Element[0]).openOutputStream();
            writer = new OutputStreamWriter(outputStream);
            DocPropertyProcessor.ExcelXML_DocHeader(writer);
            n = this.ExcelXML_Elements(writer, set);
            DocPropertyProcessor.ExcelXML_DocFooter(writer);
        }
        catch (IOException iOException) {
            messager.printMessage(Diagnostic.Kind.ERROR, "DocProperty: Exception during generate Doc: " + iOException.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                } else if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                messager.printMessage(Diagnostic.Kind.WARNING, "DocProperty: Exception during close stream: " + iOException.getMessage());
            }
        }
        return n;
    }

    static void ExcelXML_DocHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\"?>\n");
        writer.write("<?mso-application progid=\"Excel.Sheet\"?>\n");
        writer.write("<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\n");
        writer.write("  xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n");
        writer.write("  xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n");
        writer.write("  xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\n");
        writer.write("  xmlns:html=\"http://www.w3.org/TR/REC-html40\">\n");
        writer.write(" <DocumentProperties xmlns=\"urn:schemas-microsoft-com:office:office\"/>\n");
        writer.write(" <OfficeDocumentSettings xmlns=\"urn:schemas-microsoft-com:office:office\"/>\n");
        writer.write(" <ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\"/>\n");
        writer.write(" <Styles>\n");
        writer.write("  <Style ss:ID='Default' ss:Name='Normal'/>\n");
        writer.write("  <Style ss:ID='s62'>\n");
        writer.write("   <Alignment ss:Vertical='Center'/>\n");
        writer.write("   <NumberFormat ss:Format='True/False'/>\n");
        writer.write("  </Style>\n");
        writer.write("  <Style ss:ID='s63'>\n");
        writer.write("   <Alignment ss:Vertical='Center'/>\n");
        writer.write("  </Style>\n");
        writer.write("  <Style ss:ID='s64'>\n");
        writer.write("   <Alignment ss:Vertical='Center' ss:WrapText='1'/>\n");
        writer.write("  </Style>\n");
        writer.write(" </Styles>\n");
    }

    static void ExcelXML_DocFooter(Writer writer) throws IOException {
        writer.write("</Workbook>\n");
    }

    static void ExcelXML_SheetHeader(Writer writer, String string, int n, int n2) throws IOException {
        writer.append(" <Worksheet ss:Name=\"").append(string).append("\">\n");
        writer.append("  <Table ss:ExpandedColumnCount=\"").append(Integer.toString(n)).append("\" ss:ExpandedRowCount=\"").append(Integer.toString(n2)).append("\" x:FullColumns=\"1\"\n");
        writer.append("   x:FullRows=\"1\" ss:DefaultColumnWidth=\"36.6\" ss:DefaultRowHeight=\"14.4\">\n");
    }

    static void ExcelXML_SheetFooter(Writer writer) throws IOException {
        writer.append("  </Table>\n");
        writer.append("  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\n");
        writer.append("    <Zoom>80</Zoom>\n");
        writer.append("  </WorksheetOptions>\n");
        writer.append(" </Worksheet>\n");
    }

    int ExcelXML_Elements(Writer writer, Set<? extends Element> set) throws IOException {
        int n = set.size();
        if (n > 0) {
            DocPropertyProcessor.ExcelXML_SheetHeader(writer, "Trans", 11, n + 1);
            writer.append("   <Column ss:Width='175'/>\n");
            writer.append("   <Column ss:Width='200'/>\n");
            writer.append("   <Column ss:Width='200'/>\n");
            writer.append("   <Column ss:Width='30'/>\n");
            writer.append("   <Column ss:Width='80'/>\n");
            writer.append("   <Column ss:Width='30'/>\n");
            writer.append("   <Column ss:Width='30'/>\n");
            writer.append("   <Column ss:Width='70'/>\n");
            writer.append("   <Column ss:Width='40'/>\n");
            writer.append("   <Column ss:Width='400'/>\n");
            writer.append("   <Column ss:Width='150'/>\n");
            writer.append("   <Row>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Field</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Class</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Code</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Depre</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">DefValue</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Dyn.</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Priv</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Ref.</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Version</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">Comment</Data></Cell>\n");
            writer.append("    <Cell><Data ss:Type=\"String\">OldNames</Data></Cell>\n");
            writer.append("   </Row>\n");
            for (Element element : set) {
                Object object;
                writer.append("   <Row ss:Height='35'>\n");
                writer.append("    <Cell ss:StyleID='s63'><Data ss:Type=\"String\">").append(DocPropertyProcessor.toXML(element.getSimpleName().toString())).append("</Data></Cell>\n");
                Object object2 = new StringBuffer(256);
                for (object = element.getEnclosingElement(); object != null && object.getKind() != ElementKind.PACKAGE; object = object.getEnclosingElement()) {
                    if (((StringBuffer)object2).length() != 0) {
                        ((StringBuffer)object2).insert(0, ".");
                    }
                    if (object instanceof QualifiedNameable) {
                        ((StringBuffer)object2).insert(0, ((QualifiedNameable)object).getQualifiedName());
                        continue;
                    }
                    ((StringBuffer)object2).insert(0, object.getSimpleName());
                }
                writer.append("    <Cell ss:StyleID='s63'><Data ss:Type=\"String\">").append(DocPropertyProcessor.toXML(((StringBuffer)object2).toString())).append("</Data></Cell>\n");
                object2 = null;
                if (element instanceof VariableElement) {
                    object2 = ((VariableElement)element).getConstantValue();
                }
                object = object2 == null ? "<null>" : object2.toString();
                writer.append("    <Cell ss:StyleID='s63'><Data ss:Type=\"String\">").append(DocPropertyProcessor.toXML((String)object)).append("</Data></Cell>\n");
                object2 = element.getAnnotation(Deprecated.class);
                writer.append("    <Cell ss:StyleID='s62'><Data ss:Type=\"Number\">").append(object2 == null ? "0" : "1").append("</Data></Cell>\n");
                object2 = element.getAnnotation(DocProperty.class);
                writer.append("    <Cell ss:StyleID='s63'><Data ss:Type=\"String\">").append(DocPropertyProcessor.toXML(object2.def())).append("</Data></Cell>\n");
                writer.append("    <Cell ss:StyleID='s62'><Data ss:Type=\"Number\">").append(object2.dynamic() ? "1" : "0").append("</Data></Cell>\n");
                writer.append("    <Cell ss:StyleID='s62'><Data ss:Type=\"Number\">").append(object2.intern() ? "1" : "0").append("</Data></Cell>\n");
                writer.append("    <Cell ss:StyleID='s63'><Data ss:Type=\"String\">").append(DocPropertyProcessor.toXML(object2.ref())).append("</Data></Cell>\n");
                writer.append("    <Cell ss:StyleID='s63'><Data ss:Type=\"String\">").append(DocPropertyProcessor.toXML(object2.version())).append("</Data></Cell>\n");
                writer.append("    <Cell ss:StyleID='s64'><Data ss:Type=\"String\">").append(DocPropertyProcessor.toXML(object2.comment())).append("</Data></Cell>\n");
                object = new StringBuilder();
                String[] stringArray = object2.oldNames();
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i > 0) {
                            ((StringBuilder)object).append(", ");
                        }
                        ((StringBuilder)object).append(stringArray[i]);
                    }
                }
                writer.append("    <Cell ss:StyleID='s63'><Data ss:Type=\"String\">").append(DocPropertyProcessor.toXML(((StringBuilder)object).toString())).append("</Data></Cell>\n");
                writer.append("   </Row>\n");
            }
            DocPropertyProcessor.ExcelXML_SheetFooter(writer);
        }
        return n;
    }

    public static String toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        char c = ' ';
        block9: for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\r': {
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("&#10;&#13;");
                    continue block9;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

