/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core;

import Aladdin.Hasp;
import com.dassault.cecilia.core.ConfigException;
import com.dassault.cecilia.core.ConfigProperty;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBLicense;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigManager {
    private static Logger _LOG = Logger.getLogger(ConfigManager.class.getName());
    public static final String PROP_CONFIG_NET = "cecilia.config.std.UseNet";
    public static final String PROP_CONFIG_LIB_PATH = "cecilia.config.std.LibPath";
    private static final Calendar TEMP_DATE = null;
    private static final String TEMP_COMPANY = null;
    private static final String TEMP_KEY = new String("b5pbgla7jpqfh0otj3u01etbcgg74rnf8n2lnied7uaakkg73bh9sd70ah1tqkrn4gfr5sr93if9gp7metb2tin8qscpb05iqn1ia95q01jeusp3lchsdc1hjqbf8si5sbn7l9hhqdd25lbp5g690fa7ekmr1lsfh55nef7k2nlfbr61pp3h1om314et23m6pqdh5u8imrmpnm17bmmutek4piho8ol8oh776780te2lf0at8g5ju9fk56htkrt0m8qhganle3jcrpth5gda0l9gqpm4tr7g8ts5ril7tbfbel0bo60jmna2ttddank3p31itjqmuid3q6e6rlusrp1sok3r8ue9ofdm00nt1ttj8j7kkf89ols79f6ets6d2ia069kmbo11nggnc9pbtksqi101ipfulapa8ar1kar7m70tmkamb061are97l27c616pmg30lmjfnukpd01benuijerplci7quob71m9f963jo76qi2r5tr797mqgm3emcm7c5rpqeq3aeabg0k3ht8md4clal1l0thki2trlui3ac9b193fp54fcktpfgm8etgss4h9km1323g3esjt7nlf71qha8pi7cgfc2dohfdqjqrmf1ushr2oni5te4o5rlauh5r9b6dk2c5pi4tkg0slfbcjeb1cqph3ntnpoeh3ue35qosdo60b56al3i9f7mp3ic80uu90f9ffa6n1i2sknblg29931dm4hitf4b4ghfq2hkfccp9tq8n8d1nacotddj3m2fuebmr2139kdot87jms6hibr4u1a5klq7mdbp1namaid4tqsm0t75ege7e9277e4nic7fda9fomso2h1i2l9bqq2arfbrsh81mccfi7srp90cc8jnilkjlonaq0rlshim0efrmetjs243g6n18eoukij7ir60isedddukceqnsqcen99bh3fnktcog4h763oanrqmq8j83558b8b4db8ihdg2bhkkk25u0it8cig1i83pfl8iqmm7ad9fb1eikaj1c46bidje8pse72spe8neiht1lrdlkbah71o9h6rg4iu8f98ati3n3maup38dj1do45kk9nqik69n9udg4t8ojhili0tl3osoe0q7qurn29hqb6198f2i17okf39rpfsk9mrrmlsd9ferl2gd79rdqjpb4peq2muueui4p3t3dd58ithu0c7s2444i64ntrnnsrhitcida162s724nq82c9sbl12509156m2hhtldgf5hbmasg82lbecgjapg7il05c5lfdq2hbo8phi4d42i136alfcpdc6iu2qolthans63rnt9j2d95iaeogm7rd2sim1thc9b5qfngi84odti6m036b6c5ks0rrrn9un5jr3n5dfbrfds7ml68t4k92fcms960arq9fiqj1hn4ag4rj92cffnit0qcsrfte4au1lfaul6agdrs7cg1a73ophromeqffijfu9n1kqlnjj2icuh3ch9ql5g3ds");
    public static final int SENTINEL_FEATURE_CECILIA = 50;
    public static final int SENTINEL_FEATURE_DISTRIB = 51;
    private static final String scopeLocalKey = new String("<haspscope>\n <license_manager hostname=\"localhost\" />\n</haspscope>\n");
    private static byte[] TEMP_BUFFER = TEMP_KEY.getBytes();
    private static TypeVersion VERSION = TypeVersion.STD;
    private StateVersion _state = StateVersion.NO_INIT;
    private Hasp _utility = null;
    private boolean _bNet = false;
    private static ConfigManager _instance = null;
    private static Map<Integer, ConfigError> __errors;
    private final Map<Integer, Hasp> _pluginUtilities = new LinkedHashMap<Integer, Hasp>();

    public static final TypeVersion getVersion() {
        return VERSION;
    }

    public static final String getVersionLabel() {
        switch (VERSION) {
            case DA: {
                return ResMsgVoc.getString("CONFIG_LABEL_DA");
            }
            case STD: {
                return ResMsgVoc.getString("CONFIG_LABEL_STD");
            }
            case READER: {
                return ResMsgVoc.getString("CONFIG_LABEL_READER");
            }
            case DEMO: {
                return ResMsgVoc.msgFormat("CONFIG_LABEL_DEMO", SimpleDateFormat.getDateInstance().format(new Date(TEMP_DATE.getTimeInMillis())));
            }
            case TIME: {
                return ResMsgVoc.msgFormat("CONFIG_LABEL_TIME", SimpleDateFormat.getDateInstance().format(new Date(TEMP_DATE.getTimeInMillis())), ConfigManager.getTempCompany());
            }
        }
        return "";
    }

    public final StateVersion getState() {
        return this._state;
    }

    public static ConfigManager getInstance() {
        if (_instance == null) {
            TEMP_BUFFER = new BigInteger(TEMP_KEY, 31).toByteArray();
            _instance = new ConfigManager();
        }
        return _instance;
    }

    private synchronized void configure() throws ConfigException {
        if (this._state != StateVersion.NO_INIT) {
            return;
        }
        switch (ConfigManager.getVersion()) {
            case READER: {
                this._state = StateVersion.FULL;
                break;
            }
            case DA: {
                this._state = StateVersion.FULL;
                break;
            }
            case DEMO: {
                this._state = StateVersion.DEMO;
                _LOG.config("Config.Company:" + TEMP_COMPANY);
                break;
            }
            case TIME: {
                this._state = StateVersion.FULL;
                _LOG.config("Config.Company:" + TEMP_COMPANY);
                break;
            }
            case STD: {
                this._bNet = Boolean.getBoolean(PROP_CONFIG_NET);
                _LOG.config("Config.Net:" + this._bNet);
                try {
                    this.loadLibraries();
                    this.login(50);
                    this._state = StateVersion.FULL;
                }
                catch (ConfigException e) {
                    this._state = StateVersion.STOPPED;
                    throw e;
                }
                catch (Throwable e) {
                    _LOG.log(Level.SEVERE, "Config exception", e);
                    this._state = StateVersion.STOPPED;
                    throw new ConfigException(e);
                }
                _LOG.config("Config.ID:" + this.getUtilityID());
                if (this._state != StateVersion.FULL) break;
                String version = this.getUtilityVersion();
                _LOG.config("Config.Version:" + version);
                if (DBLicense.isCompatible(version, "6.3.1")) break;
                this._state = StateVersion.STOPPED;
                throw new ConfigException("License version is not correct: " + version + ". You need a 6.3 version key");
            }
        }
        if (TEMP_DATE != null) {
            if (TEMP_DATE.getTime().before(new Date())) {
                this._state = StateVersion.EXPIRED;
                throw new ConfigException("License is valid until " + SimpleDateFormat.getDateInstance().format(new Date(TEMP_DATE.getTimeInMillis())));
            }
        } else {
            if (ConfigManager.getVersion() == TypeVersion.TIME) {
                this._state = StateVersion.EXPIRED;
                throw new ConfigException("Time limit not defined, software can't start");
            }
            if (ConfigManager.getVersion() == TypeVersion.DEMO) {
                this._state = StateVersion.EXPIRED;
                throw new ConfigException("Demo version should have a time limit, software can't start");
            }
        }
        _LOG.config("Config.State:" + this._state.name().charAt(0));
    }

    private void notUsedMethod() {
        GregorianCalendar cal = new GregorianCalendar(1970, 10, 10);
        cal.getTime();
        StringUtilities.convertHexaStringToByte((String)cal.toString());
    }

    private static void addConfigError(int code, String codeName, String desc) {
        if (__errors == null) {
            __errors = new TreeMap<Integer, ConfigError>();
        }
        __errors.put(code, new ConfigError(code, codeName, desc));
    }

    public static String getMessage(int status) {
        ConfigError error = __errors.get(status);
        if (error == null) {
            return "login to feature failed " + status;
        }
        return error.toString();
    }

    public final String getMessage() {
        return ConfigManager.getMessage(this._utility.getLastError());
    }

    private void loadLibraries() throws IOException {
        String propLibPath = System.getProperty(PROP_CONFIG_LIB_PATH, "./core/lib");
        File libDir = new File(propLibPath).getCanonicalFile();
        boolean jvm64 = "x64".equals(ConfigProperty.getJVMArch());
        String syst = System.getProperty("os.name").toLowerCase();
        if (syst.contains("windows")) {
            if (jvm64) {
                this.loadLibrary("HASPJava_x64", libDir);
                this.loadLibrary("hasp_windows_x64_89115", libDir);
            } else {
                this.loadLibrary("HASPJava", libDir);
                this.loadLibrary("hasp_windows_89115", libDir);
            }
        } else if (syst.contains("linux")) {
            if (jvm64) {
                this.loadLibrary("HASPJava_x86_64", libDir);
                this.loadLibrary("hasp_linux_x86_64_89115", libDir);
            } else {
                this.loadLibrary("HASPJava", libDir);
                this.loadLibrary("hasp_linux_89115", libDir);
            }
        }
    }

    private void loadLibrary(String libName, File defaultLibDir) {
        _LOG.finer("LoadLibrary: Loading " + libName + " ...");
        File lib = new File(defaultLibDir, System.mapLibraryName(libName));
        try {
            if (lib.exists()) {
                System.load(lib.getAbsolutePath());
                _LOG.fine("LoadLibrary(" + lib.getAbsolutePath() + ") -> Ok");
            } else {
                System.loadLibrary(libName);
                _LOG.fine("LoadLibrary(" + libName + ") => Ok");
            }
        }
        catch (Throwable e) {
            _LOG.info("LoadLibrary: " + libName + " [" + lib.getAbsolutePath() + "] not found");
            throw e;
        }
    }

    public final Hasp login(Hasp utility, int ID) throws ConfigException {
        this.configure();
        if (utility != null) {
            throw new ConfigException("Login failed for Config.ID " + ID);
        }
        utility = this._pluginUtilities.computeIfAbsent(ID, k -> new Hasp((long)k.intValue()));
        if (!this._bNet ? !utility.loginScope(scopeLocalKey, new String(TEMP_BUFFER)) : !utility.login(new String(TEMP_BUFFER))) {
            throw new ConfigException(ConfigManager.getMessage(utility.getLastError()));
        }
        this._state = StateVersion.FULL;
        return utility;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void login(int ID) throws ConfigException {
        int i;
        Random rnd = new Random(846585L);
        if (this._utility == null) {
            for (i = 0; i < TEMP_BUFFER.length / 2; ++i) {
                ConfigManager.TEMP_BUFFER[i] = (byte)((long)TEMP_BUFFER[i] ^ rnd.nextLong());
            }
            this._utility = new Hasp((long)ID);
            this._pluginUtilities.put(ID, this._utility);
        }
        for (i = TEMP_BUFFER.length / 2; i < TEMP_BUFFER.length; ++i) {
            ConfigManager.TEMP_BUFFER[i] = (byte)((long)TEMP_BUFFER[i] ^ rnd.nextLong());
        }
        if (!this._bNet) {
            if (!this._utility.loginScope(scopeLocalKey, new String(TEMP_BUFFER))) throw new ConfigException(this.getMessage());
            this._state = StateVersion.FULL;
        } else {
            if (!this._utility.login(new String(TEMP_BUFFER))) throw new ConfigException(this.getMessage());
            this._state = StateVersion.FULL;
        }
        String[] __lostKeys = new String[]{};
        String serialID = this.getUtilityID().trim();
        for (int i2 = 0; i2 < __lostKeys.length; ++i2) {
            String forbiden = __lostKeys[i2];
            if (!forbiden.equals(serialID)) continue;
            this._state = StateVersion.EXPIRED;
            throw new ConfigException("The following license key is considered as lost of canceled:" + serialID);
        }
    }

    public static final Calendar getTempDate() {
        return TEMP_DATE;
    }

    public static final String getTempCompany() {
        if (TEMP_COMPANY == null) {
            return "";
        }
        return TEMP_COMPANY;
    }

    public final void login() throws ConfigException {
        this.configure();
    }

    public final void readOnly(int offset, byte[] buffer) throws ConfigException {
        this.configure();
        if (this._utility == null) {
            throw new ConfigException("Read: no login");
        }
        if (!this._utility.read(65525L, offset, buffer)) {
            throw new ConfigException("Read: " + this.getMessage());
        }
    }

    public final void decrypt(byte[] data) throws ConfigException {
        this.configure();
        if (this._utility == null) {
            throw new ConfigException("Decrypt: no login");
        }
        if (!this._utility.decrypt(data)) {
            this._state = StateVersion.STOPPED;
            throw new ConfigException("Decrypt: " + this.getMessage());
        }
    }

    public final void logout() throws ConfigException {
        if (this._state == StateVersion.NO_INIT) {
            return;
        }
        if (VERSION == TypeVersion.STD) {
            if (this._utility == null) {
                throw new ConfigException("Logout: no login");
            }
            if (!this._utility.logout()) {
                throw new ConfigException("Logout: " + this.getMessage());
            }
        } else {
            _LOG.fine("No need to log out");
        }
    }

    private final String getSessionInfo(String format) throws ConfigException {
        if (this._utility == null) {
            throw new ConfigException("GetInfo : no login");
        }
        return this._utility.getSessionInfo(format);
    }

    private final String getUtilityID() {
        try {
            String sessionInfo = this.getSessionInfo(Hasp.HASP_KEYINFO);
            if (sessionInfo == null) {
                _LOG.info("getUtilityID - No session.");
                return "-1";
            }
            BufferedReader br = new BufferedReader(new StringReader(sessionInfo));
            String line = "";
            while ((line = br.readLine()) != null) {
                if (!line.contains("haspid")) continue;
                return line.replace(" ", "").replace("\t", "").replace("haspid", "").replace("<", "").replace(">", "").replace("/", "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getUtilityVersion() {
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.convertReadOnlyToInteger(32, 2));
            buffer.append(".");
            buffer.append(this.convertReadOnlyToInteger(34, 2));
            return buffer.toString();
        }
        catch (Exception e) {
            _LOG.log(Level.INFO, "Probleme de lecture de la version", e);
            return "5.0";
        }
    }

    private int convertReadOnlyToInteger(int offset, int size) throws Exception {
        byte[] buffer = new byte[size];
        this.readOnly(offset, buffer);
        String text = new String(buffer, "ISO-8859-1");
        return Integer.parseInt(text);
    }

    public boolean isValid() {
        return this._state == StateVersion.FULL || this._state == StateVersion.DEMO;
    }

    static {
        ConfigManager.addConfigError(0, "HASP_STATUS_OK", "Request successfully completed");
        ConfigManager.addConfigError(1, "HASP_MEM_RANGE", "Request exceeds Sentinel protection key memory range");
        ConfigManager.addConfigError(2, "HASP_INV_PROGNUM_OPT", "Legacy HASP HL Run-time API: Unknown/Invalid Feature ID option");
        ConfigManager.addConfigError(3, "HASP_INSUF_MEM", "System out of memory");
        ConfigManager.addConfigError(4, "HASP_TMOF", "Too many open sessions");
        ConfigManager.addConfigError(5, "HASP_ACCESS_DENIED", "Access to Feature denied");
        ConfigManager.addConfigError(6, "HASP_INCOMPAT_FEATURE", "Legacy decryption function cannot work on Feature");
        ConfigManager.addConfigError(7, "HASP_HASP_NOT_FOUND", "Sentinel protection key is no longer available");
        ConfigManager.addConfigError(8, "HASP_TOO_SHORT", "Encrypted/decrypted data length too short to execute function call");
        ConfigManager.addConfigError(9, "HASP_INV_HND", "Handle not found OR Invalid handle");
        ConfigManager.addConfigError(10, "HASP_INV_FILEID", "Specified File ID not recognized by API");
        ConfigManager.addConfigError(11, "HASP_OLD_DRIVER", "Installed driver too old to execute function");
        ConfigManager.addConfigError(12, "HASP_NO_TIME", "Real-time clock (RTC) not available");
        ConfigManager.addConfigError(13, "HASP_SYS_ERR", "Generic error from host system call");
        ConfigManager.addConfigError(14, "HASP_NO_DRIVER", "Required driver not installed");
        ConfigManager.addConfigError(15, "HASP_INV_FORMAT", "Unrecognized file format for update");
        ConfigManager.addConfigError(16, "HASP_REQ_NOT_SUPP", "Unable to execute function in this context");
        ConfigManager.addConfigError(17, "HASP_INV_UPDATE_OBJ", "Binary data passed to function does not contain an update");
        ConfigManager.addConfigError(18, "HASP_KEYID_NOT_FOUND", "Sentinel protection key not found");
        ConfigManager.addConfigError(19, "HASP_INV_UPDATE_DATA", "Required XML tags not found OR Contents in binary data are missing or invalid");
        ConfigManager.addConfigError(20, "HASP_INV_UPDATE_NOTSUPP", "Update request not supported by Sentinel protection key");
        ConfigManager.addConfigError(21, "HASP_INV_UPDATE_CNTR", "Update counter not set correctly");
        ConfigManager.addConfigError(22, "HASP_INV_VCODE", "Invalid Vendor Code passed");
        ConfigManager.addConfigError(23, "HASP_ENC_NOT_SUPP", "Sentinel protection key does not support encryption type");
        ConfigManager.addConfigError(24, "HASP_INV_TIME", "Passed time value outside supported value range");
        ConfigManager.addConfigError(25, "HASP_NO_BATTERY_POWER", "The real-time clock battery has run out of power");
        ConfigManager.addConfigError(26, "HASP_NO_ACK_SPACE", "Acknowledge data requested by the update ack_data parameter NULL");
        ConfigManager.addConfigError(27, "HASP_TS_DETECTED", "Program running on a terminal server");
        ConfigManager.addConfigError(28, "HASP_FEATURE_TYPE_NOT_IMPL", "Requested Feature type not implemented");
        ConfigManager.addConfigError(29, "HASP_UNKNOWN_ALG", "Unknown algorithm used in V2C file");
        ConfigManager.addConfigError(30, "HASP_INV_SIG", "Signature verification operation failed");
        ConfigManager.addConfigError(31, "HASP_FEATURE_NOT_FOUND", "Requested Feature not found");
        ConfigManager.addConfigError(32, "HASP_NO_LOG", "Access log not enabled");
        ConfigManager.addConfigError(33, "HASP_LOCAL_COMM_ERR", "Communication error between API and local Sentinel License Manager");
        ConfigManager.addConfigError(34, "HASP_UNKNOWN_VCODE", "Vendor Code not recognized by API");
        ConfigManager.addConfigError(35, "HASP_INV_SPEC", "Invalid XML specification");
        ConfigManager.addConfigError(36, "HASP_INV_SCOPE", "Invalid XML scope");
        ConfigManager.addConfigError(37, "HASP_TOO_MANY_KEYS", "Too many Sentinel protection keys currently connected");
        ConfigManager.addConfigError(38, "HASP_TOO_MANY_USERS", "Too many users currently connected");
        ConfigManager.addConfigError(39, "HASP_BROKEN_SESSION", "Session was interrupted. This can occur when certain updates are applied to the license while a session is active. For example: A Feature required by the session was deleted. The license was canceled. The network (remote license) support setting for a required Feature was changed. (In this case;; all sessions will be interrupted;; including local sessions.)");
        ConfigManager.addConfigError(40, "HASP_REMOTE_COMM_ERR", "Communication error between local and remote Sentinel License Managers");
        ConfigManager.addConfigError(41, "HASP_FEATURE_EXPIRED", "Feature expired");
        ConfigManager.addConfigError(42, "HASP_OLD_LM", "Sentinel License Manager version too old (minimum supported version is 8)");
        ConfigManager.addConfigError(43, "HASP_DEVICE_ERR", "For a Sentinel SL key;; an input/output error occurred in the secure storage area OR For a Sentinel HL key;; a USB communication error occurred");
        ConfigManager.addConfigError(44, "HASP_UPDATE_BLOCKED", "Update installation not permitted");
        ConfigManager.addConfigError(45, "HASP_TIME_ERR", "System time has been tampered with");
        ConfigManager.addConfigError(46, "HASP_SCHAN_ERR", "Communication error occurred in secure channel");
        ConfigManager.addConfigError(47, "HASP_STORAGE_CORRUPT", "Corrupt data exists in secure storage area of Sentinel protection key");
        ConfigManager.addConfigError(48, "HASP_NO_VLIB", "Unable to find Vendor library");
        ConfigManager.addConfigError(49, "HASP_INV_VLIB", "Unable to load Vendor library");
        ConfigManager.addConfigError(50, "HASP_SCOPE_RESULTS_EMPTY", "Unable to locate any Feature matching scope");
        ConfigManager.addConfigError(51, "HASP_VM_DETECTED", "Protected application is running on a virtual machine;; but one or more Features are not enabled for virtual machines.");
        ConfigManager.addConfigError(52, "HASP_HARDWARE_MODIFIED", "Sentinel SL key incompatible with machine hardware. Sentinel SL key locked to different hardware. OR In the case of a V2C file;; conflict between Sentinel SL key data and machine hardware data. Sentinel SL key locked to different hardware.");
        ConfigManager.addConfigError(53, "HASP_USER_DENIED", "Login denied because of user restrictions (see admin control center configuration)");
        ConfigManager.addConfigError(54, "HASP_UPDATE_TOO_OLD", "Trying to install a V2C file with an update counter that is out of sequence with update counter in the Sentinel protection key. Values of update counter in file are lower than those in Sentinel protection key.");
        ConfigManager.addConfigError(55, "HASP_UPDATE_TOO_NEW", "Trying to install a V2C file with an update counter that is out of sequence with the update counter in the Sentinel protection key. First value in file is more-than-1 greater than value in Sentinel protection key.");
        ConfigManager.addConfigError(56, "HASP_OLD_VLIB", "Vendor library is too old");
        ConfigManager.addConfigError(57, "HASP_UPLOAD_ERROR", "Check in of a file (such as V2C;; H2R) using Admin Control Center failed;; possibly because of illegal format");
        ConfigManager.addConfigError(58, "HASP_INV_RECIPIENT", "Invalid XML RECIPIENT parameter");
        ConfigManager.addConfigError(59, "HASP_INV_DETACH_ACTION", "Invalid XML action parameter");
        ConfigManager.addConfigError(60, "HASP_TOO_MANY_PRODUCTS", "The scope specified in the Transfer function does not specify a unique Product");
        ConfigManager.addConfigError(61, "HASP_INV_PRODUCT", "Invalid Product information");
        ConfigManager.addConfigError(62, "HASP_UNKNOWN_RECIPIENT", "Update can only be applied to recipient machine specified in the Detach function;; not to this machine");
        ConfigManager.addConfigError(63, "HASP_INV_DURATION", "Invalid detached license duration period specified. Duration must be less than or equal to maximum allowed for this license.  OR Duration extension is to a date earlier than the expiration date of the current detached license.");
        ConfigManager.addConfigError(64, "HASP_CLONE_DETECTED", "Cloned Sentinel SL storage detected. Feature unavailable.");
        ConfigManager.addConfigError(65, "HASP_UPDATE_ALREADY_ADDED", "The specified V2C update was already installed in the License Manager service");
        ConfigManager.addConfigError(66, "HASP_HASP_INACTIVE", "Specified Key ID is in Inactive state");
        ConfigManager.addConfigError(67, "HASP_NO_DETACHABLE_FEATURE", "No detachable Feature exists in the specified key from which the detached license is requested");
        ConfigManager.addConfigError(68, "HASP_TOO_MANY_HOSTS", "The specified scope does not specify a unique host");
        ConfigManager.addConfigError(69, "HASP_REHOST_NOT_ALLOWED", "Rehost action is not allowed for the specified HASP ID");
        ConfigManager.addConfigError(70, "HASP_LICENSE_REHOSTED", "Original license has been transferred to another machine. Therefore;; the license cannot be returned to the source machine.");
        ConfigManager.addConfigError(71, "HASP_REHOST_ALREADY_APPLIED", "Old rehost license cannot be applied. A rehost-counter mismatch occurred");
        ConfigManager.addConfigError(72, "HASP_CANNOT_READ_FILE", "A V2C file was not found;; or access was denied");
        ConfigManager.addConfigError(73, "HASP_EXTENSION_NOT_ALLOWED", "The license cannot be extended because the number of detached licenses is greater than the number of concurrent licenses allowed");
        ConfigManager.addConfigError(74, "HASP_DETACH_DISABLED", "On a virtual machine: The user attempted to detach a Product that contains a Feature that is not enabled for virtual machines.");
        ConfigManager.addConfigError(75, "HASP_REHOST_DISABLED", "The user attempted to rehost a protection key from a virtual machine;; but the protection key contains a Feature that is not enabled for virtual machines.");
        ConfigManager.addConfigError(76, "HASP_DETACHED_LICENSE_FOUND", "The user attempted to format an SL-AdminMode key or to migrate an SL-Legacy key to an SL-AdminMode key. However;; a Product is currently detached from the key.");
        ConfigManager.addConfigError(77, "HASP_RECIPIENT_OLD_LM", "For a rehost operation: The fingerprint of the target machine was collected using tools (RUS utility or Licensing API) earlier than Sentinel LDK v.7.0.");
        ConfigManager.addConfigError(78, "HASP_SECURE_STORE_ID_MISMATCH", "A secure storage ID mismatch occurred.");
        ConfigManager.addConfigError(79, "HASP_DUPLICATE_HOSTNAME", "The license fingerprint is bound to a specific hostname; however;; two or more machines with this hostname were found in the network. As a result;; the license cannot be used.");
        ConfigManager.addConfigError(80, "HASP_MISSING_LM", "A protected application tried to log in to a Feature that supports concurrency on a Sentinel HL (Driverless configuration) key. The Sentinel LDK License Manager service is not active on the computer where the key is located.");
        ConfigManager.addConfigError(400, "HASP_NO_API_DYLIB", "Unable to locate dynamic library for API");
        ConfigManager.addConfigError(401, "HASP_INVALID_API_DYLIB", "Dynamic library for API is invalid");
        ConfigManager.addConfigError(500, "HASP_INVALID_OBJECT", "Object was incorrectly initialized");
        ConfigManager.addConfigError(501, "HASP_INV_PARAM", "Scope string is too long (maximum length is 32 KB)");
        ConfigManager.addConfigError(502, "HASP_ALREADY_LOGGED_IN", "Logging in twice to same object");
        ConfigManager.addConfigError(503, "HASP_ALREADY_LOGGED_OUT", "Logging out twice from same object");
        ConfigManager.addConfigError(525, "HASP_OPERATION_FAILED", "Incorrect use of system or platform");
        ConfigManager.addConfigError(698, "HASP_NOT_IMPL", "Requested function was not implemented  OR In the case of the API Dispatcher;; API DLL is too old");
        ConfigManager.addConfigError(699, "HASP_INT_ERR", "Internal error occurred in the API");
        ConfigManager.addConfigError(652, "HASP_DOT_NET_DLL_BROKEN", ".NET DLL found broken");
    }

    public static enum TypeVersion {
        STD,
        READER,
        TIME,
        DA,
        DEMO;

    }

    public static enum StateVersion {
        NO_INIT,
        FULL,
        DEMO,
        EXPIRED,
        STOPPED;

    }

    static class ConfigError {
        int _code;
        String _name;
        String _desc;

        public ConfigError(int code, String name, String desc) {
            this._code = code;
            this._name = name;
            this._desc = desc;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this._desc).append(" [Code=").append(this._code).append("]");
            return buffer.toString();
        }
    }
}

