/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.access;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.access.AccessRightRenderer;
import com.dassault.cecilia.core.cecilia.user.GroupRenderer;
import com.dassault.cecilia.core.cecilia.user.UserRenderer;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.list.ListComboBoxModel;
import com.dassault.cecilia.core.swing.table.TablePanel;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AccessRightEditDlg
extends JDialogCecilia {
    private static final Comparator<? super AccessRightsItem> __cmpAccessItem = new Comparator<AccessRightsItem>(){

        @Override
        public int compare(AccessRightsItem i1, AccessRightsItem i2) {
            if (i1._bGroupOwner) {
                if (i2._bGroupOwner) {
                    return 0;
                }
                return -1;
            }
            if (i1._bGroupOther) {
                if (i2._bGroupOwner) {
                    return 1;
                }
                if (i2._bGroupOther) {
                    return 0;
                }
                return -1;
            }
            if (i2._bGroupOwner) {
                if (i1._bGroupOwner) {
                    return 0;
                }
                return 1;
            }
            if (i2._bGroupOther) {
                if (i1._bGroupOwner) {
                    return -1;
                }
                if (i1._bGroupOther) {
                    return 0;
                }
                return 1;
            }
            return i1.getGroup().getName().compareTo(i2.getGroup().getName());
        }
    };
    ArrayList<AccessRightsItem> _lstAccesses;
    Map<Long, AccessRightsItem> _mapAccesses;
    Window _winOwner;
    JCheckBox _checkOwner;
    JLabel _lblUser;
    JComboBox _ctrlUsers;
    JLabel _lblGroup;
    JComboBox _ctrlGroups;
    ListComboBoxModel<IGroup> _ctrlGroupsModel;
    JCheckBox _checkAccess;
    AccessRightsModel _modelAccessRights;
    AccessRightTablePanel _panelAccessRights;
    JCheckBox _checkSubFolders;
    JCheckBox _checkElements;
    boolean _bDisplayOnlyOwner = false;
    protected boolean _activeChangeUser = true;
    boolean _bReadOnly = false;
    ArrayList<DBGroup> _lstGroups;
    ArrayList<DBUser> _lstUsers;
    Map<Long, DBGroup> _mapGroups;
    Map<Long, DBUser> _mapUsers;
    ArrayList<DBFolder> _selectFolders;
    DBUser _selectUser = null;
    DBGroup _selectGroup = null;
    boolean _withSubFolder = false;
    boolean _withSubElement = false;
    boolean _selectSubElement = false;

    public AccessRightEditDlg setDisplayOnlyOwner(boolean value) {
        this._bDisplayOnlyOwner = value;
        return this;
    }

    private void make() {
        JPanel root = new JPanel(new GridBagLayout());
        int cptLine = 0;
        this._lblUser = new JLabel(ResMsgVoc.getString("VOC_USER"));
        this._ctrlUsers = new JComboBox<Object>(this._lstUsers.toArray());
        this._ctrlUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AccessRightEditDlg.this._activeChangeUser) {
                    AccessRightEditDlg.this.changeUser();
                }
            }
        });
        this._ctrlUsers.setRenderer(new UserRenderer());
        this._lblGroup = new JLabel(ResMsgVoc.getString("VOC_GROUP"));
        this._ctrlGroups = new JComboBox<IGroup>(this._ctrlGroupsModel);
        this._ctrlGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AccessRightEditDlg.this._activeChangeUser) {
                    AccessRightEditDlg.this.changeGroup();
                }
            }
        });
        this._ctrlGroups.setRenderer(new GroupRenderer());
        JPanel ownerPanel = new JPanel(new GridBagLayout());
        ownerPanel.add((Component)this._lblUser, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        ownerPanel.add((Component)this._ctrlUsers, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        ownerPanel.add((Component)this._lblGroup, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        ownerPanel.add((Component)this._ctrlGroups, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._lblUser.setEnabled(false);
        this._ctrlUsers.setEnabled(false);
        this._lblGroup.setEnabled(false);
        this._ctrlGroups.setEnabled(false);
        this._checkOwner = new JCheckBox(ResMsgVoc.getString("VOC_OWNER"));
        this._checkOwner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean select = AccessRightEditDlg.this._checkOwner.isSelected();
                AccessRightEditDlg.this._lblUser.setEnabled(select);
                AccessRightEditDlg.this._ctrlUsers.setEnabled(select);
                AccessRightEditDlg.this._lblGroup.setEnabled(select);
                AccessRightEditDlg.this._ctrlGroups.setEnabled(select);
            }
        });
        ownerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_OWNER")));
        root.add((Component)ownerPanel, new GridBagConstraints(0, cptLine++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._modelAccessRights = new AccessRightsModel();
        this._panelAccessRights = new AccessRightTablePanel(this, this._modelAccessRights);
        this._panelAccessRights.setEnabled(false);
        this._checkAccess = new JCheckBox(ResMsgVoc.getString("VOC_RIGHTS_ACCESS"));
        this._checkAccess.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean select = AccessRightEditDlg.this._checkAccess.isSelected();
                AccessRightEditDlg.this._panelAccessRights.setEnabled(select);
            }
        });
        JPanel accessPanel = new JPanel(new BorderLayout());
        accessPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_RIGHTS_ACCESS")));
        accessPanel.add((Component)this._panelAccessRights, "Center");
        root.add((Component)accessPanel, new GridBagConstraints(0, cptLine++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._checkSubFolders = new JCheckBox(ResMsgCore.getString("LBL_AFFECT_SUBFOLDERS"));
        this._checkElements = new JCheckBox(ResMsgCore.getString("LBL_AFFECT_SUBITEMS"));
        if (!this._bDisplayOnlyOwner) {
            root.add((Component)this._checkSubFolders, new GridBagConstraints(0, cptLine++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)this._checkElements, new GridBagConstraints(0, cptLine++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)root, "Center");
        if (this._bReadOnly) {
            this.add((Component)this.createButPanelClose(false), "South");
        } else {
            this.add((Component)this.createButPanel(), "South");
        }
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this._winOwner));
    }

    protected void changeUser() {
        DBUser curUser = this.getSelectedOwnerUser();
        if (curUser == null) {
            return;
        }
        IGroup curGroup = this.getSelectedOwnerGroup();
        boolean find = false;
        for (IGroup uGroup : curUser.getGroups()) {
            if (!uGroup.equals(curGroup)) continue;
            find = true;
            break;
        }
        if (!find) {
            curGroup = this._mapGroups.get(curUser.getDefaultGroup().getID());
        }
        this._ctrlGroupsModel.clear();
        for (IGroup uGroup : curUser.getGroups()) {
            this._ctrlGroupsModel.add(this._mapGroups.get(uGroup.getID()));
        }
        this._ctrlGroupsModel.update();
        this._ctrlGroupsModel.setSelectedItem(curGroup);
    }

    protected void changeGroup() {
        DBGroup curGroup = this.getSelectedOwnerGroup();
        if (curGroup == null) {
            return;
        }
        this._panelAccessRights.removeAccessForGroup(curGroup);
    }

    public AccessRightEditDlg(Window owner) {
        super(owner, ResMsgCore.getString("TITLE_OWNER_AND_RIGHTS"), true);
        this._winOwner = owner;
    }

    public void setReadOnly(boolean readOnly) {
        this._bReadOnly = readOnly;
    }

    public void setUsersAndGroups(Collection<DBUser> users, Collection<DBGroup> groups) {
        this._lstUsers = new ArrayList<DBUser>(users);
        Collections.sort(this._lstUsers, DBUser.getComparatorLogin());
        this._mapUsers = new HashMap<Long, DBUser>();
        for (DBUser dbUser : users) {
            this._mapUsers.put(dbUser.getID(), dbUser);
        }
        this._lstGroups = new ArrayList<DBGroup>(groups);
        Collections.sort(this._lstGroups, DBGroup.getComparatorName());
        this._mapGroups = new HashMap<Long, DBGroup>();
        for (DBGroup dbGroup : groups) {
            this._mapGroups.put(dbGroup.getID(), dbGroup);
        }
    }

    public void setFolders(Collection<DBFolder> folders) {
        this._selectFolders = new ArrayList<DBFolder>(folders);
        AccessRightsItem groupRight = new AccessRightsItem(true);
        AccessRightsItem otherRight = new AccessRightsItem(false);
        this._lstAccesses = new ArrayList();
        this._mapAccesses = new HashMap<Long, AccessRightsItem>();
        this._lstAccesses.add(groupRight);
        this._lstAccesses.add(otherRight);
        this._ctrlGroupsModel = new ListComboBoxModel<IGroup>(DBGroup.getComparatorName());
        for (int i = 0; i < this._selectFolders.size(); ++i) {
            DBFolder folder = this._selectFolders.get(i);
            List<DBAccess> accesses = folder.getAccesses();
            if (folder.isFolder()) {
                this._withSubFolder = true;
                this._withSubElement = true;
            } else if (folder.isModel()) {
                this._withSubElement = true;
                this._selectSubElement = true;
            }
            if (i == 0) {
                this._selectUser = this._mapUsers.get(folder.getUserOwner().getID());
                this._selectGroup = this._mapGroups.get(folder.getGroupOwner().getID());
                groupRight.setRight(folder.getRightGroup());
                otherRight.setRight(folder.getRightOther());
                this._ctrlGroupsModel.add(this._selectGroup);
                for (DBAccess dbAccess : accesses) {
                    IGroup iGrp = dbAccess.getGroup();
                    if (iGrp.equals(this._selectGroup)) continue;
                    DBGroup grp = this._mapGroups.get(iGrp.getID());
                    AccessRightsItem accessRight = new AccessRightsItem(grp);
                    accessRight.setRight(dbAccess.getRight());
                    this._lstAccesses.add(accessRight);
                    this._mapAccesses.put(iGrp.getID(), accessRight);
                }
                continue;
            }
            DBUser currentUser = this._mapUsers.get(folder.getUserOwner().getID());
            IGroup currentGroup = this._mapGroups.get(folder.getGroupOwner().getID());
            if (!currentUser.equals(this._selectUser)) {
                this._selectUser = null;
            }
            if (!currentGroup.equals(this._selectGroup)) {
                this._selectGroup = null;
                this._ctrlGroupsModel.add(currentGroup);
            }
            if (!folder.getRightGroup().equals((Object)groupRight.getRight())) {
                groupRight.setRight(null);
            }
            if (!folder.getRightOther().equals((Object)otherRight.getRight())) {
                otherRight.setRight(null);
            }
            for (DBAccess dbAccess : accesses) {
                IGroup iGrp = dbAccess.getGroup();
                if (this._selectGroup != null && iGrp.equals(this._selectGroup)) continue;
                AccessRightsItem accessRight = this._mapAccesses.get(iGrp.getID());
                if (accessRight != null) {
                    if (accessRight.getRight() == null || accessRight.getRight().equals((Object)dbAccess.getRight())) continue;
                    accessRight.setRight(null);
                    continue;
                }
                DBGroup grp = this._mapGroups.get(iGrp.getID());
                accessRight = new AccessRightsItem(grp);
                accessRight.setRight(dbAccess.getRight());
                this._lstAccesses.add(accessRight);
                this._mapAccesses.put(iGrp.getID(), accessRight);
            }
        }
        Collections.sort(this._lstAccesses, __cmpAccessItem);
    }

    public void makeAndDisplay() {
        this.make();
        if (this._bReadOnly) {
            this._checkSubFolders.setEnabled(false);
            this._checkElements.setEnabled(false);
        }
        this._checkOwner.setSelected(!this._bReadOnly);
        this._checkAccess.setSelected(!this._bReadOnly);
        this._ctrlGroups.setSelectedItem(this._selectGroup);
        this._ctrlUsers.setSelectedItem(this._selectUser);
        this._checkElements.setEnabled(this._withSubElement && !this._bReadOnly);
        this._checkElements.setSelected(this._withSubElement && !this._bReadOnly);
        this._checkSubFolders.setEnabled(this._withSubFolder && !this._bReadOnly);
        this._checkSubFolders.setSelected(this._withSubFolder && !this._bReadOnly);
        StringBuilder builder = new StringBuilder(128);
        builder.append(ResMsgCore.getString("TITLE_OWNER_AND_RIGHTS"));
        if (this._selectFolders.size() == 1) {
            DBFolder currFolder = this._selectFolders.get(0);
            StringBuffer path = new StringBuffer();
            while (!currFolder.isSystem()) {
                if (path.length() > 0) {
                    path.insert(0, "/");
                }
                path.insert(0, currFolder.getName());
                currFolder = currFolder.getParent();
            }
            if (currFolder.isSystem() && path.length() > 0) {
                path.insert(0, "/");
            }
            builder.append(path.toString());
        } else {
            builder.append(ResMsgCore.msgFormat("TITLE_OWNER_AND_RIGHTS_APPEND_FRM", this._selectFolders.size()));
        }
        this.setTitle(builder.toString());
        this.setVisible(true);
    }

    @Override
    protected boolean verifyParameters() {
        return true;
    }

    public DBUser getSelectedOwnerUser() {
        return (DBUser)this._ctrlUsers.getSelectedItem();
    }

    public DBGroup getSelectedOwnerGroup() {
        return (DBGroup)this._ctrlGroups.getSelectedItem();
    }

    public boolean isApplicableAtSubFolders() {
        if (this._bDisplayOnlyOwner) {
            return false;
        }
        return this._checkSubFolders.isEnabled() && this._checkSubFolders.isSelected();
    }

    public boolean isApplicableAtSubElements() {
        if (this._bDisplayOnlyOwner) {
            return false;
        }
        return this._checkElements.isEnabled() && this._checkElements.isSelected();
    }

    public DBAccess.Right getRightForOwnerGroup() {
        return this._lstAccesses.get(0).getRight();
    }

    public DBAccess.Right getRightForOtherUser() {
        return this._lstAccesses.get(1).getRight();
    }

    public List<DBAccess> getAccessesRight() {
        ArrayList<DBAccess> accesses = new ArrayList<DBAccess>();
        for (int i = 2; i < this._lstAccesses.size(); ++i) {
            AccessRightsItem accessItem = this._lstAccesses.get(i);
            if (accessItem.getRight() == DBAccess.Right.NONE) continue;
            DBAccess access = new DBAccess().setGroup(accessItem.getGroup()).setRight(accessItem.getRight());
            accesses.add(access);
        }
        return accesses;
    }

    class AccessRightsModel
    extends AbstractTableModel {
        AccessRightsModel() {
        }

        @Override
        public int getRowCount() {
            return AccessRightEditDlg.this._lstAccesses.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? ResMsgVoc.getString("VOC_GROUP") : ResMsgVoc.getString("VOC_RIGHT");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? AccessRightsItem.class : DBAccess.Right.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AccessRightsItem row = AccessRightEditDlg.this._lstAccesses.get(rowIndex);
            return columnIndex == 0 ? row : row.getRight();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AccessRightsItem row = AccessRightEditDlg.this._lstAccesses.get(rowIndex);
            if (columnIndex == 1) {
                row.setRight((DBAccess.Right)((Object)aValue));
            }
        }

        public int add(AccessRightsItem accessItem) {
            int idx = -1;
            for (int i = 2; i < AccessRightEditDlg.this._lstAccesses.size() && idx == -1; ++i) {
                AccessRightsItem srcItem = AccessRightEditDlg.this._lstAccesses.get(i);
                int cpt = __cmpAccessItem.compare(srcItem, accessItem);
                if (cpt <= 0) continue;
                idx = i;
            }
            if (idx == -1) {
                idx = AccessRightEditDlg.this._lstAccesses.size();
            }
            AccessRightEditDlg.this._lstAccesses.add(idx, accessItem);
            AccessRightEditDlg.this._mapAccesses.put(accessItem.getGroup().getID(), accessItem);
            this.fireTableRowsInserted(idx, idx);
            return idx;
        }

        public void del(int[] indexes) {
            int firstRow = -1;
            int lastRow = -1;
            int nbrRow = 0;
            for (int i = indexes.length - 1; i >= 0; --i) {
                int idx = indexes[i];
                if (idx < 2) continue;
                firstRow = nbrRow == 0 ? (lastRow = idx) : idx;
                AccessRightsItem accessItem = AccessRightEditDlg.this._lstAccesses.remove(idx);
                AccessRightEditDlg.this._mapAccesses.remove(accessItem.getGroup().getID());
                ++nbrRow;
            }
            if (nbrRow - 1 == lastRow - firstRow) {
                this.fireTableRowsDeleted(firstRow, lastRow);
            } else {
                this.fireTableDataChanged();
            }
        }
    }

    class AccessRightTablePanel
    extends TablePanel {
        JComboBox _editorRight;
        AccessRightRenderer _rendererRight;
        JComboBox _ctrlAddGroup;
        ListComboBoxModel<IGroup> _ctrlAddGroupModel;

        public AccessRightTablePanel(Window window, TableModel model) {
            super(window, model, true);
            this._ctrlAddGroupModel = new ListComboBoxModel<IGroup>(DBGroup.getComparatorName());
            this._ctrlAddGroup = new JComboBox<IGroup>(this._ctrlAddGroupModel);
            this._ctrlAddGroup.setEditable(false);
            this._ctrlAddGroup.setRenderer(new GroupRenderer());
            this._ctrlTable.setDefaultRenderer(AccessRightsItem.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setEnabled(table.isEnabled());
                    this.setToolTipText(((AccessRightsItem)value).getToolTip());
                    return this;
                }
            });
            this._ctrlTable.getTableHeader().setDefaultRenderer(new TableHeaderCellRendererEnabled(this._ctrlTable.getTableHeader().getDefaultRenderer()));
            this._rendererRight = new AccessRightRenderer();
            this._editorRight = new JComboBox<DBAccess.Right>(DBAccess.Right.values());
            this._editorRight.setRenderer(this._rendererRight);
            this._ctrlTable.setDefaultRenderer(DBAccess.Right.class, this._rendererRight);
            this._ctrlTable.setDefaultEditor(DBAccess.Right.class, new DefaultCellEditor(this._editorRight));
            this._ctrlTable.setRowHeight(this._ctrlTable.getRowHeight() * 3 / 2);
            TableColumn column = null;
            block4: for (int i = 0; i < AccessRightEditDlg.this._modelAccessRights.getColumnCount(); ++i) {
                column = this._ctrlTable.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        column.setPreferredWidth(200);
                        continue block4;
                    }
                    case 1: {
                        column.setPreferredWidth(100);
                    }
                }
            }
            this._ctrlTable.setSelectionMode(2);
        }

        @Override
        protected void refreshCtrl() {
            boolean isEnabled = this.isEnabled();
            int nbrGrp = AccessRightEditDlg.this._lstGroups.size();
            int nbrAcc = AccessRightEditDlg.this._lstAccesses.size() - 1;
            if (AccessRightEditDlg.this.getSelectedOwnerGroup() == null) {
                --nbrAcc;
            }
            this._ctrlAdd.setEnabled(isEnabled && nbrAcc < nbrGrp);
            if (isEnabled) {
                if (this._ctrlTable.getSelectedRowCount() == 0) {
                    isEnabled = false;
                } else {
                    int[] idxs = this._ctrlTable.getSelectedRows();
                    boolean find = false;
                    for (int i = idxs.length - 1; !find && i >= 0; --i) {
                        if (idxs[i] < 2) continue;
                        find = true;
                    }
                    isEnabled = find;
                }
            }
            this._ctrlDel.setEnabled(isEnabled);
        }

        @Override
        protected void addData(int idx) {
            DBGroup owner = AccessRightEditDlg.this.getSelectedOwnerGroup();
            int nbr = 0;
            this._ctrlAddGroup.setSelectedItem(null);
            this._ctrlAddGroupModel.clear();
            for (IGroup iGroup : AccessRightEditDlg.this._lstGroups) {
                if (owner != null && iGroup.equals(owner) || AccessRightEditDlg.this._mapAccesses.get(iGroup.getID()) != null) continue;
                this._ctrlAddGroupModel.add(iGroup);
                ++nbr;
            }
            if (nbr == 0) {
                return;
            }
            this._ctrlAddGroupModel.update();
            this._ctrlAddGroup.setSelectedItem(this._ctrlAddGroupModel.getElementAt(0));
            int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), this._ctrlAddGroup, ResMsgCore.getString("MSG_GRP_SELECT_NEW"), 2);
            if (result != 0) {
                return;
            }
            DBGroup dBGroup = (DBGroup)this._ctrlAddGroup.getSelectedItem();
            if (dBGroup == null) {
                return;
            }
            AccessRightsItem accessItem = new AccessRightsItem(dBGroup);
            accessItem.setRight(DBAccess.Right.NONE);
            int idxAdd = AccessRightEditDlg.this._modelAccessRights.add(accessItem);
            this._ctrlTable.getSelectionModel().setSelectionInterval(idxAdd, idxAdd);
        }

        @Override
        protected void delData(int[] indexes) {
            if (indexes.length == 0) {
                return;
            }
            AccessRightEditDlg.this._modelAccessRights.del(indexes);
            this._ctrlTable.clearSelection();
        }

        public void removeAccessForGroup(DBGroup group) {
            if (group == null) {
                return;
            }
            int idx = -1;
            for (int i = 2; i < AccessRightEditDlg.this._lstAccesses.size() && idx == -1; ++i) {
                AccessRightsItem accessItem = AccessRightEditDlg.this._lstAccesses.get(i);
                if (!group.equals(accessItem.getGroup())) continue;
                idx = i;
            }
            if (idx != -1) {
                AccessRightEditDlg.this._modelAccessRights.del(new int[]{idx});
                this.refreshCtrl();
            }
        }
    }

    private static class AccessRightsItem {
        DBGroup _group;
        boolean _bGroupOwner;
        boolean _bGroupOther;
        DBAccess.Right _right;

        AccessRightsItem(DBGroup grp) {
            this._group = grp;
            this._bGroupOther = false;
            this._bGroupOwner = false;
        }

        AccessRightsItem(boolean owner) {
            this._group = null;
            this._bGroupOwner = owner;
            this._bGroupOther = !owner;
        }

        AccessRightsItem setRight(DBAccess.Right value) {
            this._right = value;
            return this;
        }

        DBAccess.Right getRight() {
            return this._right;
        }

        public String toString() {
            if (this._bGroupOwner) {
                return ResMsgCore.getString("LBL_GROUP_OWNER");
            }
            if (this._bGroupOther) {
                return ResMsgCore.getString("LBL_GROUP_OTHER");
            }
            return this._group.getName();
        }

        public DBGroup getGroup() {
            return this._group;
        }

        public String getToolTip() {
            if (this._group == null) {
                return null;
            }
            return this._group.getDescription();
        }
    }

    class TableHeaderCellRendererEnabled
    implements TableCellRenderer {
        private TableCellRenderer _delegate;

        public TableHeaderCellRendererEnabled(TableCellRenderer defaultRenderer) {
            this._delegate = defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this._delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                comp.setEnabled(table.isEnabled());
            }
            return comp;
        }
    }
}

