/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dependencies;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.Recup;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import java.util.HashSet;
import java.util.Set;

public class GenerateAccesses
extends Generate<DBFolder> {
    DBUser _dbUser;
    DBFolder _firstFolderInError = null;
    Set<DBFolder> _parentsFolder = new HashSet<DBFolder>();

    public GenerateAccesses(DAOFactory daoFactory, DBUser dbUser) {
        super(daoFactory);
        this._dbUser = dbUser;
    }

    protected boolean validParents(DBFolder current, DBFolder origin) {
        DBFolder parent = current.getParent();
        if (parent.isSystem()) {
            return true;
        }
        if (this._parentsFolder.contains(parent)) {
            return true;
        }
        if (!this.validParents(parent, origin)) {
            return false;
        }
        if (this._daoFactory.createFolderDAO().getAccessRight(parent, this._dbUser) == DBAccess.Right.NONE) {
            this.getErrors().add(new GeneralError<DBFolder>(parent, ResMsgCore.msgFormat("MSG_ERR_ACCESS_FOLDER_PARENT_FRM", origin.getRefPath())));
            this._firstFolderInError = parent;
            return false;
        }
        this._parentsFolder.add(parent);
        return true;
    }

    @Override
    protected Recup<DBFolder> makeRecup(DBFolder.Family family) {
        return new Recup<DBFolder>(family, (Generate)this){

            @Override
            protected boolean isValid(DBFolder dbFolder, DBFolder t) {
                if (GenerateAccesses.this._firstFolderInError != null) {
                    return false;
                }
                if (!GenerateAccesses.this.validParents(dbFolder, dbFolder)) {
                    return false;
                }
                if (GenerateAccesses.this._daoFactory.createFolderDAO().getAccessRight(dbFolder, GenerateAccesses.this._dbUser) == DBAccess.Right.NONE) {
                    GenerateAccesses.this.getErrors().add(new GeneralError<DBFolder>(dbFolder, ResMsgCore.getString("MSG_ERR_ACCESS_FOLDER")));
                    GenerateAccesses.this._firstFolderInError = dbFolder;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    protected DBFolder findOrCreate(DBFolder dbDest, DBFolder.Family family) {
        return dbDest;
    }

    public boolean withError() {
        return this._firstFolderInError != null || !this.getErrors().isEmpty();
    }

    public DBFolder getFirstFolderInError() {
        return this._firstFolderInError;
    }
}

