/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.error;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.error.Msg;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class DlgDisplayMsg
extends JDialogCecilia {
    List<Msg> _msgs;
    ErrorsTable _ctrlTable;

    public DlgDisplayMsg(Window owner) {
        this(owner, true);
    }

    public DlgDisplayMsg(Window owner, boolean closeDlg) {
        super(owner);
        this.create(closeDlg);
    }

    private void create(boolean closeDlg) {
        this.init();
        ErrorsTableModel model = new ErrorsTableModel();
        this._ctrlTable = new ErrorsTable(model);
        this._ctrlTable.setSelectionMode(0);
        this._ctrlTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this._ctrlTable.setDefaultRenderer(Msg.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Msg) {
                    Msg msg = (Msg)value;
                    this.setText(msg.getMsg());
                    this.setIcon(msg.getType().getIcon());
                }
                return this;
            }
        });
        JScrollPane scroll = new JScrollPane(this._ctrlTable);
        scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroll, "Center");
        if (closeDlg) {
            this.getContentPane().add((Component)this.createButPanelClose(), "South");
        } else {
            this.getContentPane().add((Component)this.createButPanel(), "South");
        }
        this.pack();
    }

    public DlgDisplayMsg setMsgs(Collection<Msg> msgs) {
        this._msgs = new ArrayList<Msg>(msgs);
        return this;
    }

    @Override
    protected boolean verifyParameters() {
        return true;
    }

    class ErrorsTableModel
    implements TableModel {
        ArrayList<TableModelListener> _listener = new ArrayList();

        ErrorsTableModel() {
        }

        @Override
        public int getRowCount() {
            if (DlgDisplayMsg.this._msgs == null) {
                return 0;
            }
            return DlgDisplayMsg.this._msgs.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return ResMsgVoc.getString("VOC_MESSAGE");
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Msg.class;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return DlgDisplayMsg.this._msgs.get(rowIndex);
            }
            return null;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            if (!this._listener.contains(l)) {
                this._listener.add(l);
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listener.remove(l);
        }
    }

    public class ErrorsTable
    extends CeciliaTable
    implements JTableTransfertHandler.HelperConvert {
        public ErrorsTable(TableModel model) {
            super(model);
            this.setTransferHandler(new JTableTransfertHandler());
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            if (obj instanceof Msg) {
                return ((Msg)obj).getMsg();
            }
            return String.valueOf(obj);
        }
    }
}

