/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.error;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.table.HtmlTableCellRenderer;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class GeneralDlgDisplayError<T>
extends JDialogCecilia {
    List<GeneralError<T>> _errors;
    JTable _ctrlTable;

    protected abstract Class<?> getSourceClass();

    protected abstract String getSourceName();

    protected abstract TableCellRenderer getSourceRenderer();

    public GeneralDlgDisplayError(Window owner) {
        super(owner);
        this.create();
    }

    private void create() {
        this.init();
        ErrorsTableModel model = new ErrorsTableModel();
        this._ctrlTable = new JTable(model);
        this._ctrlTable.setSelectionMode(2);
        TableColumn column = null;
        block5: for (int i = 0; i < model.getColumnCount(); ++i) {
            column = this._ctrlTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(60);
                    continue block5;
                }
                case 1: {
                    column.setPreferredWidth(200);
                    continue block5;
                }
                case 2: {
                    column.setPreferredWidth(500);
                }
            }
        }
        this._ctrlTable.setPreferredScrollableViewportSize(new Dimension(700, 250));
        this._ctrlTable.setAutoResizeMode(3);
        this._ctrlTable.setDefaultRenderer(MsgType.class, new MsgType.MsgTypeTableCellRenderer());
        this._ctrlTable.setDefaultRenderer(this.getSourceClass(), this.getSourceRenderer());
        this._ctrlTable.getColumnModel().getColumn(2).setCellRenderer(new HtmlTableCellRenderer(30));
        this._ctrlTable.setTransferHandler(new JTableTransfertHandler());
        this._ctrlTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int modelIdx;
                Object source;
                int tableIdx;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (tableIdx = GeneralDlgDisplayError.this._ctrlTable.getSelectedRow()) >= 0 && (source = GeneralDlgDisplayError.this._errors.get(modelIdx = GeneralDlgDisplayError.this._ctrlTable.convertRowIndexToModel(tableIdx)).getSource()) != null) {
                    GeneralDlgDisplayError.this.doSelect(source);
                }
            }
        });
        this._ctrlTable.setRowHeight(20);
        JScrollPane scroll = new JScrollPane(this._ctrlTable);
        scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        Component north = this.createNorthComponent();
        if (north != null) {
            this.getContentPane().add(north, "North");
        }
        this.getContentPane().add((Component)scroll, "Center");
        Component south = this.createSouthComponent();
        if (south != null) {
            this.getContentPane().add(south, "South");
        }
        this.pack();
    }

    protected Component createNorthComponent() {
        return null;
    }

    protected Component createSouthComponent() {
        return this.createButPanelClose(false);
    }

    public GeneralDlgDisplayError setErrors(List<GeneralError<T>> errors) {
        this._errors = errors;
        return this;
    }

    protected void doSelect(T source) {
    }

    public List<T> getSelectedItems() {
        int[] idxs = this._ctrlTable.getSelectedRows();
        if (idxs == null || idxs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(idxs.length);
        for (int i = 0; i < idxs.length; ++i) {
            int idxDoc = this._ctrlTable.convertRowIndexToModel(idxs[i]);
            result.add(this._errors.get(idxDoc).getSource());
        }
        return result;
    }

    class ErrorsTableModel
    implements TableModel {
        ArrayList<TableModelListener> _listener = new ArrayList();

        ErrorsTableModel() {
        }

        @Override
        public int getRowCount() {
            if (GeneralDlgDisplayError.this._errors == null) {
                return 0;
            }
            return GeneralDlgDisplayError.this._errors.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 1: {
                    return GeneralDlgDisplayError.this.getSourceName();
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_MESSAGE");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return MsgType.class;
                }
                case 1: {
                    return GeneralDlgDisplayError.this.getSourceClass();
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return GeneralDlgDisplayError.this._errors.get(rowIndex).getType();
                }
                case 1: {
                    return GeneralDlgDisplayError.this._errors.get(rowIndex).getSource();
                }
                case 2: {
                    return GeneralDlgDisplayError.this._errors.get(rowIndex).getMsg();
                }
            }
            return null;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            if (!this._listener.contains(l)) {
                this._listener.add(l);
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listener.remove(l);
        }
    }
}

