/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.error;

import com.dassault.cecilia.core.cecilia.error.MsgType;
import java.util.logging.Logger;

public class GeneralError<T> {
    MsgType _type;
    T _source;
    String _messag;

    public GeneralError(T source, String msg) {
        this._source = source;
        this._messag = msg;
        this._type = MsgType.ERROR;
    }

    public GeneralError(T source, String msg, MsgType type) {
        this._source = source;
        this._messag = msg;
        this._type = type;
    }

    public T getSource() {
        return this._source;
    }

    public String getMsg() {
        return this._messag;
    }

    public MsgType getType() {
        return this._type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this._type.toString().toLowerCase()).append("]");
        sb.append("[").append(this._source).append("]");
        sb.append(this._messag);
        return sb.toString();
    }

    public void log(Logger log) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this._source).append("] ");
        sb.append(this._messag);
        switch (this._type) {
            case FATAL: 
            case ERROR: {
                log.severe(sb.toString());
                break;
            }
            case WARNING: {
                log.warning(sb.toString());
                break;
            }
            case INFO: 
            case QUESTION: {
                log.info(sb.toString());
            }
        }
    }
}

