/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKWriter;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DBKTableModel {
    public static final int _NO_CELL = -1;
    public static final int _ONE_CELL = 0;
    protected List<List> _row;
    protected List<List> _moreRows = null;
    protected List<String> _column;
    protected Iterator _enumeration;
    protected DataType _dataType;

    public DBKTableModel(Vector row, List<String> column, DataType type) {
        this._column = column;
        this._row = new ArrayList<List>();
        this._dataType = type;
        this.createData();
    }

    public DBKTableModel(Iterator iterator, List<String> column, DataType type) {
        this._enumeration = iterator;
        this._column = column;
        this._row = new ArrayList<List>();
        this._dataType = type;
        this.createData();
    }

    public DBKTableModel(Collection collection, List<String> column, DataType type) {
        this._enumeration = collection.iterator();
        this._column = column;
        this._row = new ArrayList<List>();
        this._dataType = type;
        this.createData();
    }

    public DBKTableModel(Collection collection, List<String> column, List<List> moreRows, DataType type) {
        this._enumeration = collection.iterator();
        this._column = column;
        this._row = new ArrayList<List>();
        this._moreRows = moreRows;
        this._dataType = type;
        this.createData();
    }

    public int getRowCount() {
        return this._row.size();
    }

    public int getColumnCount() {
        return this._column.size();
    }

    public Object getValueAt(int row, int col) {
        return this._row.get(row).get(col);
    }

    public String getColumnName(int col) {
        return this._column.get(col);
    }

    public List<String> getColumn() {
        return this._column;
    }

    public List<List> getRow() {
        return this._row;
    }

    public Integer getMoreRowsValueAt(int row, int col) {
        if (this._moreRows != null) {
            return (Integer)this._moreRows.get(row).get(col);
        }
        return 0;
    }

    protected void createData() {
        if (this._dataType == DataType.ATTRIBUTES || this._dataType == DataType.PARAMETERS || this._dataType == DataType.OBJECTS) {
            while (this._enumeration.hasNext()) {
                Object object = this._enumeration.next();
                switch (this._dataType) {
                    case ATTRIBUTES: {
                        this.writeAttribute(object);
                        break;
                    }
                    case PARAMETERS: {
                        this.writeParameter(object);
                        break;
                    }
                    case OBJECTS: {
                        this.writeObject(object);
                        break;
                    }
                }
            }
        }
    }

    private void writeAttribute(Object object) {
        DBAttrib a = (DBAttrib)object;
        ArrayList<String> internRowAttribute = new ArrayList<String>();
        String attributeName = a.getName();
        String attributeType = a.getType().getLabel();
        StringBuilder desc = new StringBuilder(a.getDBFolder().getDescription() == null ? "" : a.getDBFolder().getDescription());
        for (int idx = 0; idx < desc.length(); ++idx) {
            char ch = desc.charAt(idx);
            desc.setCharAt(idx, ch == '\n' ? (char)' ' : (char)ch);
        }
        String attributeDescription = desc.toString();
        internRowAttribute.add(attributeName);
        internRowAttribute.add(attributeType);
        internRowAttribute.add(attributeDescription);
        this._row.add(internRowAttribute);
    }

    private void writeParameter(Object object) {
        DBParam p = (DBParam)object;
        ArrayList<String> internRowParameter = new ArrayList<String>();
        String parameterName = p.toString();
        String parameterType = p.getType().getLabel();
        String parameterValue = p.getValue().toString();
        StringBuilder desc = new StringBuilder(p.getDBFolder().getDescription() == null ? "" : p.getDBFolder().getDescription());
        for (int idx = 0; idx < desc.length(); ++idx) {
            char ch = desc.charAt(idx);
            desc.setCharAt(idx, ch == '\n' ? (char)' ' : (char)ch);
        }
        String parameterDescription = desc.toString();
        internRowParameter.add(parameterName);
        internRowParameter.add(parameterType);
        internRowParameter.add(parameterValue);
        internRowParameter.add(parameterDescription);
        this._row.add(internRowParameter);
    }

    private void writeObject(Object object) {
        if (object instanceof List) {
            this._row.add((List)object);
        } else {
            ArrayList<Object> internRowObject = new ArrayList<Object>();
            internRowObject.add(object);
            this._row.add(internRowObject);
        }
    }

    public void writeEntryAt(DBKWriter writer, int j, int i) throws IOException {
        writer.write((String)this.getValueAt(j, i), true);
    }

    public static enum DataType {
        ALTANODE,
        ALTAPORT,
        ALTASTATE,
        ALTAEVENTS,
        ALTAICONS,
        ALTAOPERATORS,
        ALTAOPERANDE,
        ALTAENUMTYPE,
        ALTAFIELD,
        ALTASYNCHRONISATION,
        ATTRIBUTES,
        PARAMETERS,
        OBJECTS;

    }
}

