/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DBKWriter {
    private Writer _write;
    private StringBuilder _buffer;
    private int _cpt;
    private boolean _newLine;
    private boolean _exportString = false;
    private String _indent;
    private int _nbr;

    public DBKWriter(Writer write, String base) {
        this._write = write;
        this._buffer = null;
        this._cpt = 0;
        this._newLine = false;
        this._nbr = 1;
        this._indent = base;
    }

    public DBKWriter(StringBuilder sb, String base) {
        this._write = null;
        this._buffer = sb;
        this._cpt = 0;
        this._newLine = false;
        this._nbr = 1;
        this._indent = base;
    }

    private void print(String txt) throws IOException {
        if (this._write != null) {
            this._write.write(txt);
        } else {
            this._buffer.append(txt);
        }
    }

    private void writeIndent() throws IOException {
        for (int i = 0; i < this._cpt; ++i) {
            this.print(this._indent);
        }
        ++this._nbr;
    }

    public void write(String add, boolean transform) throws IOException {
        int pos;
        if (transform) {
            add = this.toXML(add);
        }
        if (this._exportString && (pos = add.indexOf(34)) != -1) {
            StringBuilder sb = new StringBuilder((add.length() + 10) * 125 / 100);
            while (pos != -1) {
                sb.append(add.substring(0, pos));
                sb.append("\\\"");
                add = add.substring(pos + 1);
                pos = add.indexOf(10);
            }
            add = sb.toString();
        }
        if (this._newLine) {
            this.writeIndent();
        }
        pos = add.indexOf("\n");
        while (pos != -1) {
            this.print(add.substring(0, pos + 1));
            if (pos == add.length() - 1) {
                this._newLine = true;
                return;
            }
            this.writeIndent();
            add = add.substring(pos + 1);
            pos = add.indexOf("\n");
        }
        this._newLine = false;
        this.print(add);
    }

    public void addIndent(int mod) {
        this._cpt += mod;
        assert (this._cpt >= 0);
    }

    public int getIndent() {
        return this._cpt;
    }

    public void close(boolean writer) throws IOException {
        if (this._newLine) {
            this.writeIndent();
        }
        this._newLine = false;
        if (this._write != null) {
            if (writer) {
                this._write.close();
            } else {
                this._write.flush();
            }
        }
    }

    protected int getLine() {
        return this._nbr + (this._newLine ? 1 : 0);
    }

    public String toXML(String st) {
        StringBuilder xmlString = new StringBuilder("");
        char curCar = ' ';
        block7: for (int i = 0; i < st.length(); ++i) {
            curCar = st.charAt(i);
            switch (curCar) {
                case '&': {
                    xmlString.append("&amp;");
                    continue block7;
                }
                case '<': {
                    xmlString.append("&lt;");
                    continue block7;
                }
                case '>': {
                    xmlString.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    xmlString.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    xmlString.append("&quot;");
                    continue block7;
                }
                default: {
                    xmlString.append(curCar);
                }
            }
        }
        return xmlString.toString();
    }

    public static List<String> split(String txt, String delim) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(txt, delim);
        while (token.hasMoreTokens()) {
            tokens.add(token.nextToken());
        }
        return tokens;
    }
}

