/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpComponent {
    private ExpContainer _parent;
    private static final Logger _LOG = Logger.getLogger(ExpComponent.class.getPackage().getName());
    static final SimpleDateFormat __exportDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);

    public void setContainer(ExpContainer parent) {
        this._parent = parent;
    }

    public ExpBook getBook() {
        if (this._parent != null) {
            return this._parent.getBook();
        }
        return null;
    }

    protected int getCurrentLevelSection() {
        if (this._parent != null) {
            return this._parent.getCurrentLevelSection();
        }
        return -1;
    }

    protected void logMsg(Level lvl, String msg) {
        _LOG.log(lvl, msg);
        _LOG.finest("during export '" + this.getBook().getTitle());
    }

    protected String convertString(String txt) {
        if (txt == null) {
            return "";
        }
        return txt;
    }

    public String getCurrentDateAsDDMMYYYY() {
        return __exportDateFormat.format(new Date());
    }

    public void writeDocbook(DBKOutput output) throws IOException {
    }

    protected void writeDBKText(DBKOutput output, String text) throws IOException {
        if (Boolean.getBoolean("cecilia.exp.docbook.use.sbr")) {
            output.write("<emphasis>", false);
            output.write(text, true);
            output.write("</emphasis>", false);
        } else {
            output.write("<simpara>", false);
            output.write(text, true);
            output.write("</simpara>\n", false);
        }
    }

    protected void writeDBKSimpleParamKey(DBKOutput output, String key, String value) throws IOException {
        if (Boolean.getBoolean("cecilia.exp.docbook.use.sbr")) {
            output.write("<emphasis>", false);
            output.write(key, true);
            output.write("</emphasis> : ", false);
            output.write(value, true);
            output.write("<sbr/>\n", false);
        } else {
            output.write("<simpara>", false);
            output.write(key, true);
            output.write(" : ", false);
            output.write(value, true);
            output.write("</simpara>\n", false);
        }
    }

    public void writeScribe(SrbInputStream scribe) throws IOException {
    }

    protected void writeSRBSimpleParamKey(SrbInputStream scribe, String key, String value) throws IOException {
        scribe.concat(key + "@:@<HP2>" + value);
        scribe.concat("<EHP2>\n");
        scribe.concat(".br \n");
    }

    protected void exportScribeComment(SrbInputStream out, String comment, String format) {
        char[] text = comment.toCharArray();
        for (int i = 0; i < comment.length(); ++i) {
            if (text[i] != '\n') {
                out.concat("" + text[i]);
                continue;
            }
            if (i == comment.length() - 1) continue;
            out.concat(format);
        }
    }

    protected String dtos(double value) {
        if (Double.isNaN(value)) {
            return "-";
        }
        return this.getBook().getDoubleFormat().format(value);
    }

    protected String dateToString(Date value) {
        if (value == null) {
            return "-";
        }
        return this.getBook().getDateFormat().format(value);
    }
}

