/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.db.DBFolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class ExpListOfDependencies
extends ExpTable {
    ArrayList<DBFolder> _dependencies;

    public ExpListOfDependencies(Set<DBFolder> dependencies) {
        this._dependencies = new ArrayList<DBFolder>(dependencies);
        Collections.sort(this._dependencies, DBFolder.getComparatorWithFamily());
    }

    @Override
    protected int getColumnCount() {
        return 4;
    }

    @Override
    protected String getColumnName(int col) {
        switch (col) {
            case 0: {
                return ResMsgVoc.getString("VOC_TYPE");
            }
            case 1: {
                return ResMsgVoc.getString("VOC_PATH");
            }
            case 2: {
                return ResMsgVoc.getString("VOC_NAME");
            }
            case 3: {
                return ResMsgVoc.getString("VOC_VERSION");
            }
        }
        return "<Error>";
    }

    @Override
    protected int getRowCount() {
        return this._dependencies.size();
    }

    @Override
    protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
        DBFolder dbFolder = this._dependencies.get(row);
        output.write(this.getEntryAt(col, dbFolder), true);
    }

    @Override
    protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idxSubCell) {
        DBFolder dbFolder = this._dependencies.get(row);
        buffer.append(this.getEntryAt(col, dbFolder));
    }

    protected String getEntryAt(int col, DBFolder dbFolder) {
        switch (col) {
            case 0: {
                return DBFolderResources.getTypeModel(dbFolder.getFamily(), dbFolder.getFamilyFlag());
            }
            case 1: {
                if (dbFolder.getParent() == null || dbFolder.getParent().getParent() == null) break;
                return dbFolder.getParent().getParent().getPathUntilSystem(new StringBuilder()).toString();
            }
            case 2: {
                if (dbFolder.isVersion()) {
                    return dbFolder.getParent().getName();
                }
                return dbFolder.getName();
            }
            case 3: {
                if (!dbFolder.isVersion()) break;
                return dbFolder.getName();
            }
        }
        return "";
    }

    @Override
    protected ExpTable.ExpAlign getColumnAlign(int col) {
        return ExpTable.ExpAlign.LEFT;
    }

    @Override
    protected int getColumnWidth(int col) {
        switch (col) {
            case 0: {
                return 8;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 20;
            }
        }
        return super.getColumnWidth(col);
    }
}

