/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.db.DBFolder;
import java.io.IOException;
import java.util.List;

public class ExpTableBTPFolders
extends ExpTable {
    List<DBFolder> _folders;

    public ExpTableBTPFolders(List<DBFolder> folders) {
        this._folders = folders;
    }

    @Override
    protected int getColumnCount() {
        return 2;
    }

    @Override
    protected String getColumnName(int col) {
        switch (col) {
            case 0: {
                return ResMsgVoc.getString("VOC_NAME");
            }
            case 1: {
                return ResMsgVoc.getString("VOC_DESCRIPTION");
            }
        }
        return "<error>";
    }

    @Override
    protected int getRowCount() {
        return this._folders.size();
    }

    @Override
    protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
        DBFolder dbFolder = this._folders.get(row);
        output.write(this.getEntryAt(col, dbFolder), true);
    }

    @Override
    protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idxSubCell) {
        DBFolder dbFolder = this._folders.get(row);
        buffer.append(this.getEntryAt(col, dbFolder));
    }

    protected String getEntryAt(int col, DBFolder dbFolder) {
        switch (col) {
            case 0: {
                return dbFolder.getName();
            }
            case 1: {
                return this.convertString(dbFolder.getDescription());
            }
        }
        return "";
    }

    @Override
    protected ExpTable.ExpAlign getColumnAlign(int col) {
        return ExpTable.ExpAlign.LEFT;
    }
}

