/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpTableWithEntry;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class ExpTableEvents<T>
extends ExpTableWithEntry<T> {
    private static Logger _LOG = Logger.getLogger(ExpTableEvents.class.getPackage().getName());
    CLawManager _lawManager = null;

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        ExpBook book = this.getBook();
        if (book == null) {
            _LOG.severe("Don't find root book for exportation");
            return;
        }
        this._lawManager = book.getDAOFactory().getLawManager();
        super.writeDocbook(output);
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        ExpBook book = this.getBook();
        if (book == null) {
            _LOG.severe("Don't find root book for exportation");
            return;
        }
        this._lawManager = book.getDAOFactory().getLawManager();
        super.writeScribe(scribe);
    }

    protected String ptos(Param param) {
        return LawFormat.DEFAULT.format(param, this.getBook().getDoubleFormat());
    }

    protected String ltos(Law law) {
        return LawFormat.DEFAULT.format(law, this.getBook().getDoubleFormat());
    }
}

