/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModelInterface;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNodeFile;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DBFolderTreeModel
extends DefaultTreeModel
implements DBFolderTreeModelInterface,
DAOFolder.UpdateListener {
    private static Logger _LOG = Logger.getLogger(DBFolderTreeModel.class.getPackage().getName());
    DAOFolder _daoFolder;
    DAOUser _daoUser;
    DBUser _dbUser;
    DBFolder.Family _familyFilter;
    boolean _bWithNodeFiles;
    String _identifier;
    Map<DBFolder, DBFolderTreeNode> _nodes = new HashMap<DBFolder, DBFolderTreeNode>();

    public DBFolderTreeModel(DAOFolder daoFolder, DAOUser daoUser, DBUser dbUser, DBFolder.Family familyFilter, String identifier) {
        super(null);
        this._daoFolder = daoFolder;
        this._daoUser = daoUser;
        this._dbUser = dbUser;
        this._familyFilter = familyFilter;
        this._bWithNodeFiles = true;
        this._identifier = identifier;
    }

    public void setFolderRoot(DBFolder dbRoot) {
        this._nodes.clear();
        DBFolderTreeNode trNode = this.createTreeNode(dbRoot);
        this.putTreeNode(dbRoot, trNode);
        this.setRoot(trNode);
    }

    @Override
    public boolean withNodeFiles() {
        return this._bWithNodeFiles;
    }

    public DBFolderTreeModel setWithNodeFile(boolean value) {
        this._bWithNodeFiles = value;
        return this;
    }

    public DBUser getDBUser() {
        return this._dbUser;
    }

    public DAOFolder getDAOFolder() {
        return this._daoFolder;
    }

    public DBFolder.Family getFamilyFilter() {
        return this._familyFilter;
    }

    @Override
    public DBFolderTreeNode getRoot() {
        return (DBFolderTreeNode)super.getRoot();
    }

    @Override
    public DBFolderTreeNode getTreeNode(DBFolder dbFolder) {
        return this._nodes.get(dbFolder);
    }

    @Override
    public void putTreeNode(DBFolder dbFolder, DBFolderTreeNode trNode) {
        this._nodes.put(dbFolder, trNode);
        _LOG.finest("DBFolderTreeModel: Put graphical tree node " + dbFolder.getPathUntilSystem(new StringBuilder()).toString());
    }

    void removeTreeNode(DBFolder dbFolder, DBFolderTreeNode trNode) {
        this._nodes.remove(dbFolder);
    }

    @Override
    public List<DBFolder> findChildren(DBFolder dbFolder) {
        return this._daoFolder.findChildren(dbFolder);
    }

    protected TreeNode getParentNode(TreeNode nodeFolder) {
        return nodeFolder.getParent();
    }

    public DBFolderTreeNode constructPath(DBFolder dbFolder) {
        DBFolderTreeNode node = this.getTreeNode(dbFolder);
        if (node != null) {
            return node;
        }
        DBFolder dbParent = dbFolder.getParent();
        node = this.constructPath(dbParent);
        if (node == null) {
            return null;
        }
        if (node.getChildCount() == 0) {
            return null;
        }
        return this.getTreeNode(dbFolder);
    }

    @Override
    public void changeBegin() {
        this._daoUser.refresh(this._dbUser);
    }

    protected boolean filterFolder(DBFolder dbFolder) {
        if (this._familyFilter == null) {
            return true;
        }
        return this._familyFilter.equals((Object)dbFolder.getFamily());
    }

    @Override
    public boolean changeState(DBFolder dbFolder) {
        if (!this.filterFolder(dbFolder)) {
            return false;
        }
        DBFolderTreeNode trNode = this.getTreeNode(dbFolder);
        if (trNode != null) {
            DBAccess.Right right;
            if (dbFolder.getAccesses() == null) {
                this._daoFolder.findAccesses(dbFolder);
            }
            if ((right = dbFolder.getAccessRight(this._dbUser)).equals((Object)DBAccess.Right.NONE) || right.equals((Object)DBAccess.Right.INTEGRATE)) {
                this.deleteTreeNode(dbFolder, trNode);
                return false;
            }
            TreeNode parent = this.getParentNode(trNode);
            if (parent != null) {
                if (!this.isGoodParent(parent, dbFolder)) {
                    this.deleteTreeNode(dbFolder, trNode);
                    return this.insertTreeNode(dbFolder, trNode);
                }
                if (!this.isGoodSorted(parent, trNode)) {
                    this.deleteTreeNode(dbFolder, trNode);
                    return this.insertTreeNode(dbFolder, trNode);
                }
                boolean readOnly = right.equals((Object)DBAccess.Right.READ);
                trNode.setReadOnly(readOnly);
                this.updateTreeNode(dbFolder, trNode, parent);
                return true;
            }
        } else {
            return this.insertTreeNode(dbFolder, trNode);
        }
        return false;
    }

    protected boolean isGoodParent(TreeNode parent, DBFolder dbFolder) {
        return this.getTreeNode(dbFolder.getParent()) == parent;
    }

    protected boolean isGoodSorted(TreeNode trParent, DBFolderTreeNode trNode) {
        int idx = trParent.getIndex(trNode);
        if (idx < 0) {
            return false;
        }
        if (trParent.getChildCount() <= 1) {
            return true;
        }
        if (idx == 0) {
            DBFolderTreeNode trNext = (DBFolderTreeNode)trParent.getChildAt(idx + 1);
            if (DBFolderTreeNode.__DBFolderTreeNodeComparator.compare(trNode, trNext) > 0) {
                return false;
            }
        } else if (idx == trParent.getChildCount() - 1) {
            DBFolderTreeNode trPrev = (DBFolderTreeNode)trParent.getChildAt(idx - 1);
            if (DBFolderTreeNode.__DBFolderTreeNodeComparator.compare(trPrev, trNode) > 0) {
                return false;
            }
        } else if (idx > 0) {
            DBFolderTreeNode trPrev = (DBFolderTreeNode)trParent.getChildAt(idx - 1);
            if (DBFolderTreeNode.__DBFolderTreeNodeComparator.compare(trPrev, trNode) > 0) {
                return false;
            }
            DBFolderTreeNode trNext = (DBFolderTreeNode)trParent.getChildAt(idx + 1);
            if (DBFolderTreeNode.__DBFolderTreeNodeComparator.compare(trNode, trNext) > 0) {
                return false;
            }
        }
        return true;
    }

    protected void updateTreeNodeFiles(DBFolder dbFolder, DBFolderTreeNode trNode) {
        int i;
        DBObject dbObj = dbFolder.getObject();
        if (trNode._nodeChildren != null) {
            for (i = trNode._nodeChildren.size() - 1; i >= 0; --i) {
                DBFolderTreeNodeFile trFile;
                DBFolderTreeNode trChild = trNode._nodeChildren.get(i);
                if (!(trChild instanceof DBFolderTreeNodeFile) || dbObj.getModel((trFile = (DBFolderTreeNodeFile)trChild).getObjModel().getNature()) != null) continue;
                trNode._nodeChildren.remove(i);
                this.fireTreeNodesRemoved(this, this.getPathToRoot(trNode), new int[]{i}, new Object[]{trFile});
            }
        }
        if (trNode._nodeChildren == null || trNode._nodeChildren.isEmpty()) {
            trNode._nodeChildren = new ArrayList();
            i = 0;
            for (DBObjModel dbObjModel : dbObj.getModels()) {
                if (!dbObjModel.getNature().startsWith("associated.file")) continue;
                DBFolderTreeNodeFile trFile = new DBFolderTreeNodeFile(this, dbFolder, dbObjModel);
                trFile.setParent(trNode);
                trNode._nodeChildren.add(trFile);
                this.fireTreeNodesInserted(this, this.getPathToRoot(trNode), new int[]{i++}, new Object[]{trFile});
            }
        } else {
            i = 0;
            for (DBObjModel dbObjModel : dbObj.getModels()) {
                if (!dbObjModel.getNature().startsWith("associated.file")) continue;
                DBFolderTreeNodeFile trFile = null;
                if (i < trNode._nodeChildren.size()) {
                    trFile = (DBFolderTreeNodeFile)trNode._nodeChildren.get(i);
                    if (!trFile.getObjModel().getNature().equals(dbObjModel.getNature())) {
                        trFile = new DBFolderTreeNodeFile(this, dbFolder, dbObjModel);
                        trFile.setParent(trNode);
                        trNode._nodeChildren.add(i, trFile);
                        this.fireTreeNodesInserted(this, this.getPathToRoot(trNode), new int[]{i}, new Object[]{trFile});
                    }
                } else {
                    trFile = new DBFolderTreeNodeFile(this, dbFolder, dbObjModel);
                    trFile.setParent(trNode);
                    trNode._nodeChildren.add(trFile);
                    this.fireTreeNodesInserted(this, this.getPathToRoot(trNode), new int[]{i}, new Object[]{trFile});
                }
                ++i;
            }
        }
    }

    protected void updateTreeNode(DBFolder dbFolder, DBFolderTreeNode trNode, TreeNode parent) {
        int idx;
        if (this._bWithNodeFiles && dbFolder.isVersion() && dbFolder.getObject() != null) {
            this.updateTreeNodeFiles(dbFolder, trNode);
        }
        if ((idx = parent.getIndex(trNode)) >= 0) {
            this.fireTreeNodesChanged(this, this.getPathToRoot(parent), new int[]{idx}, new Object[]{trNode});
        } else {
            _LOG.info("[Change] Le parent d'un noeud d'arbre ne retrouve pas son fils : " + trNode + " !E " + parent);
        }
    }

    private boolean insertTreeNode(DBFolder dbFolder, DBFolderTreeNode trNode) {
        DBAccess.Right right;
        if (dbFolder.getAccesses() == null) {
            this._daoFolder.findAccesses(dbFolder);
        }
        if ((right = dbFolder.getAccessRight(this._dbUser)).equals((Object)DBAccess.Right.NONE)) {
            return false;
        }
        if (right.equals((Object)DBAccess.Right.INTEGRATE)) {
            return false;
        }
        if (!this.acceptFolder(dbFolder)) {
            return false;
        }
        DBFolder dbParent = dbFolder.getParent();
        if (dbParent == null) {
            return false;
        }
        DBFolderTreeNode trParent = this.getTreeNode(dbParent);
        if (trParent != null) {
            trNode = this.createTreeNode(dbFolder);
            trNode.setReadOnly(right.equals((Object)DBAccess.Right.READ));
            this.putTreeNode(dbFolder, trNode);
            int idx = trParent.insert(trNode);
            if (idx >= 0) {
                this.fireTreeNodesInserted(this, this.getPathToRoot(trParent), new int[]{idx}, new Object[]{trNode});
                _LOG.finest("DBFolderTreeModel: Insert graphical tree node " + dbFolder.getPathUntilSystem(new StringBuilder()).toString());
            } else {
                TreeNode parent = this.getParentNode(trNode);
                if (parent != null) {
                    idx = parent.getIndex(trNode);
                    if (idx >= 0) {
                        this.fireTreeNodesInserted(this, this.getPathToRoot(parent), new int[]{idx}, new Object[]{trNode});
                        _LOG.finest("DBFolderTreeModel: Insert graphical tree node " + dbFolder.getPathUntilSystem(new StringBuilder()).toString());
                    } else {
                        _LOG.info("[Insert] Le parent d'un noeud d'arbre ne retrouve pas son fils : " + trNode + " !E " + parent);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void deleteTreeNode(DBFolder dbFolder, DBFolderTreeNode trNode) {
        DBFolderTreeNode trParent = trNode.getParent();
        if (trParent != null) {
            int idx = trParent.remove(trNode);
            if (idx >= 0) {
                this.fireTreeNodesRemoved(this, this.getPathToRoot(trParent), new int[]{idx}, new Object[]{trNode});
                this.removeTreeNode(dbFolder, trNode);
            }
        } else {
            this.removeTreeNode(dbFolder, trNode);
        }
        _LOG.finest("DBFolderTreeModel: Delete graphical tree node " + dbFolder.getPathUntilSystem(new StringBuilder()).toString());
    }

    @Override
    public void changeStateAndChildren(DBFolder dbFolder, List<DBFolder> delChildren) {
        if (!this.filterFolder(dbFolder)) {
            return;
        }
        for (DBFolder dbDelFolder : delChildren) {
            DBFolderTreeNode trDelNode = this.getTreeNode(dbDelFolder);
            if (trDelNode == null) continue;
            this.deleteTreeNode(dbDelFolder, trDelNode);
        }
        this.changeState(dbFolder);
        for (DBFolder dbChild : dbFolder.getChildren()) {
            this.changeState(dbChild);
        }
    }

    @Override
    public void changeEnd() {
    }

    @Override
    public void refreshAll() {
        DBFolderTreeNode trRoot = this.getRoot();
        DBFolder dbRoot = trRoot.getDBFolder();
        this.setFolderRoot(dbRoot);
    }

    @Override
    public boolean acceptFolder(DBFolder dbFolder) {
        return true;
    }

    protected DBFolderTreeNode createTreeNode(DBFolder dbFolder) {
        return new DBFolderFilterTreeNode(this, dbFolder);
    }

    protected class DBFolderFilterTreeNode
    extends DBFolderTreeNode {
        protected DBFolderFilterTreeNode(DBFolderTreeModelInterface model, DBFolder dbFolder) {
            super(model, dbFolder);
        }

        @Override
        public synchronized void createNodeChildren() {
            List<DBFolder> children = this.getDBFolder().getChildren();
            if (children == null) {
                children = this.getModel().findChildren(this.getDBFolder());
            }
            if (children == null || children.isEmpty()) {
                this._nodeChildren = this.getDBFolder().isVersion() && this.getModel().withNodeFiles() ? this.createNodeFiles() : new ArrayList(0);
                return;
            }
            this._nodeChildren = new ArrayList(children.size());
            for (DBFolder dbFolder : children) {
                DBAccess.Right right;
                if (dbFolder.getAccesses() == null) {
                    DBFolderTreeModel.this._daoFolder.findAccesses(dbFolder);
                }
                if ((right = dbFolder.getAccessRight(DBFolderTreeModel.this._dbUser)).equals((Object)DBAccess.Right.NONE) || right.equals((Object)DBAccess.Right.INTEGRATE) || !this.getModel().acceptFolder(dbFolder)) continue;
                DBFolderTreeNode trNode = this.getModel().getTreeNode(dbFolder);
                if (trNode == null) {
                    trNode = DBFolderTreeModel.this.createTreeNode(dbFolder);
                    this.getModel().putTreeNode(dbFolder, trNode);
                }
                trNode.setReadOnly(right.equals((Object)DBAccess.Right.READ));
                this._nodeChildren.add(trNode);
                trNode.setParent(this);
            }
            Collections.sort(this._nodeChildren, __DBFolderTreeNodeComparator);
        }
    }
}

