/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderList;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderListDropTargetListener;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public abstract class JPanelTableFolder
extends JPanel {
    private static Logger _LOG = Logger.getLogger(JPanelTableFolder.class.getPackage().getName());
    protected CeciliaAction _ctrlLoad;
    protected CeciliaAction _ctrlSave;
    protected CeciliaAction _ctrlAdd;
    protected CeciliaAction _ctrlDel;
    protected CAppl _cAppl;
    protected JTable _table;
    protected AbstractTableModel _model;
    protected JPopupMenu _popupList;
    private DAOFolder.UpdateListener _listener = new DAOFolder.UpdateListener(){

        @Override
        public void refreshAll() {
        }

        @Override
        public void changeStateAndChildren(DBFolder dbFolder, List<DBFolder> oldChildren) {
        }

        @Override
        public boolean changeState(DBFolder dbFolder) {
            return false;
        }

        @Override
        public void changeEnd() {
            JPanelTableFolder.this.repaint();
        }

        @Override
        public void changeBegin() {
            JPanelTableFolder.this.repaint();
        }
    };
    JFileChooser _dlgFile = null;
    public FolderDropTarget _tableDropTarget = null;

    protected JPanelTableFolder(CAppl cAppl, JDialog dlg) {
        super(new BorderLayout());
        this._cAppl = cAppl;
        dlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JPanelTableFolder.this._cAppl.addFolderUpdateListener(JPanelTableFolder.this._listener);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                JPanelTableFolder.this._cAppl.removeFolderUpdateListener(JPanelTableFolder.this._listener);
            }
        });
    }

    protected abstract JPanel createBottomPanel();

    public abstract void load(File var1);

    public abstract void save(File var1);

    public abstract String getPathSave();

    public abstract void deleteRows();

    protected void initialise() {
        this.createActions();
        this.createPopUp();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JToolBar toolBar = this.createToolBar();
        this.add((Component)toolBar, "North");
        this.createModel();
        this.createTable();
        this.addTableDecorator();
        this.add((Component)this.createScrollTable(), "Center");
        JPanel additionalPanel = this.createBottomPanel();
        if (additionalPanel != null) {
            this.add((Component)additionalPanel, "South");
        }
        this.refreshCtrl();
    }

    protected void createActions() {
        this._ctrlLoad = new CeciliaAction(ResIcoCore.getImageIcon("BUT_LOAD"), ResMsgCore.getString("ACTION_LOAD_MENU"), ResMsgCore.getString("ACTION_LOAD_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File input = JPanelTableFolder.this.displayDlgFile(false, JPanelTableFolder.this.getPathSave());
                if (input == null) {
                    return;
                }
                JPanelTableFolder.this.load(input);
            }
        };
        this._ctrlSave = new CeciliaAction(ResIcoCore.getImageIcon("BUT_SAVE"), ResMsgCore.getString("ACTION_SAVE_MENU"), ResMsgCore.getString("ACTION_SAVE_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File input = JPanelTableFolder.this.displayDlgFile(true, JPanelTableFolder.this.getPathSave());
                if (input == null) {
                    return;
                }
                JPanelTableFolder.this.save(input);
            }
        };
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), ResMsgCore.getString("ACTION_ADD_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanelTableFolder.this.addRows();
            }
        };
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE"), ResMsgCore.getString("ACTION_DEL_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanelTableFolder.this.deleteRows();
            }
        };
    }

    protected void createPopUp() {
        this._popupList = new JPopupMenu();
        this._popupList.add(this._ctrlAdd);
        this._popupList.add(this._ctrlDel);
        this._popupList.addSeparator();
        this._popupList.add(this._ctrlLoad);
        this._popupList.add(this._ctrlSave);
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setBorder(CeciliaAction.STANDARD_BORDER);
        toolbar.setFloatable(false);
        this.addAction(toolbar);
        return toolbar;
    }

    protected void addAction(JToolBar toolbar) {
        toolbar.add(this._ctrlLoad.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlSave.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createGlue());
        toolbar.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
    }

    protected void createModel() {
        this._model = new DBFolderModel();
    }

    protected void createTable() {
        this._table = new DBFolderTable(this._model);
    }

    protected void addTableDecorator() {
        this._tableDropTarget = new FolderDropTarget(this._table);
        this._table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        this._table.setFillsViewportHeight(true);
        this._table.setComponentPopupMenu(this._popupList);
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int idx = JPanelTableFolder.this._table.rowAtPoint(new Point(e.getX(), e.getY()));
                    JPanelTableFolder.this._table.setRowSelectionInterval(idx, idx);
                }
            }
        });
        this._table.setRowHeight(ResIcoAbstract.getIconSize());
        ListSelectionModel selMod = this._table.getSelectionModel();
        selMod.setSelectionMode(2);
        selMod.addListSelectionListener(e -> this.refreshCtrl());
        this._model.addTableModelListener(e -> this.refreshCtrl());
    }

    private JScrollPane createScrollTable() {
        JScrollPane scrollTable = new JScrollPane(this._table);
        scrollTable.setComponentPopupMenu(this._popupList);
        return scrollTable;
    }

    protected void refreshCtrl() {
        int nbrSel = this._table.getSelectedRowCount();
        int nbrElt = this._table.getRowCount();
        this._ctrlSave.setEnabled(nbrElt > 0);
        this._ctrlDel.setEnabled(nbrSel > 0);
    }

    protected File displayDlgFile(boolean save, String path) {
        int result;
        if (this._dlgFile == null) {
            this._dlgFile = new JFileChooser();
            JChooserFileUtility.configureFileFilter(this._dlgFile, JChooserFileUtility.Type.XML);
            this._dlgFile.setFileSelectionMode(0);
        }
        this._dlgFile.setCurrentDirectory(new File(path));
        int n = result = save ? this._dlgFile.showSaveDialog(this) : this._dlgFile.showOpenDialog(this);
        if (result == 1) {
            return null;
        }
        File file = this._dlgFile.getSelectedFile();
        if (file == null) {
            return null;
        }
        if (save && (file = FileFilterExtention.addDefaultExtention(this._dlgFile)).exists() && 0 != JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.getString("FILE_MSG_EXIST"))) {
            return null;
        }
        return file;
    }

    protected void addFolders(Collection<DBFolder> folders) {
        HashSet<DBFolder> nodesTreated = new HashSet<DBFolder>();
        for (DBFolder node : folders) {
            _LOG.finest("Drag'n Drop for node " + node.toString());
            short familyFlag = node.getFamilyFlag();
            if (familyFlag == 8) {
                familyFlag = 0;
            }
            this.addToBatch(node, familyFlag, nodesTreated);
        }
        this.updateModel();
    }

    public void addToBatch(DBFolder node, short filterFamilyFlag, Set<DBFolder> nodesTreated) {
        if (nodesTreated.contains(node)) {
            return;
        }
        nodesTreated.add(node);
        if (node.isVersion()) {
            if (filterFamilyFlag != 0 && filterFamilyFlag != node.getFamilyFlag()) {
                return;
            }
            if (node.getFamilyFlag() != 2 && node.getFamilyFlag() != 5) {
                return;
            }
            this.addToBatch(node);
        } else {
            boolean treatChildren = false;
            if (node.isFolder()) {
                treatChildren = true;
            } else if (filterFamilyFlag != 0 && filterFamilyFlag == node.getFamilyFlag()) {
                treatChildren = true;
            } else if (node.getFamilyFlag() == 2 || node.getFamilyFlag() == 5) {
                treatChildren = true;
            }
            if (treatChildren) {
                List<DBFolder> children = node.getChildren();
                if (children == null) {
                    children = this._cAppl.getDAOFactory().createFolderDAO().findChildren(node);
                }
                for (DBFolder dbChild : children) {
                    this.addToBatch(dbChild, filterFamilyFlag, nodesTreated);
                }
            }
        }
    }

    protected abstract void addRows();

    protected abstract void addToBatch(DBFolder var1);

    protected void updateModel() {
    }

    public class FolderDropTarget
    extends DropTarget {
        public FolderDropTarget(JComponent component) {
            super(component, 2, new FolderDropTargetListener(component));
        }
    }

    public static class DBFolderModel
    extends DefaultTableModel {
        private List<DBFolder> _listFolders;

        public void setFolders(List<DBFolder> folders) {
            this._listFolders = folders;
        }

        public List<DBFolder> getFolders() {
            return this._listFolders;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return ResMsgVoc.getString("VOC_FOLDERS");
        }

        @Override
        public int getRowCount() {
            return this._listFolders == null ? 0 : this._listFolders.size();
        }

        public DBFolder getItem(int row) {
            return this._listFolders == null ? null : this._listFolders.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.getItem(row);
        }

        public Class getColumnClass(int column) {
            return DBFolder.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    protected static class DBFolderTable
    extends JTable {
        public DBFolderTable(TableModel model) {
            super(model);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int r, int c) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, r, c);
                    DBFolder folder = (DBFolder)value;
                    if (value == null) {
                        return this;
                    }
                    this.setIcon(DBFolderResources.getIcon(folder, true, true, false, false));
                    this.setText(FolderRenderer.convertFolderToText(folder, FolderRenderer.DBFolderName.REFPATH));
                    return this;
                }
            };
        }
    }

    class FolderDropTargetListener
    extends DBFolderListDropTargetListener {
        public FolderDropTargetListener(Component component) {
            super(component);
        }

        @Override
        protected boolean isDnDAcceptable(DBFolderList dataDnD) {
            _LOG.info("isDnDAcceptable(" + dataDnD.toString() + ")");
            for (DBFolder src : dataDnD.getFolders()) {
                if (src.getFamily() != DBFolder.Family.PROJECT) continue;
                if (src.isFolder()) {
                    return true;
                }
                if (!src.isModel() && !src.isVersion()) continue;
                if (src.getFamilyFlag() == 2) {
                    return true;
                }
                if (src.getFamilyFlag() != 5) continue;
                return true;
            }
            return false;
        }

        @Override
        public void dropDnD(DBFolderList dataDnD, Point point) {
            JPanelTableFolder.this.addFolders(dataDnD.getFolders());
        }
    }
}

