/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.IFolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class SetFolderTreeNode
implements TreeNode,
IFolder {
    private DBFolder _dbFolder;
    protected SetFolderTreeNode _nodeParent = null;
    protected ArrayList<SetFolderTreeNode> _nodeChildren;
    boolean _bReadOnly;
    protected static Comparator<? super SetFolderTreeNode> __DBFolderTreeNodeComparator = new Comparator<SetFolderTreeNode>(){

        @Override
        public int compare(SetFolderTreeNode o1, SetFolderTreeNode o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public SetFolderTreeNode(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
        this._nodeChildren = new ArrayList();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._dbFolder.isFolder()) {
            sb.append("+");
        }
        sb.append(this._dbFolder.getName());
        sb.append("[").append(this._dbFolder.getID()).append("]");
        if (this._bReadOnly) {
            sb.append("!");
        }
        return sb.toString();
    }

    public void setReadOnly(boolean bReadOnly) {
        this._bReadOnly = bReadOnly;
    }

    public int remove(SetFolderTreeNode trNode) {
        int idx = this._nodeChildren.indexOf(trNode);
        if (idx != -1) {
            this._nodeChildren.remove(idx);
        }
        return idx;
    }

    protected int findInsertPoint_rec(SetFolderTreeNode nodeWillInsert, int min, int max) {
        int mean = (min + max) / 2;
        int cmp = __DBFolderTreeNodeComparator.compare(this._nodeChildren.get(mean), nodeWillInsert);
        if (mean == min) {
            if (cmp > 0) {
                return mean;
            }
            return max;
        }
        if (cmp <= 0) {
            return this.findInsertPoint_rec(nodeWillInsert, mean, max);
        }
        return this.findInsertPoint_rec(nodeWillInsert, min, mean);
    }

    public void insert(SetFolderTreeNode trNode) {
        if (this._nodeChildren.size() == 0) {
            this._nodeChildren.add(trNode);
        } else {
            int idx = this.findInsertPoint_rec(trNode, 0, this._nodeChildren.size());
            this._nodeChildren.add(idx, trNode);
        }
        trNode.setParent(this);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this._nodeChildren.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this._nodeChildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this._nodeParent;
    }

    public void setParent(SetFolderTreeNode parent) {
        this._nodeParent = parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this._nodeChildren.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this._dbFolder.isVersion();
    }

    @Override
    public boolean isLeaf() {
        return this._dbFolder.isVersion();
    }

    public Enumeration children() {
        return Collections.enumeration(this._nodeChildren);
    }

    public DBFolder getDBFolder() {
        return this._dbFolder;
    }

    @Override
    public long getID() {
        return this._dbFolder.getID();
    }

    @Override
    public String getName() {
        return this._dbFolder.getName();
    }

    @Override
    public boolean isSystem() {
        return this._dbFolder.isSystem();
    }

    @Override
    public boolean isFreeze() {
        return this._dbFolder.isFreeze();
    }

    @Override
    public boolean isLocked() {
        return this._dbFolder.isLocked();
    }

    @Override
    public DBFolder getSource() {
        return this._dbFolder;
    }

    @Override
    public boolean isReadOnly() {
        return this._bReadOnly;
    }

    public List<SetFolderTreeNode> getChildren() {
        return this._nodeChildren;
    }
}

