/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.pref;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.FontType;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeneralTextPreferencies
implements PluginWithOptions,
PlugPanel {
    private static Logger _LOG = Logger.getLogger(GeneralTextPreferencies.class.getPackage().getName());
    public static String PREF_KEY = GeneralTextPreferencies.class.getName();
    public static final String PREF_FONT_TYPE = PREF_KEY + "#FontType";
    public static final String PREF_FONT_SIZE = PREF_KEY + "#FontSize";
    public static final String PREF_FONT_BOLD = PREF_KEY + "#FontBold";
    public static final String PREF_FORMAT_PREC = PREF_KEY + "#FormatPrecision";
    public static final String PREF_FORMAT_LIMIT = PREF_KEY + "#FormatLimit";
    public static final String PREF_DATE_FORMAT = PREF_KEY + "#DateFormat";
    JPanel _perfsPanel;
    FontType _valueFontType = FontType.Monospaced;
    int _valueFontSize = 11;
    boolean _valueFontBold = false;
    JComboBox _ctrlFontType;
    JComboBox _ctrlFontSize;
    JCheckBox _ctrlFontBold;
    DoubleFormatUtility _valueFormatUtility = new DoubleFormatUtility(3, 5);
    JComboBox _ctrlFormatPrecision;
    JComboBox _ctrlFormatLimit;
    SimpleDateFormat _valueFormatDate = new SimpleDateFormat();
    JTextField _ctrlFormatDate;

    @Override
    public void trash() {
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        this.load(launcher);
        return this;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        this.load(launcher);
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        this.save(launcher);
        return true;
    }

    @Override
    public JPanel getPanel() {
        return this.makeContent();
    }

    @Override
    public String getInfo(String key) {
        if ("plugin.key".equals(key)) {
            return PREF_KEY;
        }
        if ("plugin.key.path".equals(key)) {
            return "GENERAL";
        }
        if ("plugin.name".equals(key)) {
            return ResMsgVoc.getString("VOC_FONT");
        }
        if ("plugin.title".equals(key)) {
            return ResMsgCore.getString("PREF_GENERAL_FONT");
        }
        if ("plugin.description".equals(key)) {
            return ResMsgCore.getString("PREF_GENERAL_FONT");
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        return ResIcoCore.getImageIcon("LIVRE");
    }

    protected JPanel makeContent() {
        if (this._perfsPanel == null) {
            this._perfsPanel = new JPanel(new GridBagLayout());
            this._perfsPanel.add(this.createDefaultFontPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 10, 10), 0, 0));
            this._perfsPanel.add(this.createDecimalFormatPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 20, 10, 10), 0, 0));
            this._perfsPanel.add(this.createDateFormatPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 20, 10, 10), 0, 0));
            this._perfsPanel.add((Component)new JLabel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this._perfsPanel;
    }

    protected void load(Plugable launcher) {
        this.loadDefaultFont(launcher);
        this.loadDecimalFormat(launcher);
        this.loadDateFormat(launcher);
    }

    protected void save(Plugable launcher) {
        this.saveDefaultFont(launcher);
        this.saveDecimalFormat(launcher);
        this.saveDateFormat(launcher);
    }

    private Component createDefaultFontPanel() {
        this._ctrlFontType = new JComboBox<FontType>(FontType.values());
        Dimension size = this._ctrlFontType.getPreferredSize();
        size.width = size.width * 12 / 10;
        this._ctrlFontType.setPreferredSize(size);
        this._ctrlFontType.setSelectedItem(this._valueFontType);
        this._ctrlFontType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTextPreferencies.this._valueFontType = (FontType)GeneralTextPreferencies.this._ctrlFontType.getSelectedItem();
            }
        });
        this._ctrlFontSize = new JComboBox<Integer>(new Integer[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 24, 28, 32, 40});
        this._ctrlFontSize.setSelectedItem(this._valueFontSize);
        this._ctrlFontSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int fontSize = Integer.parseInt(GeneralTextPreferencies.this._ctrlFontSize.getSelectedItem().toString());
                    if (fontSize < 8) {
                        fontSize = 8;
                    }
                    if (fontSize > 40) {
                        fontSize = 40;
                    }
                    GeneralTextPreferencies.this._valueFontSize = fontSize;
                }
                catch (NumberFormatException nfe) {
                    _LOG.log(Level.INFO, "Erreur lors du controle de la valeur de la taille de la font", nfe);
                }
            }
        });
        this._ctrlFontBold = new JCheckBox(ResMsgCore.getString("LBL_FONT_BOLD"));
        this._ctrlFontBold.setSelected(this._valueFontBold);
        this._ctrlFontBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTextPreferencies.this._valueFontBold = GeneralTextPreferencies.this._ctrlFontBold.isSelected();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_FAMILY")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlFontType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_SIZE")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlFontSize, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlFontBold, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString("VOC_FONT")));
        return panel;
    }

    protected void loadDefaultFont(Plugable launcher) {
        String value = PlugableUtility.getStrOpt(launcher, PREF_FONT_TYPE, FontType.Monospaced.toString());
        FontType select = null;
        if (value != null && !value.isEmpty()) {
            FontType[] type = FontType.values();
            for (int i = 0; select == null && i < type.length; ++i) {
                if (!type[i].toString().equalsIgnoreCase(value)) continue;
                select = type[i];
            }
        }
        if (select == null) {
            select = FontType.Monospaced;
        }
        this._valueFontType = select;
        if (this._ctrlFontType != null) {
            this._ctrlFontType.setSelectedItem(select);
        }
        this._valueFontSize = PlugableUtility.getIntOpt(launcher, PREF_FONT_SIZE, 11);
        if (this._valueFontSize < 8) {
            this._valueFontSize = 8;
        }
        if (this._valueFontSize > 40) {
            this._valueFontSize = 40;
        }
        if (this._ctrlFontSize != null) {
            this._ctrlFontSize.setSelectedItem(Integer.toString(this._valueFontSize));
        }
        this._valueFontBold = PlugableUtility.getBoolOpt(launcher, PREF_FONT_BOLD, false);
        if (this._ctrlFontBold != null) {
            this._ctrlFontBold.setSelected(this._valueFontBold);
        }
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Load FontFormat[Type=" + this._valueFontType.toString() + ", Size=" + this._valueFontSize + ", Bold=" + this._valueFontBold + "]");
        }
    }

    protected void saveDefaultFont(Plugable launcher) {
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Save FontFormat[Type=" + this._valueFontType.toString() + ", Size=" + this._valueFontSize + ", Bold=" + this._valueFontBold + "]");
        }
        launcher.setOption(PREF_FONT_TYPE, this._valueFontType.toString());
        launcher.setOption(PREF_FONT_SIZE, Integer.toString(this._valueFontSize));
        launcher.setOption(PREF_FONT_BOLD, Boolean.toString(this._valueFontBold));
    }

    public FontType getFontType() {
        return this._valueFontType;
    }

    public int getFontSize() {
        return this._valueFontSize;
    }

    public boolean getFontBold() {
        return this._valueFontBold;
    }

    private Component createDecimalFormatPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._ctrlFormatPrecision = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        this._ctrlFormatPrecision.setSelectedItem(this._valueFormatUtility.getPrecision());
        this._ctrlFormatPrecision.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int size = Integer.parseInt(GeneralTextPreferencies.this._ctrlFormatPrecision.getSelectedItem().toString());
                    if (size < 0) {
                        size = 0;
                    }
                    if (size > 10) {
                        size = 10;
                    }
                    GeneralTextPreferencies.this._valueFormatUtility.setPrecision(size);
                }
                catch (NumberFormatException nfe) {
                    _LOG.log(Level.INFO, "Erreur lors du controle de la valeur de la precision du format d'affichage des nombres", nfe);
                }
            }
        });
        this._ctrlFormatLimit = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        this._ctrlFormatLimit.setSelectedItem(this._valueFormatUtility.getLimit());
        this._ctrlFormatLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int size = Integer.parseInt(GeneralTextPreferencies.this._ctrlFormatLimit.getSelectedItem().toString());
                    if (size < 0) {
                        size = 0;
                    }
                    if (size > 10) {
                        size = 10;
                    }
                    GeneralTextPreferencies.this._valueFormatUtility.setLimit(size);
                }
                catch (NumberFormatException nfe) {
                    _LOG.log(Level.INFO, "Erreur lors du controle de la valeur de la limite du format d'affichage des nombres", nfe);
                }
            }
        });
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_LIMIT")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlFormatLimit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_PRECISION")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlFormatPrecision, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(ResMsgCore.getString("PREF_GENERAL_DECIMAL_FORMAT")));
        return panel;
    }

    protected void loadDecimalFormat(Plugable launcher) {
        int value = PlugableUtility.getIntOpt(launcher, PREF_FORMAT_LIMIT, 3);
        if (value < 0) {
            value = 0;
        }
        if (value > 10) {
            value = 10;
        }
        if (this._ctrlFormatLimit != null) {
            this._ctrlFormatLimit.setSelectedItem(Integer.toString(value));
        }
        this._valueFormatUtility.setLimit(value);
        value = PlugableUtility.getIntOpt(launcher, PREF_FORMAT_PREC, 4);
        if (value < 0) {
            value = 0;
        }
        if (value > 10) {
            value = 10;
        }
        if (this._ctrlFormatPrecision != null) {
            this._ctrlFormatPrecision.setSelectedItem(Integer.toString(value));
        }
        this._valueFormatUtility.setPrecision(value);
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Load DoubleFormat[Limit=" + this._valueFormatUtility.getLimit() + ", Precision=" + this._valueFormatUtility.getPrecision() + "]");
        }
    }

    protected void saveDecimalFormat(Plugable launcher) {
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Save DoubleFormat[Limit=" + this._valueFormatUtility.getLimit() + ", Precision=" + this._valueFormatUtility.getPrecision() + "]");
        }
        launcher.setOption(PREF_FORMAT_LIMIT, Integer.toString(this._valueFormatUtility.getLimit()));
        launcher.setOption(PREF_FORMAT_PREC, Integer.toString(this._valueFormatUtility.getPrecision()));
    }

    public DoubleFormat getDoubleFormat() {
        return this._valueFormatUtility;
    }

    private Component createDateFormatPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._ctrlFormatDate = new JTextField(20);
        this._ctrlFormatDate.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String datePattern = GeneralTextPreferencies.this._ctrlFormatDate.getText();
                SimpleDateFormat result = GeneralTextPreferencies.this.parseDateFormat(datePattern, null);
                if (result == null) {
                    GeneralTextPreferencies.this._ctrlFormatDate.setText(GeneralTextPreferencies.this._valueFormatDate.toPattern());
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(GeneralTextPreferencies.this._ctrlFormatDate), ResMsgCore.msgFormat("PREF_GENERAL_DATE_FORMAT_ERR", datePattern));
                    GeneralTextPreferencies.this._ctrlFormatDate.requestFocus();
                } else {
                    GeneralTextPreferencies.this._valueFormatDate = result;
                }
            }
        });
        this._ctrlFormatDate.setText(this._valueFormatDate.toPattern());
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_FORMAT")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlFormatDate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(ResMsgCore.getString("PREF_GENERAL_DATE_FORMAT")));
        this._ctrlFormatDate.setToolTipText(ResMsgCore.getString("PREF_GENERAL_DATE_FORMAT_TT"));
        return panel;
    }

    protected void loadDateFormat(Plugable launcher) {
        SimpleDateFormat defaultDate = new SimpleDateFormat();
        String value = PlugableUtility.getStrOpt(launcher, PREF_DATE_FORMAT, defaultDate.toPattern());
        this._valueFormatDate = this.parseDateFormat(value, defaultDate);
        if (this._ctrlFormatDate != null) {
            this._ctrlFormatDate.setText(this._valueFormatDate.toPattern());
        }
    }

    protected SimpleDateFormat parseDateFormat(String txt, SimpleDateFormat defaultDate) {
        if (!txt.isEmpty()) {
            try {
                return new SimpleDateFormat(txt);
            }
            catch (Exception e) {
                _LOG.info("Parse Date[Le format de date ne semble pas g\u00e9rable : " + txt + "]");
            }
        }
        return defaultDate;
    }

    protected void saveDateFormat(Plugable launcher) {
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Save DateFormat[" + this._valueFormatDate.toPattern() + "]");
        }
        launcher.setOption(PREF_DATE_FORMAT, this._valueFormatDate.toPattern());
    }

    public DateFormat getDateFormat() {
        return this._valueFormatDate;
    }
}

