/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.pref;

import com.dassault.cecilia.core.cecilia.pref.PrefFieldAbstract;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;

public class PrefFieldBoolean
extends PrefFieldAbstract {
    int _idxCode;
    boolean _selected;
    boolean _optionnal;
    List<JCheckBox> _listCheckBox;

    public final int getIdxCode() {
        return this._idxCode;
    }

    public PrefFieldBoolean setIdxCode(int idx) {
        this._idxCode = idx;
        return this;
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public PrefFieldBoolean setSelected(boolean value) {
        this._selected = value;
        if (this._listCheckBox != null) {
            for (JCheckBox check : this._listCheckBox) {
                check.setSelected(this._selected);
            }
        }
        return this;
    }

    public final boolean isOptionnal() {
        return this._optionnal;
    }

    public PrefFieldBoolean setOptionnal(boolean value) {
        this._optionnal = value;
        return this;
    }

    public PrefFieldBoolean(String lbl, String code, int idx, int width, String align) {
        super(lbl, code);
        this._idxCode = idx;
        this._selected = true;
        this._optionnal = false;
        this.putInfo("Width", width);
        this.putInfo("Align", align);
    }

    public PrefFieldBoolean(String lbl, String code, String tooltip) {
        super(lbl, code, tooltip);
        this._idxCode = -1;
        this._selected = true;
        this._optionnal = false;
    }

    public PrefFieldBoolean(String lbl, String code) {
        this(lbl, code, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCode()).append("@");
        sb.append(this._selected ? 1 : 0);
        if (this._optionnal) {
            sb.append("?");
        }
        return sb.toString();
    }

    @Override
    public PrefFieldBoolean getCopy() {
        PrefFieldBoolean result = new PrefFieldBoolean("", "");
        result.copy(this);
        return result;
    }

    @Override
    protected void copy(PrefFieldAbstract abstractsrc) {
        super.copy(abstractsrc);
        PrefFieldBoolean src = (PrefFieldBoolean)abstractsrc;
        this._idxCode = src._idxCode;
        this._selected = src._selected;
        this._optionnal = src._optionnal;
    }

    public synchronized JCheckBox createCheckBox() {
        if (this._listCheckBox == null) {
            this._listCheckBox = new ArrayList<JCheckBox>();
        }
        JCheckBox chkbox = new JCheckBox(this.getLabel());
        chkbox.setToolTipText(this.getTooltip());
        chkbox.setSelected(this._selected);
        chkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefFieldBoolean.this._selected = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        this._listCheckBox.add(chkbox);
        return chkbox;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefFieldBoolean)) {
            return false;
        }
        PrefFieldBoolean prefField = (PrefFieldBoolean)obj;
        if (prefField.getCode() == null ^ this.getCode() == null) {
            return false;
        }
        if (prefField.getCode() != null && !prefField.getCode().equals(this.getCode())) {
            return false;
        }
        if (prefField.getLabel() == null ^ this.getLabel() == null) {
            return false;
        }
        return prefField.getLabel() == null || prefField.getLabel().equals(this.getLabel());
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = hashCode * 2 + this.getCode().hashCode();
        hashCode = hashCode * 3 + this.getLabel().hashCode();
        return hashCode;
    }

    public void save(Plugable launcher) {
        launcher.setOption(this.getCode(), Boolean.toString(this.isSelected()));
    }

    public void load(Plugable launcher) {
        boolean value = PlugableUtility.getBoolOpt(launcher, this.getCode(), false);
        this.setSelected(value);
    }
}

