/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.pref;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldColor;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public abstract class PrefFieldsColorCategory
implements PluginWithOptions,
PlugPanel {
    protected List<PrefFieldColor> _listColorPrefs = this.createFields();
    protected Map<String, PrefFieldColor> _mapColorPrefs = new HashMap<String, PrefFieldColor>();
    JPanel _perfsPanel;

    public PrefFieldsColorCategory() {
        for (PrefFieldColor pref : this._listColorPrefs) {
            this._mapColorPrefs.put(pref.getCode(), pref);
        }
    }

    public List<PrefFieldColor> getColorFields() {
        return Collections.unmodifiableList(this._listColorPrefs);
    }

    public PrefFieldColor getPref(String keyPref) {
        return this._mapColorPrefs.get(keyPref);
    }

    protected abstract List<PrefFieldColor> createFields();

    protected abstract String getKey();

    protected JPanel makeContent() {
        if (this._perfsPanel == null) {
            this._perfsPanel = new JPanel();
            this._perfsPanel.setLayout(new GridBagLayout());
            JPanel fieldsPanel = new JPanel();
            fieldsPanel.setLayout(new GridBagLayout());
            fieldsPanel.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString("VOC_FIELDS")));
            fieldsPanel.add((Component)PrefFieldsFactory.createPanelColor(this._listColorPrefs), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
            this._perfsPanel.add((Component)fieldsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            this._perfsPanel.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        }
        return this._perfsPanel;
    }

    @Override
    public void trash() {
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    protected void load(Plugable launcher) {
        for (PrefFieldColor pref : this._listColorPrefs) {
            int rgb = PlugableUtility.getIntOpt(launcher, this.getKey() + "#" + pref.getCode(), pref.getDefaultColor().getRGB());
            if (pref.getColor().getRGB() == rgb) continue;
            pref.setColor(new Color(rgb));
        }
    }

    protected void save(Plugable launcher) {
        for (PrefFieldColor pref : this._listColorPrefs) {
            launcher.setOption(this.getKey() + "#" + pref.getCode(), Integer.toString(pref.getColor().getRGB()));
        }
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        this.load(launcher);
        return this;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        this.load(launcher);
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        this.save(launcher);
        return true;
    }
}

