/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.pref;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Preferencies
implements TreeModel {
    private static Logger _LOG = Logger.getLogger(Preferencies.class.getPackage().getName());
    public static final String KEY_ROOT = "<root>";
    Map<String, Item> _items;
    Item _root;
    ArrayList<TreeModelListener> _treeListener = new ArrayList();
    ArrayList<PreferenciesListener> _prefListener = new ArrayList();
    private long _refreshCode = 0L;

    public Preferencies() {
        this._root = new Item(new PlugOptCategorie(KEY_ROOT, null, ResMsgVoc.getString("VOC_PREFERENCES"), ResMsgVoc.getString("VOC_PREFERENCES"), ResMsgCore.getString("PREFS_MAIN_LEGEND")));
        this._items = new LinkedHashMap<String, Item>();
    }

    public Item addOptions(PluginWithOptions plugOptions) {
        String key;
        Item newItem;
        if (!plugOptions.withOption(null)) {
            _LOG.info("Ajout de preference avec un plug sans option : " + plugOptions.getInfo("plugin.name"));
        }
        if ((newItem = this._items.get(key = plugOptions.getInfo("plugin.key"))) != null) {
            if (newItem.getPlug() == plugOptions) {
                return newItem;
            }
            _LOG.info("Preferences ecrasees pour la cle : " + key + " (par le plugin " + plugOptions.getInfo("plugin.name") + ")");
        }
        newItem = new Item(plugOptions);
        this._items.put(key, newItem);
        return newItem;
    }

    public void removeItem(Item item) {
        this._items.remove(item.getKey());
    }

    public Item getItem(String key) {
        if (KEY_ROOT.equals(key)) {
            return this._root;
        }
        return this._items.get(key);
    }

    public PluginWithOptions getOptions(String key) {
        Item item = this.getItem(key);
        if (item != null) {
            return item._plug;
        }
        return null;
    }

    public void computeItems(Plugable plugable) {
        this._root._children.clear();
        for (Item item : this._items.values()) {
            item._children.clear();
        }
        for (Item item : this._items.values()) {
            item.getPlug().refreshOptions(plugable);
            if (item.getOwner() == null || plugable.getAppl() != null && plugable.getAppl().isReader() && item.getPlug().isInvisibleIfReader()) continue;
            Item owner = this.getItem(item.getOwner());
            if (owner == null) {
                _LOG.info("L'option parente (" + item.getOwner() + ") n'existe pas pour le plugin (" + item._key + ")");
                owner = this._root;
            }
            owner._children.add(item);
        }
        if (this._treeListener.size() > 0) {
            TreeModelEvent evt = new TreeModelEvent((Object)this, new TreePath(this._root));
            for (TreeModelListener treeModelListener : this._treeListener) {
                treeModelListener.treeStructureChanged(evt);
            }
        }
    }

    public Collection<Item> getAllItems() {
        return this._items.values();
    }

    public PluginWithOptions createPLugCategorie(String key, String ownerKey, String label, String title, String description) {
        return new PlugOptCategorie(key, ownerKey, label, title, description);
    }

    @Override
    public Item getRoot() {
        return this._root;
    }

    private ArrayList<Item> getChildrenOf(Object parent) {
        return ((Item)parent)._children;
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getChildrenOf(parent).size();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getChildrenOf(parent).get(index);
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildrenOf(node).isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getChildrenOf(parent).indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (this._treeListener.contains(l)) {
            return;
        }
        this._treeListener.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this._treeListener.remove(l);
    }

    public void addPreferenciesListener(PreferenciesListener l) {
        if (this._prefListener.contains(l)) {
            return;
        }
        this._prefListener.add(l);
        l.changePreferencies(this);
    }

    public void removePreferenciesListener(PreferenciesListener l) {
        this._prefListener.remove(l);
    }

    public long getRefresh() {
        return this._refreshCode;
    }

    public void incRefresh() {
        ++this._refreshCode;
        for (PreferenciesListener preferenciesListener : this._prefListener) {
            preferenciesListener.changePreferencies(this);
        }
    }

    public static class Item {
        String _key;
        String _ownerKey;
        String _label;
        String _title;
        String _description;
        Icon _icon;
        PluginWithOptions _plug;
        PlugPanel _panel;
        ArrayList<Item> _children = new ArrayList();

        Item(PluginWithOptions plug) {
            this._key = plug.getInfo("plugin.key");
            this._label = plug.getInfo("plugin.name");
            this._title = plug.getInfo("plugin.title");
            if (this._title == null) {
                this._title = this._label;
            }
            this._description = plug.getInfo("plugin.description");
            this._icon = plug.getIcon("plugin.default");
            this._plug = plug;
            this._panel = null;
            String owner = plug.getInfo("plugin.key.path");
            if (owner == null) {
                owner = Preferencies.KEY_ROOT;
            }
            this.setOwner(owner);
        }

        public void setOwner(String owner) {
            this._ownerKey = owner;
        }

        public String getOwner() {
            return this._ownerKey;
        }

        public String getKey() {
            return this._key;
        }

        public String getLabel() {
            return this._label;
        }

        public String getTitle() {
            return this._title;
        }

        public String getDescription() {
            return this._description;
        }

        public Icon getIcon() {
            return this._icon;
        }

        public PlugPanel getPanel(Plugable launcher) {
            if (this._panel == null) {
                this._panel = this._plug.displayOption(launcher);
                return this._panel;
            }
            this._plug.refreshOptions(launcher);
            return this._panel;
        }

        public boolean withPanel() {
            return this._panel != null;
        }

        public PluginWithOptions getPlug() {
            return this._plug;
        }
    }

    static class PlugOptCategorie
    extends JPanel
    implements PluginWithOptions,
    PlugPanel {
        String _key;
        String _label;
        String _title;
        String _description;
        String _ownerKey;
        private JTextArea _legend = new JTextArea("");

        PlugOptCategorie(String key, String ownerKey, String label, String title, String description) {
            super(new GridBagLayout());
            this._key = key;
            this._ownerKey = ownerKey;
            this._label = label;
            this._title = title;
            this._description = description;
            this._legend.setText(this._description);
            this._legend.setLineWrap(true);
            this._legend.setWrapStyleWord(true);
            this._legend.setEditable(false);
            this._legend.setOpaque(false);
            this.add((Component)this._legend, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 30, 10), 0, 0));
        }

        @Override
        public String getInfo(String key) {
            if ("plugin.key".equals(key)) {
                return this._key;
            }
            if ("plugin.key.path".equals(key)) {
                return this._ownerKey;
            }
            if ("plugin.name".equals(key)) {
                return this._label;
            }
            if ("plugin.title".equals(key)) {
                return this._title;
            }
            if ("plugin.description".equals(key)) {
                return this._description;
            }
            return null;
        }

        @Override
        public Icon getIcon(String key) {
            return null;
        }

        @Override
        public boolean withOption(Plugable plugable) {
            return true;
        }

        @Override
        public PlugPanel displayOption(Plugable launcher) {
            return this;
        }

        @Override
        public Component getPanel() {
            return this;
        }

        @Override
        public void refreshOptions(Plugable launcher) {
        }

        @Override
        public boolean validOptions(Plugable launcher) {
            return true;
        }

        @Override
        public void trash() {
        }
    }

    public static interface PreferenciesListener {
        public void changePreferencies(Preferencies var1);
    }
}

